/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.internal.hppc.IntArrayList;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0003!\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ0\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\fH\u0002J0\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/util/automaton/UTF32ToUTF8;", "", "<init>", "()V", "startUTF8", "Lorg/gnit/lucenekmp/util/automaton/UTF32ToUTF8$UTF8Sequence;", "endUTF8", "tmpUTF8a", "tmpUTF8b", "convertOneEdge", "", "start", "", "end", "startCodePoint", "endCodePoint", "build", "upto", "doAll", "", "all", "startCode", "endCode", "left", "utf8", "Lorg/gnit/lucenekmp/util/automaton/Automaton$Builder;", "getUtf8", "()Lorg/gnit/lucenekmp/util/automaton/Automaton$Builder;", "setUtf8", "(Lorg/gnit/lucenekmp/util/automaton/Automaton$Builder;)V", "convert", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "utf32", "UTF8Byte", "UTF8Sequence", "Companion", "core"})
public final class UTF32ToUTF8 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UTF8Sequence startUTF8 = new UTF8Sequence();
    @NotNull
    private final UTF8Sequence endUTF8 = new UTF8Sequence();
    @NotNull
    private final UTF8Sequence tmpUTF8a = new UTF8Sequence();
    @NotNull
    private final UTF8Sequence tmpUTF8b = new UTF8Sequence();
    @Nullable
    private Automaton.Builder utf8;
    @NotNull
    private static final int[] startCodes;
    @NotNull
    private static final int[] endCodes;
    @NotNull
    private static final byte[] MASKS;

    public final void convertOneEdge(int start, int end, int startCodePoint, int endCodePoint) {
        this.startUTF8.set(startCodePoint);
        this.endUTF8.set(endCodePoint);
        this.build(start, end, this.startUTF8, this.endUTF8, 0);
    }

    private final void build(int start, int end, UTF8Sequence startUTF8, UTF8Sequence endUTF8, int upto) {
        if (startUTF8.byteAt(upto) == endUTF8.byteAt(upto)) {
            if (upto == startUTF8.getLen$core() - 1 && upto == endUTF8.getLen$core() - 1) {
                Automaton.Builder builder = this.utf8;
                Intrinsics.checkNotNull((Object)builder);
                builder.addTransition(start, end, startUTF8.byteAt(upto), endUTF8.byteAt(upto));
                return;
            }
            if (!(startUTF8.getLen$core() > upto + 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(endUTF8.getLen$core() > upto + 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Automaton.Builder builder = this.utf8;
            Intrinsics.checkNotNull((Object)builder);
            int n = builder.createState();
            Automaton.Builder builder2 = this.utf8;
            Intrinsics.checkNotNull((Object)builder2);
            builder2.addTransition(start, n, startUTF8.byteAt(upto));
            this.build(n, end, startUTF8, endUTF8, 1 + upto);
        } else if (startUTF8.getLen$core() == endUTF8.getLen$core()) {
            if (upto == startUTF8.getLen$core() - 1) {
                Automaton.Builder builder = this.utf8;
                Intrinsics.checkNotNull((Object)builder);
                builder.addTransition(start, end, startUTF8.byteAt(upto), endUTF8.byteAt(upto));
            } else {
                this.start(start, end, startUTF8, upto, false);
                if (endUTF8.byteAt(upto) - startUTF8.byteAt(upto) > 1) {
                    this.all(start, end, startUTF8.byteAt(upto) + 1, endUTF8.byteAt(upto) - 1, startUTF8.getLen$core() - upto - 1);
                }
                this.end(start, end, endUTF8, upto, false);
            }
        } else {
            this.start(start, end, startUTF8, upto, true);
            int limit = endUTF8.getLen$core() - upto;
            for (int byteCount = 1 + startUTF8.getLen$core() - upto; byteCount < limit; ++byteCount) {
                this.tmpUTF8a.setFirstByte(startCodes[byteCount - 1]);
                this.tmpUTF8b.setFirstByte(endCodes[byteCount - 1]);
                this.all(start, end, this.tmpUTF8a.byteAt(0), this.tmpUTF8b.byteAt(0), this.tmpUTF8a.getLen$core() - 1);
            }
            this.end(start, end, endUTF8, upto, true);
        }
    }

    private final void start(int start, int end, UTF8Sequence startUTF8, int upto, boolean doAll) {
        if (upto == startUTF8.getLen$core() - 1) {
            Automaton.Builder builder = this.utf8;
            Intrinsics.checkNotNull((Object)builder);
            builder.addTransition(start, end, startUTF8.byteAt(upto), startUTF8.byteAt(upto) | MASKS[startUTF8.numBits(upto)]);
        } else {
            Automaton.Builder builder = this.utf8;
            Intrinsics.checkNotNull((Object)builder);
            int n = builder.createState();
            Automaton.Builder builder2 = this.utf8;
            Intrinsics.checkNotNull((Object)builder2);
            builder2.addTransition(start, n, startUTF8.byteAt(upto));
            this.start(n, end, startUTF8, 1 + upto, true);
            int endCode = startUTF8.byteAt(upto) | MASKS[startUTF8.numBits(upto)];
            if (doAll && startUTF8.byteAt(upto) != endCode) {
                this.all(start, end, startUTF8.byteAt(upto) + 1, endCode, startUTF8.getLen$core() - upto - 1);
            }
        }
    }

    private final void end(int start, int end, UTF8Sequence endUTF8, int upto, boolean doAll) {
        if (upto == endUTF8.getLen$core() - 1) {
            Automaton.Builder builder = this.utf8;
            Intrinsics.checkNotNull((Object)builder);
            builder.addTransition(start, end, endUTF8.byteAt(upto) & (byte)(~MASKS[endUTF8.numBits(upto)]), endUTF8.byteAt(upto));
        } else {
            int startCode = 0;
            if (endUTF8.getLen$core() == 2) {
                if (!(upto == 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                startCode = 194;
            } else {
                startCode = endUTF8.getLen$core() == 3 && upto == 1 && endUTF8.byteAt(0) == 224 ? 160 : (endUTF8.getLen$core() == 4 && upto == 1 && endUTF8.byteAt(0) == 240 ? 144 : endUTF8.byteAt(upto) & (byte)(~MASKS[endUTF8.numBits(upto)]));
            }
            if (doAll && endUTF8.byteAt(upto) != startCode) {
                this.all(start, end, startCode, endUTF8.byteAt(upto) - 1, endUTF8.getLen$core() - upto - 1);
            }
            Automaton.Builder builder = this.utf8;
            Intrinsics.checkNotNull((Object)builder);
            int n = builder.createState();
            Automaton.Builder builder2 = this.utf8;
            Intrinsics.checkNotNull((Object)builder2);
            builder2.addTransition(start, n, endUTF8.byteAt(upto));
            this.end(n, end, endUTF8, 1 + upto, true);
        }
    }

    private final void all(int start, int end, int startCode, int endCode, int left) {
        int left2 = left;
        if (left2 == 0) {
            Automaton.Builder builder = this.utf8;
            Intrinsics.checkNotNull((Object)builder);
            builder.addTransition(start, end, startCode, endCode);
        } else {
            Automaton.Builder builder = this.utf8;
            Intrinsics.checkNotNull((Object)builder);
            int lastN = builder.createState();
            Automaton.Builder builder2 = this.utf8;
            Intrinsics.checkNotNull((Object)builder2);
            builder2.addTransition(start, lastN, startCode, endCode);
            while (left2 > 1) {
                Automaton.Builder builder3 = this.utf8;
                Intrinsics.checkNotNull((Object)builder3);
                int n = builder3.createState();
                Automaton.Builder builder4 = this.utf8;
                Intrinsics.checkNotNull((Object)builder4);
                builder4.addTransition(lastN, n, 128, 191);
                --left2;
                lastN = n;
            }
            Automaton.Builder builder5 = this.utf8;
            Intrinsics.checkNotNull((Object)builder5);
            builder5.addTransition(lastN, end, 128, 191);
        }
    }

    @Nullable
    public final Automaton.Builder getUtf8() {
        return this.utf8;
    }

    public final void setUtf8(@Nullable Automaton.Builder builder) {
        this.utf8 = builder;
    }

    @NotNull
    public final Automaton convert(@NotNull Automaton utf32) {
        Intrinsics.checkNotNullParameter((Object)utf32, (String)"utf32");
        if (utf32.getNumStates() == 0) {
            return utf32;
        }
        int[] map2 = new int[utf32.getNumStates()];
        ArraysKt.fill$default((int[])map2, (int)-1, (int)0, (int)0, (int)6, null);
        IntArrayList pending = new IntArrayList();
        int utf32State = 0;
        pending.add(utf32State);
        Automaton.Builder builder = this.utf8 = new Automaton.Builder(0, 0, 3, null);
        Intrinsics.checkNotNull((Object)builder);
        int utf8State = builder.createState();
        Automaton.Builder builder2 = this.utf8;
        Intrinsics.checkNotNull((Object)builder2);
        builder2.setAccept(utf8State, utf32.isAccept(utf32State));
        map2[utf32State] = utf8State;
        Transition scratch = new Transition();
        while (pending.size() != 0) {
            utf32State = pending.removeLast();
            utf8State = map2[utf32State];
            if (!(utf8State != -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int numTransitions = utf32.getNumTransitions(utf32State);
            utf32.initTransition(utf32State, scratch);
            for (int i = 0; i < numTransitions; ++i) {
                utf32.getNextTransition(scratch);
                int destUTF32 = scratch.getDest();
                int destUTF8 = map2[destUTF32];
                if (destUTF8 == -1) {
                    Automaton.Builder builder3 = this.utf8;
                    Intrinsics.checkNotNull((Object)builder3);
                    destUTF8 = builder3.createState();
                    Automaton.Builder builder4 = this.utf8;
                    Intrinsics.checkNotNull((Object)builder4);
                    builder4.setAccept(destUTF8, utf32.isAccept(destUTF32));
                    map2[destUTF32] = destUTF8;
                    pending.add(destUTF32);
                }
                this.convertOneEdge(utf8State, destUTF8, scratch.getMin(), scratch.getMax());
            }
        }
        Automaton.Builder builder5 = this.utf8;
        Intrinsics.checkNotNull((Object)builder5);
        return builder5.finish();
    }

    static {
        int[] nArray = new int[]{0, 128, 2048, 65536};
        startCodes = nArray;
        nArray = new int[]{127, 2047, 65535, 0x10FFFF};
        endCodes = nArray;
        MASKS = new byte[8];
        for (int i = 0; i < 7; ++i) {
            UTF32ToUTF8.MASKS[i + 1] = (byte)((2 << i) - 1);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/util/automaton/UTF32ToUTF8$Companion;", "", "<init>", "()V", "startCodes", "", "endCodes", "MASKS", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/automaton/UTF32ToUTF8$UTF8Byte;", "", "<init>", "()V", "value", "", "getValue", "()B", "setValue", "(B)V", "bits", "getBits", "setBits", "core"})
    private static final class UTF8Byte {
        private byte value;
        private byte bits;

        public final byte getValue() {
            return this.value;
        }

        public final void setValue(byte by) {
            this.value = by;
        }

        public final byte getBits() {
            return this.bits;
        }

        public final void setBits(byte by) {
            this.bits = by;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/automaton/UTF32ToUTF8$UTF8Sequence;", "", "<init>", "()V", "bytes", "", "Lorg/gnit/lucenekmp/util/automaton/UTF32ToUTF8$UTF8Byte;", "[Lorg/gnit/lucenekmp/util/automaton/UTF32ToUTF8$UTF8Byte;", "len", "", "getLen$core", "()I", "setLen$core", "(I)V", "byteAt", "idx", "numBits", "set", "", "code", "setFirstByte", "setRest", "numBytes", "toString", "", "core"})
    private static final class UTF8Sequence {
        @NotNull
        private final UTF8Byte[] bytes = new UTF8Byte[4];
        private int len;

        public UTF8Sequence() {
            for (int i = 0; i < 4; ++i) {
                this.bytes[i] = new UTF8Byte();
            }
        }

        public final int getLen$core() {
            return this.len;
        }

        public final void setLen$core(int n) {
            this.len = n;
        }

        public final int byteAt(int idx) {
            UTF8Byte uTF8Byte = this.bytes[idx];
            Intrinsics.checkNotNull((Object)uTF8Byte);
            return uTF8Byte.getValue() & 0xFF;
        }

        public final int numBits(int idx) {
            UTF8Byte uTF8Byte = this.bytes[idx];
            Intrinsics.checkNotNull((Object)uTF8Byte);
            return uTF8Byte.getBits();
        }

        public final void set(int code) {
            if (code < 128) {
                UTF8Byte uTF8Byte = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte);
                uTF8Byte.setValue((byte)code);
                UTF8Byte uTF8Byte2 = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte2);
                uTF8Byte2.setBits((byte)7);
                this.len = 1;
            } else if (code < 2048) {
                UTF8Byte uTF8Byte = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte);
                uTF8Byte.setValue((byte)(0xC0 | code >> 6));
                UTF8Byte uTF8Byte3 = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte3);
                uTF8Byte3.setBits((byte)5);
                this.setRest(code, 1);
                this.len = 2;
            } else if (code < 65536) {
                UTF8Byte uTF8Byte = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte);
                uTF8Byte.setValue((byte)(0xE0 | code >> 12));
                UTF8Byte uTF8Byte4 = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte4);
                uTF8Byte4.setBits((byte)4);
                this.setRest(code, 2);
                this.len = 3;
            } else {
                UTF8Byte uTF8Byte = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte);
                uTF8Byte.setValue((byte)(0xF0 | code >> 18));
                UTF8Byte uTF8Byte5 = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte5);
                uTF8Byte5.setBits((byte)3);
                this.setRest(code, 3);
                this.len = 4;
            }
        }

        public final void setFirstByte(int code) {
            if (code < 128) {
                UTF8Byte uTF8Byte = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte);
                uTF8Byte.setValue((byte)code);
                this.len = 1;
            } else if (code < 2048) {
                UTF8Byte uTF8Byte = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte);
                uTF8Byte.setValue((byte)(0xC0 | code >> 6));
                this.len = 2;
            } else if (code < 65536) {
                UTF8Byte uTF8Byte = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte);
                uTF8Byte.setValue((byte)(0xE0 | code >> 12));
                this.len = 3;
            } else {
                UTF8Byte uTF8Byte = this.bytes[0];
                Intrinsics.checkNotNull((Object)uTF8Byte);
                uTF8Byte.setValue((byte)(0xF0 | code >> 18));
                this.len = 4;
            }
        }

        public final void setRest(int code, int numBytes) {
            int code2 = code;
            for (int i = 0; i < numBytes; ++i) {
                UTF8Byte uTF8Byte = this.bytes[numBytes - i];
                Intrinsics.checkNotNull((Object)uTF8Byte);
                uTF8Byte.setValue((byte)(0x80 | code2 & MASKS[6]));
                UTF8Byte uTF8Byte2 = this.bytes[numBytes - i];
                Intrinsics.checkNotNull((Object)uTF8Byte2);
                uTF8Byte2.setBits((byte)6);
                code2 >>= 6;
            }
        }

        @NotNull
        public String toString() {
            StringBuilder b = new StringBuilder();
            int n = this.len;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    b.append(' ');
                }
                b.append(IntExtKt.toBinaryString(IntCompanionObject.INSTANCE, this.byteAt(i)));
            }
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

