/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.bkd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.MutablePointTree;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.internal.hppc.LongArrayList;
import org.gnit.lucenekmp.jdkport.ByteExtKt;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.store.TrackingDirectoryWrapper;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IORunnable;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.NumericUtils;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.gnit.lucenekmp.util.bkd.BKDConfig;
import org.gnit.lucenekmp.util.bkd.BKDRadixSelector;
import org.gnit.lucenekmp.util.bkd.BKDUtil;
import org.gnit.lucenekmp.util.bkd.DocIdsWriter;
import org.gnit.lucenekmp.util.bkd.HeapPointWriter;
import org.gnit.lucenekmp.util.bkd.MutablePointTreeReaderUtils;
import org.gnit.lucenekmp.util.bkd.OfflinePointWriter;
import org.gnit.lucenekmp.util.bkd.PointReader;
import org.gnit.lucenekmp.util.bkd.PointValue;
import org.gnit.lucenekmp.util.bkd.PointWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 \u00a7\u00012\u00060\u0001j\u0002`\u0002:\f\u00a2\u0001\u00a3\u0001\u00a4\u0001\u00a5\u0001\u00a6\u0001\u00a7\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010E\u001a\u00020FH\u0002J\u0016\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020\u0004J0\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u0002082\u0006\u0010M\u001a\u0002082\u0006\u0010N\u001a\u0002082\u0006\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020QJ8\u0010R\u001a\u00020F2\u0006\u0010S\u001a\u00020Q2\u0006\u0010T\u001a\u00020\u00042\u0006\u0010U\u001a\u00020\u00042\u0006\u0010:\u001a\u00020 2\u0006\u0010<\u001a\u00020 2\u0006\u0010#\u001a\u00020&H\u0002J2\u0010V\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u0002082\u0006\u0010M\u001a\u0002082\u0006\u0010N\u001a\u0002082\u0006\u0010O\u001a\u00020\b2\u0006\u0010S\u001a\u00020QH\u0002J2\u0010W\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u0002082\u0006\u0010M\u001a\u0002082\u0006\u0010N\u001a\u0002082\u0006\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020QH\u0002J>\u0010X\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u0002082\u0006\u0010M\u001a\u0002082\u0006\u0010N\u001a\u0002082\u000e\u0010Y\u001a\n\u0012\u0004\u0012\u00020[\u0018\u00010Z2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020]0ZJ\u0010\u0010^\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u0004H\u0002J\u0010\u0010`\u001a\u00020F2\u0006\u0010_\u001a\u00020\u0004H\u0002J \u0010a\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u0002082\u0006\u0010M\u001a\u0002082\u0006\u0010N\u001a\u000208J0\u0010b\u001a\u00020K2\u0006\u0010L\u001a\u0002082\u0006\u0010M\u001a\u0002082\u0006\u0010c\u001a\u00020 2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020\u000eH\u0002J\u0010\u0010g\u001a\u00020 2\u0006\u0010h\u001a\u00020iH\u0002J\u001e\u0010j\u001a\u00020\u00042\u0006\u0010k\u001a\u00020l2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020 0ZH\u0002JX\u0010n\u001a\u00020\u00042\u0006\u0010k\u001a\u00020l2\u0006\u0010h\u001a\u00020i2\u0006\u0010o\u001a\u00020\u000e2\u000e\u0010m\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0Z2\u0006\u0010p\u001a\u00020 2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u0002062\u0006\u0010t\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u0004H\u0002J0\u0010u\u001a\u00020F2\u0006\u0010L\u001a\u0002082\u0006\u0010M\u001a\u0002082\u0006\u0010v\u001a\u00020\u00042\u0006\u0010h\u001a\u00020i2\u0006\u0010f\u001a\u00020\u000eH\u0002J8\u0010u\u001a\u00020F2\u0006\u0010L\u001a\u0002082\u0006\u0010M\u001a\u0002082\u0006\u0010v\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u00042\u0006\u0010w\u001a\u00020 2\u0006\u0010f\u001a\u00020\u000eH\u0002J(\u0010x\u001a\u00020F2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020,2\u0006\u0010|\u001a\u00020\u00042\u0006\u0010}\u001a\u00020\u0004H\u0002JG\u0010~\u001a\u00020F2\u0006\u0010y\u001a\u00020z2\u0006\u0010+\u001a\u00020,2\u0006\u0010}\u001a\u00020\u00042\u0006\u0010\u007f\u001a\u00020\u00042\u0014\u0010\u0080\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020&0\u0081\u00012\u0007\u0010\u0082\u0001\u001a\u00020\u0004H\u0002J7\u0010\u0083\u0001\u001a\u00020F2\u0006\u0010y\u001a\u00020z2\u0006\u0010+\u001a\u00020,2\u0006\u0010}\u001a\u00020\u00042\u0014\u0010\u0080\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020&0\u0081\u0001H\u0002JH\u0010\u0084\u0001\u001a\u00020F2\u0006\u0010y\u001a\u00020z2\u0006\u0010+\u001a\u00020,2\u0006\u0010}\u001a\u00020\u00042\u0006\u0010\u007f\u001a\u00020\u00042\u0014\u0010\u0080\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020&0\u0081\u00012\u0007\u0010\u0085\u0001\u001a\u00020\u0004H\u0002J7\u0010\u0086\u0001\u001a\u00020F2\u0006\u0010y\u001a\u00020z2\u0006\u0010+\u001a\u00020,2\u0006\u0010}\u001a\u00020\u00042\u0014\u0010\u0080\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020&0\u0081\u0001H\u0002J@\u0010\u0087\u0001\u001a\u00020F2\u0006\u0010y\u001a\u00020z2\u0006\u0010+\u001a\u00020,2\u0006\u0010|\u001a\u00020\u00042\u0007\u0010\u0088\u0001\u001a\u00020\u00042\u0014\u0010\u0080\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020&0\u0081\u0001H\u0002J\"\u0010\u0089\u0001\u001a\u00020F2\u0006\u0010y\u001a\u00020z2\u0007\u0010\u008a\u0001\u001a\u00020,2\u0006\u0010H\u001a\u00020 H\u0002J\t\u0010\u008b\u0001\u001a\u00020FH\u0016J\"\u0010\u008c\u0001\u001a\b0\u008d\u0001j\u0003`\u008e\u00012\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u0091\u0001\u001a\u000204H\u0002J\"\u0010\u0092\u0001\u001a\u00020\u00042\u0006\u0010:\u001a\u00020 2\u0006\u0010<\u001a\u00020 2\u0007\u0010\u0093\u0001\u001a\u00020,H\u0004J\u0013\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u000204H\u0002Jt\u0010\u0097\u0001\u001a\u00020F2\u0006\u0010t\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u00042\u0006\u0010P\u001a\u00020Q2\u0006\u0010T\u001a\u00020\u00042\u0006\u0010U\u001a\u00020\u00042\u0006\u0010y\u001a\u0002082\u0006\u0010:\u001a\u00020 2\u0006\u0010<\u001a\u00020 2\u0007\u0010\u0093\u0001\u001a\u00020,2\u0007\u0010\u0098\u0001\u001a\u00020 2\u0006\u0010c\u001a\u00020 2\u0006\u0010d\u001a\u00020e2\u0007\u0010\u0099\u0001\u001a\u00020,H\u0002J\"\u0010R\u001a\u00020F2\b\u0010\u009a\u0001\u001a\u00030\u009b\u00012\u0006\u0010:\u001a\u00020 2\u0006\u0010<\u001a\u00020 H\u0002Jp\u0010\u0097\u0001\u001a\u00020F2\u0006\u0010t\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u00042\b\u0010\u009c\u0001\u001a\u00030\u009b\u00012\u0006\u0010y\u001a\u0002082\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\u0006\u0010:\u001a\u00020 2\u0006\u0010<\u001a\u00020 2\u0007\u0010\u0093\u0001\u001a\u00020,2\u0007\u0010\u0098\u0001\u001a\u00020 2\u0006\u0010c\u001a\u00020 2\u0006\u0010d\u001a\u00020e2\u0007\u0010\u0099\u0001\u001a\u00020,H\u0002J*\u0010\u009f\u0001\u001a\u00020F2\b\u0010\u00a0\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u00a1\u0001\u001a\u00020 2\u0006\u0010T\u001a\u00020\u00042\u0006\u0010U\u001a\u00020\u0004R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010(R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u000200X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\"R\u0014\u0010<\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\"R\u001a\u0010>\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a8\u0001"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDWriter;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "maxDoc", "", "tempDir", "Lorg/gnit/lucenekmp/store/Directory;", "tempFileNamePrefix", "", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "maxMBSortInHeap", "", "totalPointCount", "", "<init>", "(ILorg/gnit/lucenekmp/store/Directory;Ljava/lang/String;Lorg/gnit/lucenekmp/util/bkd/BKDConfig;DJ)V", "getConfig", "()Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "comparator", "Lorg/gnit/lucenekmp/util/ArrayUtil$Companion$ByteArrayComparator;", "equalsPredicate", "Lorg/gnit/lucenekmp/util/bkd/BKDUtil$ByteArrayPredicate;", "commonPrefixComparator", "Lorg/gnit/lucenekmp/store/TrackingDirectoryWrapper;", "getTempDir", "()Lorg/gnit/lucenekmp/store/TrackingDirectoryWrapper;", "getTempFileNamePrefix", "()Ljava/lang/String;", "getMaxMBSortInHeap", "()D", "scratchDiff", "", "getScratchDiff", "()[B", "scratch", "getScratch", "scratchBytesRef1", "Lorg/gnit/lucenekmp/util/BytesRef;", "getScratchBytesRef1", "()Lorg/gnit/lucenekmp/util/BytesRef;", "scratchBytesRef2", "getScratchBytesRef2", "commonPrefixLengths", "", "getCommonPrefixLengths", "()[I", "docsSeen", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "getDocsSeen", "()Lorg/gnit/lucenekmp/util/FixedBitSet;", "pointWriter", "Lorg/gnit/lucenekmp/util/bkd/PointWriter;", "finished", "", "tempInput", "Lorg/gnit/lucenekmp/store/IndexOutput;", "maxPointsSortInHeap", "minPackedValue", "getMinPackedValue", "maxPackedValue", "getMaxPackedValue", "pointCount", "getPointCount", "()J", "setPointCount", "(J)V", "docIdsWriter", "Lorg/gnit/lucenekmp/util/bkd/DocIdsWriter;", "initPointWriter", "", "add", "packedValue", "docID", "writeField", "Lorg/gnit/lucenekmp/util/IORunnable;", "metaOut", "indexOut", "dataOut", "fieldName", "reader", "Lorg/gnit/lucenekmp/codecs/MutablePointTree;", "computePackedValueBounds", "values", "from", "to", "writeFieldNDims", "writeField1Dim", "merge", "docMaps", "", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "readers", "Lorg/gnit/lucenekmp/index/PointValues;", "getNumLeftLeafNodes", "numLeaves", "checkMaxLeafNodeCount", "finish", "makeWriter", "splitDimensionValues", "leafBlockFPs", "", "dataStartFP", "packIndex", "leafNodes", "Lorg/gnit/lucenekmp/util/bkd/BKDWriter$BKDTreeLeafNodes;", "appendBlock", "writeBuffer", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "blocks", "recursePackIndex", "minBlockFP", "lastSplitValues", "negativeDeltas", "", "isLeft", "leavesOffset", "writeIndex", "countPerLeaf", "packedIndex", "writeLeafBlockDocs", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "docIDs", "start", "count", "writeLeafBlockPackedValues", "sortedDim", "packedValues", "Lkotlin/Function1;", "leafCardinality", "writeLowCardinalityLeafBlockPackedValues", "writeHighCardinalityLeafBlockPackedValues", "compressedByteOffset", "writeActualBounds", "writeLeafBlockPackedValuesRange", "end", "writeCommonPrefixes", "commonPrefixes", "close", "verifyChecksum", "Ljava/lang/Error;", "Lkotlin/Error;", "priorException", "", "writer", "split", "parentSplits", "switchToHeap", "Lorg/gnit/lucenekmp/util/bkd/HeapPointWriter;", "source", "build", "splitPackedValues", "spareDocIds", "slice", "Lorg/gnit/lucenekmp/util/bkd/BKDRadixSelector$PathSlice;", "points", "radixSelector", "Lorg/gnit/lucenekmp/util/bkd/BKDRadixSelector;", "computeCommonPrefixLength", "heapPointWriter", "commonPrefix", "MergeReader", "MergeIntersectsVisitor", "BKDMergeQueue", "BKDTreeLeafNodes", "OneDimensionBKDWriter", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBKDWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BKDWriter.kt\norg/gnit/lucenekmp/util/bkd/BKDWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2307:1\n1#2:2308\n*E\n"})
public class BKDWriter
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BKDConfig config;
    @NotNull
    private final ArrayUtil.Companion.ByteArrayComparator comparator;
    @NotNull
    private final BKDUtil.ByteArrayPredicate equalsPredicate;
    @NotNull
    private final ArrayUtil.Companion.ByteArrayComparator commonPrefixComparator;
    @NotNull
    private final TrackingDirectoryWrapper tempDir;
    @NotNull
    private final String tempFileNamePrefix;
    private final double maxMBSortInHeap;
    @NotNull
    private final byte[] scratchDiff;
    @NotNull
    private final byte[] scratch;
    @NotNull
    private final BytesRef scratchBytesRef1;
    @NotNull
    private final BytesRef scratchBytesRef2;
    @NotNull
    private final int[] commonPrefixLengths;
    @NotNull
    private final FixedBitSet docsSeen;
    @Nullable
    private PointWriter pointWriter;
    private boolean finished;
    @Nullable
    private IndexOutput tempInput;
    private final int maxPointsSortInHeap;
    @NotNull
    private final byte[] minPackedValue;
    @NotNull
    private final byte[] maxPackedValue;
    private long pointCount;
    private final long totalPointCount;
    private final int maxDoc;
    @NotNull
    private final DocIdsWriter docIdsWriter;
    @NotNull
    public static final String CODEC_NAME = "BKD";
    public static final int VERSION_START = 4;
    public static final int VERSION_LEAF_STORES_BOUNDS = 5;
    public static final int VERSION_SELECTIVE_INDEXING = 6;
    public static final int VERSION_LOW_CARDINALITY_LEAVES = 7;
    public static final int VERSION_META_FILE = 9;
    public static final int VERSION_CURRENT = 9;
    private static final int SPLITS_BEFORE_EXACT_BOUNDS = 4;
    public static final float DEFAULT_MAX_MB_SORT_IN_HEAP = 16.0f;

    public BKDWriter(int maxDoc, @NotNull Directory tempDir, @NotNull String tempFileNamePrefix, @NotNull BKDConfig config, double maxMBSortInHeap, long totalPointCount) {
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)tempFileNamePrefix, (String)"tempFileNamePrefix");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.scratchBytesRef1 = new BytesRef();
        this.scratchBytesRef2 = new BytesRef();
        BKDWriter.Companion.verifyParams(maxMBSortInHeap, totalPointCount);
        this.tempDir = new TrackingDirectoryWrapper(tempDir);
        this.tempFileNamePrefix = tempFileNamePrefix;
        this.maxMBSortInHeap = maxMBSortInHeap;
        this.totalPointCount = totalPointCount;
        this.maxDoc = maxDoc;
        this.config = config;
        this.comparator = ArrayUtil.Companion.getUnsignedComparator(config.getBytesPerDim());
        this.equalsPredicate = BKDUtil.INSTANCE.getEqualsPredicate(config.getBytesPerDim());
        this.commonPrefixComparator = BKDUtil.INSTANCE.getPrefixLengthComparator(config.getBytesPerDim());
        this.docsSeen = new FixedBitSet(maxDoc);
        this.scratchDiff = new byte[config.getBytesPerDim()];
        this.scratch = new byte[config.packedBytesLength()];
        this.commonPrefixLengths = new int[config.getNumDims()];
        this.minPackedValue = new byte[config.packedIndexBytesLength()];
        this.maxPackedValue = new byte[config.packedIndexBytesLength()];
        this.maxPointsSortInHeap = (int)(maxMBSortInHeap * (double)1024 * (double)1024 / (double)config.bytesPerDoc());
        this.docIdsWriter = new DocIdsWriter(config.getMaxPointsInLeafNode());
        if (!(this.maxPointsSortInHeap >= config.getMaxPointsInLeafNode())) {
            boolean bl = false;
            String string = "maxMBSortInHeap=" + maxMBSortInHeap + " only allows for maxPointsSortInHeap=" + this.maxPointsSortInHeap + ", but this is less than maxPointsInLeafNode=" + config.getMaxPointsInLeafNode() + "; either increase maxMBSortInHeap or decrease maxPointsInLeafNode";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    protected final BKDConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final TrackingDirectoryWrapper getTempDir() {
        return this.tempDir;
    }

    @NotNull
    public final String getTempFileNamePrefix() {
        return this.tempFileNamePrefix;
    }

    public final double getMaxMBSortInHeap() {
        return this.maxMBSortInHeap;
    }

    @NotNull
    public final byte[] getScratchDiff() {
        return this.scratchDiff;
    }

    @NotNull
    public final byte[] getScratch() {
        return this.scratch;
    }

    @NotNull
    public final BytesRef getScratchBytesRef1() {
        return this.scratchBytesRef1;
    }

    @NotNull
    public final BytesRef getScratchBytesRef2() {
        return this.scratchBytesRef2;
    }

    @NotNull
    public final int[] getCommonPrefixLengths() {
        return this.commonPrefixLengths;
    }

    @NotNull
    protected final FixedBitSet getDocsSeen() {
        return this.docsSeen;
    }

    @NotNull
    protected final byte[] getMinPackedValue() {
        return this.minPackedValue;
    }

    @NotNull
    protected final byte[] getMaxPackedValue() {
        return this.maxPackedValue;
    }

    protected final long getPointCount() {
        return this.pointCount;
    }

    protected final void setPointCount(long l) {
        this.pointCount = l;
    }

    private final void initPointWriter() throws IOException {
        if (!(this.pointWriter == null)) {
            boolean bl = false;
            String string = "Point writer is already initialized";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.totalPointCount > (long)this.maxPointsSortInHeap) {
            PointWriter pointWriter = this.pointWriter = (PointWriter)new OfflinePointWriter(this.config, this.tempDir, this.tempFileNamePrefix, "spill", 0L);
            Intrinsics.checkNotNull((Object)pointWriter, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.bkd.OfflinePointWriter");
            this.tempInput = ((OfflinePointWriter)pointWriter).getOut();
        } else {
            this.pointWriter = new HeapPointWriter(this.config, Math.INSTANCE.toIntExact(this.totalPointCount));
        }
    }

    public final void add(@NotNull byte[] packedValue, int docID) throws IOException {
        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
        if (!(packedValue.length == this.config.packedBytesLength())) {
            boolean $i$a$-require-BKDWriter$add$22 = false;
            String $i$a$-require-BKDWriter$add$22 = "packedValue should be length=" + this.config.packedBytesLength() + " (got: " + packedValue.length + ")";
            throw new IllegalArgumentException($i$a$-require-BKDWriter$add$22.toString());
        }
        if (!(this.pointCount < this.totalPointCount)) {
            boolean bl = false;
            String string = "totalPointCount=" + this.totalPointCount + " was passed when we were created, but we just hit " + (this.pointCount + 1L) + " values";
            throw new IllegalStateException(string.toString());
        }
        if (this.pointCount == 0L) {
            this.initPointWriter();
            System.INSTANCE.arraycopy(packedValue, 0, this.minPackedValue, 0, this.config.packedIndexBytesLength());
            System.INSTANCE.arraycopy(packedValue, 0, this.maxPackedValue, 0, this.config.packedIndexBytesLength());
        } else {
            int n = this.config.getNumIndexDims();
            for (int dim = 0; dim < n; ++dim) {
                int offset = dim * this.config.getBytesPerDim();
                if (this.comparator.compare(packedValue, offset, this.minPackedValue, offset) < 0) {
                    System.INSTANCE.arraycopy(packedValue, offset, this.minPackedValue, offset, this.config.getBytesPerDim());
                    continue;
                }
                if (this.comparator.compare(packedValue, offset, this.maxPackedValue, offset) <= 0) continue;
                System.INSTANCE.arraycopy(packedValue, offset, this.maxPackedValue, offset, this.config.getBytesPerDim());
            }
        }
        PointWriter pointWriter = this.pointWriter;
        Intrinsics.checkNotNull((Object)pointWriter);
        pointWriter.append(packedValue, docID);
        long l = this.pointCount;
        this.pointCount = l + 1L;
        this.docsSeen.set(docID);
    }

    @Nullable
    public final IORunnable writeField(@NotNull IndexOutput metaOut, @NotNull IndexOutput indexOut, @NotNull IndexOutput dataOut, @NotNull String fieldName, @NotNull MutablePointTree reader2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)metaOut, (String)"metaOut");
        Intrinsics.checkNotNullParameter((Object)indexOut, (String)"indexOut");
        Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        return this.config.getNumDims() == 1 ? this.writeField1Dim(metaOut, indexOut, dataOut, fieldName, reader2) : this.writeFieldNDims(metaOut, indexOut, dataOut, fieldName, reader2);
    }

    private final void computePackedValueBounds(MutablePointTree values2, int from, int to, byte[] minPackedValue, byte[] maxPackedValue, BytesRef scratch) {
        if (from == to) {
            return;
        }
        values2.getValue(from, scratch);
        System.INSTANCE.arraycopy(scratch.getBytes(), scratch.getOffset(), minPackedValue, 0, this.config.packedIndexBytesLength());
        System.INSTANCE.arraycopy(scratch.getBytes(), scratch.getOffset(), maxPackedValue, 0, this.config.packedIndexBytesLength());
        for (int i = from + 1; i < to; ++i) {
            values2.getValue(i, scratch);
            int n = this.config.getNumIndexDims();
            for (int dim = 0; dim < n; ++dim) {
                int startOffset = dim * this.config.getBytesPerDim();
                int endOffset = startOffset + this.config.getBytesPerDim();
                if (org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.compareUnsigned(scratch.getBytes(), scratch.getOffset() + startOffset, scratch.getOffset() + endOffset, minPackedValue, startOffset, endOffset) < 0) {
                    System.INSTANCE.arraycopy(scratch.getBytes(), scratch.getOffset() + startOffset, minPackedValue, startOffset, this.config.getBytesPerDim());
                    continue;
                }
                if (org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.compareUnsigned(scratch.getBytes(), scratch.getOffset() + startOffset, scratch.getOffset() + endOffset, maxPackedValue, startOffset, endOffset) <= 0) continue;
                System.INSTANCE.arraycopy(scratch.getBytes(), scratch.getOffset() + startOffset, maxPackedValue, startOffset, this.config.getBytesPerDim());
            }
        }
    }

    private final IORunnable writeFieldNDims(IndexOutput metaOut, IndexOutput indexOut, IndexOutput dataOut, String fieldName, MutablePointTree values2) throws IOException {
        if (!(this.pointCount == 0L)) {
            boolean $i$a$-check-BKDWriter$writeFieldNDims$32 = false;
            String $i$a$-check-BKDWriter$writeFieldNDims$32 = "cannot mix add and writeField";
            throw new IllegalStateException($i$a$-check-BKDWriter$writeFieldNDims$32.toString());
        }
        if (!(!this.finished)) {
            boolean $i$a$-check-BKDWriter$writeFieldNDims$42 = false;
            String $i$a$-check-BKDWriter$writeFieldNDims$42 = "already finished";
            throw new IllegalStateException($i$a$-check-BKDWriter$writeFieldNDims$42.toString());
        }
        this.finished = true;
        this.pointCount = values2.size();
        if (this.pointCount == 0L) {
            return null;
        }
        int numLeaves = Math.INSTANCE.toIntExact((this.pointCount + (long)this.config.getMaxPointsInLeafNode() - 1L) / (long)this.config.getMaxPointsInLeafNode());
        int numSplits = numLeaves - 1;
        this.checkMaxLeafNodeCount(numLeaves);
        byte[] splitPackedValues = new byte[Math.INSTANCE.multiplyExact(numSplits, this.config.getBytesPerDim())];
        byte[] splitDimensionValues = new byte[numSplits];
        long[] leafBlockFPs = new long[numLeaves];
        this.computePackedValueBounds(values2, 0, Math.INSTANCE.toIntExact(this.pointCount), this.minPackedValue, this.maxPackedValue, this.scratchBytesRef1);
        int n = Math.INSTANCE.toIntExact(this.pointCount);
        for (int i = 0; i < n; ++i) {
            this.docsSeen.set(values2.getDocID(i));
        }
        long dataStartFP = dataOut.getFilePointer();
        int[] parentSplits = new int[this.config.getNumIndexDims()];
        int n2 = Math.INSTANCE.toIntExact(this.pointCount);
        byte[] byArray = Arrays.copyOf(this.minPackedValue, this.minPackedValue.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        byte[] byArray2 = Arrays.copyOf(this.maxPackedValue, this.maxPackedValue.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        this.build(0, numLeaves, values2, 0, n2, dataOut, byArray, byArray2, parentSplits, splitPackedValues, splitDimensionValues, leafBlockFPs, new int[this.config.getMaxPointsInLeafNode()]);
        if (!Arrays.equals(parentSplits, new int[this.config.getNumIndexDims()])) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.scratchBytesRef1.setLength(this.config.getBytesPerDim());
        this.scratchBytesRef1.setBytes(splitPackedValues);
        return this.makeWriter(metaOut, indexOut, splitDimensionValues, leafBlockFPs, dataStartFP);
    }

    private final IORunnable writeField1Dim(IndexOutput metaOut, IndexOutput indexOut, IndexOutput dataOut, String fieldName, MutablePointTree reader2) throws IOException {
        MutablePointTreeReaderUtils.INSTANCE.sort(this.config, this.maxDoc, reader2, 0, Math.INSTANCE.toIntExact(reader2.size()));
        OneDimensionBKDWriter oneDimWriter = new OneDimensionBKDWriter(metaOut, indexOut, dataOut);
        reader2.visitDocValues(new PointValues.IntersectVisitor(oneDimWriter){
            final /* synthetic */ OneDimensionBKDWriter $oneDimWriter;
            {
                this.$oneDimWriter = $oneDimWriter;
            }

            public void visit(int docID, byte[] packedValue) throws IOException {
                Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                this.$oneDimWriter.add(packedValue, docID);
            }

            public void visit(int docID) {
                throw new IllegalStateException();
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }

            public void visit(DocIdSetIterator iterator2) throws IOException {
                PointValues.IntersectVisitor.super.visit(iterator2);
            }

            public void visit(IntsRef ref) throws IOException {
                PointValues.IntersectVisitor.super.visit(ref);
            }

            public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
            }

            public void grow(int count) {
                PointValues.IntersectVisitor.super.grow(count);
            }
        });
        return oneDimWriter.finish();
    }

    @Nullable
    public final IORunnable merge(@NotNull IndexOutput metaOut, @NotNull IndexOutput indexOut, @NotNull IndexOutput dataOut, @Nullable List<MergeState.DocMap> docMaps, @NotNull List<PointValues> readers) throws IOException {
        Intrinsics.checkNotNullParameter((Object)metaOut, (String)"metaOut");
        Intrinsics.checkNotNullParameter((Object)indexOut, (String)"indexOut");
        Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
        Intrinsics.checkNotNullParameter(readers, (String)"readers");
        if (!(docMaps == null || readers.size() == docMaps.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        BKDMergeQueue queue2 = new BKDMergeQueue(this.config.getBytesPerDim(), readers.size());
        int n = ((Collection)readers).size();
        for (int i = 0; i < n; ++i) {
            MergeState.DocMap docMap;
            PointValues pointValues = readers.get(i);
            if (!(pointValues.getNumDimensions() == this.config.getNumDims() && pointValues.getBytesPerDimension() == this.config.getBytesPerDim() && pointValues.getNumIndexDimensions() == this.config.getNumIndexDims())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            MergeState.DocMap docMap2 = docMap = docMaps == null ? null : docMaps.get(i);
            Intrinsics.checkNotNull((Object)docMap2);
            MergeReader reader2 = new MergeReader(pointValues, docMap2);
            if (!reader2.next()) continue;
            queue2.add(reader2);
        }
        OneDimensionBKDWriter oneDimWriter = new OneDimensionBKDWriter(metaOut, indexOut, dataOut);
        while (queue2.size() != 0) {
            MergeReader reader3 = (MergeReader)queue2.top();
            oneDimWriter.add(reader3.getPackedValue(), reader3.getDocID());
            MergeReader mergeReader = reader3.next() ? (MergeReader)queue2.updateTop() : (MergeReader)queue2.pop();
        }
        return oneDimWriter.finish();
    }

    private final int getNumLeftLeafNodes(int numLeaves) {
        if (!(numLeaves > 1)) {
            boolean $i$a$-require-BKDWriter$getNumLeftLeafNodes$22 = false;
            String $i$a$-require-BKDWriter$getNumLeftLeafNodes$22 = "getNumLeftLeaveNodes() called with " + numLeaves;
            throw new IllegalArgumentException($i$a$-require-BKDWriter$getNumLeftLeafNodes$22.toString());
        }
        int lastFullLevel = 31 - IntExtKt.numberOfLeadingZeros(IntCompanionObject.INSTANCE, numLeaves);
        int leavesFullLevel = 1 << lastFullLevel;
        int numLeftLeafNodes = leavesFullLevel / 2;
        int unbalancedLeafNodes = numLeaves - leavesFullLevel;
        numLeftLeafNodes += java.lang.Math.min(unbalancedLeafNodes, numLeftLeafNodes);
        if (!(numLeftLeafNodes >= numLeaves - numLeftLeafNodes && (long)numLeftLeafNodes <= 2L * (long)(numLeaves - numLeftLeafNodes))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return numLeftLeafNodes;
    }

    private final void checkMaxLeafNodeCount(int numLeaves) {
        if (!((long)this.config.getBytesPerDim() * (long)numLeaves <= (long)ArrayUtil.Companion.getMAX_ARRAY_LENGTH())) {
            boolean bl = false;
            String string = "too many nodes; increase config.maxPointsInLeafNode (currently " + this.config.getMaxPointsInLeafNode() + ") and reindex";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IORunnable finish(@NotNull IndexOutput metaOut, @NotNull IndexOutput indexOut, @NotNull IndexOutput dataOut) throws IOException {
        Intrinsics.checkNotNullParameter((Object)metaOut, (String)"metaOut");
        Intrinsics.checkNotNullParameter((Object)indexOut, (String)"indexOut");
        Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
        if (!(!this.finished)) {
            boolean $i$a$-check-BKDWriter$finish$22 = false;
            String $i$a$-check-BKDWriter$finish$22 = "already finished";
            throw new IllegalStateException($i$a$-check-BKDWriter$finish$22.toString());
        }
        if (this.pointCount == 0L) {
            return null;
        }
        this.finished = true;
        PointWriter pointWriter = this.pointWriter;
        if (pointWriter != null) {
            pointWriter.close();
        }
        PointWriter pointWriter2 = this.pointWriter;
        Intrinsics.checkNotNull((Object)pointWriter2);
        BKDRadixSelector.PathSlice points2 = new BKDRadixSelector.PathSlice(pointWriter2, 0L, this.pointCount);
        this.tempInput = null;
        this.pointWriter = null;
        int numLeaves = Math.INSTANCE.toIntExact((this.pointCount + (long)this.config.getMaxPointsInLeafNode() - 1L) / (long)this.config.getMaxPointsInLeafNode());
        int numSplits = numLeaves - 1;
        this.checkMaxLeafNodeCount(numLeaves);
        byte[] splitPackedValues = new byte[Math.INSTANCE.multiplyExact(numSplits, this.config.getBytesPerDim())];
        byte[] splitDimensionValues = new byte[numSplits];
        long[] leafBlockFPs = new long[numLeaves];
        if (!(this.pointCount / (long)numLeaves <= (long)this.config.getMaxPointsInLeafNode())) {
            boolean $i$a$-require-BKDWriter$finish$32 = false;
            String $i$a$-require-BKDWriter$finish$32 = "pointCount=" + this.pointCount + " numLeaves=" + numLeaves + " config.maxPointsInLeafNode=" + this.config.getMaxPointsInLeafNode();
            throw new IllegalArgumentException($i$a$-require-BKDWriter$finish$32.toString());
        }
        BKDRadixSelector radixSelector = new BKDRadixSelector(this.config, this.maxPointsSortInHeap, this.tempDir, this.tempFileNamePrefix);
        long dataStartFP = dataOut.getFilePointer();
        boolean success = false;
        try {
            int[] parentSplits = new int[this.config.getNumIndexDims()];
            byte[] byArray = Arrays.copyOf(this.minPackedValue, this.minPackedValue.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            byte[] byArray2 = Arrays.copyOf(this.maxPackedValue, this.maxPackedValue.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
            this.build(0, numLeaves, points2, dataOut, radixSelector, byArray, byArray2, parentSplits, splitPackedValues, splitDimensionValues, leafBlockFPs, new int[this.config.getMaxPointsInLeafNode()]);
            if (!Arrays.equals(parentSplits, new int[this.config.getNumIndexDims()])) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!this.tempDir.getCreatedFiles().isEmpty()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            success = true;
        }
        catch (Throwable throwable) {
            IOUtils.INSTANCE.deleteFilesIgnoringExceptions((Directory)this.tempDir, (Collection<String>)this.tempDir.getCreatedFiles());
            throw throwable;
        }
        this.scratchBytesRef1.setBytes(splitPackedValues);
        this.scratchBytesRef1.setLength(this.config.getBytesPerDim());
        return this.makeWriter(metaOut, indexOut, splitDimensionValues, leafBlockFPs, dataStartFP);
    }

    private final IORunnable makeWriter(IndexOutput metaOut, IndexOutput indexOut, byte[] splitDimensionValues, long[] leafBlockFPs, long dataStartFP) {
        BKDTreeLeafNodes leafNodes2 = new BKDTreeLeafNodes(leafBlockFPs, this, splitDimensionValues){
            final /* synthetic */ long[] $leafBlockFPs;
            final /* synthetic */ BKDWriter this$0;
            final /* synthetic */ byte[] $splitDimensionValues;
            {
                this.$leafBlockFPs = $leafBlockFPs;
                this.this$0 = $receiver;
                this.$splitDimensionValues = $splitDimensionValues;
            }

            public long getLeafLP(int index) {
                return this.$leafBlockFPs[index];
            }

            public BytesRef getSplitValue(int index) {
                this.this$0.getScratchBytesRef1().setOffset(index * this.this$0.getConfig().getBytesPerDim());
                return this.this$0.getScratchBytesRef1();
            }

            public int getSplitDimension(int index) {
                return this.$splitDimensionValues[index] & 0xFF;
            }

            public int numLeaves() {
                return this.$leafBlockFPs.length;
            }
        };
        return () -> BKDWriter.makeWriter$lambda$10(this, metaOut, indexOut, leafNodes2, dataStartFP);
    }

    private final byte[] packIndex(BKDTreeLeafNodes leafNodes2) throws IOException {
        ByteBuffersDataOutput writeBuffer = ByteBuffersDataOutput.Companion.newResettableInstance();
        List blocks = new ArrayList();
        byte[] lastSplitValues = new byte[this.config.getBytesPerDim() * this.config.getNumIndexDims()];
        int totalSize = this.recursePackIndex(writeBuffer, leafNodes2, 0L, TypeIntrinsics.asMutableList((Object)blocks), lastSplitValues, new boolean[this.config.getNumIndexDims()], false, 0, leafNodes2.numLeaves());
        byte[] index = new byte[totalSize];
        int upto = 0;
        for (byte[] block2 : blocks) {
            System.INSTANCE.arraycopy(block2, 0, index, upto, block2.length);
            upto += block2.length;
        }
        if (!(upto == totalSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return index;
    }

    private final int appendBlock(ByteBuffersDataOutput writeBuffer, List<byte[]> blocks) {
        byte[] block2 = writeBuffer.toArrayCopy();
        blocks.add(block2);
        writeBuffer.reset();
        return block2.length;
    }

    private final int recursePackIndex(ByteBuffersDataOutput writeBuffer, BKDTreeLeafNodes leafNodes2, long minBlockFP, List<byte[]> blocks, byte[] lastSplitValues, boolean[] negativeDeltas, boolean isLeft, int leavesOffset, int numLeaves) throws IOException {
        if (numLeaves == 1) {
            if (isLeft) {
                if (!(leafNodes2.getLeafLP(leavesOffset) - minBlockFP == 0L)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return 0;
            }
            long delta = leafNodes2.getLeafLP(leavesOffset) - minBlockFP;
            if (!(leafNodes2.numLeaves() == numLeaves || delta > 0L)) {
                boolean $i$a$-require-BKDWriter$recursePackIndex$42 = false;
                String $i$a$-require-BKDWriter$recursePackIndex$42 = "expected delta > 0; got numLeaves =" + numLeaves + " and delta=" + delta;
                throw new IllegalArgumentException($i$a$-require-BKDWriter$recursePackIndex$42.toString());
            }
            writeBuffer.writeVLong(delta);
            Intrinsics.checkNotNull(blocks, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.ByteArray>");
            return this.appendBlock(writeBuffer, TypeIntrinsics.asMutableList(blocks));
        }
        long leftBlockFP = 0L;
        if (isLeft) {
            if (!(leafNodes2.getLeafLP(leavesOffset) == minBlockFP)) {
                String $i$a$-require-BKDWriter$recursePackIndex$42 = "Failed requirement.";
                throw new IllegalArgumentException($i$a$-require-BKDWriter$recursePackIndex$42.toString());
            }
            leftBlockFP = minBlockFP;
        } else {
            leftBlockFP = leafNodes2.getLeafLP(leavesOffset);
            long delta = leftBlockFP - minBlockFP;
            if (!(leafNodes2.numLeaves() == numLeaves || delta > 0L)) {
                boolean $i$a$-require-BKDWriter$recursePackIndex$52 = false;
                String $i$a$-require-BKDWriter$recursePackIndex$52 = "expected delta > 0; got numLeaves =" + numLeaves + " and delta=" + delta;
                throw new IllegalArgumentException($i$a$-require-BKDWriter$recursePackIndex$52.toString());
            }
            writeBuffer.writeVLong(delta);
        }
        int numLeftLeafNodes = this.getNumLeftLeafNodes(numLeaves);
        int rightOffset = leavesOffset + numLeftLeafNodes;
        int splitOffset = rightOffset - 1;
        int splitDim = leafNodes2.getSplitDimension(splitOffset);
        BytesRef splitValue = leafNodes2.getSplitValue(splitOffset);
        int address = splitValue.getOffset();
        int prefix = this.commonPrefixComparator.compare(splitValue.getBytes(), address, lastSplitValues, splitDim * this.config.getBytesPerDim());
        int firstDiffByteDelta = 0;
        if (prefix < this.config.getBytesPerDim()) {
            firstDiffByteDelta = (splitValue.getBytes()[address + prefix] & 0xFF) - (lastSplitValues[splitDim * this.config.getBytesPerDim() + prefix] & 0xFF);
            if (negativeDeltas[splitDim]) {
                firstDiffByteDelta = -firstDiffByteDelta;
            }
            if (!(firstDiffByteDelta > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        } else {
            firstDiffByteDelta = 0;
        }
        int code = (firstDiffByteDelta * (1 + this.config.getBytesPerDim()) + prefix) * this.config.getNumIndexDims() + splitDim;
        writeBuffer.writeVInt(code);
        int suffix = this.config.getBytesPerDim() - prefix;
        byte[] savSplitValue = new byte[suffix];
        if (suffix > 1) {
            writeBuffer.writeBytes(splitValue.getBytes(), address + prefix + 1, suffix - 1);
        }
        byte[] byArray = Arrays.copyOf(lastSplitValues, lastSplitValues.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        byte[] cmp = byArray;
        System.INSTANCE.arraycopy(lastSplitValues, splitDim * this.config.getBytesPerDim() + prefix, savSplitValue, 0, suffix);
        System.INSTANCE.arraycopy(splitValue.getBytes(), address + prefix, lastSplitValues, splitDim * this.config.getBytesPerDim() + prefix, suffix);
        Intrinsics.checkNotNull(blocks, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.ByteArray>");
        int numBytes = this.appendBlock(writeBuffer, TypeIntrinsics.asMutableList(blocks));
        int idxSav = blocks.size();
        blocks.add(null);
        boolean savNegativeDelta = negativeDeltas[splitDim];
        negativeDeltas[splitDim] = true;
        int leftNumBytes = this.recursePackIndex(writeBuffer, leafNodes2, leftBlockFP, blocks, lastSplitValues, negativeDeltas, true, leavesOffset, numLeftLeafNodes);
        if (numLeftLeafNodes != 1) {
            writeBuffer.writeVInt(leftNumBytes);
        } else if (!(leftNumBytes == 0)) {
            boolean $i$a$-require-BKDWriter$recursePackIndex$62 = false;
            String $i$a$-require-BKDWriter$recursePackIndex$62 = "leftNumBytes=" + leftNumBytes;
            throw new IllegalArgumentException($i$a$-require-BKDWriter$recursePackIndex$62.toString());
        }
        byte[] bytes2 = writeBuffer.toArrayCopy();
        writeBuffer.reset();
        blocks.set(idxSav, bytes2);
        negativeDeltas[splitDim] = false;
        int rightNumBytes = this.recursePackIndex(writeBuffer, leafNodes2, leftBlockFP, blocks, lastSplitValues, negativeDeltas, false, rightOffset, numLeaves - numLeftLeafNodes);
        negativeDeltas[splitDim] = savNegativeDelta;
        System.INSTANCE.arraycopy(savSplitValue, 0, lastSplitValues, splitDim * this.config.getBytesPerDim() + prefix, suffix);
        if (!Arrays.equals(lastSplitValues, cmp)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return numBytes + bytes2.length + leftNumBytes + rightNumBytes;
    }

    private final void writeIndex(IndexOutput metaOut, IndexOutput indexOut, int countPerLeaf, BKDTreeLeafNodes leafNodes2, long dataStartFP) throws IOException {
        byte[] packedIndex = this.packIndex(leafNodes2);
        this.writeIndex(metaOut, indexOut, countPerLeaf, leafNodes2.numLeaves(), packedIndex, dataStartFP);
    }

    private final void writeIndex(IndexOutput metaOut, IndexOutput indexOut, int countPerLeaf, int numLeaves, byte[] packedIndex, long dataStartFP) throws IOException {
        CodecUtil.INSTANCE.writeHeader(metaOut, CODEC_NAME, 9);
        metaOut.writeVInt(this.config.getNumDims());
        metaOut.writeVInt(this.config.getNumIndexDims());
        metaOut.writeVInt(countPerLeaf);
        metaOut.writeVInt(this.config.getBytesPerDim());
        if (!(numLeaves > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        metaOut.writeVInt(numLeaves);
        metaOut.writeBytes(this.minPackedValue, 0, this.config.packedIndexBytesLength());
        metaOut.writeBytes(this.maxPackedValue, 0, this.config.packedIndexBytesLength());
        metaOut.writeVLong(this.pointCount);
        metaOut.writeVInt(this.docsSeen.cardinality());
        metaOut.writeVInt(packedIndex.length);
        metaOut.writeLong(dataStartFP);
        metaOut.writeLong(indexOut.getFilePointer() + (long)(metaOut == indexOut ? 8 : 0));
        indexOut.writeBytes(packedIndex, 0, packedIndex.length);
    }

    private final void writeLeafBlockDocs(DataOutput out, int[] docIDs, int start, int count) throws IOException {
        if (!(count > 0)) {
            boolean bl = false;
            String string = "config.maxPointsInLeafNode=" + this.config.getMaxPointsInLeafNode();
            throw new IllegalArgumentException(string.toString());
        }
        out.writeVInt(count);
        this.docIdsWriter.writeDocIds(docIDs, start, count, out);
    }

    private final void writeLeafBlockPackedValues(DataOutput out, int[] commonPrefixLengths, int count, int sortedDim, Function1<? super Integer, BytesRef> packedValues, int leafCardinality) throws IOException {
        int prefixLenSum = ArraysKt.sum((int[])commonPrefixLengths);
        if (prefixLenSum == this.config.packedBytesLength()) {
            out.writeByte((byte)-1);
        } else {
            if (!(commonPrefixLengths[sortedDim] < this.config.getBytesPerDim())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int compressedByteOffset = sortedDim * this.config.getBytesPerDim() + commonPrefixLengths[sortedDim];
            int highCardinalityCost = 0;
            int lowCardinalityCost = 0;
            if (count == leafCardinality) {
                highCardinalityCost = 0;
                lowCardinalityCost = 1;
            } else {
                int runLen;
                int numRunLens = 0;
                for (int i = 0; i < count; i += runLen) {
                    runLen = BKDWriter.Companion.runLen((Function1<? super Integer, BytesRef>)packedValues, i, java.lang.Math.min(i + 255, count), compressedByteOffset);
                    if (!(runLen <= 255)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    ++numRunLens;
                }
                highCardinalityCost = count * (this.config.packedBytesLength() - prefixLenSum - 1) + 2 * numRunLens;
                lowCardinalityCost = leafCardinality * (this.config.packedBytesLength() - prefixLenSum + 1);
            }
            if (lowCardinalityCost <= highCardinalityCost) {
                out.writeByte((byte)-2);
                this.writeLowCardinalityLeafBlockPackedValues(out, commonPrefixLengths, count, packedValues);
            } else {
                out.writeByte((byte)sortedDim);
                this.writeHighCardinalityLeafBlockPackedValues(out, commonPrefixLengths, count, sortedDim, packedValues, compressedByteOffset);
            }
        }
    }

    private final void writeLowCardinalityLeafBlockPackedValues(DataOutput out, int[] commonPrefixLengths, int count, Function1<? super Integer, BytesRef> packedValues) throws IOException {
        int i;
        if (this.config.getNumIndexDims() != 1) {
            this.writeActualBounds(out, commonPrefixLengths, count, packedValues);
        }
        BytesRef value = (BytesRef)packedValues.invoke((Object)0);
        System.INSTANCE.arraycopy(value.getBytes(), value.getOffset(), this.scratch, 0, this.config.packedBytesLength());
        int cardinality = 1;
        block0: for (i = 1; i < count; ++i) {
            value = (BytesRef)packedValues.invoke((Object)i);
            int n = this.config.getNumDims();
            for (int dim = 0; dim < n; ++dim) {
                int start = dim * this.config.getBytesPerDim();
                if (!this.equalsPredicate.test(value.getBytes(), value.getOffset() + start, this.scratch, start)) {
                    out.writeVInt(cardinality);
                    int n2 = this.config.getNumDims();
                    for (int j = 0; j < n2; ++j) {
                        out.writeBytes(this.scratch, j * this.config.getBytesPerDim() + commonPrefixLengths[j], this.config.getBytesPerDim() - commonPrefixLengths[j]);
                    }
                    System.INSTANCE.arraycopy(value.getBytes(), value.getOffset(), this.scratch, 0, this.config.packedBytesLength());
                    cardinality = 1;
                    continue block0;
                }
                if (dim != this.config.getNumDims() - 1) continue;
                ++cardinality;
            }
        }
        out.writeVInt(cardinality);
        int n = this.config.getNumDims();
        for (i = 0; i < n; ++i) {
            out.writeBytes(this.scratch, i * this.config.getBytesPerDim() + commonPrefixLengths[i], this.config.getBytesPerDim() - commonPrefixLengths[i]);
        }
    }

    private final void writeHighCardinalityLeafBlockPackedValues(DataOutput out, int[] commonPrefixLengths, int count, int sortedDim, Function1<? super Integer, BytesRef> packedValues, int compressedByteOffset) throws IOException {
        if (this.config.getNumIndexDims() != 1) {
            this.writeActualBounds(out, commonPrefixLengths, count, packedValues);
        }
        int n = commonPrefixLengths[sortedDim];
        commonPrefixLengths[sortedDim] = n + 1;
        int i = 0;
        while (i < count) {
            int runLen = BKDWriter.Companion.runLen((Function1<? super Integer, BytesRef>)packedValues, i, java.lang.Math.min(i + 255, count), compressedByteOffset);
            if (!(runLen <= 255)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            BytesRef first = (BytesRef)packedValues.invoke((Object)i);
            byte prefixByte = first.getBytes()[first.getOffset() + compressedByteOffset];
            out.writeByte(prefixByte);
            out.writeByte((byte)runLen);
            this.writeLeafBlockPackedValuesRange(out, commonPrefixLengths, i, i + runLen, packedValues);
            if ((i += runLen) <= count) continue;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void writeActualBounds(DataOutput out, int[] commonPrefixLengths, int count, Function1<? super Integer, BytesRef> packedValues) throws IOException {
        int n = this.config.getNumIndexDims();
        for (int dim = 0; dim < n; ++dim) {
            int commonPrefixLength = commonPrefixLengths[dim];
            int suffixLength = this.config.getBytesPerDim() - commonPrefixLength;
            if (suffixLength <= 0) continue;
            BytesRef[] minMax = BKDWriter.Companion.computeMinMax(count, (Function1<? super Integer, BytesRef>)packedValues, dim * this.config.getBytesPerDim() + commonPrefixLength, suffixLength);
            BytesRef min = minMax[0];
            BytesRef max = minMax[1];
            out.writeBytes(min.getBytes(), min.getOffset(), min.getLength());
            out.writeBytes(max.getBytes(), max.getOffset(), max.getLength());
        }
    }

    private final void writeLeafBlockPackedValuesRange(DataOutput out, int[] commonPrefixLengths, int start, int end, Function1<? super Integer, BytesRef> packedValues) throws IOException {
        for (int i = start; i < end; ++i) {
            BytesRef ref = (BytesRef)packedValues.invoke((Object)i);
            if (!(ref.getLength() == this.config.packedBytesLength())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n = this.config.getNumDims();
            for (int dim = 0; dim < n; ++dim) {
                int prefix = commonPrefixLengths[dim];
                out.writeBytes(ref.getBytes(), ref.getOffset() + dim * this.config.getBytesPerDim() + prefix, this.config.getBytesPerDim() - prefix);
            }
        }
    }

    private final void writeCommonPrefixes(DataOutput out, int[] commonPrefixes, byte[] packedValue) throws IOException {
        int n = this.config.getNumDims();
        for (int dim = 0; dim < n; ++dim) {
            out.writeVInt(commonPrefixes[dim]);
            out.writeBytes(packedValue, dim * this.config.getBytesPerDim(), commonPrefixes[dim]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.finished = true;
        if (this.tempInput != null) {
            try {
                IndexOutput indexOutput = this.tempInput;
                Intrinsics.checkNotNull((Object)indexOutput);
                indexOutput.close();
            }
            finally {
                IndexOutput indexOutput = this.tempInput;
                Intrinsics.checkNotNull((Object)indexOutput);
                this.tempDir.deleteFile(indexOutput.getName());
                this.tempInput = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Error verifyChecksum(Throwable priorException, PointWriter writer) throws IOException {
        if (priorException == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        if (writer instanceof OfflinePointWriter) {
            String tempFileName2 = ((OfflinePointWriter)writer).getName();
            if (this.tempDir.getCreatedFiles().contains(tempFileName2)) {
                AutoCloseable autoCloseable = this.tempDir.openChecksumInput(tempFileName2);
                Throwable throwable = null;
                try {
                    ChecksumIndexInput in = (ChecksumIndexInput)autoCloseable;
                    boolean bl = false;
                    CodecUtil.INSTANCE.checkFooter(in, priorException);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
        }
        IOUtils.INSTANCE.rethrowAlways(priorException);
        throw new KotlinNothingValueException();
    }

    protected final int split(@NotNull byte[] minPackedValue, @NotNull byte[] maxPackedValue, @NotNull int[] parentSplits) {
        Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
        Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
        Intrinsics.checkNotNullParameter((Object)parentSplits, (String)"parentSplits");
        int maxNumSplits = 0;
        for (int numSplits : parentSplits) {
            maxNumSplits = java.lang.Math.max(maxNumSplits, numSplits);
        }
        int n = this.config.getNumIndexDims();
        for (int dim = 0; dim < n; ++dim) {
            int offset = dim * this.config.getBytesPerDim();
            if (parentSplits[dim] >= maxNumSplits / 2 || this.comparator.compare(minPackedValue, offset, maxPackedValue, offset) == 0) continue;
            return dim;
        }
        int splitDim = -1;
        int n2 = this.config.getNumIndexDims();
        for (int dim = 0; dim < n2; ++dim) {
            NumericUtils.INSTANCE.subtract(this.config.getBytesPerDim(), dim, maxPackedValue, minPackedValue, this.scratchDiff);
            if (splitDim != -1 && this.comparator.compare(this.scratchDiff, 0, this.scratch, 0) <= 0) continue;
            System.INSTANCE.arraycopy(this.scratchDiff, 0, this.scratch, 0, this.config.getBytesPerDim());
            splitDim = dim;
        }
        return splitDim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HeapPointWriter switchToHeap(PointWriter source) throws IOException {
        int count = Math.INSTANCE.toIntExact(source.count());
        try {
            AutoCloseable autoCloseable = source.getReader(0L, source.count());
            Throwable throwable = null;
            try {
                HeapPointWriter heapPointWriter;
                PointReader reader2 = (PointReader)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = new HeapPointWriter(this.config, count);
                Throwable throwable2 = null;
                try {
                    HeapPointWriter writer = (HeapPointWriter)autoCloseable2;
                    boolean bl2 = false;
                    for (int i = 0; i < count; ++i) {
                        boolean hasNext = reader2.next();
                        if (!hasNext) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        PointValue pointValue = reader2.pointValue();
                        Intrinsics.checkNotNull((Object)pointValue);
                        writer.append(pointValue);
                    }
                    source.destroy();
                    heapPointWriter = writer;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                HeapPointWriter heapPointWriter2 = heapPointWriter;
                return heapPointWriter2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            throw this.verifyChecksum(t, source);
        }
    }

    private final void build(int leavesOffset, int numLeaves, MutablePointTree reader2, int from, int to, IndexOutput out, byte[] minPackedValue, byte[] maxPackedValue, int[] parentSplits, byte[] splitPackedValues, byte[] splitDimensionValues, long[] leafBlockFPs, int[] spareDocIds) throws IOException {
        if (numLeaves == 1) {
            int b;
            int offset;
            int dim;
            int n;
            int count = to - from;
            if (!(count <= this.config.getMaxPointsInLeafNode())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.commonPrefixLengths, this.config.getBytesPerDim());
            reader2.getValue(from, this.scratchBytesRef1);
            for (int i = from + 1; i < to; ++i) {
                reader2.getValue(i, this.scratchBytesRef2);
                n = this.config.getNumDims();
                for (dim = 0; dim < n; ++dim) {
                    offset = dim * this.config.getBytesPerDim();
                    int dimensionPrefixLength = this.commonPrefixLengths[dim];
                    this.commonPrefixLengths[dim] = java.lang.Math.min(dimensionPrefixLength, this.commonPrefixComparator.compare(this.scratchBytesRef1.getBytes(), this.scratchBytesRef1.getOffset() + offset, this.scratchBytesRef2.getBytes(), this.scratchBytesRef2.getOffset() + offset));
                }
            }
            FixedBitSet[] usedBytes = new FixedBitSet[this.config.getNumDims()];
            n = this.config.getNumDims();
            for (dim = 0; dim < n; ++dim) {
                if (this.commonPrefixLengths[dim] >= this.config.getBytesPerDim()) continue;
                usedBytes[dim] = new FixedBitSet(256);
            }
            for (int i = from + 1; i < to; ++i) {
                offset = this.config.getNumDims();
                for (int dim2 = 0; dim2 < offset; ++dim2) {
                    if (usedBytes[dim2] == null) continue;
                    b = reader2.getByteAt(i, dim2 * this.config.getBytesPerDim() + this.commonPrefixLengths[dim2]);
                    FixedBitSet fixedBitSet = usedBytes[dim2];
                    Intrinsics.checkNotNull((Object)fixedBitSet);
                    fixedBitSet.set(ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, (byte)b));
                }
            }
            int sortedDim = 0;
            int sortedDimCardinality = Integer.MAX_VALUE;
            b = this.config.getNumDims();
            for (int dim3 = 0; dim3 < b; ++dim3) {
                if (usedBytes[dim3] == null) continue;
                FixedBitSet fixedBitSet = usedBytes[dim3];
                Intrinsics.checkNotNull((Object)fixedBitSet);
                int cardinality = fixedBitSet.cardinality();
                if (cardinality >= sortedDimCardinality) continue;
                sortedDim = dim3;
                sortedDimCardinality = cardinality;
            }
            MutablePointTreeReaderUtils.INSTANCE.sortByDim(this.config, sortedDim, this.commonPrefixLengths, reader2, from, to, this.scratchBytesRef1, this.scratchBytesRef2);
            BytesRef comparator2 = this.scratchBytesRef1;
            BytesRef collector2 = this.scratchBytesRef2;
            reader2.getValue(from, comparator2);
            int leafCardinality = 1;
            block6: for (int i = from + 1; i < to; ++i) {
                reader2.getValue(i, collector2);
                int n2 = this.config.getNumDims();
                for (int dim4 = 0; dim4 < n2; ++dim4) {
                    int start = dim4 * this.config.getBytesPerDim();
                    if (this.equalsPredicate.test(collector2.getBytes(), collector2.getOffset() + start, comparator2.getBytes(), comparator2.getOffset() + start)) continue;
                    ++leafCardinality;
                    BytesRef scratch = collector2;
                    collector2 = comparator2;
                    comparator2 = scratch;
                    continue block6;
                }
            }
            leafBlockFPs[leavesOffset] = out.getFilePointer();
            int[] docIDs = spareDocIds;
            for (int i = from; i < to; ++i) {
                docIDs[i - from] = reader2.getDocID(i);
            }
            this.writeLeafBlockDocs(out, docIDs, 0, count);
            reader2.getValue(from, this.scratchBytesRef1);
            System.INSTANCE.arraycopy(this.scratchBytesRef1.getBytes(), this.scratchBytesRef1.getOffset(), this.scratch, 0, this.config.packedBytesLength());
            this.writeCommonPrefixes(out, this.commonPrefixLengths, this.scratch);
            Function1 packedValues = arg_0 -> BKDWriter.build$lambda$18(reader2, from, this, arg_0);
            if (!BKDWriter.Companion.valuesInOrderAndBounds(this.config, count, sortedDim, minPackedValue, maxPackedValue, (Function1<? super Integer, BytesRef>)packedValues, docIDs, 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.writeLeafBlockPackedValues(out, this.commonPrefixLengths, count, sortedDim, (Function1<? super Integer, BytesRef>)packedValues, leafCardinality);
        } else {
            int splitDim = 0;
            if (this.config.getNumIndexDims() == 1) {
                splitDim = 0;
            } else {
                if (numLeaves != leafBlockFPs.length && this.config.getNumIndexDims() > 2 && ArraysKt.sum((int[])parentSplits) % 4 == 0) {
                    splitDim = this.split(minPackedValue, maxPackedValue, parentSplits);
                }
                int numLeftLeafNodes = this.getNumLeftLeafNodes(numLeaves);
                int mid = from + numLeftLeafNodes * this.config.getMaxPointsInLeafNode();
                int commonPrefixLen = this.commonPrefixComparator.compare(minPackedValue, splitDim * this.config.getBytesPerDim(), maxPackedValue, splitDim * this.config.getBytesPerDim());
                MutablePointTreeReaderUtils.INSTANCE.partition(this.config, this.maxDoc, splitDim, commonPrefixLen, reader2, from, to, mid, this.scratchBytesRef1, this.scratchBytesRef2);
                int rightOffset = leavesOffset + numLeftLeafNodes;
                int splitOffset = rightOffset - 1;
                int address = splitOffset * this.config.getBytesPerDim();
                splitDimensionValues[splitOffset] = (byte)splitDim;
                reader2.getValue(mid, this.scratchBytesRef1);
                System.INSTANCE.arraycopy(this.scratchBytesRef1.getBytes(), this.scratchBytesRef1.getOffset() + splitDim * this.config.getBytesPerDim(), splitPackedValues, address, this.config.getBytesPerDim());
                byte[] minSplitPackedValue = ArrayUtil.Companion.copyOfSubArray(minPackedValue, 0, this.config.packedIndexBytesLength());
                byte[] maxSplitPackedValue = ArrayUtil.Companion.copyOfSubArray(maxPackedValue, 0, this.config.packedIndexBytesLength());
                System.INSTANCE.arraycopy(this.scratchBytesRef1.getBytes(), this.scratchBytesRef1.getOffset() + splitDim * this.config.getBytesPerDim(), minSplitPackedValue, splitDim * this.config.getBytesPerDim(), this.config.getBytesPerDim());
                System.INSTANCE.arraycopy(this.scratchBytesRef1.getBytes(), this.scratchBytesRef1.getOffset() + splitDim * this.config.getBytesPerDim(), maxSplitPackedValue, splitDim * this.config.getBytesPerDim(), this.config.getBytesPerDim());
                int n = splitDim;
                int n3 = parentSplits[n];
                parentSplits[n] = n3 + 1;
                this.build(leavesOffset, numLeftLeafNodes, reader2, from, mid, out, minPackedValue, maxSplitPackedValue, parentSplits, splitPackedValues, splitDimensionValues, leafBlockFPs, spareDocIds);
                this.build(rightOffset, numLeaves - numLeftLeafNodes, reader2, mid, to, out, minSplitPackedValue, maxPackedValue, parentSplits, splitPackedValues, splitDimensionValues, leafBlockFPs, spareDocIds);
                int n4 = splitDim;
                int n5 = parentSplits[n4];
                parentSplits[n4] = n5 + -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void computePackedValueBounds(BKDRadixSelector.PathSlice slice, byte[] minPackedValue, byte[] maxPackedValue) throws IOException {
        AutoCloseable autoCloseable = slice.getWriter().getReader(slice.getStart(), slice.getCount());
        Throwable throwable = null;
        try {
            PointReader reader2 = (PointReader)autoCloseable;
            boolean bl = false;
            if (!reader2.next()) {
                return;
            }
            PointValue pointValue = reader2.pointValue();
            Intrinsics.checkNotNull((Object)pointValue);
            BytesRef value = pointValue.packedValue();
            System.INSTANCE.arraycopy(value.getBytes(), value.getOffset(), minPackedValue, 0, this.config.packedIndexBytesLength());
            System.INSTANCE.arraycopy(value.getBytes(), value.getOffset(), maxPackedValue, 0, this.config.packedIndexBytesLength());
            while (reader2.next()) {
                PointValue pointValue2 = reader2.pointValue();
                Intrinsics.checkNotNull((Object)pointValue2);
                value = pointValue2.packedValue();
                int n = this.config.getNumIndexDims();
                for (int dim = 0; dim < n; ++dim) {
                    int startOffset = dim * this.config.getBytesPerDim();
                    if (this.comparator.compare(value.getBytes(), value.getOffset() + startOffset, minPackedValue, startOffset) < 0) {
                        System.INSTANCE.arraycopy(value.getBytes(), value.getOffset() + startOffset, minPackedValue, startOffset, this.config.getBytesPerDim());
                        continue;
                    }
                    if (this.comparator.compare(value.getBytes(), value.getOffset() + startOffset, maxPackedValue, startOffset) <= 0) continue;
                    System.INSTANCE.arraycopy(value.getBytes(), value.getOffset() + startOffset, maxPackedValue, startOffset, this.config.getBytesPerDim());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void build(int leavesOffset, int numLeaves, BKDRadixSelector.PathSlice points2, IndexOutput out, BKDRadixSelector radixSelector, byte[] minPackedValue, byte[] maxPackedValue, int[] parentSplits, byte[] splitPackedValues, byte[] splitDimensionValues, long[] leafBlockFPs, int[] spareDocIds) throws IOException {
        if (numLeaves == 1) {
            String value;
            int dim;
            HeapPointWriter heapSource = null;
            heapSource = !(points2.getWriter() instanceof HeapPointWriter) ? this.switchToHeap(points2.getWriter()) : (HeapPointWriter)points2.getWriter();
            int from = Math.INSTANCE.toIntExact(points2.getStart());
            int to = Math.INSTANCE.toIntExact(points2.getStart() + points2.getCount());
            this.computeCommonPrefixLength(heapSource, this.scratch, from, to);
            int sortedDim = 0;
            int sortedDimCardinality = Integer.MAX_VALUE;
            FixedBitSet[] usedBytes = new FixedBitSet[this.config.getNumDims()];
            int n = this.config.getNumDims();
            for (dim = 0; dim < n; ++dim) {
                if (this.commonPrefixLengths[dim] >= this.config.getBytesPerDim()) continue;
                usedBytes[dim] = new FixedBitSet(256);
            }
            n = this.config.getNumDims();
            for (dim = 0; dim < n; ++dim) {
                int prefix = this.commonPrefixLengths[dim];
                if (prefix >= this.config.getBytesPerDim()) continue;
                int offset = dim * this.config.getBytesPerDim();
                for (int i = from; i < to; ++i) {
                    Intrinsics.checkNotNull((Object)heapSource.getPackedValueSlice(i));
                    BytesRef packedValue = value.packedValue();
                    int bucket = packedValue.getBytes()[packedValue.getOffset() + offset + prefix] & 0xFF;
                    FixedBitSet fixedBitSet = usedBytes[dim];
                    Intrinsics.checkNotNull((Object)fixedBitSet);
                    fixedBitSet.set(bucket);
                }
                FixedBitSet fixedBitSet = usedBytes[dim];
                Intrinsics.checkNotNull((Object)fixedBitSet);
                int cardinality = fixedBitSet.cardinality();
                if (cardinality >= sortedDimCardinality) continue;
                sortedDim = dim;
                sortedDimCardinality = cardinality;
            }
            radixSelector.heapRadixSort(heapSource, from, to, sortedDim, this.commonPrefixLengths[sortedDim]);
            int leafCardinality = heapSource.computeCardinality(from, to, this.commonPrefixLengths);
            leafBlockFPs[leavesOffset] = out.getFilePointer();
            int count = to - from;
            if (!(count > 0)) {
                boolean $i$a$-require-BKDWriter$build$42 = false;
                String $i$a$-require-BKDWriter$build$42 = "numLeaves=" + numLeaves + " leavesOffset=" + leavesOffset;
                throw new IllegalArgumentException($i$a$-require-BKDWriter$build$42.toString());
            }
            if (!(count <= spareDocIds.length)) {
                boolean $i$a$-require-BKDWriter$build$52 = false;
                String $i$a$-require-BKDWriter$build$52 = "count=" + count + " > length=" + spareDocIds.length;
                throw new IllegalArgumentException($i$a$-require-BKDWriter$build$52.toString());
            }
            int[] docIDs = spareDocIds;
            for (int i = 0; i < count; ++i) {
                PointValue pointValue = heapSource.getPackedValueSlice(from + i);
                Intrinsics.checkNotNull((Object)pointValue);
                docIDs[i] = pointValue.docID();
            }
            this.writeLeafBlockDocs(out, docIDs, 0, count);
            this.writeCommonPrefixes(out, this.commonPrefixLengths, this.scratch);
            Function1 packedValues = arg_0 -> BKDWriter.build$lambda$22(heapSource, from, arg_0);
            if (!BKDWriter.Companion.valuesInOrderAndBounds(this.config, count, sortedDim, minPackedValue, maxPackedValue, (Function1<? super Integer, BytesRef>)packedValues, docIDs, 0)) {
                value = "Failed requirement.";
                throw new IllegalArgumentException(value.toString());
            }
            this.writeLeafBlockPackedValues(out, this.commonPrefixLengths, count, sortedDim, (Function1<? super Integer, BytesRef>)packedValues, leafCardinality);
        } else {
            int splitDim = 0;
            if (this.config.getNumIndexDims() == 1) {
                splitDim = 0;
            } else {
                if (numLeaves != leafBlockFPs.length && this.config.getNumIndexDims() > 2 && ArraysKt.sum((int[])parentSplits) % 4 == 0) {
                    this.computePackedValueBounds(points2, minPackedValue, maxPackedValue);
                }
                splitDim = this.split(minPackedValue, maxPackedValue, parentSplits);
            }
            if (!(numLeaves <= leafBlockFPs.length)) {
                boolean $i$a$-require-BKDWriter$build$62 = false;
                String $i$a$-require-BKDWriter$build$62 = "numLeaves=" + numLeaves + " leafBlockFPs.length=" + leafBlockFPs.length;
                throw new IllegalArgumentException($i$a$-require-BKDWriter$build$62.toString());
            }
            int numLeftLeafNodes = this.getNumLeftLeafNodes(numLeaves);
            long leftCount = (long)numLeftLeafNodes * (long)this.config.getMaxPointsInLeafNode();
            BKDRadixSelector.PathSlice[] slices = new BKDRadixSelector.PathSlice[2];
            int commonPrefixLen = this.commonPrefixComparator.compare(minPackedValue, splitDim * this.config.getBytesPerDim(), maxPackedValue, splitDim * this.config.getBytesPerDim());
            byte[] splitValue = radixSelector.select(points2, slices, points2.getStart(), points2.getStart() + points2.getCount(), points2.getStart() + leftCount, splitDim, commonPrefixLen);
            int rightOffset = leavesOffset + numLeftLeafNodes;
            int splitValueOffset = rightOffset - 1;
            splitDimensionValues[splitValueOffset] = (byte)splitDim;
            int address = splitValueOffset * this.config.getBytesPerDim();
            System.INSTANCE.arraycopy(splitValue, 0, splitPackedValues, address, this.config.getBytesPerDim());
            byte[] minSplitPackedValue = new byte[this.config.packedIndexBytesLength()];
            System.INSTANCE.arraycopy(minPackedValue, 0, minSplitPackedValue, 0, this.config.packedIndexBytesLength());
            byte[] maxSplitPackedValue = new byte[this.config.packedIndexBytesLength()];
            System.INSTANCE.arraycopy(maxPackedValue, 0, maxSplitPackedValue, 0, this.config.packedIndexBytesLength());
            System.INSTANCE.arraycopy(splitValue, 0, minSplitPackedValue, splitDim * this.config.getBytesPerDim(), this.config.getBytesPerDim());
            System.INSTANCE.arraycopy(splitValue, 0, maxSplitPackedValue, splitDim * this.config.getBytesPerDim(), this.config.getBytesPerDim());
            int n = parentSplits[splitDim];
            parentSplits[splitDim] = n + 1;
            BKDRadixSelector.PathSlice pathSlice = slices[0];
            Intrinsics.checkNotNull((Object)pathSlice);
            this.build(leavesOffset, numLeftLeafNodes, pathSlice, out, radixSelector, minPackedValue, maxSplitPackedValue, parentSplits, splitPackedValues, splitDimensionValues, leafBlockFPs, spareDocIds);
            BKDRadixSelector.PathSlice pathSlice2 = slices[1];
            Intrinsics.checkNotNull((Object)pathSlice2);
            this.build(rightOffset, numLeaves - numLeftLeafNodes, pathSlice2, out, radixSelector, minSplitPackedValue, maxPackedValue, parentSplits, splitPackedValues, splitDimensionValues, leafBlockFPs, spareDocIds);
            int n2 = parentSplits[splitDim];
            parentSplits[splitDim] = n2 + -1;
        }
    }

    public final void computeCommonPrefixLength(@NotNull HeapPointWriter heapPointWriter, @NotNull byte[] commonPrefix, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)heapPointWriter, (String)"heapPointWriter");
        Intrinsics.checkNotNullParameter((Object)commonPrefix, (String)"commonPrefix");
        org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.commonPrefixLengths, this.config.getBytesPerDim());
        PointValue pointValue = heapPointWriter.getPackedValueSlice(from);
        Intrinsics.checkNotNull((Object)pointValue);
        PointValue value = pointValue;
        BytesRef packedValue = value.packedValue();
        int n = this.config.getNumDims();
        for (int dim = 0; dim < n; ++dim) {
            System.INSTANCE.arraycopy(packedValue.getBytes(), packedValue.getOffset() + dim * this.config.getBytesPerDim(), commonPrefix, dim * this.config.getBytesPerDim(), this.config.getBytesPerDim());
        }
        for (int i = from + 1; i < to; ++i) {
            Intrinsics.checkNotNull((Object)heapPointWriter.getPackedValueSlice(i));
            packedValue = value.packedValue();
            int n2 = this.config.getNumDims();
            for (int dim = 0; dim < n2; ++dim) {
                if (this.commonPrefixLengths[dim] == 0) continue;
                this.commonPrefixLengths[dim] = java.lang.Math.min(this.commonPrefixLengths[dim], this.commonPrefixComparator.compare(commonPrefix, dim * this.config.getBytesPerDim(), packedValue.getBytes(), packedValue.getOffset() + dim * this.config.getBytesPerDim()));
            }
        }
    }

    private static final void makeWriter$lambda$10(BKDWriter this$0, IndexOutput $metaOut, IndexOutput $indexOut, BKDTreeLeafNodes $leafNodes, long $dataStartFP) {
        this$0.writeIndex($metaOut, $indexOut, this$0.config.getMaxPointsInLeafNode(), $leafNodes, $dataStartFP);
    }

    private static final BytesRef build$lambda$18(MutablePointTree $reader, int $from, BKDWriter this$0, int i) {
        $reader.getValue($from + i, this$0.scratchBytesRef1);
        return this$0.scratchBytesRef1;
    }

    private static final BytesRef build$lambda$22(HeapPointWriter $heapSource, int $from, int i) {
        PointValue pointValue = $heapSource.getPackedValueSlice($from + i);
        Intrinsics.checkNotNull((Object)pointValue);
        return pointValue.packedValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDWriter$BKDMergeQueue;", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/util/bkd/BKDWriter$MergeReader;", "bytesPerDim", "", "maxSize", "<init>", "(II)V", "comparator", "Lorg/gnit/lucenekmp/util/ArrayUtil$Companion$ByteArrayComparator;", "lessThan", "", "a", "b", "core"})
    private static final class BKDMergeQueue
    extends PriorityQueue<MergeReader> {
        @NotNull
        private final ArrayUtil.Companion.ByteArrayComparator comparator;

        public BKDMergeQueue(int bytesPerDim, int maxSize) {
            super(maxSize, null, 2, null);
            this.comparator = ArrayUtil.Companion.getUnsignedComparator(bytesPerDim);
        }

        @Override
        public boolean lessThan(@NotNull MergeReader a, @NotNull MergeReader b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (!(a != b)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int cmp = this.comparator.compare(a.getPackedValue(), 0, b.getPackedValue(), 0);
            if (cmp < 0) {
                return true;
            }
            if (cmp > 0) {
                return false;
            }
            return a.getDocID() < b.getDocID();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDWriter$BKDTreeLeafNodes;", "", "numLeaves", "", "getLeafLP", "", "index", "getSplitValue", "Lorg/gnit/lucenekmp/util/BytesRef;", "getSplitDimension", "core"})
    private static interface BKDTreeLeafNodes {
        public int numLeaves();

        public long getLeafLP(int var1);

        @NotNull
        public BytesRef getSplitValue(int var1);

        public int getSplitDimension(int var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J?\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00072\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001eJ4\u0010\u001f\u001a\u00020\u00072\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0002JT\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0007H\u0002JH\u0010/\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00072\u0006\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007H\u0002J(\u00106\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u00102\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDWriter$Companion;", "", "<init>", "()V", "CODEC_NAME", "", "VERSION_START", "", "VERSION_LEAF_STORES_BOUNDS", "VERSION_SELECTIVE_INDEXING", "VERSION_LOW_CARDINALITY_LEAVES", "VERSION_META_FILE", "VERSION_CURRENT", "SPLITS_BEFORE_EXACT_BOUNDS", "DEFAULT_MAX_MB_SORT_IN_HEAP", "", "verifyParams", "", "maxMBSortInHeap", "", "totalPointCount", "", "computeMinMax", "", "Lorg/gnit/lucenekmp/util/BytesRef;", "count", "packedValues", "Lkotlin/Function1;", "offset", "length", "(ILkotlin/jvm/functions/Function1;II)[Lorg/gnit/lucenekmp/util/BytesRef;", "runLen", "start", "end", "byteOffset", "valuesInOrderAndBounds", "", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "sortedDim", "minPackedValue", "", "maxPackedValue", "values", "docs", "", "docsOffset", "valueInOrder", "ord", "lastPackedValue", "packedValue", "packedValueOffset", "doc", "lastDoc", "valueInBounds", "core"})
    @SourceDebugExtension(value={"SMAP\nBKDWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BKDWriter.kt\norg/gnit/lucenekmp/util/bkd/BKDWriter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2307:1\n1#2:2308\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void verifyParams(double maxMBSortInHeap, long totalPointCount) {
            if (!(!(maxMBSortInHeap < 0.0))) {
                boolean $i$a$-require-BKDWriter$Companion$verifyParams$32 = false;
                String $i$a$-require-BKDWriter$Companion$verifyParams$32 = "maxMBSortInHeap must be >= 0.0 (got: " + maxMBSortInHeap + ")";
                throw new IllegalArgumentException($i$a$-require-BKDWriter$Companion$verifyParams$32.toString());
            }
            if (!(totalPointCount >= 0L)) {
                boolean bl = false;
                String string = "totalPointCount must be >=0 (got: " + totalPointCount + ")";
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final BytesRef[] computeMinMax(int count, Function1<? super Integer, BytesRef> packedValues, int offset, int length) {
            if (!(length > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            BytesRefBuilder min = new BytesRefBuilder();
            BytesRefBuilder max = new BytesRefBuilder();
            BytesRef first = (BytesRef)packedValues.invoke((Object)0);
            min.copyBytes(first.getBytes(), first.getOffset() + offset, length);
            max.copyBytes(first.getBytes(), first.getOffset() + offset, length);
            for (int i = 1; i < count; ++i) {
                BytesRef candidate = (BytesRef)packedValues.invoke((Object)i);
                if (org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.compareUnsigned(min.bytes(), 0, length, candidate.getBytes(), candidate.getOffset() + offset, candidate.getOffset() + offset + length) > 0) {
                    min.copyBytes(candidate.getBytes(), candidate.getOffset() + offset, length);
                    continue;
                }
                if (org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.compareUnsigned(max.bytes(), 0, length, candidate.getBytes(), candidate.getOffset() + offset, candidate.getOffset() + offset + length) >= 0) continue;
                max.copyBytes(candidate.getBytes(), candidate.getOffset() + offset, length);
            }
            BytesRef[] bytesRefArray = new BytesRef[]{min.get(), max.get()};
            return bytesRefArray;
        }

        private final int runLen(Function1<? super Integer, BytesRef> packedValues, int start, int end, int byteOffset) {
            BytesRef first = (BytesRef)packedValues.invoke((Object)start);
            byte b = first.getBytes()[first.getOffset() + byteOffset];
            for (int i = start + 1; i < end; ++i) {
                BytesRef ref = (BytesRef)packedValues.invoke((Object)i);
                byte b2 = ref.getBytes()[ref.getOffset() + byteOffset];
                if (!(ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, b2) >= ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, b))) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (b == b2) continue;
                return i - start;
            }
            return end - start;
        }

        private final boolean valuesInOrderAndBounds(BKDConfig config, int count, int sortedDim, byte[] minPackedValue, byte[] maxPackedValue, Function1<? super Integer, BytesRef> values2, int[] docs, int docsOffset) {
            byte[] lastPackedValue = new byte[config.packedBytesLength()];
            int lastDoc = -1;
            for (int i = 0; i < count; ++i) {
                BytesRef packedValue = (BytesRef)values2.invoke((Object)i);
                if (!(packedValue.getLength() == config.packedBytesLength())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!this.valueInOrder(config, i, sortedDim, lastPackedValue, packedValue.getBytes(), packedValue.getOffset(), docs[docsOffset + i], lastDoc)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                lastDoc = docs[docsOffset + i];
                if (this.valueInBounds(config, packedValue, minPackedValue, maxPackedValue)) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return true;
        }

        private final boolean valueInOrder(BKDConfig config, long ord, int sortedDim, byte[] lastPackedValue, byte[] packedValue, int packedValueOffset, int doc, int lastDoc) {
            int dimOffset = sortedDim * config.getBytesPerDim();
            if (ord > 0L) {
                int cmp = org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.compareUnsigned(lastPackedValue, dimOffset, dimOffset + config.getBytesPerDim(), packedValue, packedValueOffset + dimOffset, packedValueOffset + dimOffset + config.getBytesPerDim());
                if (cmp > 0) {
                    throw new AssertionError((Object)("values out of order: last value=" + new BytesRef(lastPackedValue) + " current value=" + new BytesRef(packedValue, packedValueOffset, config.packedBytesLength()) + " ord=" + ord));
                }
                if (cmp == 0 && config.getNumDims() > config.getNumIndexDims() && (cmp = org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.compareUnsigned(lastPackedValue, config.packedIndexBytesLength(), config.packedBytesLength(), packedValue, packedValueOffset + config.packedIndexBytesLength(), packedValueOffset + config.packedBytesLength())) > 0) {
                    throw new AssertionError((Object)("data values out of order: last value=" + new BytesRef(lastPackedValue) + " current value=" + new BytesRef(packedValue, packedValueOffset, config.packedBytesLength()) + " ord=" + ord));
                }
                if (cmp == 0 && doc < lastDoc) {
                    throw new AssertionError((Object)("docs out of order: last doc=" + lastDoc + " current doc=" + doc + " ord=" + ord));
                }
            }
            System.INSTANCE.arraycopy(packedValue, packedValueOffset, lastPackedValue, 0, config.packedBytesLength());
            return true;
        }

        private final boolean valueInBounds(BKDConfig config, BytesRef packedValue, byte[] minPackedValue, byte[] maxPackedValue) {
            int n = config.getNumIndexDims();
            for (int dim = 0; dim < n; ++dim) {
                int offset = config.getBytesPerDim() * dim;
                if (org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.compareUnsigned(packedValue.getBytes(), packedValue.getOffset() + offset, packedValue.getOffset() + offset + config.getBytesPerDim(), minPackedValue, offset, offset + config.getBytesPerDim()) < 0) {
                    return false;
                }
                if (org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.compareUnsigned(packedValue.getBytes(), packedValue.getOffset() + offset, packedValue.getOffset() + offset + config.getBytesPerDim(), maxPackedValue, offset, offset + config.getBytesPerDim()) <= 0) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDWriter$MergeIntersectsVisitor;", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "packedBytesLength", "", "<init>", "(I)V", "docsInBlock", "getDocsInBlock", "()I", "setDocsInBlock", "packedValues", "", "getPackedValues", "()[B", "setPackedValues", "([B)V", "docIDs", "", "getDocIDs", "()[I", "setDocIDs", "([I)V", "reset", "", "grow", "count", "visit", "docID", "packedValue", "compare", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "minPackedValue", "maxPackedValue", "core"})
    private static final class MergeIntersectsVisitor
    implements PointValues.IntersectVisitor {
        private final int packedBytesLength;
        private int docsInBlock;
        @NotNull
        private byte[] packedValues;
        @NotNull
        private int[] docIDs;

        public MergeIntersectsVisitor(int packedBytesLength) {
            this.packedBytesLength = packedBytesLength;
            this.docIDs = new int[0];
            this.packedValues = new byte[0];
        }

        public final int getDocsInBlock() {
            return this.docsInBlock;
        }

        public final void setDocsInBlock(int n) {
            this.docsInBlock = n;
        }

        @NotNull
        public final byte[] getPackedValues() {
            return this.packedValues;
        }

        public final void setPackedValues(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.packedValues = byArray;
        }

        @NotNull
        public final int[] getDocIDs() {
            return this.docIDs;
        }

        public final void setDocIDs(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.docIDs = nArray;
        }

        public final void reset() {
            this.docsInBlock = 0;
        }

        @Override
        public void grow(int count) {
            if (!(this.docsInBlock == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.docIDs.length < count) {
                this.docIDs = ArrayUtil.Companion.grow(this.docIDs, count);
                int packedValuesSize = Math.INSTANCE.toIntExact((long)this.docIDs.length * (long)this.packedBytesLength);
                if (!(packedValuesSize <= ArrayUtil.Companion.getMAX_ARRAY_LENGTH())) {
                    boolean bl = false;
                    String string = "array length must be <= to " + ArrayUtil.Companion.getMAX_ARRAY_LENGTH() + " but was: " + packedValuesSize;
                    throw new IllegalStateException(string.toString());
                }
                this.packedValues = ArrayUtil.Companion.growExact(this.packedValues, packedValuesSize);
            }
        }

        @Override
        public void visit(int docID) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visit(int docID, @NotNull byte[] packedValue) {
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            System.INSTANCE.arraycopy(packedValue, 0, this.packedValues, this.docsInBlock * this.packedBytesLength, this.packedBytesLength);
            int n = this.docsInBlock;
            this.docsInBlock = n + 1;
            this.docIDs[n] = docID;
        }

        @Override
        @NotNull
        public PointValues.Relation compare(@NotNull byte[] minPackedValue, @NotNull byte[] maxPackedValue) {
            Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
            Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2) throws IOException {
            PointValues.IntersectVisitor.super.visit(iterator2);
        }

        @Override
        public void visit(@NotNull IntsRef ref) throws IOException {
            PointValues.IntersectVisitor.super.visit(ref);
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2, @NotNull byte[] packedValue) throws IOException {
            PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDWriter$MergeReader;", "", "pointValues", "Lorg/gnit/lucenekmp/index/PointValues;", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "<init>", "(Lorg/gnit/lucenekmp/index/PointValues;Lorg/gnit/lucenekmp/index/MergeState$DocMap;)V", "pointTree", "Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "packedBytesLength", "", "mergeIntersectsVisitor", "Lorg/gnit/lucenekmp/util/bkd/BKDWriter$MergeIntersectsVisitor;", "docBlockUpto", "docID", "getDocID", "()I", "setDocID", "(I)V", "packedValue", "", "getPackedValue", "()[B", "next", "", "collectNextLeaf", "core"})
    private static final class MergeReader {
        @NotNull
        private final MergeState.DocMap docMap;
        @NotNull
        private final PointValues.PointTree pointTree;
        private final int packedBytesLength;
        @NotNull
        private final MergeIntersectsVisitor mergeIntersectsVisitor;
        private int docBlockUpto;
        private int docID;
        @NotNull
        private final byte[] packedValue;

        public MergeReader(@NotNull PointValues pointValues, @NotNull MergeState.DocMap docMap) {
            Intrinsics.checkNotNullParameter((Object)pointValues, (String)"pointValues");
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            this.docMap = docMap;
            this.pointTree = pointValues.getPointTree();
            this.packedBytesLength = pointValues.getBytesPerDimension() * pointValues.getNumDimensions();
            this.mergeIntersectsVisitor = new MergeIntersectsVisitor(this.packedBytesLength);
            this.packedValue = new byte[this.packedBytesLength];
            while (this.pointTree.moveToChild()) {
            }
            this.pointTree.visitDocValues(this.mergeIntersectsVisitor);
        }

        public final int getDocID() {
            return this.docID;
        }

        public final void setDocID(int n) {
            this.docID = n;
        }

        @NotNull
        public final byte[] getPackedValue() {
            return this.packedValue;
        }

        public final boolean next() throws IOException {
            int index;
            int oldDocID;
            int mappedDocID;
            do {
                if (this.docBlockUpto == this.mergeIntersectsVisitor.getDocsInBlock()) {
                    if (!this.collectNextLeaf()) {
                        if (!(this.mergeIntersectsVisitor.getDocsInBlock() == 0)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        return false;
                    }
                    if (!(this.mergeIntersectsVisitor.getDocsInBlock() > 0)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.docBlockUpto = 0;
                }
                int n = this.docBlockUpto;
                this.docBlockUpto = n + 1;
                index = n;
                oldDocID = this.mergeIntersectsVisitor.getDocIDs()[index];
                mappedDocID = 0;
            } while ((mappedDocID = this.docMap == null ? oldDocID : this.docMap.get(oldDocID)) == -1);
            this.docID = mappedDocID;
            System.INSTANCE.arraycopy(this.mergeIntersectsVisitor.getPackedValues(), index * this.packedBytesLength, this.packedValue, 0, this.packedBytesLength);
            return true;
        }

        public final boolean collectNextLeaf() throws IOException {
            if (!(!this.pointTree.moveToChild())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.mergeIntersectsVisitor.reset();
            do {
                if (!this.pointTree.moveToSibling()) continue;
                while (this.pointTree.moveToChild()) {
                }
                this.pointTree.visitDocValues(this.mergeIntersectsVisitor);
                return true;
            } while (this.pointTree.moveToParent());
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\"J\b\u0010+\u001a\u0004\u0018\u00010,J\u000e\u0010-\u001a\u00020(2\u0006\u0010#\u001a\u00020\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001bR\u000e\u0010&\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDWriter$OneDimensionBKDWriter;", "", "metaOut", "Lorg/gnit/lucenekmp/store/IndexOutput;", "indexOut", "dataOut", "<init>", "(Lorg/gnit/lucenekmp/util/bkd/BKDWriter;Lorg/gnit/lucenekmp/store/IndexOutput;Lorg/gnit/lucenekmp/store/IndexOutput;Lorg/gnit/lucenekmp/store/IndexOutput;)V", "getMetaOut", "()Lorg/gnit/lucenekmp/store/IndexOutput;", "getIndexOut", "getDataOut", "dataStartFP", "", "getDataStartFP", "()J", "leafBlockFPs", "Lorg/gnit/lucenekmp/internal/hppc/LongArrayList;", "getLeafBlockFPs", "()Lorg/gnit/lucenekmp/internal/hppc/LongArrayList;", "leafBlockStartValues", "", "", "getLeafBlockStartValues", "()Ljava/util/List;", "leafValues", "getLeafValues", "()[B", "leafDocs", "", "getLeafDocs", "()[I", "valueCount", "leafCount", "", "leafCardinality", "lastPackedValue", "getLastPackedValue", "lastDocID", "add", "", "packedValue", "docID", "finish", "Lorg/gnit/lucenekmp/util/IORunnable;", "writeLeafBlock", "core"})
    @SourceDebugExtension(value={"SMAP\nBKDWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BKDWriter.kt\norg/gnit/lucenekmp/util/bkd/BKDWriter$OneDimensionBKDWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2307:1\n1#2:2308\n*E\n"})
    private final class OneDimensionBKDWriter {
        @NotNull
        private final IndexOutput metaOut;
        @NotNull
        private final IndexOutput indexOut;
        @NotNull
        private final IndexOutput dataOut;
        private final long dataStartFP;
        @NotNull
        private final LongArrayList leafBlockFPs;
        @NotNull
        private final List<byte[]> leafBlockStartValues;
        @NotNull
        private final byte[] leafValues;
        @NotNull
        private final int[] leafDocs;
        private long valueCount;
        private int leafCount;
        private int leafCardinality;
        @NotNull
        private final byte[] lastPackedValue;
        private int lastDocID;

        public OneDimensionBKDWriter(@NotNull IndexOutput metaOut, @NotNull IndexOutput indexOut, IndexOutput dataOut) {
            Intrinsics.checkNotNullParameter((Object)metaOut, (String)"metaOut");
            Intrinsics.checkNotNullParameter((Object)indexOut, (String)"indexOut");
            Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
            this.leafBlockFPs = new LongArrayList();
            this.leafBlockStartValues = new ArrayList();
            this.leafValues = new byte[BKDWriter.this.getConfig().getMaxPointsInLeafNode() * BKDWriter.this.getConfig().packedBytesLength()];
            this.leafDocs = new int[BKDWriter.this.getConfig().getMaxPointsInLeafNode()];
            if (BKDWriter.this.getConfig().getNumIndexDims() != 1) {
                throw new UnsupportedOperationException("config.numIndexDims must be 1 but got " + BKDWriter.this.getConfig().getNumIndexDims());
            }
            if (!(BKDWriter.this.getPointCount() == 0L)) {
                boolean $i$a$-check-BKDWriter$OneDimensionBKDWriter$32 = false;
                String $i$a$-check-BKDWriter$OneDimensionBKDWriter$32 = "cannot mix add and merge";
                throw new IllegalStateException($i$a$-check-BKDWriter$OneDimensionBKDWriter$32.toString());
            }
            if (!(!BKDWriter.this.finished)) {
                boolean bl = false;
                String string = "already finished";
                throw new IllegalStateException(string.toString());
            }
            BKDWriter.this.finished = true;
            this.metaOut = metaOut;
            this.indexOut = indexOut;
            this.dataOut = dataOut;
            this.dataStartFP = dataOut.getFilePointer();
            this.lastPackedValue = new byte[BKDWriter.this.getConfig().packedBytesLength()];
        }

        @NotNull
        public final IndexOutput getMetaOut() {
            return this.metaOut;
        }

        @NotNull
        public final IndexOutput getIndexOut() {
            return this.indexOut;
        }

        @NotNull
        public final IndexOutput getDataOut() {
            return this.dataOut;
        }

        public final long getDataStartFP() {
            return this.dataStartFP;
        }

        @NotNull
        public final LongArrayList getLeafBlockFPs() {
            return this.leafBlockFPs;
        }

        @NotNull
        public final List<byte[]> getLeafBlockStartValues() {
            return this.leafBlockStartValues;
        }

        @NotNull
        public final byte[] getLeafValues() {
            return this.leafValues;
        }

        @NotNull
        public final int[] getLeafDocs() {
            return this.leafDocs;
        }

        @NotNull
        public final byte[] getLastPackedValue() {
            return this.lastPackedValue;
        }

        public final void add(@NotNull byte[] packedValue, int docID) throws IOException {
            int n;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                    if (!Companion.valueInOrder(BKDWriter.this.getConfig(), this.valueCount + (long)this.leafCount, 0, this.lastPackedValue, packedValue, 0, docID, this.lastDocID)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (this.leafCount == 0) break block7;
                    if (BKDWriter.this.equalsPredicate.test(this.leafValues, (this.leafCount - 1) * BKDWriter.this.getConfig().getBytesPerDim(), packedValue, 0)) break block8;
                }
                n = this.leafCardinality;
                this.leafCardinality = n + 1;
            }
            System.INSTANCE.arraycopy(packedValue, 0, this.leafValues, this.leafCount * BKDWriter.this.getConfig().packedBytesLength(), BKDWriter.this.getConfig().packedBytesLength());
            this.leafDocs[this.leafCount] = docID;
            BKDWriter.this.getDocsSeen().set(docID);
            n = this.leafCount;
            this.leafCount = n + 1;
            n = this.valueCount + (long)this.leafCount <= BKDWriter.this.totalPointCount ? 1 : 0;
            BKDWriter bKDWriter = BKDWriter.this;
            if (n == 0) {
                boolean $i$a$-check-BKDWriter$OneDimensionBKDWriter$add$22 = false;
                String $i$a$-check-BKDWriter$OneDimensionBKDWriter$add$22 = "totalPointCount=" + bKDWriter.totalPointCount + " was passed when we were created, but we just hit " + (this.valueCount + (long)this.leafCount) + " values";
                throw new IllegalStateException($i$a$-check-BKDWriter$OneDimensionBKDWriter$add$22.toString());
            }
            if (this.leafCount == BKDWriter.this.getConfig().getMaxPointsInLeafNode()) {
                this.writeLeafBlock(this.leafCardinality);
                this.leafCardinality = 0;
                this.leafCount = 0;
            }
            int it = n = docID;
            boolean bl = false;
            this.lastDocID = it;
            if (!(n >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Nullable
        public final IORunnable finish() throws IOException {
            if (this.leafCount > 0) {
                this.writeLeafBlock(this.leafCardinality);
                this.leafCardinality = 0;
                this.leafCount = 0;
            }
            if (this.valueCount == 0L) {
                return null;
            }
            BKDWriter.this.setPointCount(this.valueCount);
            BKDWriter.this.getScratchBytesRef1().setLength(BKDWriter.this.getConfig().getBytesPerDim());
            BKDWriter.this.getScratchBytesRef1().setOffset(0);
            if (!(this.leafBlockStartValues.size() + 1 == this.leafBlockFPs.size())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            BKDTreeLeafNodes leafNodes2 = new BKDTreeLeafNodes(this, BKDWriter.this){
                final /* synthetic */ OneDimensionBKDWriter this$0;
                final /* synthetic */ BKDWriter this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public long getLeafLP(int index) {
                    return this.this$0.getLeafBlockFPs().get(index);
                }

                public BytesRef getSplitValue(int index) {
                    this.this$1.getScratchBytesRef1().setBytes(this.this$0.getLeafBlockStartValues().get(index));
                    return this.this$1.getScratchBytesRef1();
                }

                public int getSplitDimension(int index) {
                    return 0;
                }

                public int numLeaves() {
                    return this.this$0.getLeafBlockFPs().size();
                }
            };
            return () -> OneDimensionBKDWriter.finish$lambda$4(BKDWriter.this, this, leafNodes2);
        }

        public final void writeLeafBlock(int leafCardinality) throws IOException {
            if (!(this.leafCount != 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.valueCount == 0L) {
                System.INSTANCE.arraycopy(this.leafValues, 0, BKDWriter.this.getMinPackedValue(), 0, BKDWriter.this.getConfig().packedIndexBytesLength());
            }
            System.INSTANCE.arraycopy(this.leafValues, (this.leafCount - 1) * BKDWriter.this.getConfig().packedBytesLength(), BKDWriter.this.getMaxPackedValue(), 0, BKDWriter.this.getConfig().packedIndexBytesLength());
            this.valueCount += (long)this.leafCount;
            if (this.leafBlockFPs.size() > 0) {
                this.leafBlockStartValues.add(ArrayUtil.Companion.copyOfSubArray(this.leafValues, 0, BKDWriter.this.getConfig().packedBytesLength()));
            }
            this.leafBlockFPs.add(this.dataOut.getFilePointer());
            BKDWriter.this.checkMaxLeafNodeCount(this.leafBlockFPs.size());
            BKDWriter.this.getCommonPrefixLengths()[0] = BKDWriter.this.commonPrefixComparator.compare(this.leafValues, 0, this.leafValues, (this.leafCount - 1) * BKDWriter.this.getConfig().packedBytesLength());
            BKDWriter.this.writeLeafBlockDocs(this.dataOut, this.leafDocs, 0, this.leafCount);
            BKDWriter.this.writeCommonPrefixes(this.dataOut, BKDWriter.this.getCommonPrefixLengths(), this.leafValues);
            BKDWriter.this.getScratchBytesRef1().setLength(BKDWriter.this.getConfig().packedBytesLength());
            BKDWriter.this.getScratchBytesRef1().setBytes(this.leafValues);
            Function1 packedValues = arg_0 -> OneDimensionBKDWriter.writeLeafBlock$lambda$5(BKDWriter.this, arg_0);
            if (!Companion.valuesInOrderAndBounds(BKDWriter.this.getConfig(), this.leafCount, 0, ArrayUtil.Companion.copyOfSubArray(this.leafValues, 0, BKDWriter.this.getConfig().packedBytesLength()), ArrayUtil.Companion.copyOfSubArray(this.leafValues, (this.leafCount - 1) * BKDWriter.this.getConfig().packedBytesLength(), this.leafCount * BKDWriter.this.getConfig().packedBytesLength()), (Function1<? super Integer, BytesRef>)packedValues, this.leafDocs, 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            BKDWriter.this.writeLeafBlockPackedValues(this.dataOut, BKDWriter.this.getCommonPrefixLengths(), this.leafCount, 0, (Function1<? super Integer, BytesRef>)packedValues, leafCardinality);
        }

        private static final void finish$lambda$4(BKDWriter this$0, OneDimensionBKDWriter this$1, BKDTreeLeafNodes $leafNodes) {
            this$0.writeIndex(this$1.metaOut, this$1.indexOut, this$0.getConfig().getMaxPointsInLeafNode(), $leafNodes, this$1.dataStartFP);
        }

        private static final BytesRef writeLeafBlock$lambda$5(BKDWriter this$0, int i) {
            this$0.getScratchBytesRef1().setOffset(this$0.getConfig().packedBytesLength() * i);
            return this$0.getScratchBytesRef1();
        }
    }
}

