/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.bkd;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.ShortCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.ByteExtKt;
import org.gnit.lucenekmp.jdkport.ShortExtKt;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.DocBaseBitSetIterator;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.LongsRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J \u0010\u0019\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u0019\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001d\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001e\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/util/bkd/DocIdsWriter;", "", "maxPointsInLeaf", "", "<init>", "(I)V", "scratch", "", "scratchLongs", "Lorg/gnit/lucenekmp/util/LongsRef;", "scratchIntsRef", "Lorg/gnit/lucenekmp/util/IntsRef;", "writeDocIds", "", "docIds", "start", "count", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "readInts", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "docIDs", "readBitSetIterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "readBitSet", "visitor", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "readDelta16", "readInts24", "readInts32", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDocIdsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocIdsWriter.kt\norg/gnit/lucenekmp/util/bkd/DocIdsWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
public final class DocIdsWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] scratch;
    @NotNull
    private final LongsRef scratchLongs;
    @NotNull
    private final IntsRef scratchIntsRef;
    private static final byte CONTINUOUS_IDS = -2;
    private static final byte BITSET_IDS = -1;
    private static final byte DELTA_BPV_16 = 16;
    private static final byte BPV_24 = 24;
    private static final byte BPV_32 = 32;
    private static final byte LEGACY_DELTA_VINT = 0;

    public DocIdsWriter(int maxPointsInLeaf) {
        this.scratch = new int[maxPointsInLeaf];
        this.scratchLongs = new LongsRef();
        this.scratchIntsRef = new IntsRef();
        this.scratchIntsRef.setOffset(0);
    }

    public final void writeDocIds(@NotNull int[] docIds, int start, int count, @NotNull DataOutput out) throws IOException {
        block15: {
            int i;
            int max;
            block14: {
                int i2;
                Intrinsics.checkNotNullParameter((Object)docIds, (String)"docIds");
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                boolean strictlySorted = true;
                int min = docIds[0];
                max = docIds[0];
                for (int i3 = 1; i3 < count; ++i3) {
                    int last = docIds[start + i3 - 1];
                    int current = docIds[start + i3];
                    if (last >= current) {
                        strictlySorted = false;
                    }
                    min = Math.min(min, current);
                    max = Math.max(max, current);
                }
                int min2max = max - min + 1;
                if (strictlySorted) {
                    if (min2max == count) {
                        out.writeByte((byte)-2);
                        out.writeVInt(docIds[start]);
                        return;
                    }
                    if (min2max <= count << 4) {
                        if (!(min2max > count)) {
                            boolean $i$a$-require-DocIdsWriter$writeDocIds$22 = false;
                            String $i$a$-require-DocIdsWriter$writeDocIds$22 = "min2max: " + min2max + ", count: " + count;
                            throw new IllegalArgumentException($i$a$-require-DocIdsWriter$writeDocIds$22.toString());
                        }
                        out.writeByte((byte)-1);
                        DocIdsWriter.Companion.writeIdsAsBitSet(docIds, start, count, out);
                        return;
                    }
                }
                if (min2max > 65535) break block14;
                out.writeByte((byte)16);
                for (i = 0; i < count; ++i) {
                    this.scratch[i] = docIds[start + i] - min;
                }
                out.writeVInt(min);
                int halfLen = count >>> 1;
                for (i2 = 0; i2 < halfLen; ++i2) {
                    this.scratch[i2] = this.scratch[halfLen + i2] | this.scratch[i2] << 16;
                }
                for (i2 = 0; i2 < halfLen; ++i2) {
                    out.writeInt(this.scratch[i2]);
                }
                if ((count & 1) != 1) break block15;
                out.writeShort((short)this.scratch[count - 1]);
                break block15;
            }
            if (max <= 0xFFFFFF) {
                out.writeByte((byte)24);
                for (i = 0; i < count - 7; i += 8) {
                    int doc1 = docIds[start + i];
                    int doc2 = docIds[start + i + 1];
                    int doc3 = docIds[start + i + 2];
                    int doc4 = docIds[start + i + 3];
                    int doc5 = docIds[start + i + 4];
                    int doc6 = docIds[start + i + 5];
                    int doc7 = docIds[start + i + 6];
                    int doc8 = docIds[start + i + 7];
                    long l1 = ((long)doc1 & 0xFFFFFFL) << 40 | ((long)doc2 & 0xFFFFFFL) << 16 | (long)(doc3 >>> 8) & 0xFFFFL;
                    long l2 = ((long)doc3 & 0xFFL) << 56 | ((long)doc4 & 0xFFFFFFL) << 32 | ((long)doc5 & 0xFFFFFFL) << 8 | (long)(doc6 >> 16) & 0xFFL;
                    long l3 = ((long)doc6 & 0xFFFFL) << 48 | ((long)doc7 & 0xFFFFFFL) << 24 | (long)doc8 & 0xFFFFFFL;
                    out.writeLong(l1);
                    out.writeLong(l2);
                    out.writeLong(l3);
                }
                while (i < count) {
                    out.writeShort((short)(docIds[start + i] >>> 8));
                    out.writeByte((byte)docIds[start + i]);
                    ++i;
                }
            } else {
                out.writeByte((byte)32);
                for (i = 0; i < count; ++i) {
                    out.writeInt(docIds[start + i]);
                }
            }
        }
    }

    public final void readInts(@NotNull IndexInput in, int count, @NotNull int[] docIDs) throws IOException {
        byte bpv;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)docIDs, (String)"docIDs");
        byte by = bpv = in.readByte();
        if (by == -2) {
            DocIdsWriter.Companion.readContinuousIds(in, count, docIDs);
        } else if (by == -1) {
            this.readBitSet(in, count, docIDs);
        } else if (by == 16) {
            DocIdsWriter.Companion.readDelta16(in, count, docIDs);
        } else if (by == 24) {
            DocIdsWriter.Companion.readInts24(in, count, docIDs);
        } else if (by == 32) {
            DocIdsWriter.Companion.readInts32(in, count, docIDs);
        } else if (by == 0) {
            DocIdsWriter.Companion.readLegacyDeltaVInts(in, count, docIDs);
        } else {
            throw new IOException("Unsupported number of bits per value: " + bpv);
        }
    }

    private final DocIdSetIterator readBitSetIterator(IndexInput in, int count) throws IOException {
        int offsetWords = in.readVInt();
        int longLen = in.readVInt();
        this.scratchLongs.setLongs(ArrayUtil.Companion.growNoCopy(this.scratchLongs.getLongs(), longLen));
        in.readLongs(this.scratchLongs.getLongs(), 0, longLen);
        if (longLen < this.scratchLongs.getLength()) {
            Arrays.INSTANCE.fill(this.scratchLongs.getLongs(), longLen, this.scratchLongs.getLongs().length, 0L);
        }
        this.scratchLongs.setLength(longLen);
        FixedBitSet bitSet = new FixedBitSet(this.scratchLongs.getLongs(), longLen << 6);
        return new DocBaseBitSetIterator(bitSet, count, offsetWords << 6);
    }

    private final void readBitSet(IndexInput in, int count, int[] docIDs) throws IOException {
        DocIdSetIterator iterator2 = this.readBitSetIterator(in, count);
        int docId = 0;
        int pos = 0;
        while (true) {
            int n;
            int it = n = iterator2.nextDoc();
            boolean bl = false;
            docId = it;
            if (n == Integer.MAX_VALUE) break;
            n = pos;
            pos = n + 1;
            docIDs[n] = docId;
        }
        if (!(pos == count)) {
            boolean bl = false;
            String string = "pos: " + pos + ", count: " + count;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void readInts(@NotNull IndexInput in, int count, @NotNull PointValues.IntersectVisitor visitor2) throws IOException {
        byte bpv;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        byte by = bpv = in.readByte();
        if (by == -2) {
            DocIdsWriter.Companion.readContinuousIds(in, count, visitor2);
        } else if (by == -1) {
            this.readBitSet(in, count, visitor2);
        } else if (by == 16) {
            this.readDelta16(in, count, visitor2);
        } else if (by == 24) {
            this.readInts24(in, count, visitor2);
        } else if (by == 32) {
            this.readInts32(in, count, visitor2);
        } else if (by == 0) {
            DocIdsWriter.Companion.readLegacyDeltaVInts(in, count, visitor2);
        } else {
            throw new IOException("Unsupported number of bits per value: " + bpv);
        }
    }

    private final void readBitSet(IndexInput in, int count, PointValues.IntersectVisitor visitor2) throws IOException {
        DocIdSetIterator bitSetIterator = this.readBitSetIterator(in, count);
        visitor2.visit(bitSetIterator);
    }

    private final void readDelta16(IndexInput in, int count, PointValues.IntersectVisitor visitor2) throws IOException {
        DocIdsWriter.Companion.readDelta16(in, count, this.scratch);
        this.scratchIntsRef.setInts(this.scratch);
        this.scratchIntsRef.setLength(count);
        visitor2.visit(this.scratchIntsRef);
    }

    private final void readInts24(IndexInput in, int count, PointValues.IntersectVisitor visitor2) throws IOException {
        DocIdsWriter.Companion.readInts24(in, count, this.scratch);
        this.scratchIntsRef.setInts(this.scratch);
        this.scratchIntsRef.setLength(count);
        visitor2.visit(this.scratchIntsRef);
    }

    private final void readInts32(IndexInput in, int count, PointValues.IntersectVisitor visitor2) throws IOException {
        in.readInts(this.scratch, 0, count);
        this.scratchIntsRef.setInts(this.scratch);
        this.scratchIntsRef.setLength(count);
        visitor2.visit(this.scratchIntsRef);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J \u0010\u001a\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J \u0010\u001b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/util/bkd/DocIdsWriter$Companion;", "", "<init>", "()V", "CONTINUOUS_IDS", "", "BITSET_IDS", "DELTA_BPV_16", "BPV_24", "BPV_32", "LEGACY_DELTA_VINT", "writeIdsAsBitSet", "", "docIds", "", "start", "", "count", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "readContinuousIds", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "docIDs", "readLegacyDeltaVInts", "readDelta16", "readInts24", "readInts32", "visitor", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void writeIdsAsBitSet(int[] docIds, int start, int count, DataOutput out) throws IOException {
            int min = docIds[start];
            int max = docIds[start + count - 1];
            int offsetWords = min >> 6;
            int offsetBits = offsetWords << 6;
            int totalWordCount = FixedBitSet.Companion.bits2words(max - offsetBits + 1);
            long currentWord = 0L;
            int currentWordIndex = 0;
            out.writeVInt(offsetWords);
            out.writeVInt(totalWordCount);
            for (int i = 0; i < count; ++i) {
                int index = docIds[start + i] - offsetBits;
                int nextWordIndex = index >> 6;
                if (!(currentWordIndex <= nextWordIndex)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (currentWordIndex < nextWordIndex) {
                    out.writeLong(currentWord);
                    currentWord = 0L;
                    ++currentWordIndex;
                    while (currentWordIndex < nextWordIndex) {
                        ++currentWordIndex;
                        out.writeLong(0L);
                    }
                }
                currentWord |= 1L << index;
            }
            out.writeLong(currentWord);
            if (!(currentWordIndex + 1 == totalWordCount)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final void readContinuousIds(IndexInput in, int count, int[] docIDs) throws IOException {
            int start = in.readVInt();
            for (int i = 0; i < count; ++i) {
                docIDs[i] = start + i;
            }
        }

        private final void readLegacyDeltaVInts(IndexInput in, int count, int[] docIDs) throws IOException {
            int doc = 0;
            for (int i = 0; i < count; ++i) {
                docIDs[i] = doc += in.readVInt();
            }
        }

        private final void readDelta16(IndexInput in, int count, int[] docIDs) throws IOException {
            int min = in.readVInt();
            int halfLen = count >>> 1;
            in.readInts(docIDs, 0, halfLen);
            for (int i = 0; i < halfLen; ++i) {
                int l = docIDs[i];
                docIDs[i] = (l >>> 16) + min;
                docIDs[halfLen + i] = (l & 0xFFFF) + min;
            }
            if ((count & 1) == 1) {
                docIDs[count - 1] = ShortExtKt.toUnsignedInt(ShortCompanionObject.INSTANCE, in.readShort()) + min;
            }
        }

        private final void readInts24(IndexInput in, int count, int[] docIDs) throws IOException {
            int i;
            for (i = 0; i < count - 7; i += 8) {
                long l1 = in.readLong();
                long l2 = in.readLong();
                long l3 = in.readLong();
                docIDs[i] = (int)(l1 >>> 40);
                docIDs[i + 1] = (int)(l1 >>> 16) & 0xFFFFFF;
                docIDs[i + 2] = (int)((l1 & 0xFFFFL) << 8 | l2 >>> 56);
                docIDs[i + 3] = (int)(l2 >>> 32) & 0xFFFFFF;
                docIDs[i + 4] = (int)(l2 >>> 8) & 0xFFFFFF;
                docIDs[i + 5] = (int)((l2 & 0xFFL) << 16 | l3 >>> 48);
                docIDs[i + 6] = (int)(l3 >>> 24) & 0xFFFFFF;
                docIDs[i + 7] = (int)l3 & 0xFFFFFF;
            }
            while (i < count) {
                docIDs[i] = ShortExtKt.toUnsignedInt(ShortCompanionObject.INSTANCE, in.readShort()) << 8 | ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, in.readByte());
                ++i;
            }
        }

        private final void readInts32(IndexInput in, int count, int[] docIDs) throws IOException {
            in.readInts(docIDs, 0, count);
        }

        private final void readContinuousIds(IndexInput in, int count, PointValues.IntersectVisitor visitor2) throws IOException {
            int start = in.readVInt();
            visitor2.visit(DocIdSetIterator.Companion.range(start, start + count));
        }

        private final void readLegacyDeltaVInts(IndexInput in, int count, PointValues.IntersectVisitor visitor2) throws IOException {
            int doc = 0;
            for (int i = 0; i < count; ++i) {
                visitor2.visit(doc += in.readVInt());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

