/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.bkd;

import kotlin.Metadata;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.MutablePointTree;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.ByteExtKt;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IntroSelector;
import org.gnit.lucenekmp.util.IntroSorter;
import org.gnit.lucenekmp.util.RadixSelector;
import org.gnit.lucenekmp.util.Selector;
import org.gnit.lucenekmp.util.StableMSBRadixSorter;
import org.gnit.lucenekmp.util.bkd.BKDConfig;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJH\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013JV\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/bkd/MutablePointTreeReaderUtils;", "", "<init>", "()V", "sort", "", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "maxDoc", "", "reader", "Lorg/gnit/lucenekmp/codecs/MutablePointTree;", "from", "to", "sortByDim", "sortedDim", "commonPrefixLengths", "", "scratch1", "Lorg/gnit/lucenekmp/util/BytesRef;", "scratch2", "partition", "splitDim", "commonPrefixLen", "mid", "core"})
public final class MutablePointTreeReaderUtils {
    @NotNull
    public static final MutablePointTreeReaderUtils INSTANCE = new MutablePointTreeReaderUtils();

    private MutablePointTreeReaderUtils() {
    }

    public final void sort(@NotNull BKDConfig config, int maxDoc, @NotNull MutablePointTree reader2, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        boolean sortedByDocID = true;
        int prevDoc = 0;
        for (int i = from; i < to; ++i) {
            int doc = reader2.getDocID(i);
            if (doc < prevDoc) {
                sortedByDocID = false;
                break;
            }
            prevDoc = doc;
        }
        int bitsPerDocId = sortedByDocID ? 0 : PackedInts.INSTANCE.bitsRequired((long)maxDoc - 1L);
        int n = config.packedBytesLength() + (bitsPerDocId + 7) / 8;
        new StableMSBRadixSorter(reader2, config, bitsPerDocId, n){
            final /* synthetic */ MutablePointTree $reader;
            final /* synthetic */ BKDConfig $config;
            final /* synthetic */ int $bitsPerDocId;
            {
                this.$reader = $reader;
                this.$config = $config;
                this.$bitsPerDocId = $bitsPerDocId;
                super($super_call_param$1);
            }

            protected void swap(int i, int j) {
                this.$reader.swap(i, j);
            }

            protected void save(int i, int j) {
                this.$reader.save(i, j);
            }

            protected void restore(int i, int j) {
                this.$reader.restore(i, j);
            }

            protected int byteAt(int i, int k) {
                int n;
                if (k < this.$config.packedBytesLength()) {
                    n = ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, this.$reader.getByteAt(i, k));
                } else {
                    int shift = this.$bitsPerDocId - (k - this.$config.packedBytesLength() + 1 << 3);
                    n = this.$reader.getDocID(i) >>> Math.max(0, shift) & 0xFF;
                }
                return n;
            }
        }.sort(from, to);
    }

    public final void sortByDim(@NotNull BKDConfig config, int sortedDim, @Nullable int[] commonPrefixLengths, @NotNull MutablePointTree reader2, int from, int to, @NotNull BytesRef scratch1, @NotNull BytesRef scratch2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)scratch1, (String)"scratch1");
        Intrinsics.checkNotNullParameter((Object)scratch2, (String)"scratch2");
        ArrayUtil.Companion.ByteArrayComparator comparator2 = ArrayUtil.Companion.getUnsignedComparator(config.getBytesPerDim());
        int start = sortedDim * config.getBytesPerDim();
        new IntroSorter(scratch1, reader2, scratch2, comparator2, start, config){
            private final BytesRef pivot;
            private int pivotDoc;
            final /* synthetic */ MutablePointTree $reader;
            final /* synthetic */ BytesRef $scratch2;
            final /* synthetic */ ArrayUtil.Companion.ByteArrayComparator $comparator;
            final /* synthetic */ int $start;
            final /* synthetic */ BKDConfig $config;
            {
                this.$reader = $reader;
                this.$scratch2 = $scratch2;
                this.$comparator = $comparator;
                this.$start = $start;
                this.$config = $config;
                this.pivot = $scratch1;
                this.pivotDoc = -1;
            }

            public final BytesRef getPivot() {
                return this.pivot;
            }

            public final int getPivotDoc() {
                return this.pivotDoc;
            }

            public final void setPivotDoc(int n) {
                this.pivotDoc = n;
            }

            protected void swap(int i, int j) {
                this.$reader.swap(i, j);
            }

            protected void setPivot(int i) {
                this.$reader.getValue(i, this.pivot);
                this.pivotDoc = this.$reader.getDocID(i);
            }

            protected int comparePivot(int j) {
                this.$reader.getValue(j, this.$scratch2);
                int cmp = this.$comparator.compare(this.pivot.getBytes(), this.pivot.getOffset() + this.$start, this.$scratch2.getBytes(), this.$scratch2.getOffset() + this.$start);
                if (cmp == 0 && (cmp = Arrays.INSTANCE.compareUnsigned(this.pivot.getBytes(), this.pivot.getOffset() + this.$config.packedIndexBytesLength(), this.pivot.getOffset() + this.$config.packedBytesLength(), this.$scratch2.getBytes(), this.$scratch2.getOffset() + this.$config.packedIndexBytesLength(), this.$scratch2.getOffset() + this.$config.packedBytesLength())) == 0) {
                    cmp = this.pivotDoc - this.$reader.getDocID(j);
                }
                return cmp;
            }
        }.sort(from, to);
    }

    public final void partition(@NotNull BKDConfig config, int maxDoc, int splitDim, int commonPrefixLen, @NotNull MutablePointTree reader2, int from, int to, int mid, @NotNull BytesRef scratch1, @NotNull BytesRef scratch2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)scratch1, (String)"scratch1");
        Intrinsics.checkNotNullParameter((Object)scratch2, (String)"scratch2");
        int dimOffset = splitDim * config.getBytesPerDim() + commonPrefixLen;
        int dimCmpBytes = config.getBytesPerDim() - commonPrefixLen;
        int dataCmpBytes = (config.getNumDims() - config.getNumIndexDims()) * config.getBytesPerDim() + dimCmpBytes;
        int bitsPerDocId = PackedInts.INSTANCE.bitsRequired((long)maxDoc - 1L);
        int n = dataCmpBytes + (bitsPerDocId + 7) / 8;
        new RadixSelector(splitDim, config, dimCmpBytes, scratch1, reader2, scratch2, dataCmpBytes, dimOffset, bitsPerDocId, n){
            final /* synthetic */ int $splitDim;
            final /* synthetic */ BKDConfig $config;
            final /* synthetic */ int $dimCmpBytes;
            final /* synthetic */ BytesRef $scratch1;
            final /* synthetic */ MutablePointTree $reader;
            final /* synthetic */ BytesRef $scratch2;
            final /* synthetic */ int $dataCmpBytes;
            final /* synthetic */ int $dimOffset;
            final /* synthetic */ int $bitsPerDocId;
            {
                this.$splitDim = $splitDim;
                this.$config = $config;
                this.$dimCmpBytes = $dimCmpBytes;
                this.$scratch1 = $scratch1;
                this.$reader = $reader;
                this.$scratch2 = $scratch2;
                this.$dataCmpBytes = $dataCmpBytes;
                this.$dimOffset = $dimOffset;
                this.$bitsPerDocId = $bitsPerDocId;
                super($super_call_param$1);
            }

            protected Selector getFallbackSelector(int k) {
                int dimStart = this.$splitDim * this.$config.getBytesPerDim();
                int dataStart = k < this.$dimCmpBytes ? this.$config.packedIndexBytesLength() : this.$config.packedIndexBytesLength() + k - this.$dimCmpBytes;
                int dataEnd = this.$config.getNumDims() * this.$config.getBytesPerDim();
                ArrayUtil.Companion.ByteArrayComparator dimComparator = ArrayUtil.Companion.getUnsignedComparator(this.$config.getBytesPerDim());
                return new IntroSelector(this.$scratch1, this.$reader, k, this.$dimCmpBytes, this.$scratch2, dimComparator, dimStart, this.$dataCmpBytes, dataStart, dataEnd){
                    private final BytesRef pivot;
                    private int pivotDoc;
                    final /* synthetic */ MutablePointTree $reader;
                    final /* synthetic */ int $k;
                    final /* synthetic */ int $dimCmpBytes;
                    final /* synthetic */ BytesRef $scratch2;
                    final /* synthetic */ ArrayUtil.Companion.ByteArrayComparator $dimComparator;
                    final /* synthetic */ int $dimStart;
                    final /* synthetic */ int $dataCmpBytes;
                    final /* synthetic */ int $dataStart;
                    final /* synthetic */ int $dataEnd;
                    {
                        this.$reader = $reader;
                        this.$k = $k;
                        this.$dimCmpBytes = $dimCmpBytes;
                        this.$scratch2 = $scratch2;
                        this.$dimComparator = $dimComparator;
                        this.$dimStart = $dimStart;
                        this.$dataCmpBytes = $dataCmpBytes;
                        this.$dataStart = $dataStart;
                        this.$dataEnd = $dataEnd;
                        this.pivot = $scratch1;
                    }

                    public final BytesRef getPivot() {
                        return this.pivot;
                    }

                    public final int getPivotDoc() {
                        return this.pivotDoc;
                    }

                    public final void setPivotDoc(int n) {
                        this.pivotDoc = n;
                    }

                    protected void swap(int i, int j) {
                        this.$reader.swap(i, j);
                    }

                    protected void setPivot(int i) {
                        this.$reader.getValue(i, this.pivot);
                        this.pivotDoc = this.$reader.getDocID(i);
                    }

                    protected int comparePivot(int j) {
                        int cmp;
                        if (this.$k < this.$dimCmpBytes) {
                            this.$reader.getValue(j, this.$scratch2);
                            cmp = this.$dimComparator.compare(this.pivot.getBytes(), this.pivot.getOffset() + this.$dimStart, this.$scratch2.getBytes(), this.$scratch2.getOffset() + this.$dimStart);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        if (this.$k < this.$dataCmpBytes) {
                            this.$reader.getValue(j, this.$scratch2);
                            cmp = Arrays.INSTANCE.compareUnsigned(this.pivot.getBytes(), this.pivot.getOffset() + this.$dataStart, this.pivot.getOffset() + this.$dataEnd, this.$scratch2.getBytes(), this.$scratch2.getOffset() + this.$dataStart, this.$scratch2.getOffset() + this.$dataEnd);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        return this.pivotDoc - this.$reader.getDocID(j);
                    }
                };
            }

            protected void swap(int i, int j) {
                this.$reader.swap(i, j);
            }

            protected int byteAt(int i, int k) {
                int n;
                if (k < this.$dimCmpBytes) {
                    n = ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, this.$reader.getByteAt(i, this.$dimOffset + k));
                } else if (k < this.$dataCmpBytes) {
                    n = ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, this.$reader.getByteAt(i, this.$config.packedIndexBytesLength() + k - this.$dimCmpBytes));
                } else {
                    int shift = this.$bitsPerDocId - (k - this.$dataCmpBytes + 1 << 3);
                    n = this.$reader.getDocID(i) >>> Math.max(0, shift) & 0xFF;
                }
                return n;
            }
        }.select(from, to, mid);
    }
}

