/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.bkd;

import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.bkd.BKDConfig;
import org.gnit.lucenekmp.util.bkd.PointReader;
import org.gnit.lucenekmp.util.bkd.PointValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00012B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010.\u001a\u00020&H\u0016J\b\u0010,\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/gnit/lucenekmp/util/bkd/OfflinePointReader;", "Lorg/gnit/lucenekmp/util/bkd/PointReader;", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "tempDir", "Lorg/gnit/lucenekmp/store/Directory;", "tempFileName", "", "start", "", "length", "reusableBuffer", "", "<init>", "(Lorg/gnit/lucenekmp/util/bkd/BKDConfig;Lorg/gnit/lucenekmp/store/Directory;Ljava/lang/String;JJ[B)V", "countLeft", "getCountLeft", "()J", "setCountLeft", "(J)V", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "getIn", "()Lorg/gnit/lucenekmp/store/IndexInput;", "setIn", "(Lorg/gnit/lucenekmp/store/IndexInput;)V", "onHeapBuffer", "getOnHeapBuffer", "()[B", "setOnHeapBuffer", "([B)V", "offset", "", "getOffset", "()I", "setOffset", "(I)V", "checked", "", "pointsInBuffer", "maxPointOnHeap", "name", "getName", "()Ljava/lang/String;", "pointValue", "Lorg/gnit/lucenekmp/util/bkd/OfflinePointReader$OfflinePointValue;", "next", "Lorg/gnit/lucenekmp/util/bkd/PointValue;", "close", "", "OfflinePointValue", "core"})
@SourceDebugExtension(value={"SMAP\nOfflinePointReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflinePointReader.kt\norg/gnit/lucenekmp/util/bkd/OfflinePointReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
public final class OfflinePointReader
implements PointReader {
    @NotNull
    private final BKDConfig config;
    private long countLeft;
    @Nullable
    private IndexInput in;
    @NotNull
    private byte[] onHeapBuffer;
    private int offset;
    private boolean checked;
    private int pointsInBuffer;
    private final int maxPointOnHeap;
    @NotNull
    private final String name;
    @NotNull
    private final OfflinePointValue pointValue;

    public OfflinePointReader(@NotNull BKDConfig config, @NotNull Directory tempDir, @NotNull String tempFileName2, long start, long length, @NotNull byte[] reusableBuffer) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)tempFileName2, (String)"tempFileName");
        Intrinsics.checkNotNullParameter((Object)reusableBuffer, (String)"reusableBuffer");
        this.config = config;
        if (!((start + length) * (long)this.config.bytesPerDoc() + (long)CodecUtil.INSTANCE.footerLength() <= tempDir.fileLength(tempFileName2))) {
            boolean $i$a$-require-OfflinePointReader$22 = false;
            String $i$a$-require-OfflinePointReader$22 = "requested slice is beyond the length of this file: start=" + start + " length=" + length + " bytesPerDoc=" + this.config.bytesPerDoc() + " fileLength=" + tempDir.fileLength(tempFileName2) + " tempFileName=" + tempFileName2;
            throw new IllegalArgumentException($i$a$-require-OfflinePointReader$22.toString());
        }
        if (!(reusableBuffer.length >= this.config.bytesPerDoc())) {
            boolean bl = false;
            String string = "Length of [reusableBuffer] must be bigger than " + this.config.bytesPerDoc();
            throw new IllegalArgumentException(string.toString());
        }
        this.maxPointOnHeap = reusableBuffer.length / this.config.bytesPerDoc();
        this.in = start == 0L && length * (long)this.config.bytesPerDoc() == tempDir.fileLength(tempFileName2) - (long)CodecUtil.INSTANCE.footerLength() ? (IndexInput)tempDir.openChecksumInput(tempFileName2) : tempDir.openInput(tempFileName2, IOContext.Companion.getREADONCE());
        this.name = tempFileName2;
        long seekFP = start * (long)this.config.bytesPerDoc();
        IndexInput indexInput = this.in;
        if (indexInput != null) {
            indexInput.seek(seekFP);
        }
        this.countLeft = length;
        this.onHeapBuffer = reusableBuffer;
        this.pointValue = new OfflinePointValue(this.config, this.onHeapBuffer);
    }

    public final long getCountLeft() {
        return this.countLeft;
    }

    public final void setCountLeft(long l) {
        this.countLeft = l;
    }

    @Nullable
    public final IndexInput getIn() {
        return this.in;
    }

    public final void setIn(@Nullable IndexInput indexInput) {
        this.in = indexInput;
    }

    @NotNull
    public final byte[] getOnHeapBuffer() {
        return this.onHeapBuffer;
    }

    public final void setOnHeapBuffer(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.onHeapBuffer = byArray;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean next() throws IOException {
        if (this.pointsInBuffer == 0) {
            if (this.countLeft >= 0L && this.countLeft == 0L) {
                return false;
            }
            try {
                if (this.countLeft > (long)this.maxPointOnHeap) {
                    IndexInput indexInput = this.in;
                    if (indexInput != null) {
                        indexInput.readBytes(this.onHeapBuffer, 0, this.maxPointOnHeap * this.config.bytesPerDoc());
                    }
                    this.pointsInBuffer = this.maxPointOnHeap - 1;
                    this.countLeft -= (long)this.maxPointOnHeap;
                } else {
                    IndexInput indexInput = this.in;
                    if (indexInput != null) {
                        indexInput.readBytes(this.onHeapBuffer, 0, (int)this.countLeft * this.config.bytesPerDoc());
                    }
                    this.pointsInBuffer = Math.INSTANCE.toIntExact(this.countLeft - 1L);
                    this.countLeft = 0L;
                }
                this.offset = 0;
            }
            catch (EOFException eofe) {
                if (!(this.countLeft == -1L)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return false;
            }
        } else {
            int n = this.pointsInBuffer;
            this.pointsInBuffer = n + -1;
            this.offset += this.config.bytesPerDoc();
        }
        return true;
    }

    @Override
    @NotNull
    public PointValue pointValue() {
        this.pointValue.setOffset(this.offset);
        return this.pointValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.countLeft == 0L && this.in instanceof ChecksumIndexInput && !this.checked) {
                this.checked = true;
                IndexInput indexInput = this.in;
                Intrinsics.checkNotNull((Object)indexInput);
                CodecUtil.INSTANCE.checkFooter((ChecksumIndexInput)indexInput);
            }
        }
        finally {
            IndexInput indexInput = this.in;
            Intrinsics.checkNotNull((Object)indexInput);
            indexInput.close();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/util/bkd/OfflinePointReader$OfflinePointValue;", "Lorg/gnit/lucenekmp/util/bkd/PointValue;", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "value", "", "<init>", "(Lorg/gnit/lucenekmp/util/bkd/BKDConfig;[B)V", "packedValue", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPackedValue", "()Lorg/gnit/lucenekmp/util/BytesRef;", "packedValueDocID", "getPackedValueDocID", "packedValueLength", "", "getPackedValueLength", "()I", "setOffset", "", "offset", "docID", "packedValueDocIDBytes", "core"})
    public static final class OfflinePointValue
    implements PointValue {
        @NotNull
        private final BytesRef packedValue;
        @NotNull
        private final BytesRef packedValueDocID;
        private final int packedValueLength;

        public OfflinePointValue(@NotNull BKDConfig config, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.packedValueDocID = new BytesRef(value, 0, config.bytesPerDoc());
            this.packedValueLength = config.packedBytesLength();
            this.packedValue = new BytesRef(value, 0, this.packedValueLength);
        }

        @NotNull
        public final BytesRef getPackedValue() {
            return this.packedValue;
        }

        @NotNull
        public final BytesRef getPackedValueDocID() {
            return this.packedValueDocID;
        }

        public final int getPackedValueLength() {
            return this.packedValueLength;
        }

        public final void setOffset(int offset) {
            this.packedValue.setOffset(offset);
            this.packedValueDocID.setOffset(offset);
        }

        @Override
        @NotNull
        public BytesRef packedValue() {
            return this.packedValue;
        }

        @Override
        public int docID() {
            int position = this.packedValueDocID.getOffset() + this.packedValueLength;
            return BitUtil.VH_BE_INT.INSTANCE.get(this.packedValueDocID.getBytes(), position);
        }

        @Override
        @NotNull
        public BytesRef packedValueDocIDBytes() {
            return this.packedValueDocID;
        }
    }
}

