/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.bkd;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.bkd.BKDConfig;
import org.gnit.lucenekmp.util.bkd.OfflinePointReader;
import org.gnit.lucenekmp.util.bkd.PointReader;
import org.gnit.lucenekmp.util.bkd.PointValue;
import org.gnit.lucenekmp.util.bkd.PointWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0016J\u001e\u0010(\u001a\u00020,2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\n2\u0006\u0010-\u001a\u00020#J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010.\u001a\u00020!H\u0016J\b\u0010/\u001a\u00020!H\u0016J\b\u00100\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/gnit/lucenekmp/util/bkd/OfflinePointWriter;", "Lorg/gnit/lucenekmp/util/bkd/PointWriter;", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "tempDir", "Lorg/gnit/lucenekmp/store/Directory;", "tempFileNamePrefix", "", "desc", "expectedCount", "", "<init>", "(Lorg/gnit/lucenekmp/util/bkd/BKDConfig;Lorg/gnit/lucenekmp/store/Directory;Ljava/lang/String;Ljava/lang/String;J)V", "getConfig", "()Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "getTempDir", "()Lorg/gnit/lucenekmp/store/Directory;", "getExpectedCount", "()J", "out", "Lorg/gnit/lucenekmp/store/IndexOutput;", "getOut", "()Lorg/gnit/lucenekmp/store/IndexOutput;", "name", "getName", "()Ljava/lang/String;", "count", "getCount", "setCount", "(J)V", "closed", "", "append", "", "packedValue", "", "docID", "", "pointValue", "Lorg/gnit/lucenekmp/util/bkd/PointValue;", "getReader", "Lorg/gnit/lucenekmp/util/bkd/PointReader;", "start", "length", "Lorg/gnit/lucenekmp/util/bkd/OfflinePointReader;", "reusableBuffer", "close", "destroy", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nOfflinePointWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflinePointWriter.kt\norg/gnit/lucenekmp/util/bkd/OfflinePointWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public class OfflinePointWriter
implements PointWriter {
    @NotNull
    private final BKDConfig config;
    @NotNull
    private final Directory tempDir;
    private final long expectedCount;
    @NotNull
    private final IndexOutput out;
    @NotNull
    private final String name;
    private long count;
    private boolean closed;

    public OfflinePointWriter(@NotNull BKDConfig config, @NotNull Directory tempDir, @NotNull String tempFileNamePrefix, @NotNull String desc, long expectedCount) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)tempFileNamePrefix, (String)"tempFileNamePrefix");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        this.config = config;
        this.tempDir = tempDir;
        this.expectedCount = expectedCount;
        this.out = this.tempDir.createTempOutput(tempFileNamePrefix, "bkd_" + desc, IOContext.Companion.getDEFAULT());
        this.name = this.out.getName();
    }

    @NotNull
    public final BKDConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Directory getTempDir() {
        return this.tempDir;
    }

    public final long getExpectedCount() {
        return this.expectedCount;
    }

    @NotNull
    public final IndexOutput getOut() {
        return this.out;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getCount() {
        return this.count;
    }

    public final void setCount(long l) {
        this.count = l;
    }

    @Override
    public void append(@NotNull byte[] packedValue, int docID) throws IOException {
        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
        if (!(!this.closed)) {
            boolean $i$a$-require-OfflinePointWriter$append$42 = false;
            String $i$a$-require-OfflinePointWriter$append$42 = "Point writer is already closed";
            throw new IllegalArgumentException($i$a$-require-OfflinePointWriter$append$42.toString());
        }
        if (!(packedValue.length == this.config.packedBytesLength())) {
            boolean $i$a$-require-OfflinePointWriter$append$52 = false;
            String $i$a$-require-OfflinePointWriter$append$52 = "[packedValue] must have length [" + this.config.packedBytesLength() + "] but was [" + packedValue.length + "]";
            throw new IllegalArgumentException($i$a$-require-OfflinePointWriter$append$52.toString());
        }
        this.out.writeBytes(packedValue, 0, packedValue.length);
        this.out.writeInt(IntExtKt.reverseBytes(IntCompanionObject.INSTANCE, docID));
        long l = this.count;
        this.count = l + 1L;
        if (!(this.expectedCount == 0L || this.count <= this.expectedCount)) {
            boolean bl = false;
            String string = "expectedCount=" + this.expectedCount + " vs count=" + this.count;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void append(@NotNull PointValue pointValue) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pointValue, (String)"pointValue");
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "Point writer is already closed";
            throw new IllegalArgumentException(string.toString());
        }
        BytesRef packedValueDocID = pointValue.packedValueDocIDBytes();
        if (!(packedValueDocID.getLength() == this.config.bytesPerDoc())) {
            boolean $i$a$-require-OfflinePointWriter$append$72 = false;
            String $i$a$-require-OfflinePointWriter$append$72 = "[packedValue and docID] must have length [" + this.config.bytesPerDoc() + "] but was [" + packedValueDocID.getLength() + "]";
            throw new IllegalArgumentException($i$a$-require-OfflinePointWriter$append$72.toString());
        }
        this.out.writeBytes(packedValueDocID.getBytes(), packedValueDocID.getOffset(), packedValueDocID.getLength());
        long l = this.count;
        this.count = l + 1L;
        if (!(this.expectedCount == 0L || this.count <= this.expectedCount)) {
            boolean bl = false;
            String string = "expectedCount=" + this.expectedCount + " vs count=" + this.count;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public PointReader getReader(long start, long length) throws IOException {
        byte[] buffer = new byte[this.config.bytesPerDoc()];
        return this.getReader(start, length, buffer);
    }

    @NotNull
    public final OfflinePointReader getReader(long start, long length, @NotNull byte[] reusableBuffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reusableBuffer, (String)"reusableBuffer");
        if (!this.closed) {
            boolean $i$a$-require-OfflinePointWriter$getReader$32 = false;
            String $i$a$-require-OfflinePointWriter$getReader$32 = "point writer is still open and trying to get a reader";
            throw new IllegalArgumentException($i$a$-require-OfflinePointWriter$getReader$32.toString());
        }
        if (!(start + length <= this.count)) {
            boolean bl = false;
            String string = "start=" + start + " length=" + length + " count=" + this.count;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.expectedCount == 0L || this.count == this.expectedCount)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new OfflinePointReader(this.config, this.tempDir, this.name, start, length, reusableBuffer);
    }

    @Override
    public long count() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                CodecUtil.INSTANCE.writeFooter(this.out);
            }
            finally {
                this.out.close();
                this.closed = true;
            }
        }
    }

    @Override
    public void destroy() throws IOException {
        this.tempDir.deleteFile(this.name);
    }

    @NotNull
    public String toString() {
        return "OfflinePointWriter(count=" + this.count + " tempFileName=" + this.name + ")";
    }
}

