/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.compress;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.ShortCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.ShortExtKt;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006456789B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0005H\u0002J(\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J&\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0005J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J0\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J(\u0010'\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J8\u0010(\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J.\u0010,\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010/\u001a\u000200J6\u00101\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010/\u001a\u000200R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/gnit/lucenekmp/util/compress/LZ4;", "", "<init>", "()V", "MAX_DISTANCE", "", "MEMORY_USAGE", "MIN_MATCH", "LAST_LITERALS", "HASH_LOG_HC", "HASH_TABLE_SIZE_HC", "hash", "i", "hashBits", "hashHC", "readInt", "buf", "", "commonBytes", "b", "o1", "o2", "limit", "decompress", "compressed", "Lorg/gnit/lucenekmp/store/DataInput;", "decompressedLen", "dest", "dOff", "encodeLen", "", "l", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "encodeLiterals", "bytes", "token", "anchor", "literalLen", "encodeLastLiterals", "encodeSequence", "matchRef", "matchOff", "matchLen", "compress", "off", "len", "ht", "Lorg/gnit/lucenekmp/util/compress/LZ4$HashTable;", "compressWithDictionary", "dictOff", "dictLen", "HashTable", "Table", "Table16", "Table32", "FastCompressionHashTable", "HighCompressionHashTable", "core"})
@SourceDebugExtension(value={"SMAP\nLZ4.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LZ4.kt\norg/gnit/lucenekmp/util/compress/LZ4\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,550:1\n1#2:551\n*E\n"})
public final class LZ4 {
    @NotNull
    public static final LZ4 INSTANCE = new LZ4();
    public static final int MAX_DISTANCE = 65536;
    public static final int MEMORY_USAGE = 14;
    public static final int MIN_MATCH = 4;
    public static final int LAST_LITERALS = 5;
    public static final int HASH_LOG_HC = 15;
    public static final int HASH_TABLE_SIZE_HC = 32768;

    private LZ4() {
    }

    private final int hash(int i, int hashBits) {
        return i * -1640531535 >>> 32 - hashBits;
    }

    private final int hashHC(int i) {
        return this.hash(i, 15);
    }

    private final int readInt(byte[] buf, int i) {
        return BitUtil.VH_NATIVE_INT.INSTANCE.get(buf, i);
    }

    private final int commonBytes(byte[] b, int o1, int o2, int limit) {
        if (!(o1 < o2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return Arrays.INSTANCE.mismatch(b, o1, limit, b, o2, limit);
    }

    public final int decompress(@NotNull DataInput compressed, int decompressedLen, @NotNull byte[] dest, int dOff) throws IOException {
        Intrinsics.checkNotNullParameter((Object)compressed, (String)"compressed");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int dOff2 = dOff;
        int destEnd = dOff2 + decompressedLen;
        do {
            byte by;
            int token;
            int literalLen;
            if ((literalLen = (token = compressed.readByte() & 0xFF) >>> 4) != 0) {
                if (literalLen == 15) {
                    byte len = 0;
                    while (true) {
                        byte by2;
                        byte it = by2 = compressed.readByte();
                        by = 0;
                        len = it;
                        if (by2 != -1) break;
                        literalLen += 255;
                    }
                    literalLen += len & 0xFF;
                }
                compressed.readBytes(dest, dOff2, literalLen);
                dOff2 += literalLen;
            }
            if (dOff2 >= destEnd) break;
            int matchDec = compressed.readShort() & 0xFFFF;
            if (!(matchDec > 0)) {
                String it = "Failed requirement.";
                throw new IllegalArgumentException(it.toString());
            }
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                byte len = 0;
                while (true) {
                    byte it = by = compressed.readByte();
                    boolean bl = false;
                    len = it;
                    if (by != -1) break;
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            int fastLen = (matchLen += 4) + 7 & 0xFFFFFFF8;
            if (matchDec < matchLen || dOff2 + fastLen > destEnd) {
                int ref = dOff2 - matchDec;
                int end = dOff2 + matchLen;
                while (dOff2 < end) {
                    dest[dOff2] = dest[ref];
                    ++ref;
                    ++dOff2;
                }
            } else {
                ArraysKt.copyInto((byte[])dest, (byte[])dest, (int)dOff2, (int)(dOff2 - matchDec), (int)(dOff2 - matchDec + fastLen));
                dOff2 += matchLen;
            }
        } while (dOff2 < destEnd);
        return dOff2;
    }

    private final void encodeLen(int l, DataOutput out) throws IOException {
        int l2;
        for (l2 = l; l2 >= 255; l2 -= 255) {
            out.writeByte((byte)-1);
        }
        out.writeByte((byte)l2);
    }

    private final void encodeLiterals(byte[] bytes, int token, int anchor, int literalLen, DataOutput out) throws IOException {
        out.writeByte((byte)token);
        if (literalLen >= 15) {
            this.encodeLen(literalLen - 15, out);
        }
        out.writeBytes(bytes, anchor, literalLen);
    }

    private final void encodeLastLiterals(byte[] bytes, int anchor, int literalLen, DataOutput out) throws IOException {
        int token = Math.min(literalLen, 15) << 4;
        this.encodeLiterals(bytes, token, anchor, literalLen, out);
    }

    private final void encodeSequence(byte[] bytes, int anchor, int matchRef, int matchOff, int matchLen, DataOutput out) throws IOException {
        int literalLen = matchOff - anchor;
        if (!(matchLen >= 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int token = Math.min(literalLen, 15) << 4 | Math.min(matchLen - 4, 15);
        this.encodeLiterals(bytes, token, anchor, literalLen, out);
        int matchDec = matchOff - matchRef;
        if (!(matchDec > 0 && matchDec < 65536)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        out.writeShort((short)matchDec);
        if (matchLen >= 19) {
            this.encodeLen(matchLen - 15 - 4, out);
        }
    }

    public final void compress(@NotNull byte[] bytes, int off, int len, @NotNull DataOutput out, @NotNull HashTable ht) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)ht, (String)"ht");
        this.compressWithDictionary(bytes, off, 0, len, out, ht);
    }

    public final void compressWithDictionary(@NotNull byte[] bytes, int dictOff, int dictLen, int len, @NotNull DataOutput out, @NotNull HashTable ht) throws IOException {
        int literalLen;
        int off;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)ht, (String)"ht");
        Objects.INSTANCE.checkFromIndexSize(dictOff, dictLen, bytes.length);
        Objects.INSTANCE.checkFromIndexSize(dictOff + dictLen, len, bytes.length);
        if (!(dictLen <= 65536)) {
            boolean $i$a$-require-LZ4$compressWithDictionary$22 = false;
            String $i$a$-require-LZ4$compressWithDictionary$22 = "dictLen must not be greater than 64kB, but got " + dictLen;
            throw new IllegalArgumentException($i$a$-require-LZ4$compressWithDictionary$22.toString());
        }
        int end = dictOff + dictLen + len;
        int anchor = off = dictOff + dictLen;
        if (len > 9) {
            int limit = end - 5;
            int matchLimit = limit - 4;
            ht.reset(bytes, dictOff, dictLen + len);
            ht.initDictionary(dictLen);
            block0: while (off <= limit) {
                int ref = 0;
                while (off < matchLimit) {
                    ref = ht.get(off);
                    if (ref != -1) {
                        if (!(ref >= dictOff && ref < off)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        if (!(this.readInt(bytes, ref) == this.readInt(bytes, off))) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                    } else {
                        ++off;
                        continue;
                    }
                    int matchLen = 4 + this.commonBytes(bytes, ref + 4, off + 4, limit);
                    int r = ht.previous(ref);
                    int min = Math.max(off - 65536 + 1, dictOff);
                    while (r >= min) {
                        if (!(this.readInt(bytes, r) == this.readInt(bytes, off))) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        int rMatchLen = 4 + this.commonBytes(bytes, r + 4, off + 4, limit);
                        if (rMatchLen > matchLen) {
                            ref = r;
                            matchLen = rMatchLen;
                        }
                        r = ht.previous(r);
                    }
                    this.encodeSequence(bytes, anchor, ref, off, matchLen, out);
                    anchor = off += matchLen;
                    continue block0;
                }
                break block0;
            }
        }
        if (!((literalLen = end - anchor) >= 5 || literalLen == len)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.encodeLastLiterals(bytes, anchor, end - anchor, out);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/util/compress/LZ4$FastCompressionHashTable;", "Lorg/gnit/lucenekmp/util/compress/LZ4$HashTable;", "<init>", "()V", "bytes", "", "base", "", "lastOff", "end", "hashLog", "hashTable", "Lorg/gnit/lucenekmp/util/compress/LZ4$Table;", "reset", "", "off", "len", "initDictionary", "dictLen", "get", "previous", "assertReset", "", "core"})
    public static final class FastCompressionHashTable
    extends HashTable {
        private byte[] bytes;
        private int base;
        private int lastOff;
        private int end;
        private int hashLog;
        @Nullable
        private Table hashTable;

        @Override
        public void reset(@NotNull byte[] bytes, int off, int len) {
            block8: {
                int bitsPerOffset;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                    Objects.INSTANCE.checkFromIndexSize(off, len, bytes.length);
                    this.bytes = bytes;
                    this.base = off;
                    this.end = off + len;
                    bitsPerOffset = len - 5 < 65536 ? 16 : 32;
                    int bitsPerOffsetLog = 32 - IntExtKt.numberOfLeadingZeros(IntCompanionObject.INSTANCE, bitsPerOffset - 1);
                    this.hashLog = 17 - bitsPerOffsetLog;
                    if (this.hashTable == null) break block7;
                    Table table = this.hashTable;
                    Intrinsics.checkNotNull((Object)table);
                    if (table.size() < 1 << this.hashLog) break block7;
                    Table table2 = this.hashTable;
                    Intrinsics.checkNotNull((Object)table2);
                    if (table2.getBitsPerValue() >= bitsPerOffset) break block8;
                }
                if (bitsPerOffset > 16) {
                    if (!(bitsPerOffset == 32)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.hashTable = new Table32(1 << this.hashLog);
                } else {
                    if (!(bitsPerOffset == 16)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.hashTable = new Table16(1 << this.hashLog);
                }
            }
            this.lastOff = off - 1;
        }

        @Override
        public void initDictionary(int dictLen) {
            for (int i = 0; i < dictLen; ++i) {
                byte[] byArray = this.bytes;
                if (this.bytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                    byArray = null;
                }
                int v = INSTANCE.readInt(byArray, this.base + i);
                int h = INSTANCE.hash(v, this.hashLog);
                Table table = this.hashTable;
                Intrinsics.checkNotNull((Object)table);
                table.set(h, i);
            }
            this.lastOff += dictLen;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int get(int off) {
            if (!(off > this.lastOff)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(off < this.end)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            int v = INSTANCE.readInt(byArray, off);
            int h = INSTANCE.hash(v, this.hashLog);
            Table table = this.hashTable;
            Intrinsics.checkNotNull((Object)table);
            int ref = this.base + table.getAndSet(h, off - this.base);
            this.lastOff = off;
            if (ref >= off) return -1;
            if (off - ref >= 65536) return -1;
            byte[] byArray2 = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray2 = null;
            }
            if (INSTANCE.readInt(byArray2, ref) != v) return -1;
            int n = ref;
            return n;
        }

        @Override
        public int previous(int off) {
            return -1;
        }

        @Override
        public boolean assertReset() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\tH&J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\u000f\u001a\u00020\u0010H&\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/util/compress/LZ4$HashTable;", "", "<init>", "()V", "reset", "", "b", "", "off", "", "len", "initDictionary", "dictLen", "get", "previous", "assertReset", "", "core"})
    public static abstract class HashTable {
        public abstract void reset(@NotNull byte[] var1, int var2, int var3);

        public abstract void initDictionary(int var1);

        public abstract int get(int var1);

        public abstract int previous(int var1);

        public abstract boolean assertReset();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/util/compress/LZ4$HighCompressionHashTable;", "Lorg/gnit/lucenekmp/util/compress/LZ4$HashTable;", "<init>", "()V", "bytes", "", "base", "", "next", "end", "hashTable", "", "chainTable", "", "attempts", "reset", "", "off", "len", "initDictionary", "dictLen", "get", "addHash", "previous", "assertReset", "", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nLZ4.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LZ4.kt\norg/gnit/lucenekmp/util/compress/LZ4$HighCompressionHashTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,550:1\n1#2:551\n*E\n"})
    public static final class HighCompressionHashTable
    extends HashTable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private byte[] bytes;
        private int base;
        private int next;
        private int end;
        @NotNull
        private final int[] hashTable = new int[32768];
        @NotNull
        private final short[] chainTable = new short[65536];
        private int attempts;
        private static final int MAX_ATTEMPTS = 256;
        private static final int MASK = 65535;

        public HighCompressionHashTable() {
            Arrays.INSTANCE.fill(this.hashTable, -1);
            Arrays.INSTANCE.fill(this.chainTable, (short)-1);
        }

        @Override
        public void reset(@NotNull byte[] bytes, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Objects.INSTANCE.checkFromIndexSize(off, len, bytes.length);
            if (this.end - this.base < this.chainTable.length) {
                int endOffset;
                int startOffset = this.base & 0xFFFF;
                int n = endOffset = this.end == 0 ? 0 : (this.end - 1 & 0xFFFF) + 1;
                if (startOffset < endOffset) {
                    Arrays.INSTANCE.fill(this.chainTable, startOffset, endOffset, (short)-1);
                } else {
                    Arrays.INSTANCE.fill(this.chainTable, 0, endOffset, (short)-1);
                    Arrays.INSTANCE.fill(this.chainTable, startOffset, this.chainTable.length, (short)-1);
                }
            } else {
                Arrays.INSTANCE.fill(this.hashTable, -1);
                Arrays.INSTANCE.fill(this.chainTable, (short)-1);
            }
            this.bytes = bytes;
            this.base = off;
            this.next = off;
            this.end = off + len;
        }

        @Override
        public void initDictionary(int dictLen) {
            if (!(this.next == this.base)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            for (int i = 0; i < dictLen; ++i) {
                this.addHash(this.base + i);
            }
            this.next += dictLen;
        }

        @Override
        public int get(int off) {
            if (!(off >= this.next)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(off < this.end)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            while (this.next < off) {
                this.addHash(this.next);
                int n = this.next;
                this.next = n + 1;
            }
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            int v = INSTANCE.readInt(byArray, off);
            int h = INSTANCE.hashHC(v);
            this.attempts = 0;
            int ref = this.hashTable[h];
            if (ref >= off) {
                return -1;
            }
            int min = Math.max(this.base, off - 65536 + 1);
            while (ref >= min && this.attempts < 256) {
                byte[] byArray2 = this.bytes;
                if (this.bytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                    byArray2 = null;
                }
                if (INSTANCE.readInt(byArray2, ref) == v) {
                    return ref;
                }
                ref -= this.chainTable[ref & 0xFFFF] & 0xFFFF;
                int n = this.attempts;
                this.attempts = n + 1;
            }
            return -1;
        }

        private final void addHash(int off) {
            int v;
            int h;
            int delta;
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            if ((delta = off - this.hashTable[h = INSTANCE.hashHC(v = INSTANCE.readInt(byArray, off))]) <= 0 || delta >= 65536) {
                delta = 65535;
            }
            this.chainTable[off & 0xFFFF] = (short)delta;
            this.hashTable[h] = off;
        }

        @Override
        public int previous(int off) {
            byte[] byArray = this.bytes;
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                byArray = null;
            }
            int v = INSTANCE.readInt(byArray, off);
            for (int ref = off - (this.chainTable[off & 0xFFFF] & 0xFFFF); ref >= this.base && this.attempts < 256; ref -= this.chainTable[ref & 0xFFFF] & 0xFFFF) {
                byte[] byArray2 = this.bytes;
                if (this.bytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
                    byArray2 = null;
                }
                if (INSTANCE.readInt(byArray2, ref) == v) {
                    return ref;
                }
                int n = this.attempts;
                this.attempts = n + 1;
            }
            return -1;
        }

        @Override
        public boolean assertReset() {
            int n = this.chainTable.length;
            for (int i = 0; i < n; ++i) {
                if (this.chainTable[i] == -1) continue;
                boolean bl = false;
                Integer n2 = i;
                throw new IllegalArgumentException(((Object)n2).toString());
            }
            return true;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/util/compress/LZ4$HighCompressionHashTable$Companion;", "", "<init>", "()V", "MAX_ATTEMPTS", "", "MASK", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&J\b\u0010\r\u001a\u00020\u0007H&R\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/compress/LZ4$Table;", "", "<init>", "()V", "set", "", "offset", "", "value", "getAndSet", "bitsPerValue", "getBitsPerValue", "()I", "size", "core"})
    private static abstract class Table {
        public abstract void set(int var1, int var2);

        public abstract int getAndSet(int var1, int var2);

        public abstract int getBitsPerValue();

        public abstract int size();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/util/compress/LZ4$Table16;", "Lorg/gnit/lucenekmp/util/compress/LZ4$Table;", "size", "", "<init>", "(I)V", "table", "", "set", "", "index", "value", "getAndSet", "bitsPerValue", "getBitsPerValue", "()I", "core"})
    private static final class Table16
    extends Table {
        @NotNull
        private final short[] table;

        public Table16(int size2) {
            this.table = new short[size2];
        }

        @Override
        public void set(int index, int value) {
            if (!(value >= 0 && value < 65536)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.table[index] = (short)value;
        }

        @Override
        public int getAndSet(int index, int value) {
            int prev = ShortExtKt.toUnsignedInt(ShortCompanionObject.INSTANCE, this.table[index]);
            this.set(index, value);
            return prev;
        }

        @Override
        public int getBitsPerValue() {
            return 16;
        }

        @Override
        public int size() {
            return this.table.length;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/util/compress/LZ4$Table32;", "Lorg/gnit/lucenekmp/util/compress/LZ4$Table;", "size", "", "<init>", "(I)V", "table", "", "set", "", "index", "value", "getAndSet", "bitsPerValue", "getBitsPerValue", "()I", "core"})
    private static final class Table32
    extends Table {
        @NotNull
        private final int[] table;

        public Table32(int size2) {
            this.table = new int[size2];
        }

        @Override
        public void set(int index, int value) {
            this.table[index] = value;
        }

        @Override
        public int getAndSet(int index, int value) {
            int prev = this.table[index];
            this.set(index, value);
            return prev;
        }

        @Override
        public int getBitsPerValue() {
            return 32;
        }

        @Override
        public int size() {
            return this.table.length;
        }
    }
}

