/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.compress;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/util/compress/LowercaseAsciiCompression;", "", "<init>", "()V", "isCompressible", "", "b", "", "compress", "in", "", "len", "tmp", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "decompress", "", "Lorg/gnit/lucenekmp/store/DataInput;", "core"})
public final class LowercaseAsciiCompression {
    @NotNull
    public static final LowercaseAsciiCompression INSTANCE = new LowercaseAsciiCompression();

    private LowercaseAsciiCompression() {
    }

    private final boolean isCompressible(int b) {
        int high3Bits = b + 1 & 0xFFFFFFE0;
        return high3Bits == 32 || high3Bits == 96;
    }

    public final boolean compress(@NotNull byte[] in, int len, @NotNull byte[] tmp, @NotNull DataOutput out) throws IOException {
        int i;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (len < 8) {
            return false;
        }
        int maxExceptions = len >>> 5;
        int previousExceptionIndex = 0;
        int numExceptions = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int b = in[i2] & 0xFF;
            if (this.isCompressible(b)) continue;
            while (i2 - previousExceptionIndex > 255) {
                ++numExceptions;
                previousExceptionIndex += 255;
            }
            if (++numExceptions > maxExceptions) {
                return false;
            }
            previousExceptionIndex = i2;
        }
        if (!(numExceptions <= maxExceptions)) {
            String b = "Failed requirement.";
            throw new IllegalArgumentException(b.toString());
        }
        int compressedLen = len - (len >>> 2);
        if (!(compressedLen < len)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (int i3 = 0; i3 < len; ++i3) {
            int b = (in[i3] & 0xFF) + 1;
            tmp[i3] = (byte)(b & 0x1F | (b & 0x40) >>> 1);
        }
        int o = 0;
        for (i = compressedLen; i < len; ++i) {
            tmp[o] = (byte)(tmp[o] | (byte)(tmp[i] & 0x30) << 2);
            ++o;
        }
        for (i = compressedLen; i < len; ++i) {
            tmp[o] = (byte)(tmp[o] | (byte)(tmp[i] & 0xC) << 4);
            ++o;
        }
        for (i = compressedLen; i < len; ++i) {
            tmp[o] = (byte)(tmp[o] | (byte)(tmp[i] & 3) << 6);
            ++o;
        }
        if (!(o <= compressedLen)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        out.writeBytes(tmp, 0, compressedLen);
        out.writeVInt(numExceptions);
        if (numExceptions > 0) {
            previousExceptionIndex = 0;
            int numExceptions2 = 0;
            for (int i4 = 0; i4 < len; ++i4) {
                int n;
                int b = in[i4] & 0xFF;
                if (this.isCompressible(b)) continue;
                while (i4 - previousExceptionIndex > 255) {
                    out.writeByte((byte)-1);
                    out.writeByte(in[previousExceptionIndex += 255]);
                    n = numExceptions2;
                    numExceptions2 = n + 1;
                }
                out.writeByte((byte)(i4 - previousExceptionIndex));
                previousExceptionIndex = i4;
                out.writeByte((byte)b);
                n = numExceptions2;
                numExceptions2 = n + 1;
            }
            if (!(numExceptions == numExceptions2)) {
                boolean bl = false;
                String string = numExceptions + " <> " + numExceptions2 + " " + new BytesRef(in, 0, len);
                throw new IllegalStateException(string.toString());
            }
        }
        return true;
    }

    public final void decompress(@NotNull DataInput in, @NotNull byte[] out, int len) throws IOException {
        int i;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int saved = len >>> 2;
        int compressedLen = len - saved;
        in.readBytes(out, 0, compressedLen);
        for (i = 0; i < saved; ++i) {
            out[compressedLen + i] = (byte)((out[i] & 0xC0) >>> 2 | (out[saved + i] & 0xC0) >>> 4 | (out[(saved << 1) + i] & 0xC0) >>> 6);
        }
        for (i = 0; i < len; ++i) {
            byte b = out[i];
            out[i] = (byte)((b & 0x1F | 0x20 | (b & 0x20) << 1) - 1);
        }
        int numExceptions = in.readVInt();
        int i2 = 0;
        for (int exception = 0; exception < numExceptions; ++exception) {
            out[i2 += in.readByte() & 0xFF] = in.readByte();
        }
    }
}

