/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.util.fst.FST;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/util/fst/BitTableUtil;", "", "<init>", "()V", "isBitSet", "", "bitIndex", "", "reader", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "countBits", "bitTableBytes", "countBitsUpTo", "nextBitSet", "previousBitSet", "readByte", "", "readUpTo8Bytes", "numBytes", "bitCount8Bytes", "core"})
@SourceDebugExtension(value={"SMAP\nBitTableUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitTableUtil.kt\norg/gnit/lucenekmp/util/fst/BitTableUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
public final class BitTableUtil {
    @NotNull
    public static final BitTableUtil INSTANCE = new BitTableUtil();

    private BitTableUtil() {
    }

    public final boolean isBitSet(int bitIndex, @NotNull FST.BytesReader reader2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        if (!(bitIndex >= 0)) {
            boolean bl = false;
            String string = "bitIndex=" + bitIndex;
            throw new IllegalArgumentException(string.toString());
        }
        reader2.skipBytes(bitIndex >> 3);
        return (this.readByte(reader2) & 1L << (bitIndex & 7)) != 0L;
    }

    public final int countBits(int bitTableBytes, @NotNull FST.BytesReader reader2) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        if (!(bitTableBytes >= 0)) {
            boolean $i$a$-require-BitTableUtil$countBits$22 = false;
            String $i$a$-require-BitTableUtil$countBits$22 = "bitTableBytes=" + bitTableBytes;
            throw new IllegalArgumentException($i$a$-require-BitTableUtil$countBits$22.toString());
        }
        int bitCount = 0;
        for (int i = bitTableBytes >> 3; 0 < i; --i) {
            bitCount += this.bitCount8Bytes(reader2);
        }
        int numRemainingBytes = 0;
        int it = n = bitTableBytes & 7;
        boolean bl = false;
        numRemainingBytes = it;
        if (n != 0) {
            bitCount += LongExtKt.bitCount(LongCompanionObject.INSTANCE, this.readUpTo8Bytes(numRemainingBytes, reader2));
        }
        return bitCount;
    }

    public final int countBitsUpTo(int bitIndex, @NotNull FST.BytesReader reader2) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        if (!(bitIndex >= 0)) {
            boolean $i$a$-require-BitTableUtil$countBitsUpTo$22 = false;
            String $i$a$-require-BitTableUtil$countBitsUpTo$22 = "bitIndex=" + bitIndex;
            throw new IllegalArgumentException($i$a$-require-BitTableUtil$countBitsUpTo$22.toString());
        }
        int bitCount = 0;
        for (int i = bitIndex >> 6; 0 < i; --i) {
            bitCount += this.bitCount8Bytes(reader2);
        }
        int remainingBits = 0;
        int it = n = bitIndex & 0x3F;
        boolean bl = false;
        remainingBits = it;
        if (n != 0) {
            int numRemainingBytes = remainingBits + 7 >> 3;
            long mask = (1L << bitIndex) - 1L;
            bitCount += LongExtKt.bitCount(LongCompanionObject.INSTANCE, this.readUpTo8Bytes(numRemainingBytes, reader2) & mask);
        }
        return bitCount;
    }

    public final int nextBitSet(int bitIndex, int bitTableBytes, @NotNull FST.BytesReader reader2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        if (!(bitIndex >= -1 && bitIndex < bitTableBytes * 8)) {
            boolean $i$a$-require-BitTableUtil$nextBitSet$22 = false;
            String $i$a$-require-BitTableUtil$nextBitSet$22 = "bitIndex=" + bitIndex + " bitTableBytes=" + bitTableBytes;
            throw new IllegalArgumentException($i$a$-require-BitTableUtil$nextBitSet$22.toString());
        }
        int byteIndex = bitIndex / 8;
        int mask = -1 << (bitIndex + 1 & 7);
        int i = 0;
        if (mask == -1 && bitIndex != -1) {
            reader2.skipBytes((long)byteIndex + 1L);
            i = 0;
        } else {
            reader2.skipBytes(byteIndex);
            i = reader2.readByte() & 0xFF & mask;
        }
        while (i == 0) {
            if (++byteIndex == bitTableBytes) {
                return -1;
            }
            i = reader2.readByte() & 0xFF;
        }
        return IntExtKt.numberOfTrailingZeros(IntCompanionObject.INSTANCE, i) + (byteIndex << 3);
    }

    public final int previousBitSet(int bitIndex, @NotNull FST.BytesReader reader2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        if (!(bitIndex >= 0)) {
            boolean $i$a$-require-BitTableUtil$previousBitSet$22 = false;
            String $i$a$-require-BitTableUtil$previousBitSet$22 = "bitIndex=" + bitIndex;
            throw new IllegalArgumentException($i$a$-require-BitTableUtil$previousBitSet$22.toString());
        }
        int byteIndex = bitIndex >> 3;
        reader2.skipBytes(byteIndex);
        int mask = (1 << (bitIndex & 7)) - 1;
        int i = reader2.readByte() & 0xFF & mask;
        while (i == 0) {
            if (byteIndex-- == 0) {
                return -1;
            }
            reader2.skipBytes(-2L);
            i = reader2.readByte() & 0xFF;
        }
        return 31 - IntExtKt.numberOfLeadingZeros(IntCompanionObject.INSTANCE, i) + (byteIndex << 3);
    }

    private final long readByte(FST.BytesReader reader2) throws IOException {
        return reader2.readByte() & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    private final long readUpTo8Bytes(int numBytes, FST.BytesReader reader2) throws IOException {
        int numBytes2 = 0;
        numBytes2 = numBytes;
        if (!(numBytes2 > 0 && numBytes2 <= 8)) {
            boolean bl = false;
            String string = "numBytes=" + numBytes2;
            throw new IllegalArgumentException(string.toString());
        }
        long l = this.readByte(reader2);
        int shift = 0;
        while ((numBytes2 += -1) != 0) {
            void it;
            int n = 8;
            long l2 = this.readByte(reader2);
            long l3 = l;
            boolean bl = false;
            int n2 = shift += it;
            l = l3 | l2 << n2;
        }
        return l;
    }

    private final int bitCount8Bytes(FST.BytesReader reader2) throws IOException {
        return LongExtKt.bitCount(LongCompanionObject.INSTANCE, reader2.readLong());
    }
}

