/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.FSTEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0018B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nJ\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0014J\u0010\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/fst/BytesRefFSTEnum;", "T", "Lorg/gnit/lucenekmp/util/fst/FSTEnum;", "fst", "Lorg/gnit/lucenekmp/util/fst/FST;", "<init>", "(Lorg/gnit/lucenekmp/util/fst/FST;)V", "current", "Lorg/gnit/lucenekmp/util/BytesRef;", "result", "Lorg/gnit/lucenekmp/util/fst/BytesRefFSTEnum$InputOutput;", "target", "next", "seekCeil", "seekFloor", "seekExact", "getTargetLabel", "", "getCurrentLabel", "setCurrentLabel", "", "label", "grow", "setResult", "InputOutput", "core"})
public class BytesRefFSTEnum<T>
extends FSTEnum<T> {
    @NotNull
    private final BytesRef current;
    @NotNull
    private final InputOutput<T> result;
    @Nullable
    private BytesRef target;

    public BytesRefFSTEnum(@NotNull FST<T> fst) {
        Intrinsics.checkNotNullParameter(fst, (String)"fst");
        super(fst);
        this.current = new BytesRef(10);
        this.result = new InputOutput();
        this.result.setInput(this.current);
        this.current.setOffset(1);
    }

    @NotNull
    public final InputOutput<T> current() {
        return this.result;
    }

    @Nullable
    public final InputOutput<T> next() throws IOException {
        this.doNext();
        return this.setResult();
    }

    @Nullable
    public final InputOutput<T> seekCeil(@NotNull BytesRef target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
        this.setTargetLength(target.getLength());
        super.doSeekCeil();
        return this.setResult();
    }

    @Nullable
    public final InputOutput<T> seekFloor(@NotNull BytesRef target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
        this.setTargetLength(target.getLength());
        super.doSeekFloor();
        return this.setResult();
    }

    @Nullable
    public final InputOutput<T> seekExact(@NotNull BytesRef target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
        this.setTargetLength(target.getLength());
        if (this.doSeekExact()) {
            if (!(this.getUpto() == 1 + target.getLength())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.setResult();
        }
        return null;
    }

    @Override
    protected int getTargetLabel() {
        byte by;
        int n = this.getUpto() - 1;
        BytesRef bytesRef = this.target;
        Intrinsics.checkNotNull((Object)bytesRef);
        if (n == bytesRef.getLength()) {
            by = -1;
        } else {
            BytesRef bytesRef2 = this.target;
            Intrinsics.checkNotNull((Object)bytesRef2);
            byte[] byArray = bytesRef2.getBytes();
            BytesRef bytesRef3 = this.target;
            Intrinsics.checkNotNull((Object)bytesRef3);
            by = (byte)(byArray[bytesRef3.getOffset() + this.getUpto() - 1] & 0xFFFFFFFF);
        }
        return by;
    }

    @Override
    protected int getCurrentLabel() {
        return (byte)(this.current.getBytes()[this.getUpto()] & 0xFFFFFFFF);
    }

    @Override
    protected void setCurrentLabel(int label) {
        this.current.getBytes()[this.getUpto()] = (byte)label;
    }

    @Override
    protected void grow() {
        this.current.setBytes(ArrayUtil.Companion.grow(this.current.getBytes(), this.getUpto() + 1));
    }

    private final InputOutput<T> setResult() {
        if (this.getUpto() == 0) {
            return null;
        }
        this.current.setLength(this.getUpto() - 1);
        this.result.setOutput(this.getOutput()[this.getUpto()]);
        return this.result;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/util/fst/BytesRefFSTEnum$InputOutput;", "T", "", "<init>", "()V", "input", "Lorg/gnit/lucenekmp/util/BytesRef;", "getInput", "()Lorg/gnit/lucenekmp/util/BytesRef;", "setInput", "(Lorg/gnit/lucenekmp/util/BytesRef;)V", "output", "getOutput", "()Ljava/lang/Object;", "setOutput", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "core"})
    public static final class InputOutput<T> {
        @Nullable
        private BytesRef input;
        @Nullable
        private T output;

        @Nullable
        public final BytesRef getInput() {
            return this.input;
        }

        public final void setInput(@Nullable BytesRef bytesRef) {
            this.input = bytesRef;
        }

        @Nullable
        public final T getOutput() {
            return this.output;
        }

        public final void setOutput(@Nullable T t) {
            this.output = t;
        }
    }
}

