/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.ShortCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Path;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.jdkport.BufferedInputStream;
import org.gnit.lucenekmp.jdkport.BufferedOutputStream;
import org.gnit.lucenekmp.jdkport.Files;
import org.gnit.lucenekmp.jdkport.InputStream;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.ShortExtKt;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.InputStreamDataInput;
import org.gnit.lucenekmp.store.OutputStreamDataOutput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.Constants;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.fst.BitTableUtil;
import org.gnit.lucenekmp.util.fst.FSTCompiler;
import org.gnit.lucenekmp.util.fst.FSTReader;
import org.gnit.lucenekmp.util.fst.OnHeapFSTStore;
import org.gnit.lucenekmp.util.fst.Outputs;
import org.gnit.lucenekmp.util.fst.ReadWriteDataOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0016\u0018\u0000 D*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0005@ABCDB\u001f\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001f\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0013J\r\u0010\u0017\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\"\u001a\u00020\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%H\u0002J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$J0\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020%H\u0002J0\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%J&\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%H\u0002J*\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010,\u001a\u00020\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%J\u001c\u0010.\u001a\u00020/2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%J\"\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%J\u001c\u00101\u001a\u00020!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%J*\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%2\u0006\u00103\u001a\u00020!J*\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%2\u0006\u00105\u001a\u00020!J*\u00106\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%2\u0006\u00105\u001a\u00020!J4\u00106\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%2\u0006\u00105\u001a\u00020!2\u0006\u00107\u001a\u00020!H\u0002J\"\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%J\"\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%J\"\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%J$\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%H\u0002J:\u0010<\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010$2\u0006\u0010=\u001a\u00020!2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\t\u001a\u00020%J\u0010\u0010>\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020%H\u0002J\u0006\u0010?\u001a\u00020%R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006E"}, d2={"Lorg/gnit/lucenekmp/util/fst/FST;", "T", "Lorg/gnit/lucenekmp/util/Accountable;", "metadata", "Lorg/gnit/lucenekmp/util/fst/FST$FSTMetadata;", "fstReader", "Lorg/gnit/lucenekmp/util/fst/FSTReader;", "<init>", "(Lorg/gnit/lucenekmp/util/fst/FST$FSTMetadata;Lorg/gnit/lucenekmp/util/fst/FSTReader;)V", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "(Lorg/gnit/lucenekmp/util/fst/FST$FSTMetadata;Lorg/gnit/lucenekmp/store/DataInput;)V", "getMetadata", "()Lorg/gnit/lucenekmp/util/fst/FST$FSTMetadata;", "outputs", "Lorg/gnit/lucenekmp/util/fst/Outputs;", "getOutputs", "()Lorg/gnit/lucenekmp/util/fst/Outputs;", "ramBytesUsed", "", "toString", "", "numBytes", "getEmptyOutput", "()Ljava/lang/Object;", "save", "", "metaOut", "Lorg/gnit/lucenekmp/store/DataOutput;", "out", "path", "Lokio/Path;", "readLabel", "", "readPresenceBytes", "arc", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "getFirstArc", "readLastTargetArc", "follow", "readUnpackedNodeTarget", "readFirstTargetArc", "readFirstArcInfo", "nodeAddress", "readFirstRealTargetArc", "isExpandedTarget", "", "readNextArc", "readNextArcLabel", "readArcByIndex", "idx", "readArcByContinuous", "rangeIndex", "readArcByDirectAddressing", "presenceIndex", "readLastArcByDirectAddressing", "readLastArcByContinuous", "readNextRealArc", "readArc", "findTargetArc", "labelToMatch", "seekToNextNode", "getBytesReader", "INPUT_TYPE", "Arc", "BytesReader", "FSTMetadata", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFST.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FST.kt\norg/gnit/lucenekmp/util/fst/FST\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1216:1\n1#2:1217\n*E\n"})
public final class FST<T>
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FSTMetadata<T> metadata;
    @NotNull
    private final FSTReader fstReader;
    @NotNull
    private final Outputs<T> outputs;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(FST.class));
    public static final int BIT_FINAL_ARC = 1;
    public static final int BIT_LAST_ARC = 2;
    public static final int BIT_TARGET_NEXT = 4;
    public static final int BIT_STOP_NODE = 8;
    public static final int BIT_ARC_HAS_OUTPUT = 16;
    public static final int BIT_ARC_HAS_FINAL_OUTPUT = 32;
    public static final byte ARCS_FOR_BINARY_SEARCH = 32;
    public static final byte ARCS_FOR_DIRECT_ADDRESSING = 64;
    public static final byte ARCS_FOR_CONTINUOUS = 96;
    @NotNull
    private static final String FILE_FORMAT_NAME = "FST";
    public static final int VERSION_START = 6;
    private static final int VERSION_LITTLE_ENDIAN = 8;
    public static final int VERSION_CONTINUOUS_ARCS = 9;
    public static final int VERSION_CURRENT = 9;
    public static final int VERSION_90 = 8;
    public static final long FINAL_END_NODE = -1L;
    public static final long NON_FINAL_END_NODE = 0L;
    public static final int END_LABEL = -1;
    private static final int DEFAULT_MAX_BLOCK_BITS = Constants.INSTANCE.getJRE_IS_64BIT() ? 30 : 28;

    public FST(@NotNull FSTMetadata<T> metadata, @NotNull FSTReader fstReader) {
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)fstReader, (String)"fstReader");
        this.metadata = metadata;
        this.outputs = metadata.getOutputs();
        this.fstReader = fstReader;
    }

    @NotNull
    public final FSTMetadata<T> getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final Outputs<T> getOutputs() {
        return this.outputs;
    }

    public FST(@NotNull FSTMetadata<T> metadata, @NotNull DataInput in) {
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this(metadata, new OnHeapFSTStore(DEFAULT_MAX_BLOCK_BITS, in, metadata.getNumBytes()));
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.fstReader.ramBytesUsed();
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(input=" + this.metadata.getInputType() + ",output=" + this.outputs;
    }

    public final long numBytes() {
        return this.metadata.getNumBytes();
    }

    @Nullable
    public final T getEmptyOutput() {
        return this.metadata.getEmptyOutput();
    }

    public final void save(@NotNull DataOutput metaOut, @NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)metaOut, (String)"metaOut");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.metadata.save(metaOut);
        this.fstReader.writeTo(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        AutoCloseable autoCloseable = new BufferedOutputStream(Files.INSTANCE.newOutputStream(path));
        Throwable throwable = null;
        try {
            BufferedOutputStream os = (BufferedOutputStream)autoCloseable;
            boolean bl = false;
            DataOutput out = new OutputStreamDataOutput(os);
            this.save(out, out);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final int readLabel(@NotNull DataInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        short v = this.metadata.getInputType() == INPUT_TYPE.BYTE1 ? (short)(in.readByte() & 0xFFFFFFFF) : (this.metadata.getInputType() == INPUT_TYPE.BYTE2 ? (this.metadata.getVersion() < 8 ? (short)(ShortExtKt.reverseBytes(ShortCompanionObject.INSTANCE, in.readShort()) & 0xFFFF) : (short)(in.readShort() & 0xFFFFFFFF)) : (short)in.readVInt());
        return v;
    }

    private final void readPresenceBytes(Arc<T> arc, BytesReader in) throws IOException {
        if (!(arc.bytesPerArc() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(arc.nodeFlags() == 64)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        arc.setBitTableStart(in.getPosition());
        in.skipBytes(Companion.getNumPresenceBytes(arc.numArcs()));
    }

    @NotNull
    public final Arc<T> getFirstArc(@NotNull Arc<T> arc) {
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        T NO_OUTPUT2 = this.outputs.getNoOutput();
        if (this.metadata.getEmptyOutput() != null) {
            arc.setFlags((byte)3);
            arc.setNextFinalOutput(this.metadata.getEmptyOutput());
            if (this.metadata.getEmptyOutput() != NO_OUTPUT2) {
                arc.setFlags((byte)(arc.flags() | 0x20));
            }
        } else {
            arc.setFlags((byte)2);
            arc.setNextFinalOutput(NO_OUTPUT2);
        }
        arc.setOutput(NO_OUTPUT2);
        arc.setTarget(this.metadata.getStartNode());
        return arc;
    }

    @NotNull
    public final Arc<T> readLastTargetArc(@NotNull Arc<T> follow, @NotNull Arc<T> arc, @NotNull BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(follow, (String)"follow");
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (!Companion.targetHasArcs(follow)) {
            if (!follow.isFinal()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            arc.setLabel(-1);
            arc.setTarget(-1L);
            arc.setOutput(follow.nextFinalOutput());
            arc.setFlags((byte)2);
            arc.setNodeFlags(arc.getFlags());
        } else {
            in.setPosition(follow.target());
            arc.setNodeFlags(in.readByte());
            byte flags = arc.getNodeFlags();
            if (flags == 32 || flags == 64 || flags == 96) {
                arc.setNumArcs(in.readVInt());
                arc.setBytesPerArc(in.readVInt());
                if (flags == 64) {
                    this.readPresenceBytes(arc, in);
                    arc.setFirstLabel(this.readLabel(in));
                    arc.setPosArcsStart(in.getPosition());
                    v0 = this.readLastArcByDirectAddressing(arc, in);
                } else if (flags == 32) {
                    arc.setArcIdx(arc.numArcs() - 2);
                    arc.setPosArcsStart(in.getPosition());
                    v0 = this.readNextRealArc(arc, in);
                } else {
                    arc.setFirstLabel(this.readLabel(in));
                    arc.setPosArcsStart(in.getPosition());
                    v0 = this.readLastArcByContinuous(arc, in);
                }
            } else {
                arc.setFlags(flags);
                arc.setBytesPerArc(0);
                while (!arc.isLast()) {
                    this.readLabel(in);
                    if (arc.flag(16)) {
                        this.outputs.skipOutput(in);
                    }
                    if (arc.flag(32)) {
                        this.outputs.skipFinalOutput(in);
                    }
                    if (!arc.flag(8) && !arc.flag(4)) {
                        this.readUnpackedNodeTarget(in);
                    }
                    arc.setFlags(in.readByte());
                }
                in.skipBytes(-1L);
                arc.setNextArc(in.getPosition());
                v0 = this.readNextRealArc(arc, in);
            }
            if (!arc.isLast()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        return arc;
    }

    private final long readUnpackedNodeTarget(BytesReader in) throws IOException {
        return in.readVLong();
    }

    @NotNull
    public final Arc<T> readFirstTargetArc(@NotNull Arc<T> follow, @NotNull Arc<T> arc, @NotNull BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(follow, (String)"follow");
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (follow.isFinal()) {
            arc.setLabel(-1);
            arc.setOutput(follow.nextFinalOutput());
            arc.setFlags((byte)1);
            if (follow.target() <= 0L) {
                arc.setFlags((byte)(arc.getFlags() | 2));
            } else {
                arc.setNextArc(follow.target());
            }
            arc.setTarget(-1L);
            arc.setNodeFlags(arc.getFlags());
            return arc;
        }
        return this.readFirstRealTargetArc(follow.target(), arc, in);
    }

    private final void readFirstArcInfo(long nodeAddress, Arc<T> arc, BytesReader in) throws IOException {
        in.setPosition(nodeAddress);
        arc.setNodeFlags(in.readByte());
        byte flags = arc.getNodeFlags();
        if (flags == 32 || flags == 64 || flags == 96) {
            arc.setNumArcs(in.readVInt());
            arc.setBytesPerArc(in.readVInt());
            arc.setArcIdx(-1);
            if (flags == 64) {
                this.readPresenceBytes(arc, in);
                arc.setFirstLabel(this.readLabel(in));
                arc.setPresenceIndex(-1);
            } else if (flags == 96) {
                arc.setFirstLabel(this.readLabel(in));
            }
            arc.setPosArcsStart(in.getPosition());
        } else {
            arc.setNextArc(nodeAddress);
            arc.setBytesPerArc(0);
        }
    }

    @NotNull
    public final Arc<T> readFirstRealTargetArc(long nodeAddress, @NotNull Arc<T> arc, @NotNull BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.readFirstArcInfo(nodeAddress, arc, in);
        return this.readNextRealArc(arc, in);
    }

    public final boolean isExpandedTarget(@NotNull Arc<T> follow, @NotNull BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(follow, (String)"follow");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (!Companion.targetHasArcs(follow)) {
            return false;
        }
        in.setPosition(follow.target());
        byte flags = in.readByte();
        return flags == 32 || flags == 64 || flags == 96;
    }

    @NotNull
    public final Arc<T> readNextArc(@NotNull Arc<T> arc, @NotNull BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (arc.label() == -1) {
            if (!(arc.nextArc() > 0L)) {
                boolean bl = false;
                String string = "cannot readNextArc when arc.isLast()=true";
                throw new IllegalArgumentException(string.toString());
            }
            return this.readFirstRealTargetArc(arc.nextArc(), arc, in);
        }
        return this.readNextRealArc(arc, in);
    }

    public final int readNextArcLabel(@NotNull Arc<T> arc, @NotNull BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (!(!arc.isLast())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (arc.label() == -1) {
            in.setPosition(arc.nextArc());
            byte flags = in.readByte();
            if (flags == 32 || flags == 64 || flags == 96) {
                int numArcs = in.readVInt();
                in.readVInt();
                if (flags == 32) {
                    in.readByte();
                } else if (flags == 64) {
                    in.skipBytes(Companion.getNumPresenceBytes(numArcs));
                }
            }
        } else {
            byte by = arc.nodeFlags();
            if (by == 32) {
                in.setPosition(arc.posArcsStart() - (long)(1 + arc.arcIdx()) * (long)arc.bytesPerArc() - 1L);
            } else {
                if (by == 64) {
                    if (!Arc.BitTable.INSTANCE.assertIsValid(arc, in)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!Arc.BitTable.INSTANCE.isBitSet(arc.arcIdx(), arc, in)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    int nextIndex = Arc.BitTable.INSTANCE.nextBitSet(arc.arcIdx(), arc, in);
                    if (!(nextIndex != -1)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return arc.firstLabel() + nextIndex;
                }
                if (by == 96) {
                    return arc.firstLabel() + arc.arcIdx() + 1;
                }
                if (!(arc.bytesPerArc() == 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                in.setPosition(arc.nextArc() - 1L);
            }
        }
        return this.readLabel(in);
    }

    @NotNull
    public final Arc<T> readArcByIndex(@NotNull Arc<T> arc, @NotNull BytesReader in, int idx) throws IOException {
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (!(arc.bytesPerArc() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(arc.nodeFlags() == 32)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(idx >= 0 && idx < arc.numArcs())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        in.setPosition(arc.posArcsStart() - (long)idx * (long)arc.bytesPerArc());
        arc.setArcIdx(idx);
        arc.setFlags(in.readByte());
        return this.readArc(arc, in);
    }

    @NotNull
    public final Arc<T> readArcByContinuous(@NotNull Arc<T> arc, @NotNull BytesReader in, int rangeIndex) throws IOException {
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (!(rangeIndex >= 0 && rangeIndex < arc.numArcs())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        in.setPosition(arc.posArcsStart() - (long)rangeIndex * (long)arc.bytesPerArc());
        arc.setArcIdx(rangeIndex);
        arc.setFlags(in.readByte());
        return this.readArc(arc, in);
    }

    @NotNull
    public final Arc<T> readArcByDirectAddressing(@NotNull Arc<T> arc, @NotNull BytesReader in, int rangeIndex) throws IOException {
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (!Arc.BitTable.INSTANCE.assertIsValid(arc, in)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(rangeIndex >= 0 && rangeIndex < arc.numArcs())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Arc.BitTable.INSTANCE.isBitSet(rangeIndex, arc, in)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int presenceIndex = Arc.BitTable.INSTANCE.countBitsUpTo(rangeIndex, arc, in);
        return this.readArcByDirectAddressing(arc, in, rangeIndex, presenceIndex);
    }

    private final Arc<T> readArcByDirectAddressing(Arc<T> arc, BytesReader in, int rangeIndex, int presenceIndex) throws IOException {
        in.setPosition(arc.posArcsStart() - (long)presenceIndex * (long)arc.bytesPerArc());
        arc.setArcIdx(rangeIndex);
        arc.setPresenceIndex(presenceIndex);
        arc.setFlags(in.readByte());
        return this.readArc(arc, in);
    }

    @NotNull
    public final Arc<T> readLastArcByDirectAddressing(@NotNull Arc<T> arc, @NotNull BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (!Arc.BitTable.INSTANCE.assertIsValid(arc, in)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int presenceIndex = Arc.BitTable.INSTANCE.countBits(arc, in) - 1;
        return this.readArcByDirectAddressing(arc, in, arc.numArcs() - 1, presenceIndex);
    }

    @NotNull
    public final Arc<T> readLastArcByContinuous(@NotNull Arc<T> arc, @NotNull BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        return this.readArcByContinuous(arc, in, arc.numArcs() - 1);
    }

    @NotNull
    public final Arc<T> readNextRealArc(@NotNull Arc<T> arc, @NotNull BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        byte by = arc.nodeFlags();
        if (by == 32 || by == 96) {
            if (!(arc.bytesPerArc() > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n = arc.getArcIdx();
            arc.setArcIdx(n + 1);
            if (!(arc.arcIdx() >= 0 && arc.arcIdx() < arc.numArcs())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            in.setPosition(arc.posArcsStart() - (long)arc.arcIdx() * (long)arc.bytesPerArc());
            arc.setFlags(in.readByte());
        } else {
            if (by == 64) {
                if (!Arc.BitTable.INSTANCE.assertIsValid(arc, in)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(arc.arcIdx() == -1 || Arc.BitTable.INSTANCE.isBitSet(arc.arcIdx(), arc, in))) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                int nextIndex = Arc.BitTable.INSTANCE.nextBitSet(arc.arcIdx(), arc, in);
                return this.readArcByDirectAddressing(arc, in, nextIndex, arc.getPresenceIndex() + 1);
            }
            if (!(arc.bytesPerArc() == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            in.setPosition(arc.nextArc());
            arc.setFlags(in.readByte());
        }
        return this.readArc(arc, in);
    }

    private final Arc<T> readArc(Arc<T> arc, BytesReader in) throws IOException {
        if (arc.nodeFlags() == 64 || arc.nodeFlags() == 96) {
            arc.setLabel(arc.firstLabel() + arc.arcIdx());
        } else {
            arc.setLabel(this.readLabel(in));
        }
        if (arc.flag(16)) {
            arc.setOutput(this.outputs.read(in));
        } else {
            arc.setOutput(this.outputs.getNoOutput());
        }
        if (arc.flag(32)) {
            arc.setNextFinalOutput(this.outputs.readFinalOutput(in));
        } else {
            arc.setNextFinalOutput(this.outputs.getNoOutput());
        }
        if (arc.flag(8)) {
            if (arc.flag(1)) {
                arc.setTarget(-1L);
            } else {
                arc.setTarget(0L);
            }
            arc.setNextArc(in.getPosition());
        } else if (arc.flag(4)) {
            arc.setNextArc(in.getPosition());
            if (!arc.flag(2)) {
                if (arc.bytesPerArc() == 0) {
                    this.seekToNextNode(in);
                } else {
                    int numArcs = arc.getNodeFlags() == 64 ? Arc.BitTable.INSTANCE.countBits(arc, in) : arc.numArcs();
                    in.setPosition(arc.posArcsStart() - (long)arc.bytesPerArc() * (long)numArcs);
                }
            }
            arc.setTarget(in.getPosition());
        } else {
            arc.setTarget(this.readUnpackedNodeTarget(in));
            arc.setNextArc(in.getPosition());
        }
        return arc;
    }

    @Nullable
    public final Arc<T> findTargetArc(int labelToMatch, @NotNull Arc<T> follow, @NotNull Arc<T> arc, @NotNull BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(follow, (String)"follow");
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (labelToMatch == -1) {
            if (follow.isFinal()) {
                if (follow.target() <= 0L) {
                    arc.setFlags((byte)2);
                } else {
                    arc.setFlags((byte)0);
                    arc.setNextArc(follow.target());
                }
                arc.setOutput(follow.nextFinalOutput());
                arc.setLabel(-1);
                arc.setNodeFlags(arc.getFlags());
                return arc;
            }
            return null;
        }
        if (!Companion.targetHasArcs(follow)) {
            return null;
        }
        in.setPosition(follow.target());
        arc.setNodeFlags(in.readByte());
        byte flags = arc.getNodeFlags();
        if (flags == 64) {
            arc.setNumArcs(in.readVInt());
            arc.setBytesPerArc(in.readVInt());
            this.readPresenceBytes(arc, in);
            arc.setFirstLabel(this.readLabel(in));
            arc.setPosArcsStart(in.getPosition());
            int arcIndex = labelToMatch - arc.firstLabel();
            if (arcIndex < 0 || arcIndex >= arc.numArcs()) {
                return null;
            }
            if (!Arc.BitTable.INSTANCE.isBitSet(arcIndex, arc, in)) {
                return null;
            }
            return this.readArcByDirectAddressing(arc, in, arcIndex);
        }
        if (flags == 32) {
            arc.setNumArcs(in.readVInt());
            arc.setBytesPerArc(in.readVInt());
            arc.setPosArcsStart(in.getPosition());
            int low = 0;
            int high = arc.numArcs() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                in.setPosition(arc.posArcsStart() - (long)(arc.bytesPerArc() * mid + 1));
                int midLabel = this.readLabel(in);
                int cmp = midLabel - labelToMatch;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                arc.setArcIdx(mid - 1);
                return this.readNextRealArc(arc, in);
            }
            return null;
        }
        if (flags == 96) {
            arc.setNumArcs(in.readVInt());
            arc.setBytesPerArc(in.readVInt());
            arc.setFirstLabel(this.readLabel(in));
            arc.setPosArcsStart(in.getPosition());
            int arcIndex = labelToMatch - arc.firstLabel();
            if (arcIndex < 0 || arcIndex >= arc.numArcs()) {
                return null;
            }
            arc.setArcIdx(arcIndex - 1);
            return this.readNextRealArc(arc, in);
        }
        this.readFirstArcInfo(follow.target(), arc, in);
        in.setPosition(arc.nextArc());
        while (true) {
            if (!(arc.bytesPerArc() == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            arc.setFlags(in.readByte());
            flags = arc.getFlags();
            long pos = in.getPosition();
            int label = this.readLabel(in);
            if (label == labelToMatch) {
                in.setPosition(pos);
                return this.readArc(arc, in);
            }
            if (label > labelToMatch) {
                return null;
            }
            if (arc.isLast()) {
                return null;
            }
            if (FST.Companion.flag(flags, 16)) {
                this.outputs.skipOutput(in);
            }
            if (FST.Companion.flag(flags, 32)) {
                this.outputs.skipFinalOutput(in);
            }
            if (FST.Companion.flag(flags, 8) || FST.Companion.flag(flags, 4)) continue;
            this.readUnpackedNodeTarget(in);
        }
    }

    private final void seekToNextNode(BytesReader in) throws IOException {
        byte flags;
        do {
            flags = in.readByte();
            this.readLabel(in);
            if (FST.Companion.flag(flags, 16)) {
                this.outputs.skipOutput(in);
            }
            if (FST.Companion.flag(flags, 32)) {
                this.outputs.skipFinalOutput(in);
            }
            if (FST.Companion.flag(flags, 8) || FST.Companion.flag(flags, 4)) continue;
            this.readUnpackedNodeTarget(in);
        } while (!FST.Companion.flag(flags, 2));
    }

    @NotNull
    public final BytesReader getBytesReader() {
        return this.fstReader.getReverseBytesReader();
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b%\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002:\u0001DB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000J\u000e\u0010=\u001a\u00020>2\u0006\u0010=\u001a\u00020\u0006J\b\u0010B\u001a\u00020CH\u0016J\u0006\u0010\u0005\u001a\u00020\u0006J\r\u0010\u000b\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u0018J\r\u0010\u001d\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\rJ\u0006\u0010 \u001a\u00020\u0012J\u0006\u0010,\u001a\u00020\u0006J\u0006\u0010#\u001a\u00020\u0018J\u0006\u0010)\u001a\u00020\u0012J\u0006\u0010&\u001a\u00020\u0006J\u0006\u0010/\u001a\u00020\u0006J\u0006\u00105\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\u001e\u0010\r\"\u0004\b\u001f\u0010\u000fR\u001a\u0010 \u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R\u001a\u0010#\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001a\"\u0004\b%\u0010\u001cR\u001a\u0010&\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\b\"\u0004\b(\u0010\nR\u001a\u0010)\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0014\"\u0004\b+\u0010\u0016R\u001a\u0010,\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\b\"\u0004\b.\u0010\nR\u001a\u0010/\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\b\"\u0004\b1\u0010\nR\u001a\u00102\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0014\"\u0004\b4\u0010\u0016R\u001a\u00105\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\b\"\u0004\b7\u0010\nR\u001a\u00108\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\b\"\u0004\b:\u0010\nR\u0011\u0010?\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0011\u0010A\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010@\u00a8\u0006E"}, d2={"Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "T", "", "<init>", "()V", "label", "", "getLabel", "()I", "setLabel", "(I)V", "output", "getOutput", "()Ljava/lang/Object;", "setOutput", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "target", "", "getTarget", "()J", "setTarget", "(J)V", "flags", "", "getFlags", "()B", "setFlags", "(B)V", "nextFinalOutput", "getNextFinalOutput", "setNextFinalOutput", "nextArc", "getNextArc", "setNextArc", "nodeFlags", "getNodeFlags", "setNodeFlags", "bytesPerArc", "getBytesPerArc", "setBytesPerArc", "posArcsStart", "getPosArcsStart", "setPosArcsStart", "arcIdx", "getArcIdx", "setArcIdx", "numArcs", "getNumArcs", "setNumArcs", "bitTableStart", "getBitTableStart", "setBitTableStart", "firstLabel", "getFirstLabel", "setFirstLabel", "presenceIndex", "getPresenceIndex", "setPresenceIndex", "copyFrom", "other", "flag", "", "isLast", "()Z", "isFinal", "toString", "", "BitTable", "core"})
    public static final class Arc<T> {
        private int label;
        @Nullable
        private T output;
        private long target;
        private byte flags;
        @Nullable
        private T nextFinalOutput;
        private long nextArc;
        private byte nodeFlags;
        private int bytesPerArc;
        private long posArcsStart;
        private int arcIdx;
        private int numArcs;
        private long bitTableStart;
        private int firstLabel;
        private int presenceIndex;

        public final int getLabel() {
            return this.label;
        }

        public final void setLabel(int n) {
            this.label = n;
        }

        @Nullable
        public final T getOutput() {
            return this.output;
        }

        public final void setOutput(@Nullable T t) {
            this.output = t;
        }

        public final long getTarget() {
            return this.target;
        }

        public final void setTarget(long l) {
            this.target = l;
        }

        public final byte getFlags() {
            return this.flags;
        }

        public final void setFlags(byte by) {
            this.flags = by;
        }

        @Nullable
        public final T getNextFinalOutput() {
            return this.nextFinalOutput;
        }

        public final void setNextFinalOutput(@Nullable T t) {
            this.nextFinalOutput = t;
        }

        public final long getNextArc() {
            return this.nextArc;
        }

        public final void setNextArc(long l) {
            this.nextArc = l;
        }

        public final byte getNodeFlags() {
            return this.nodeFlags;
        }

        public final void setNodeFlags(byte by) {
            this.nodeFlags = by;
        }

        public final int getBytesPerArc() {
            return this.bytesPerArc;
        }

        public final void setBytesPerArc(int n) {
            this.bytesPerArc = n;
        }

        public final long getPosArcsStart() {
            return this.posArcsStart;
        }

        public final void setPosArcsStart(long l) {
            this.posArcsStart = l;
        }

        public final int getArcIdx() {
            return this.arcIdx;
        }

        public final void setArcIdx(int n) {
            this.arcIdx = n;
        }

        public final int getNumArcs() {
            return this.numArcs;
        }

        public final void setNumArcs(int n) {
            this.numArcs = n;
        }

        public final long getBitTableStart() {
            return this.bitTableStart;
        }

        public final void setBitTableStart(long l) {
            this.bitTableStart = l;
        }

        public final int getFirstLabel() {
            return this.firstLabel;
        }

        public final void setFirstLabel(int n) {
            this.firstLabel = n;
        }

        public final int getPresenceIndex() {
            return this.presenceIndex;
        }

        public final void setPresenceIndex(int n) {
            this.presenceIndex = n;
        }

        @NotNull
        public final Arc<T> copyFrom(@NotNull Arc<T> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            this.label = other.label();
            this.target = other.target();
            this.flags = other.flags();
            this.output = other.output();
            this.nextFinalOutput = other.nextFinalOutput();
            this.nextArc = other.nextArc();
            this.nodeFlags = other.nodeFlags();
            this.bytesPerArc = other.bytesPerArc();
            this.posArcsStart = other.posArcsStart();
            this.arcIdx = other.arcIdx();
            this.numArcs = other.numArcs();
            this.bitTableStart = other.bitTableStart;
            this.firstLabel = other.firstLabel();
            this.presenceIndex = other.presenceIndex;
            return this;
        }

        public final boolean flag(int flag) {
            return Companion.flag(this.flags, flag);
        }

        public final boolean isLast() {
            return this.flag(2);
        }

        public final boolean isFinal() {
            return this.flag(1);
        }

        @NotNull
        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(" target=").append(this.target());
            b.append(" label=0x").append(IntExtKt.toHexString(IntCompanionObject.INSTANCE, this.label()));
            if (this.flag(1)) {
                b.append(" final");
            }
            if (this.flag(2)) {
                b.append(" last");
            }
            if (this.flag(4)) {
                b.append(" targetNext");
            }
            if (this.flag(8)) {
                b.append(" stop");
            }
            if (this.flag(16)) {
                b.append(" output=").append(this.output());
            }
            if (this.flag(32)) {
                b.append(" nextFinalOutput=").append(this.nextFinalOutput());
            }
            if (this.bytesPerArc() != 0) {
                b.append(" arcArray(idx=").append(this.arcIdx()).append(" of ").append(this.numArcs()).append(")").append("(").append(this.nodeFlags() == 64 ? "da" : (this.nodeFlags() == 96 ? "cs" : "bs")).append(")");
            }
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public final int label() {
            return this.label;
        }

        @Nullable
        public final T output() {
            return this.output;
        }

        public final long target() {
            return this.target;
        }

        public final byte flags() {
            return this.flags;
        }

        @Nullable
        public final T nextFinalOutput() {
            return this.nextFinalOutput;
        }

        public final long nextArc() {
            return this.nextArc;
        }

        public final int arcIdx() {
            return this.arcIdx;
        }

        public final byte nodeFlags() {
            return this.nodeFlags;
        }

        public final long posArcsStart() {
            return this.posArcsStart;
        }

        public final int bytesPerArc() {
            return this.bytesPerArc;
        }

        public final int numArcs() {
            return this.numArcs;
        }

        public final int firstLabel() {
            return this.firstLabel;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\u0010\u001a\u00020\u00052\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/util/fst/FST$Arc$BitTable;", "", "<init>", "()V", "isBitSet", "", "bitIndex", "", "arc", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "in", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "countBits", "countBitsUpTo", "nextBitSet", "previousBitSet", "assertIsValid", "core"})
        public static final class BitTable {
            @NotNull
            public static final BitTable INSTANCE = new BitTable();

            private BitTable() {
            }

            public final boolean isBitSet(int bitIndex, @NotNull Arc<?> arc, @NotNull BytesReader in) throws IOException {
                Intrinsics.checkNotNullParameter(arc, (String)"arc");
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                if (!(arc.nodeFlags() == 64)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                in.setPosition(arc.getBitTableStart());
                return BitTableUtil.INSTANCE.isBitSet(bitIndex, in);
            }

            public final int countBits(@NotNull Arc<?> arc, @NotNull BytesReader in) throws IOException {
                Intrinsics.checkNotNullParameter(arc, (String)"arc");
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                if (!(arc.nodeFlags() == 64)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                in.setPosition(arc.getBitTableStart());
                return BitTableUtil.INSTANCE.countBits(Companion.getNumPresenceBytes(arc.numArcs()), in);
            }

            public final int countBitsUpTo(int bitIndex, @NotNull Arc<?> arc, @NotNull BytesReader in) throws IOException {
                Intrinsics.checkNotNullParameter(arc, (String)"arc");
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                if (!(arc.nodeFlags() == 64)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                in.setPosition(arc.getBitTableStart());
                return BitTableUtil.INSTANCE.countBitsUpTo(bitIndex, in);
            }

            public final int nextBitSet(int bitIndex, @NotNull Arc<?> arc, @NotNull BytesReader in) throws IOException {
                Intrinsics.checkNotNullParameter(arc, (String)"arc");
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                if (!(arc.nodeFlags() == 64)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                in.setPosition(arc.getBitTableStart());
                return BitTableUtil.INSTANCE.nextBitSet(bitIndex, Companion.getNumPresenceBytes(arc.numArcs()), in);
            }

            public final int previousBitSet(int bitIndex, @NotNull Arc<?> arc, @NotNull BytesReader in) throws IOException {
                Intrinsics.checkNotNullParameter(arc, (String)"arc");
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                if (!(arc.nodeFlags() == 64)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                in.setPosition(arc.getBitTableStart());
                return BitTableUtil.INSTANCE.previousBitSet(bitIndex, in);
            }

            public final boolean assertIsValid(@NotNull Arc<?> arc, @NotNull BytesReader in) throws IOException {
                Intrinsics.checkNotNullParameter(arc, (String)"arc");
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                if (!(arc.bytesPerArc() > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(arc.nodeFlags() == 64)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!this.isBitSet(0, arc, in)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!this.isBitSet(arc.numArcs() - 1, arc, in)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(this.nextBitSet(arc.numArcs() - 1, arc, in) == -1)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return true;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\u00020\u0005X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "Lorg/gnit/lucenekmp/store/DataInput;", "<init>", "()V", "position", "", "getPosition", "()J", "setPosition", "(J)V", "core"})
    public static abstract class BytesReader
    extends DataInput {
        public abstract long getPosition();

        public abstract void setPosition(long var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J,\u0010 \u001a\n\u0012\u0004\u0012\u0002H\"\u0018\u00010!\"\u0004\b\u0001\u0010\"2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u0002H\"\u0018\u00010$2\u0006\u0010%\u001a\u00020&J(\u0010'\u001a\b\u0012\u0004\u0012\u0002H\"0$\"\u0004\b\u0001\u0010\"2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\"0+J(\u0010,\u001a\b\u0012\u0004\u0012\u0002H\"0!\"\u0004\b\u0001\u0010\"2\u0006\u0010-\u001a\u00020.2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\"0+J\u001a\u0010/\u001a\u00020\u001c\"\u0004\b\u0001\u0010\"2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\"01J\u000e\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007J0\u00104\u001a\n\u0012\u0004\u0012\u0002H\"\u0018\u000101\"\u0004\b\u0001\u0010\"2\f\u00105\u001a\b\u0012\u0004\u0012\u0002H\"012\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\"01R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/gnit/lucenekmp/util/fst/FST$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "BIT_FINAL_ARC", "", "BIT_LAST_ARC", "BIT_TARGET_NEXT", "BIT_STOP_NODE", "BIT_ARC_HAS_OUTPUT", "BIT_ARC_HAS_FINAL_OUTPUT", "ARCS_FOR_BINARY_SEARCH", "", "ARCS_FOR_DIRECT_ADDRESSING", "ARCS_FOR_CONTINUOUS", "FILE_FORMAT_NAME", "", "VERSION_START", "VERSION_LITTLE_ENDIAN", "VERSION_CONTINUOUS_ARCS", "VERSION_CURRENT", "VERSION_90", "FINAL_END_NODE", "NON_FINAL_END_NODE", "END_LABEL", "flag", "", "flags", "bit", "DEFAULT_MAX_BLOCK_BITS", "fromFSTReader", "Lorg/gnit/lucenekmp/util/fst/FST;", "T", "fstMetadata", "Lorg/gnit/lucenekmp/util/fst/FST$FSTMetadata;", "fstReader", "Lorg/gnit/lucenekmp/util/fst/FSTReader;", "readMetadata", "metaIn", "Lorg/gnit/lucenekmp/store/DataInput;", "outputs", "Lorg/gnit/lucenekmp/util/fst/Outputs;", "read", "path", "Lokio/Path;", "targetHasArcs", "arc", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "getNumPresenceBytes", "labelRange", "readEndArc", "follow", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean flag(int flags, int bit) {
            return (flags & bit) != 0;
        }

        @Nullable
        public final <T> FST<T> fromFSTReader(@Nullable FSTMetadata<T> fstMetadata, @NotNull FSTReader fstReader) {
            Intrinsics.checkNotNullParameter((Object)fstReader, (String)"fstReader");
            if (fstMetadata == null) {
                return null;
            }
            return new FST<T>(fstMetadata, fstReader);
        }

        @NotNull
        public final <T> FSTMetadata<T> readMetadata(@NotNull DataInput metaIn, @NotNull Outputs<T> outputs) throws IOException {
            INPUT_TYPE iNPUT_TYPE;
            byte t;
            Intrinsics.checkNotNullParameter((Object)metaIn, (String)"metaIn");
            Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
            int version = CodecUtil.INSTANCE.checkHeader(metaIn, FST.FILE_FORMAT_NAME, 6, 9);
            Object emptyOutput = null;
            if (metaIn.readByte() == 1) {
                DataOutput dataOutput = FSTCompiler.Companion.getOnHeapReaderWriter(10);
                Intrinsics.checkNotNull((Object)dataOutput, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.fst.ReadWriteDataOutput");
                ReadWriteDataOutput emptyBytes = (ReadWriteDataOutput)dataOutput;
                int numBytes = metaIn.readVInt();
                emptyBytes.copyBytes(metaIn, numBytes);
                emptyBytes.freeze();
                BytesReader reader2 = emptyBytes.getReverseBytesReader();
                if (numBytes > 0) {
                    reader2.setPosition(numBytes - 1);
                }
                emptyOutput = outputs.readFinalOutput(reader2);
            } else {
                emptyOutput = null;
            }
            INPUT_TYPE inputType = null;
            byte reader2 = t = metaIn.readByte();
            if (reader2 == 0) {
                iNPUT_TYPE = INPUT_TYPE.BYTE1;
            } else if (reader2 == 1) {
                iNPUT_TYPE = INPUT_TYPE.BYTE2;
            } else if (reader2 == 2) {
                iNPUT_TYPE = INPUT_TYPE.BYTE4;
            } else {
                throw new CorruptIndexException("invalid input type " + t, metaIn);
            }
            inputType = iNPUT_TYPE;
            long startNode = metaIn.readVLong();
            long numBytes = metaIn.readVLong();
            Object t2 = emptyOutput;
            Intrinsics.checkNotNull(t2);
            return new FSTMetadata<Object>(inputType, (Outputs<Object>)outputs, t2, startNode, version, numBytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final <T> FST<T> read(@NotNull Path path, @NotNull Outputs<T> outputs) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
            AutoCloseable autoCloseable = Files.INSTANCE.newInputStream(path);
            Throwable throwable = null;
            try {
                InputStream is = (InputStream)autoCloseable;
                boolean bl = false;
                DataInput in = new InputStreamDataInput(new BufferedInputStream(is, 0, 2, null));
                FST<T> fST = new FST<T>(Companion.readMetadata(in, outputs), in);
                return fST;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        public final <T> boolean targetHasArcs(@NotNull Arc<T> arc) {
            Intrinsics.checkNotNullParameter(arc, (String)"arc");
            return arc.target() > 0L;
        }

        public final int getNumPresenceBytes(int labelRange) {
            if (!(labelRange >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return labelRange + 7 >> 3;
        }

        @Nullable
        public final <T> Arc<T> readEndArc(@NotNull Arc<T> follow, @NotNull Arc<T> arc) {
            Intrinsics.checkNotNullParameter(follow, (String)"follow");
            Intrinsics.checkNotNullParameter(arc, (String)"arc");
            if (follow.isFinal()) {
                if (follow.target() <= 0L) {
                    arc.setFlags((byte)2);
                } else {
                    arc.setFlags((byte)0);
                    arc.setNextArc(follow.target());
                }
                arc.setOutput(follow.nextFinalOutput());
                arc.setLabel(-1);
                return arc;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00018\u0001\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0007\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001d\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/util/fst/FST$FSTMetadata;", "T", "", "inputType", "Lorg/gnit/lucenekmp/util/fst/FST$INPUT_TYPE;", "outputs", "Lorg/gnit/lucenekmp/util/fst/Outputs;", "emptyOutput", "startNode", "", "version", "", "numBytes", "<init>", "(Lorg/gnit/lucenekmp/util/fst/FST$INPUT_TYPE;Lorg/gnit/lucenekmp/util/fst/Outputs;Ljava/lang/Object;JIJ)V", "getInputType", "()Lorg/gnit/lucenekmp/util/fst/FST$INPUT_TYPE;", "getOutputs", "()Lorg/gnit/lucenekmp/util/fst/Outputs;", "getEmptyOutput", "()Ljava/lang/Object;", "setEmptyOutput", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getVersion", "()I", "getStartNode", "()J", "setStartNode", "(J)V", "getNumBytes", "setNumBytes", "save", "", "metaOut", "Lorg/gnit/lucenekmp/store/DataOutput;", "core"})
    public static final class FSTMetadata<T> {
        @NotNull
        private final INPUT_TYPE inputType;
        @NotNull
        private final Outputs<T> outputs;
        @Nullable
        private T emptyOutput;
        private final int version;
        private long startNode;
        private long numBytes;

        public FSTMetadata(@NotNull INPUT_TYPE inputType, @NotNull Outputs<T> outputs, @Nullable T emptyOutput, long startNode, int version, long numBytes) {
            Intrinsics.checkNotNullParameter((Object)((Object)inputType), (String)"inputType");
            Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
            this.inputType = inputType;
            this.outputs = outputs;
            this.emptyOutput = emptyOutput;
            this.emptyOutput = this.emptyOutput;
            this.startNode = startNode;
            this.version = version;
            this.numBytes = numBytes;
        }

        @NotNull
        public final INPUT_TYPE getInputType() {
            return this.inputType;
        }

        @NotNull
        public final Outputs<T> getOutputs() {
            return this.outputs;
        }

        @Nullable
        public final T getEmptyOutput() {
            return this.emptyOutput;
        }

        public final void setEmptyOutput(@Nullable T t) {
            this.emptyOutput = t;
        }

        public final int getVersion() {
            return this.version;
        }

        public final long getStartNode() {
            return this.startNode;
        }

        public final void setStartNode(long l) {
            this.startNode = l;
        }

        public final long getNumBytes() {
            return this.numBytes;
        }

        public final void setNumBytes(long l) {
            this.numBytes = l;
        }

        public final void save(@NotNull DataOutput metaOut) throws IOException {
            Intrinsics.checkNotNullParameter((Object)metaOut, (String)"metaOut");
            CodecUtil.INSTANCE.writeHeader(metaOut, FST.FILE_FORMAT_NAME, 9);
            if (this.emptyOutput != null) {
                metaOut.writeByte((byte)1);
                ByteBuffersDataOutput ros = new ByteBuffersDataOutput(0, 0, null, null, 15, null);
                T t = this.emptyOutput;
                Intrinsics.checkNotNull(t);
                this.outputs.writeFinalOutput(t, ros);
                byte[] emptyOutputBytes = ros.toArrayCopy();
                int emptyLen = emptyOutputBytes.length;
                int stopAt = emptyLen / 2;
                for (int upto = 0; upto < stopAt; ++upto) {
                    byte b = emptyOutputBytes[upto];
                    emptyOutputBytes[upto] = emptyOutputBytes[emptyLen - upto - 1];
                    emptyOutputBytes[emptyLen - upto - 1] = b;
                }
                metaOut.writeVInt(emptyLen);
                metaOut.writeBytes(emptyOutputBytes, 0, emptyLen);
            } else {
                metaOut.writeByte((byte)0);
            }
            byte t = this.inputType == INPUT_TYPE.BYTE1 ? (byte)0 : (this.inputType == INPUT_TYPE.BYTE2 ? (byte)1 : 2);
            metaOut.writeByte(t);
            metaOut.writeVLong(this.startNode);
            metaOut.writeVLong(this.numBytes);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/util/fst/FST$INPUT_TYPE;", "", "<init>", "(Ljava/lang/String;I)V", "BYTE1", "BYTE2", "BYTE4", "core"})
    public static final class INPUT_TYPE
    extends Enum<INPUT_TYPE> {
        public static final /* enum */ INPUT_TYPE BYTE1 = new INPUT_TYPE();
        public static final /* enum */ INPUT_TYPE BYTE2 = new INPUT_TYPE();
        public static final /* enum */ INPUT_TYPE BYTE4 = new INPUT_TYPE();
        private static final /* synthetic */ INPUT_TYPE[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static INPUT_TYPE[] values() {
            return (INPUT_TYPE[])$VALUES.clone();
        }

        public static INPUT_TYPE valueOf(String value) {
            return Enum.valueOf(INPUT_TYPE.class, value);
        }

        @NotNull
        public static EnumEntries<INPUT_TYPE> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = iNPUT_TYPEArray = new INPUT_TYPE[]{INPUT_TYPE.BYTE1, INPUT_TYPE.BYTE2, INPUT_TYPE.BYTE4};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

