/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.Outputs;
import org.gnit.lucenekmp.util.fst.Util;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010(\u001a\u00020 H$J\b\u0010)\u001a\u00020 H$J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020 H$J\b\u0010-\u001a\u00020+H$J\b\u0010.\u001a\u00020+H\u0002J\b\u0010/\u001a\u00020+H\u0004J\b\u00100\u001a\u00020+H\u0004J.\u00101\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u001cH\u0002J.\u00105\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u001cH\u0002J.\u00106\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u001cH\u0002J&\u00107\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 H\u0002J\u0006\u00108\u001a\u00020+J.\u00109\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u001cH\u0002J.\u0010:\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u001cH\u0002J\b\u0010;\u001a\u00020+H\u0002J.\u0010<\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u001cH\u0002J&\u0010=\u001a\u00020+2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u001cH\u0002J&\u0010>\u001a\u00020+2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u001cH\u0002J&\u0010?\u001a\u00020+2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u001cH\u0002J.\u0010@\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u001cH\u0002J&\u0010A\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00103\u001a\u00020 H\u0002J\u0006\u0010B\u001a\u00020CJ\b\u0010D\u001a\u00020+H\u0002J\b\u0010E\u001a\u00020+H\u0002J\b\u0010F\u001a\u00020+H\u0002J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010H\u001a\u00020 H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b0\nX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$\u00a8\u0006I"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTEnum;", "T", "", "fst", "Lorg/gnit/lucenekmp/util/fst/FST;", "<init>", "(Lorg/gnit/lucenekmp/util/fst/FST;)V", "getFst", "()Lorg/gnit/lucenekmp/util/fst/FST;", "arcs", "", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "getArcs", "()[Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "setArcs", "([Lorg/gnit/lucenekmp/util/fst/FST$Arc;)V", "[Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "output", "getOutput", "()[Ljava/lang/Object;", "setOutput", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "NO_OUTPUT", "getNO_OUTPUT", "()Ljava/lang/Object;", "Ljava/lang/Object;", "fstReader", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "getFstReader", "()Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "upto", "", "getUpto", "()I", "setUpto", "(I)V", "targetLength", "getTargetLength", "setTargetLength", "getTargetLabel", "getCurrentLabel", "setCurrentLabel", "", "label", "grow", "rewindPrefix", "doNext", "doSeekCeil", "doSeekCeilArrayContinuous", "arc", "targetLabel", "in", "doSeekCeilArrayDirectAddressing", "doSeekCeilArrayPacked", "doSeekCeilList", "doSeekFloor", "doSeekFloorContinuous", "doSeekFloorArrayDirectAddressing", "rollbackToLastForkThenPush", "backtrackToFloorArc", "findNextFloorArcDirectAddressing", "findNextFloorArcContinuous", "findNextFloorArcBinarySearch", "doSeekFloorArrayPacked", "doSeekFloorList", "doSeekExact", "", "incr", "pushFirst", "pushLast", "getArc", "idx", "core"})
public abstract class FSTEnum<T> {
    @NotNull
    private final FST<T> fst;
    @NotNull
    private FST.Arc<T>[] arcs;
    @NotNull
    private T[] output;
    private final T NO_OUTPUT;
    @NotNull
    private final FST.BytesReader fstReader;
    private int upto;
    private int targetLength;

    public FSTEnum(@NotNull FST<T> fst) {
        Intrinsics.checkNotNullParameter(fst, (String)"fst");
        this.fst = fst;
        this.arcs = new FST.Arc[10];
        this.output = new Object[10];
        this.NO_OUTPUT = this.fst.getOutputs().getNoOutput();
        this.fstReader = this.fst.getBytesReader();
        this.fst.getFirstArc(this.getArc(0));
        this.output[0] = this.NO_OUTPUT;
    }

    @NotNull
    protected final FST<T> getFst() {
        return this.fst;
    }

    @NotNull
    protected final FST.Arc<T>[] getArcs() {
        return this.arcs;
    }

    protected final void setArcs(@NotNull FST.Arc<T>[] arcArray) {
        Intrinsics.checkNotNullParameter(arcArray, (String)"<set-?>");
        this.arcs = arcArray;
    }

    @NotNull
    protected final T[] getOutput() {
        return this.output;
    }

    protected final void setOutput(@NotNull T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"<set-?>");
        this.output = TArray;
    }

    protected final T getNO_OUTPUT() {
        return this.NO_OUTPUT;
    }

    @NotNull
    protected final FST.BytesReader getFstReader() {
        return this.fstReader;
    }

    protected final int getUpto() {
        return this.upto;
    }

    protected final void setUpto(int n) {
        this.upto = n;
    }

    public final int getTargetLength() {
        return this.targetLength;
    }

    public final void setTargetLength(int n) {
        this.targetLength = n;
    }

    protected abstract int getTargetLabel();

    protected abstract int getCurrentLabel();

    protected abstract void setCurrentLabel(int var1);

    protected abstract void grow();

    private final void rewindPrefix() throws IOException {
        int cmp;
        if (this.upto == 0) {
            this.upto = 1;
            this.fst.readFirstTargetArc(this.getArc(0), this.getArc(1), this.fstReader);
            return;
        }
        int currentLimit = this.upto;
        this.upto = 1;
        while (this.upto < currentLimit && this.upto <= this.targetLength + 1 && (cmp = this.getCurrentLabel() - this.getTargetLabel()) >= 0) {
            if (cmp > 0) {
                FST.Arc<T> arc = this.getArc(this.upto);
                this.fst.readFirstTargetArc(this.getArc(this.upto - 1), arc, this.fstReader);
                break;
            }
            int n = this.upto;
            this.upto = n + 1;
        }
    }

    protected final void doNext() throws IOException {
        if (this.upto == 0) {
            this.upto = 1;
            v0 = this.fst.readFirstTargetArc(this.getArc(0), this.getArc(1), this.fstReader);
        } else {
            block3: {
                do {
                    FST.Arc<T> arc = this.arcs[this.upto];
                    Intrinsics.checkNotNull(arc);
                    if (!arc.isLast()) break block3;
                    int n = this.upto;
                    this.upto = n + -1;
                } while (this.upto != 0);
                return;
            }
            FST.Arc<T> arc = this.arcs[this.upto];
            Intrinsics.checkNotNull(arc);
            v0 = this.fst.readNextArc(arc, this.fstReader);
        }
        this.pushFirst();
    }

    protected final void doSeekCeil() throws IOException {
        this.rewindPrefix();
        FST.Arc<T> arc = this.getArc(this.upto);
        while (arc != null) {
            int targetLabel = this.getTargetLabel();
            if (arc.bytesPerArc() != 0 && arc.label() != -1) {
                FST.BytesReader in = this.fst.getBytesReader();
                if (arc.nodeFlags() == 64) {
                    arc = this.doSeekCeilArrayDirectAddressing(arc, targetLabel, in);
                    continue;
                }
                if (arc.nodeFlags() == 32) {
                    arc = this.doSeekCeilArrayPacked(arc, targetLabel, in);
                    continue;
                }
                if (!(arc.nodeFlags() == 96)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                arc = this.doSeekCeilArrayContinuous(arc, targetLabel, in);
                continue;
            }
            arc = this.doSeekCeilList(arc, targetLabel);
        }
    }

    private final FST.Arc<T> doSeekCeilArrayContinuous(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int targetIndex = targetLabel - arc.firstLabel();
        if (targetIndex >= arc.numArcs()) {
            this.rollbackToLastForkThenPush();
            return null;
        }
        if (targetIndex < 0) {
            this.fst.readArcByContinuous(arc, in, 0);
            if (!(arc.label() > targetLabel)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.pushFirst();
            return null;
        }
        this.fst.readArcByContinuous(arc, in, targetIndex);
        if (!(arc.label() == targetLabel)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Outputs<T> outputs = this.fst.getOutputs();
        T t = this.output[this.upto - 1];
        T t2 = arc.output();
        Intrinsics.checkNotNull(t2);
        this.output[this.upto] = outputs.add(t, t2);
        if (targetLabel == -1) {
            return null;
        }
        this.setCurrentLabel(arc.label());
        this.incr();
        return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
    }

    private final FST.Arc<T> doSeekCeilArrayDirectAddressing(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int targetIndex = targetLabel - arc.firstLabel();
        if (targetIndex >= arc.numArcs()) {
            this.rollbackToLastForkThenPush();
            return null;
        }
        if (targetIndex < 0) {
            targetIndex = -1;
        } else if (FST.Arc.BitTable.INSTANCE.isBitSet(targetIndex, arc, in)) {
            this.fst.readArcByDirectAddressing(arc, in, targetIndex);
            if (!(arc.label() == targetLabel)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Outputs<T> outputs = this.fst.getOutputs();
            T t = this.output[this.upto - 1];
            T t2 = arc.output();
            Intrinsics.checkNotNull(t2);
            this.output[this.upto] = outputs.add(t, t2);
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        int ceilIndex = FST.Arc.BitTable.INSTANCE.nextBitSet(targetIndex, arc, in);
        if (!(ceilIndex != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.fst.readArcByDirectAddressing(arc, in, ceilIndex);
        if (!(arc.label() > targetLabel)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.pushFirst();
        return null;
    }

    private final FST.Arc<T> doSeekCeilArrayPacked(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int idx = 0;
        idx = Util.INSTANCE.binarySearch(this.fst, arc, targetLabel);
        if (idx >= 0) {
            this.fst.readArcByIndex(arc, in, idx);
            if (!(arc.arcIdx() == idx)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(arc.label() == targetLabel)) {
                boolean bl = false;
                String string = "arc.label=" + arc.label() + " vs targetLabel=" + targetLabel + " mid=" + idx;
                throw new IllegalArgumentException(string.toString());
            }
            Outputs<T> outputs = this.fst.getOutputs();
            T t = this.output[this.upto - 1];
            T t2 = arc.output();
            Intrinsics.checkNotNull(t2);
            this.output[this.upto] = outputs.add(t, t2);
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        if ((idx = -1 - idx) == arc.numArcs()) {
            this.fst.readArcByIndex(arc, in, idx - 1);
            if (!arc.isLast()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n = this.upto;
            this.upto = n + -1;
            while (true) {
                if (this.upto == 0) {
                    return null;
                }
                FST.Arc<T> prevArc = this.getArc(this.upto);
                if (!prevArc.isLast()) {
                    this.fst.readNextArc(prevArc, this.fstReader);
                    this.pushFirst();
                    return null;
                }
                int n2 = this.upto;
                this.upto = n2 + -1;
            }
        }
        this.fst.readArcByIndex(arc, in, idx);
        if (!(arc.label() > targetLabel)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.pushFirst();
        return null;
    }

    private final FST.Arc<T> doSeekCeilList(FST.Arc<T> arc, int targetLabel) throws IOException {
        if (arc.label() == targetLabel) {
            Outputs<T> outputs = this.fst.getOutputs();
            T t = this.output[this.upto - 1];
            T t2 = arc.output();
            Intrinsics.checkNotNull(t2);
            this.output[this.upto] = outputs.add(t, t2);
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        if (arc.label() > targetLabel) {
            this.pushFirst();
            return null;
        }
        if (arc.isLast()) {
            int n = this.upto;
            this.upto = n + -1;
            while (true) {
                if (this.upto == 0) {
                    return null;
                }
                FST.Arc<T> prevArc = this.getArc(this.upto);
                if (!prevArc.isLast()) {
                    this.fst.readNextArc(prevArc, this.fstReader);
                    this.pushFirst();
                    return null;
                }
                int n2 = this.upto;
                this.upto = n2 + -1;
            }
        }
        this.fst.readNextArc(arc, this.fstReader);
        return arc;
    }

    public final void doSeekFloor() throws IOException {
        this.rewindPrefix();
        FST.Arc<T> arc = this.getArc(this.upto);
        while (arc != null) {
            int targetLabel = this.getTargetLabel();
            if (arc.bytesPerArc() != 0 && arc.label() != -1) {
                FST.BytesReader in = this.fst.getBytesReader();
                if (arc.nodeFlags() == 64) {
                    arc = this.doSeekFloorArrayDirectAddressing(arc, targetLabel, in);
                    continue;
                }
                if (arc.nodeFlags() == 32) {
                    arc = this.doSeekFloorArrayPacked(arc, targetLabel, in);
                    continue;
                }
                if (!(arc.nodeFlags() == 96)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                arc = this.doSeekFloorContinuous(arc, targetLabel, in);
                continue;
            }
            arc = this.doSeekFloorList(arc, targetLabel);
        }
    }

    private final FST.Arc<T> doSeekFloorContinuous(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int targetIndex = targetLabel - arc.firstLabel();
        if (targetIndex < 0) {
            return this.backtrackToFloorArc(arc, targetLabel, in);
        }
        if (targetIndex >= arc.numArcs()) {
            this.fst.readLastArcByContinuous(arc, in);
            if (!(arc.label() < targetLabel)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!arc.isLast()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.pushLast();
            return null;
        }
        this.fst.readArcByContinuous(arc, in, targetIndex);
        if (!(arc.label() == targetLabel)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Outputs<T> outputs = this.fst.getOutputs();
        T t = this.output[this.upto - 1];
        T t2 = arc.output();
        Intrinsics.checkNotNull(t2);
        this.output[this.upto] = outputs.add(t, t2);
        if (targetLabel == -1) {
            return null;
        }
        this.setCurrentLabel(arc.label());
        this.incr();
        return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
    }

    private final FST.Arc<T> doSeekFloorArrayDirectAddressing(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int targetIndex = targetLabel - arc.firstLabel();
        if (targetIndex < 0) {
            return this.backtrackToFloorArc(arc, targetLabel, in);
        }
        if (targetIndex >= arc.numArcs()) {
            this.fst.readLastArcByDirectAddressing(arc, in);
            if (!(arc.label() < targetLabel)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!arc.isLast()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.pushLast();
            return null;
        }
        if (FST.Arc.BitTable.INSTANCE.isBitSet(targetIndex, arc, in)) {
            this.fst.readArcByDirectAddressing(arc, in, targetIndex);
            if (!(arc.label() == targetLabel)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Outputs<T> outputs = this.fst.getOutputs();
            T t = this.output[this.upto - 1];
            T t2 = arc.output();
            Intrinsics.checkNotNull(t2);
            this.output[this.upto] = outputs.add(t, t2);
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        int floorIndex = FST.Arc.BitTable.INSTANCE.previousBitSet(targetIndex, arc, in);
        if (!(floorIndex != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.fst.readArcByDirectAddressing(arc, in, floorIndex);
        if (!(arc.label() < targetLabel)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(arc.isLast() || this.fst.readNextArcLabel(arc, in) > targetLabel)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.pushLast();
        return null;
    }

    private final void rollbackToLastForkThenPush() throws IOException {
        int n = this.upto;
        this.upto = n + -1;
        while (this.upto != 0) {
            FST.Arc<T> prevArc = this.getArc(this.upto);
            if (!prevArc.isLast()) {
                this.fst.readNextArc(prevArc, this.fstReader);
                this.pushFirst();
                return;
            }
            int n2 = this.upto;
            this.upto = n2 + -1;
        }
        return;
    }

    private final FST.Arc<T> backtrackToFloorArc(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        FST.Arc<T> arc2 = arc;
        int targetLabel2 = targetLabel;
        while (true) {
            this.fst.readFirstTargetArc(this.getArc(this.upto - 1), arc2, this.fstReader);
            if (arc2.label() < targetLabel2) {
                if (!arc2.isLast()) {
                    if (arc2.bytesPerArc() != 0 && arc2.label() != -1) {
                        if (arc2.nodeFlags() == 32) {
                            this.findNextFloorArcBinarySearch(arc2, targetLabel2, in);
                        } else if (arc2.nodeFlags() == 64) {
                            this.findNextFloorArcDirectAddressing(arc2, targetLabel2, in);
                        } else {
                            if (!(arc2.nodeFlags() == 96)) {
                                String string = "Failed requirement.";
                                throw new IllegalArgumentException(string.toString());
                            }
                            this.findNextFloorArcContinuous(arc2, targetLabel2, in);
                        }
                    } else {
                        while (!arc2.isLast() && this.fst.readNextArcLabel(arc2, in) < targetLabel2) {
                            this.fst.readNextArc(arc2, this.fstReader);
                        }
                    }
                }
                if (!(arc2.label() < targetLabel2)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(arc2.isLast() || this.fst.readNextArcLabel(arc2, in) >= targetLabel2)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.pushLast();
                return null;
            }
            int n = this.upto;
            this.upto = n + -1;
            if (this.upto == 0) {
                return null;
            }
            targetLabel2 = this.getTargetLabel();
            arc2 = this.getArc(this.upto);
        }
    }

    private final void findNextFloorArcDirectAddressing(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        if (!(arc.nodeFlags() == 64)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(arc.label() != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(arc.label() == arc.firstLabel())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (arc.numArcs() > 1) {
            int targetIndex = targetLabel - arc.firstLabel();
            if (!(targetIndex >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (targetIndex >= arc.numArcs()) {
                this.fst.readLastArcByDirectAddressing(arc, in);
            } else {
                int floorIndex = FST.Arc.BitTable.INSTANCE.previousBitSet(targetIndex, arc, in);
                if (floorIndex > 0) {
                    this.fst.readArcByDirectAddressing(arc, in, floorIndex);
                }
            }
        }
    }

    private final void findNextFloorArcContinuous(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        if (!(arc.nodeFlags() == 96)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(arc.label() != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(arc.label() == arc.firstLabel())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (arc.numArcs() > 1) {
            int targetIndex = targetLabel - arc.firstLabel();
            if (!(targetIndex >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            FST.Arc<T> arc2 = targetIndex >= arc.numArcs() ? this.fst.readLastArcByContinuous(arc, in) : this.fst.readArcByContinuous(arc, in, targetIndex - 1);
        }
    }

    private final void findNextFloorArcBinarySearch(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        if (!(arc.nodeFlags() == 32)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(arc.label() != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(arc.arcIdx() == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (arc.numArcs() > 1) {
            int idx = Util.INSTANCE.binarySearch(this.fst, arc, targetLabel);
            if (!(idx != -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (idx > 1) {
                this.fst.readArcByIndex(arc, in, idx - 1);
            } else if (idx < -2) {
                this.fst.readArcByIndex(arc, in, -2 - idx);
            }
        }
    }

    private final FST.Arc<T> doSeekFloorArrayPacked(FST.Arc<T> arc, int targetLabel, FST.BytesReader in) throws IOException {
        int idx = Util.INSTANCE.binarySearch(this.fst, arc, targetLabel);
        if (idx >= 0) {
            this.fst.readArcByIndex(arc, in, idx);
            if (!(arc.arcIdx() == idx)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(arc.label() == targetLabel)) {
                boolean $i$a$-require-FSTEnum$doSeekFloorArrayPacked$32 = false;
                String $i$a$-require-FSTEnum$doSeekFloorArrayPacked$32 = "arc.label=" + arc.label() + " vs targetLabel=" + targetLabel + " mid=" + idx;
                throw new IllegalArgumentException($i$a$-require-FSTEnum$doSeekFloorArrayPacked$32.toString());
            }
            Outputs<T> outputs = this.fst.getOutputs();
            T t = this.output[this.upto - 1];
            T t2 = arc.output();
            Intrinsics.checkNotNull(t2);
            this.output[this.upto] = outputs.add(t, t2);
            if (targetLabel == -1) {
                return null;
            }
            this.setCurrentLabel(arc.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc, this.getArc(this.upto), this.fstReader);
        }
        if (idx == -1) {
            return this.backtrackToFloorArc(arc, targetLabel, in);
        }
        this.fst.readArcByIndex(arc, in, -2 - idx);
        if (!(arc.isLast() || this.fst.readNextArcLabel(arc, in) > targetLabel)) {
            String $i$a$-require-FSTEnum$doSeekFloorArrayPacked$32 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-require-FSTEnum$doSeekFloorArrayPacked$32.toString());
        }
        if (!(arc.label() < targetLabel)) {
            boolean bl = false;
            String string = "arc.label=" + arc.label() + " vs targetLabel=" + targetLabel;
            throw new IllegalArgumentException(string.toString());
        }
        this.pushLast();
        return null;
    }

    private final FST.Arc<T> doSeekFloorList(FST.Arc<T> arc, int targetLabel) throws IOException {
        FST.Arc<T> arc2 = arc;
        int targetLabel2 = targetLabel;
        if (arc2.label() == targetLabel2) {
            Outputs<T> outputs = this.fst.getOutputs();
            T t = this.output[this.upto - 1];
            T t2 = arc2.output();
            Intrinsics.checkNotNull(t2);
            this.output[this.upto] = outputs.add(t, t2);
            if (targetLabel2 == -1) {
                return null;
            }
            this.setCurrentLabel(arc2.label());
            this.incr();
            return this.fst.readFirstTargetArc(arc2, this.getArc(this.upto), this.fstReader);
        }
        if (arc2.label() > targetLabel2) {
            while (true) {
                this.fst.readFirstTargetArc(this.getArc(this.upto - 1), arc2, this.fstReader);
                if (arc2.label() < targetLabel2) {
                    while (!arc2.isLast() && this.fst.readNextArcLabel(arc2, this.fstReader) < targetLabel2) {
                        this.fst.readNextArc(arc2, this.fstReader);
                    }
                    this.pushLast();
                    return null;
                }
                int n = this.upto;
                this.upto = n + -1;
                if (this.upto == 0) {
                    return null;
                }
                targetLabel2 = this.getTargetLabel();
                arc2 = this.getArc(this.upto);
            }
        }
        if (!arc2.isLast()) {
            if (this.fst.readNextArcLabel(arc2, this.fstReader) > targetLabel2) {
                this.pushLast();
                return null;
            }
            return this.fst.readNextArc(arc2, this.fstReader);
        }
        this.pushLast();
        return null;
    }

    public final boolean doSeekExact() throws IOException {
        this.rewindPrefix();
        FST.Arc<T> arc = this.getArc(this.upto - 1);
        int targetLabel = this.getTargetLabel();
        FST.BytesReader fstReader = this.fst.getBytesReader();
        while (true) {
            FST.Arc<T> nextArc;
            if ((nextArc = this.fst.findTargetArc(targetLabel, arc, this.getArc(this.upto), fstReader)) == null) {
                this.fst.readFirstTargetArc(arc, this.getArc(this.upto), fstReader);
                return false;
            }
            Outputs<T> outputs = this.fst.getOutputs();
            T t = this.output[this.upto - 1];
            T t2 = nextArc.output();
            Intrinsics.checkNotNull(t2);
            this.output[this.upto] = outputs.add(t, t2);
            if (targetLabel == -1) {
                return true;
            }
            this.setCurrentLabel(targetLabel);
            this.incr();
            targetLabel = this.getTargetLabel();
            arc = nextArc;
        }
    }

    private final void incr() {
        int n = this.upto;
        this.upto = n + 1;
        this.grow();
        if (this.arcs.length <= this.upto) {
            FST.Arc[] newArcs = new FST.Arc[ArrayUtil.Companion.oversize(1 + this.upto, 4)];
            System.INSTANCE.arraycopyKtNullable(this.arcs, 0, newArcs, 0, this.arcs.length);
            this.arcs = newArcs;
        }
        if (this.output.length <= this.upto) {
            Object[] newOutput = new Object[ArrayUtil.Companion.oversize(1 + this.upto, 4)];
            System.INSTANCE.arraycopyKt(this.output, 0, newOutput, 0, this.output.length);
            this.output = newOutput;
        }
    }

    private final void pushFirst() throws IOException {
        FST.Arc<T> arc = this.arcs[this.upto];
        if (arc == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        FST.Arc<T> arc2 = arc;
        while (true) {
            Outputs<T> outputs = this.fst.getOutputs();
            T t = this.output[this.upto - 1];
            T t2 = arc2.output();
            Intrinsics.checkNotNull(t2);
            this.output[this.upto] = outputs.add(t, t2);
            if (arc2.label() == -1) break;
            this.setCurrentLabel(arc2.label());
            this.incr();
            FST.Arc<T> nextArc = this.getArc(this.upto);
            this.fst.readFirstTargetArc(arc2, nextArc, this.fstReader);
            arc2 = nextArc;
        }
    }

    private final void pushLast() throws IOException {
        FST.Arc<T> arc = this.arcs[this.upto];
        if (arc == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        FST.Arc<T> arc2 = arc;
        while (true) {
            this.setCurrentLabel(arc2.label());
            Outputs<T> outputs = this.fst.getOutputs();
            T t = this.output[this.upto - 1];
            T t2 = arc2.output();
            Intrinsics.checkNotNull(t2);
            this.output[this.upto] = outputs.add(t, t2);
            if (arc2.label() == -1) break;
            this.incr();
            arc2 = this.fst.readLastTargetArc(arc2, this.getArc(this.upto), this.fstReader);
        }
    }

    private final FST.Arc<T> getArc(int idx) {
        if (this.arcs[idx] == null) {
            this.arcs[idx] = new FST.Arc();
        }
        FST.Arc<T> arc = this.arcs[idx];
        Intrinsics.checkNotNull(arc);
        return arc;
    }
}

