/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.FSTReader;
import org.gnit.lucenekmp.util.fst.ReverseRandomAccessReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0006\u0010\f\u001a\u00020\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/util/fst/OffHeapFSTStore;", "Lorg/gnit/lucenekmp/util/fst/FSTReader;", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "offset", "", "metadata", "Lorg/gnit/lucenekmp/util/fst/FST$FSTMetadata;", "<init>", "(Lorg/gnit/lucenekmp/store/IndexInput;JLorg/gnit/lucenekmp/util/fst/FST$FSTMetadata;)V", "numBytes", "ramBytesUsed", "size", "getReverseBytesReader", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "writeTo", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "Companion", "core"})
public final class OffHeapFSTStore
implements FSTReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexInput in;
    private final long offset;
    private final long numBytes;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(OffHeapFSTStore.class));

    public OffHeapFSTStore(@NotNull IndexInput in, long offset, @NotNull FST.FSTMetadata<?> metadata) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        this.in = in;
        this.offset = offset;
        this.numBytes = metadata.getNumBytes();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    public final long size() {
        return this.numBytes;
    }

    @Override
    @NotNull
    public FST.BytesReader getReverseBytesReader() {
        try {
            return new ReverseRandomAccessReader(this.in.randomAccessSlice(this.offset, this.numBytes));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeTo(@NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        throw new UnsupportedOperationException("writeToOutput operation is not supported for OffHeapFSTStore");
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return FSTReader.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/fst/OffHeapFSTStore$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

