/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.FSTReader;
import org.gnit.lucenekmp.util.fst.ReverseBytesReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0011J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0001H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/util/fst/ReadWriteDataOutput;", "Lorg/gnit/lucenekmp/store/DataOutput;", "Lorg/gnit/lucenekmp/util/fst/FSTReader;", "blockBits", "", "<init>", "(I)V", "dataOutput", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "blockSize", "blockMask", "byteBuffers", "", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "frozen", "", "writeByte", "", "b", "", "writeBytes", "", "offset", "length", "ramBytesUsed", "", "freeze", "getReverseBytesReader", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "writeTo", "out", "core"})
@SourceDebugExtension(value={"SMAP\nReadWriteDataOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadWriteDataOutput.kt\norg/gnit/lucenekmp/util/fst/ReadWriteDataOutput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1740#2,3:97\n*S KotlinDebug\n*F\n+ 1 ReadWriteDataOutput.kt\norg/gnit/lucenekmp/util/fst/ReadWriteDataOutput\n*L\n45#1:97,3\n*E\n"})
public final class ReadWriteDataOutput
extends DataOutput
implements FSTReader {
    private final int blockBits;
    @NotNull
    private final ByteBuffersDataOutput dataOutput;
    private final int blockSize;
    private final int blockMask;
    @Nullable
    private List<ByteBuffer> byteBuffers;
    private boolean frozen;

    public ReadWriteDataOutput(int blockBits) {
        this.blockBits = blockBits;
        this.dataOutput = new ByteBuffersDataOutput(this.blockBits, this.blockBits, ByteBuffersDataOutput.Companion.getALLOCATE_BB_ON_HEAP(), ByteBuffersDataOutput.Companion.getNO_REUSE());
        this.blockSize = 1 << this.blockBits;
        this.blockMask = this.blockSize - 1;
    }

    @Override
    public void writeByte(byte b) {
        if (!(!this.frozen)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.dataOutput.writeByte(b);
    }

    @Override
    public void writeBytes(@NotNull byte[] b, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(!this.frozen)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.dataOutput.writeBytes(b, offset, length);
    }

    @Override
    public long ramBytesUsed() {
        return this.dataOutput.ramBytesUsed();
    }

    public final void freeze() {
        boolean bl;
        block4: {
            this.frozen = true;
            List<ByteBuffer> list = this.byteBuffers = this.dataOutput.toWriteableBufferList();
            Intrinsics.checkNotNull(list);
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ByteBuffer obj = (ByteBuffer)element$iv;
                    boolean bl2 = false;
                    if (obj.hasArray()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public FST.BytesReader getReverseBytesReader() {
        if (this.byteBuffers == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        List<ByteBuffer> list = this.byteBuffers;
        Intrinsics.checkNotNull(list);
        if (list.size() == 1) {
            List<ByteBuffer> list2 = this.byteBuffers;
            Intrinsics.checkNotNull(list2);
            return new ReverseBytesReader(list2.get(0).array());
        }
        return new FST.BytesReader(this){
            private byte[] current;
            private int nextBuffer;
            private int nextRead;
            final /* synthetic */ ReadWriteDataOutput this$0;
            {
                this.this$0 = $receiver;
                List list = ReadWriteDataOutput.access$getByteBuffers$p($receiver);
                Intrinsics.checkNotNull((Object)list);
                this.current = ((ByteBuffer)list.get(0)).array();
                this.nextBuffer = -1;
            }

            public byte readByte() {
                int n;
                if (this.nextRead == -1) {
                    List list = ReadWriteDataOutput.access$getByteBuffers$p(this.this$0);
                    Intrinsics.checkNotNull((Object)list);
                    n = this.nextBuffer;
                    this.nextBuffer = n + -1;
                    this.current = ((ByteBuffer)list.get(n)).array();
                    this.nextRead = ReadWriteDataOutput.access$getBlockSize$p(this.this$0) - 1;
                }
                n = this.nextRead;
                this.nextRead = n + -1;
                return this.current[n];
            }

            public void skipBytes(long count) {
                this.setPosition(this.getPosition() - count);
            }

            public void readBytes(byte[] b, int offset, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                for (int i = 0; i < len; ++i) {
                    b[offset + i] = this.readByte();
                }
            }

            public long getPosition() {
                return ((long)this.nextBuffer + 1L) * (long)ReadWriteDataOutput.access$getBlockSize$p(this.this$0) + (long)this.nextRead;
            }

            public void setPosition(long pos) {
                int bufferIndex = (int)(pos >> ReadWriteDataOutput.access$getBlockBits$p(this.this$0));
                if (this.nextBuffer != bufferIndex - 1) {
                    this.nextBuffer = bufferIndex - 1;
                    List list = ReadWriteDataOutput.access$getByteBuffers$p(this.this$0);
                    Intrinsics.checkNotNull((Object)list);
                    this.current = ((ByteBuffer)list.get(bufferIndex)).array();
                }
                this.nextRead = (int)(pos & (long)ReadWriteDataOutput.access$getBlockMask$p(this.this$0));
                if (!(this.getPosition() == pos)) {
                    boolean bl = false;
                    String string = "pos=" + pos + " getPos()=" + this.getPosition();
                    throw new IllegalArgumentException(string.toString());
                }
            }
        };
    }

    @Override
    public void writeTo(@NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.dataOutput.copyTo(out);
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return FSTReader.super.getChildResources();
    }

    public static final /* synthetic */ List access$getByteBuffers$p(ReadWriteDataOutput $this) {
        return $this.byteBuffers;
    }

    public static final /* synthetic */ int access$getBlockSize$p(ReadWriteDataOutput $this) {
        return $this.blockSize;
    }

    public static final /* synthetic */ int access$getBlockBits$p(ReadWriteDataOutput $this) {
        return $this.blockBits;
    }

    public static final /* synthetic */ int access$getBlockMask$p(ReadWriteDataOutput $this) {
        return $this.blockMask;
    }
}

