/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.analysis.TokenStream;
import org.gnit.lucenekmp.analysis.tokenattributes.PositionIncrementAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.PositionLengthAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.TermToBytesRefAttribute;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.internal.hppc.IntArrayList;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.BitSet;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.AttributeSource;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.FiniteStringsIterator;
import org.gnit.lucenekmp.util.automaton.Operations;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0010\u001a\u00020\u0011J!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/util/graph/GraphTokenStreamFiniteStrings;", "", "in", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "<init>", "(Lorg/gnit/lucenekmp/analysis/TokenStream;)V", "tokens", "", "Lorg/gnit/lucenekmp/util/AttributeSource;", "[Lorg/gnit/lucenekmp/util/AttributeSource;", "det", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "transition", "Lorg/gnit/lucenekmp/util/automaton/Transition;", "hasSidePath", "", "state", "", "getTerms", "", "Lorg/gnit/lucenekmp/index/Term;", "field", "", "(Ljava/lang/String;I)[Lorg/gnit/lucenekmp/index/Term;", "finiteStrings", "", "getFiniteStrings", "()Ljava/util/Iterator;", "startState", "endState", "articulationPoints", "", "build", "FiniteStringsTokenStream", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGraphTokenStreamFiniteStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphTokenStreamFiniteStrings.kt\norg/gnit/lucenekmp/util/graph/GraphTokenStreamFiniteStrings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n*L\n1#1,290:1\n1563#2:291\n1634#2,3:292\n37#3:295\n36#3,3:296\n1#4:299\n207#5,5:300\n180#5,5:305\n212#5:310\n*S KotlinDebug\n*F\n+ 1 GraphTokenStreamFiniteStrings.kt\norg/gnit/lucenekmp/util/graph/GraphTokenStreamFiniteStrings\n*L\n98#1:291\n98#1:292,3\n104#1:295\n104#1:296,3\n214#1:300,5\n214#1:305,5\n214#1:310\n*E\n"})
public final class GraphTokenStreamFiniteStrings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AttributeSource[] tokens;
    @NotNull
    private final Automaton det;
    @NotNull
    private final Transition transition;
    private static final int MAX_RECURSION_LEVEL = 1000;

    public GraphTokenStreamFiniteStrings(@NotNull TokenStream in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.tokens = new AttributeSource[4];
        this.transition = new Transition();
        Automaton aut = this.build(in);
        this.det = Operations.INSTANCE.removeDeadStates(Operations.INSTANCE.determinize(aut, 10000));
    }

    public final boolean hasSidePath(int state2) {
        int numT = this.det.initTransition(state2, this.transition);
        if (numT <= 1) {
            return false;
        }
        this.det.getNextTransition(this.transition);
        int dest = this.transition.getDest();
        for (int i = 1; i < numT; ++i) {
            this.det.getNextTransition(this.transition);
            if (dest == this.transition.getDest()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<AttributeSource> getTerms(int state2) {
        int numT = this.det.initTransition(state2, this.transition);
        List tokens = new ArrayList();
        for (int i = 0; i < numT; ++i) {
            this.det.getNextTransition(this.transition);
            tokens.addAll(ArraysKt.asList((Object[])this.tokens).subList(this.transition.getMin(), this.transition.getMax() + 1));
        }
        return tokens;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Term[] getTerms(@NotNull String field, int state2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Iterable $this$map$iv = this.getTerms(state2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void s;
            AttributeSource attributeSource = (AttributeSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Term(field, ((TermToBytesRefAttribute)s.addAttribute(Reflection.getOrCreateKotlinClass(TermToBytesRefAttribute.class))).getBytesRef()));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Term[0]);
    }

    @NotNull
    public final Iterator<TokenStream> getFiniteStrings() {
        return this.getFiniteStrings(0, -1);
    }

    @NotNull
    public final Iterator<TokenStream> getFiniteStrings(int startState, int endState) {
        FiniteStringsIterator it = new FiniteStringsIterator(this.det, startState, endState);
        return new Iterator<TokenStream>(it, this){
            private IntsRef current;
            private boolean finished;
            final /* synthetic */ FiniteStringsIterator $it;
            final /* synthetic */ GraphTokenStreamFiniteStrings this$0;
            {
                this.$it = $it;
                this.this$0 = $receiver;
            }

            public final IntsRef getCurrent() {
                return this.current;
            }

            public final void setCurrent(IntsRef intsRef) {
                this.current = intsRef;
            }

            public final boolean getFinished() {
                return this.finished;
            }

            public final void setFinished(boolean bl) {
                this.finished = bl;
            }

            public boolean hasNext() {
                if (!this.finished && this.current == null) {
                    this.current = this.$it.next();
                    if (this.current == null) {
                        this.finished = true;
                    }
                }
                return this.current != null;
            }

            public TokenStream next() {
                if (this.current == null) {
                    this.hasNext();
                }
                IntsRef intsRef = this.current;
                Intrinsics.checkNotNull((Object)intsRef);
                TokenStream next = this.this$0.new FiniteStringsTokenStream(intsRef);
                this.current = null;
                return next;
            }

            public void remove() {
                throw new UnsupportedOperationException("remove() is not supported by this iterator");
            }
        };
    }

    @NotNull
    public final int[] articulationPoints() {
        if (this.det.getNumStates() == 0) {
            return new int[0];
        }
        Automaton.Builder undirect = new Automaton.Builder(0, 0, 3, null);
        undirect.copy(this.det);
        int n = this.det.getNumStates();
        for (int i = 0; i < n; ++i) {
            int numT = this.det.initTransition(i, this.transition);
            for (int j = 0; j < numT; ++j) {
                this.det.getNextTransition(this.transition);
                undirect.addTransition(this.transition.getDest(), i, this.transition.getMin());
            }
        }
        int numStates = this.det.getNumStates();
        BitSet visited = new BitSet(numStates);
        int[] depth = new int[this.det.getNumStates()];
        int[] low = new int[this.det.getNumStates()];
        int[] parent = new int[this.det.getNumStates()];
        Arrays.INSTANCE.fill(parent, -1);
        IntArrayList points2 = new IntArrayList();
        GraphTokenStreamFiniteStrings.Companion.articulationPointsRecurse(undirect.finish(), 0, 0, depth, low, parent, visited, points2);
        return points2.reverse().toArray();
    }

    /*
     * WARNING - void declaration
     */
    private final Automaton build(TokenStream in) throws IOException {
        Automaton.Builder builder = new Automaton.Builder(0, 0, 3, null);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)in.addAttribute(Reflection.getOrCreateKotlinClass(PositionIncrementAttribute.class));
        PositionLengthAttribute posLengthAtt = (PositionLengthAttribute)in.addAttribute(Reflection.getOrCreateKotlinClass(PositionLengthAttribute.class));
        in.reset();
        int pos = -1;
        int prevIncr = 1;
        int state2 = -1;
        int id = -1;
        int gap = 0;
        while (in.incrementToken()) {
            int currentIncr = posIncAtt.getPositionIncrement();
            if (!(pos != -1 || currentIncr >= 1)) {
                boolean $i$a$-check-GraphTokenStreamFiniteStrings$build$22 = false;
                String $i$a$-check-GraphTokenStreamFiniteStrings$build$22 = "Malformed TokenStream, start token can't have increment less than 1";
                throw new IllegalStateException($i$a$-check-GraphTokenStreamFiniteStrings$build$22.toString());
            }
            if (currentIncr == 0) {
                if (gap > 0) {
                    pos -= gap;
                }
            } else {
                ++pos;
                gap = currentIncr - 1;
            }
            int endPos = pos + posLengthAtt.getPositionLength() + gap;
            while (state2 < endPos) {
                state2 = builder.createState();
            }
            if (this.tokens.length < ++id + 1) {
                AttributeSource[] attributeSourceArray;
                void array$iv;
                void minSize$iv;
                ArrayUtil.Companion $i$a$-check-GraphTokenStreamFiniteStrings$build$22 = ArrayUtil.Companion;
                AttributeSource[] attributeSourceArray2 = this.tokens;
                int n = id + 1;
                GraphTokenStreamFiniteStrings graphTokenStreamFiniteStrings = this;
                boolean $i$f$grow = false;
                if (minSize$iv < 0) {
                    throw new Exception("size must be positive (got " + (int)minSize$iv + "): likely integer overflow?");
                }
                if (((void)array$iv).length < minSize$iv) {
                    AttributeSource[] newArray$iv$iv;
                    void array$iv$iv;
                    void this_$iv;
                    int newLength$iv = this_$iv.oversize((int)minSize$iv, 4);
                    void var17_19 = this_$iv;
                    void var18_20 = array$iv;
                    int newLength$iv$iv = newLength$iv;
                    boolean $i$f$growExact = false;
                    if (newLength$iv$iv < ((void)array$iv$iv).length) {
                        throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + ((void)array$iv$iv).length + ")");
                    }
                    AttributeSource[] attributeSourceArray3 = new AttributeSource[newLength$iv$iv];
                    for (int i = 0; i < newLength$iv$iv; ++i) {
                        int n2 = i;
                        attributeSourceArray3[n2] = n2 < ((void)array$iv$iv).length ? array$iv$iv[n2] : null;
                    }
                    attributeSourceArray = newArray$iv$iv = attributeSourceArray3;
                } else {
                    attributeSourceArray = array$iv;
                }
                graphTokenStreamFiniteStrings.tokens = attributeSourceArray;
            }
            this.tokens[id] = in.cloneAttributes();
            builder.addTransition(pos, endPos, id);
            pos += gap;
            ((PositionLengthAttribute)this.tokens[id].addAttribute(Reflection.getOrCreateKotlinClass(PositionLengthAttribute.class))).setPositionLength(1);
            if (currentIncr == 0) {
                ((PositionIncrementAttribute)this.tokens[id].addAttribute(Reflection.getOrCreateKotlinClass(PositionIncrementAttribute.class))).setPositionIncrement(prevIncr);
            }
            if (currentIncr <= 0) continue;
            prevIncr = currentIncr;
        }
        in.end();
        if (state2 != -1) {
            builder.setAccept(state2, true);
        }
        return builder.finish();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/util/graph/GraphTokenStreamFiniteStrings$Companion;", "", "<init>", "()V", "MAX_RECURSION_LEVEL", "", "articulationPointsRecurse", "", "a", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "state", "d", "depth", "", "low", "parent", "visited", "Lorg/gnit/lucenekmp/jdkport/BitSet;", "points", "Lorg/gnit/lucenekmp/internal/hppc/IntArrayList;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void articulationPointsRecurse(Automaton a, int state2, int d, int[] depth, int[] low, int[] parent, BitSet visited, IntArrayList points2) {
            visited.set(state2);
            depth[state2] = d;
            low[state2] = d;
            int childCount = 0;
            boolean isArticulation = false;
            Transition t = new Transition();
            int numT = a.initTransition(state2, t);
            for (int i = 0; i < numT; ++i) {
                a.getNextTransition(t);
                if (!visited.get(t.getDest())) {
                    parent[t.getDest()] = state2;
                    if (d >= 1000) {
                        throw new IllegalArgumentException("Exceeded maximum recursion level during graph analysis");
                    }
                    this.articulationPointsRecurse(a, t.getDest(), d + 1, depth, low, parent, visited, points2);
                    ++childCount;
                    if (low[t.getDest()] >= depth[state2]) {
                        isArticulation = true;
                    }
                    low[state2] = Math.min(low[state2], low[t.getDest()]);
                    continue;
                }
                if (t.getDest() == parent[state2]) continue;
                low[state2] = Math.min(low[state2], depth[t.getDest()]);
            }
            if (parent[state2] != -1 && isArticulation || parent[state2] == -1 && childCount > 1) {
                points2.add(state2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/util/graph/GraphTokenStreamFiniteStrings$FiniteStringsTokenStream;", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "ids", "Lorg/gnit/lucenekmp/util/IntsRef;", "<init>", "(Lorg/gnit/lucenekmp/util/graph/GraphTokenStreamFiniteStrings;Lorg/gnit/lucenekmp/util/IntsRef;)V", "end", "", "offset", "incrementToken", "", "core"})
    private final class FiniteStringsTokenStream
    extends TokenStream {
        @NotNull
        private final IntsRef ids;
        private final int end;
        private int offset;

        public FiniteStringsTokenStream(IntsRef ids) {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            super(GraphTokenStreamFiniteStrings.this.tokens[0].cloneAttributes());
            this.ids = ids;
            this.end = this.ids.getOffset() + this.ids.getLength();
            this.offset = this.ids.getOffset();
        }

        @Override
        public boolean incrementToken() throws IOException {
            if (this.offset < this.end) {
                this.clearAttributes();
                int id = this.ids.getInts()[this.offset];
                GraphTokenStreamFiniteStrings.this.tokens[id].copyTo(this);
                int n = this.offset;
                this.offset = n + 1;
                return true;
            }
            return false;
        }
    }
}

