/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.KnnVectorsReader;
import org.gnit.lucenekmp.codecs.hnsw.HnswGraphProvider;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.KnnVectorValues;
import org.gnit.lucenekmp.search.TaskExecutor;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.hnsw.HnswBuilder;
import org.gnit.lucenekmp.util.hnsw.HnswConcurrentMergeBuilder;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.gnit.lucenekmp.util.hnsw.IncrementalHnswGraphMerger;
import org.gnit.lucenekmp.util.hnsw.InitializedHnswGraphBuilder;
import org.gnit.lucenekmp.util.hnsw.OnHeapHnswGraph;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorerSupplier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/ConcurrentHnswMerger;", "Lorg/gnit/lucenekmp/util/hnsw/IncrementalHnswGraphMerger;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "scorerSupplier", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "M", "", "beamWidth", "taskExecutor", "Lorg/gnit/lucenekmp/search/TaskExecutor;", "numWorker", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfo;Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;IILorg/gnit/lucenekmp/search/TaskExecutor;I)V", "createBuilder", "Lorg/gnit/lucenekmp/util/hnsw/HnswBuilder;", "mergedVectorValues", "Lorg/gnit/lucenekmp/index/KnnVectorValues;", "maxOrd", "core"})
public final class ConcurrentHnswMerger
extends IncrementalHnswGraphMerger {
    @NotNull
    private final TaskExecutor taskExecutor;
    private final int numWorker;

    public ConcurrentHnswMerger(@NotNull FieldInfo fieldInfo, @NotNull RandomVectorScorerSupplier scorerSupplier2, int M, int beamWidth, @NotNull TaskExecutor taskExecutor, int numWorker) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        super(fieldInfo, scorerSupplier2, M, beamWidth);
        this.taskExecutor = taskExecutor;
        this.numWorker = numWorker;
    }

    @Override
    @NotNull
    protected HnswBuilder createBuilder(@NotNull KnnVectorValues mergedVectorValues, int maxOrd) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergedVectorValues, (String)"mergedVectorValues");
        OnHeapHnswGraph graph = null;
        BitSet initializedNodes = null;
        if (this.getInitReader() == null) {
            graph = new OnHeapHnswGraph(this.getM(), maxOrd);
        } else {
            HnswGraph initializerGraph;
            KnnVectorsReader knnVectorsReader = this.getInitReader();
            Intrinsics.checkNotNull((Object)knnVectorsReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.hnsw.HnswGraphProvider");
            HnswGraph hnswGraph = initializerGraph = ((HnswGraphProvider)((Object)knnVectorsReader)).getGraph(this.getFieldInfo().getName());
            boolean bl = hnswGraph != null ? hnswGraph.size() == 0 : false;
            if (bl) {
                graph = new OnHeapHnswGraph(this.getM(), maxOrd);
            } else {
                initializedNodes = new FixedBitSet(maxOrd);
                int[] oldToNewOrdinalMap = this.getNewOrdMapping(mergedVectorValues, initializedNodes);
                HnswGraph hnswGraph2 = initializerGraph;
                Intrinsics.checkNotNull((Object)hnswGraph2);
                graph = InitializedHnswGraphBuilder.Companion.initGraph(hnswGraph2, oldToNewOrdinalMap, maxOrd);
            }
        }
        return new HnswConcurrentMergeBuilder(this.taskExecutor, this.numWorker, this.getScorerSupplier(), this.getBeamWidth(), graph, initializedNodes);
    }
}

