/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.knn.KnnSearchStrategy;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.hnsw.HnswBuilder;
import org.gnit.lucenekmp.util.hnsw.HnswGraphSearcher;
import org.gnit.lucenekmp.util.hnsw.HnswLock;
import org.gnit.lucenekmp.util.hnsw.HnswUtil;
import org.gnit.lucenekmp.util.hnsw.Lock;
import org.gnit.lucenekmp.util.hnsw.NeighborArray;
import org.gnit.lucenekmp.util.hnsw.NeighborQueue;
import org.gnit.lucenekmp.util.hnsw.OnHeapHnswGraph;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorer;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorerSupplier;
import org.gnit.lucenekmp.util.hnsw.UpdateableRandomVectorScorer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 J2\u00020\u0001:\u0002IJB;\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB1\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000e\u0010\u0012B)\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u0013J\u0010\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0005H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0004J\u0010\u0010-\u001a\u00020(2\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0018\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0016J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u0005H\u0016J \u00103\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007H\u0002J(\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00108\u001a\u0002092\u0006\u00101\u001a\u000202H\u0002J(\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u0002092\u0006\u00108\u001a\u0002092\u0006\u0010=\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0002J \u0010>\u001a\u00020$2\u0006\u0010?\u001a\u00020@2\u0006\u0010<\u001a\u0002092\u0006\u00101\u001a\u00020AH\u0002J\u0006\u0010B\u001a\u00020(J\b\u0010C\u001a\u00020(H\u0002J\u0010\u0010C\u001a\u00020$2\u0006\u00107\u001a\u00020\u0005H\u0002J0\u0010D\u001a\u00020(2\u0006\u00107\u001a\u00020\u00052\u0006\u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u00052\u0006\u0010?\u001a\u00020@2\u0006\u0010G\u001a\u00020HH\u0002R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001eR\u0014\u0010+\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001e\u00a8\u0006K"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder;", "Lorg/gnit/lucenekmp/util/hnsw/HnswBuilder;", "scorerSupplier", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "beamWidth", "", "seed", "", "hnsw", "Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "hnswLock", "Lorg/gnit/lucenekmp/util/hnsw/HnswLock;", "graphSearcher", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphSearcher;", "<init>", "(Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;IJLorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;Lorg/gnit/lucenekmp/util/hnsw/HnswLock;Lorg/gnit/lucenekmp/util/hnsw/HnswGraphSearcher;)V", "M", "graphSize", "(Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;IIJI)V", "(Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;IJLorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;)V", "ml", "", "random", "Lkotlin/random/Random;", "getScorerSupplier", "()Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "entryCandidates", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder$GraphBuilderKnnCollector;", "beamCandidates", "getHnsw", "()Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "getHnswLock", "()Lorg/gnit/lucenekmp/util/hnsw/HnswLock;", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "frozen", "", "build", "maxOrd", "setInfoStream", "", "completedGraph", "getCompletedGraph", "graph", "getGraph", "addVectors", "minOrd", "addGraphNode", "node", "scorer", "Lorg/gnit/lucenekmp/util/hnsw/UpdateableRandomVectorScorer;", "printGraphBuildStatus", "start", "t", "addDiverseNeighbors", "level", "candidates", "Lorg/gnit/lucenekmp/util/hnsw/NeighborArray;", "selectAndLinkDiverse", "", "neighbors", "maxConnOnLevel", "diversityCheck", "score", "", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorer;", "finish", "connectComponents", "link", "n0", "n1", "notFullyConnected", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "GraphBuilderKnnCollector", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nHnswGraphBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HnswGraphBuilder.kt\norg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,605:1\n1#2:606\n1969#3,14:607\n*S KotlinDebug\n*F\n+ 1 HnswGraphBuilder.kt\norg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder\n*L\n396#1:607,14\n*E\n"})
public class HnswGraphBuilder
implements HnswBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int M;
    private final double ml;
    @NotNull
    private final Random random;
    @NotNull
    private final RandomVectorScorerSupplier scorerSupplier;
    @NotNull
    private final HnswGraphSearcher graphSearcher;
    @NotNull
    private final GraphBuilderKnnCollector entryCandidates;
    @NotNull
    private final GraphBuilderKnnCollector beamCandidates;
    @NotNull
    private final OnHeapHnswGraph hnsw;
    @Nullable
    private final HnswLock hnswLock;
    @NotNull
    private InfoStream infoStream;
    private boolean frozen;
    public static final int DEFAULT_MAX_CONN = 16;
    public static final int DEFAULT_BEAM_WIDTH = 100;
    private static final long DEFAULT_RAND_SEED = 42L;
    @NotNull
    public static final String HNSW_COMPONENT = "HNSW";
    private static long randSeed = 42L;

    protected HnswGraphBuilder(@NotNull RandomVectorScorerSupplier scorerSupplier2, int beamWidth, long seed, @NotNull OnHeapHnswGraph hnsw, @Nullable HnswLock hnswLock, @NotNull HnswGraphSearcher graphSearcher) {
        Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
        Intrinsics.checkNotNullParameter((Object)hnsw, (String)"hnsw");
        Intrinsics.checkNotNullParameter((Object)graphSearcher, (String)"graphSearcher");
        this.infoStream = InfoStream.Companion.getDefault();
        if (!(hnsw.maxConn() > 0)) {
            boolean $i$a$-require-HnswGraphBuilder$32 = false;
            String $i$a$-require-HnswGraphBuilder$32 = "M (max connections) must be positive";
            throw new IllegalArgumentException($i$a$-require-HnswGraphBuilder$32.toString());
        }
        if (!(beamWidth > 0)) {
            boolean bl = false;
            String string = "beamWidth must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        this.M = hnsw.maxConn();
        this.scorerSupplier = scorerSupplier2;
        this.ml = this.M == 1 ? 1.0 : 1.0 / Math.log(1.0 * (double)this.M);
        this.random = RandomKt.Random((long)seed);
        this.hnsw = hnsw;
        this.hnswLock = hnswLock;
        this.graphSearcher = graphSearcher;
        this.entryCandidates = new GraphBuilderKnnCollector(1);
        this.beamCandidates = new GraphBuilderKnnCollector(beamWidth);
    }

    @NotNull
    protected final RandomVectorScorerSupplier getScorerSupplier() {
        return this.scorerSupplier;
    }

    @NotNull
    protected final OnHeapHnswGraph getHnsw() {
        return this.hnsw;
    }

    @Nullable
    protected final HnswLock getHnswLock() {
        return this.hnswLock;
    }

    protected HnswGraphBuilder(@NotNull RandomVectorScorerSupplier scorerSupplier2, int M, int beamWidth, long seed, int graphSize) {
        Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
        this(scorerSupplier2, beamWidth, seed, new OnHeapHnswGraph(M, graphSize));
    }

    protected HnswGraphBuilder(@NotNull RandomVectorScorerSupplier scorerSupplier2, int beamWidth, long seed, @NotNull OnHeapHnswGraph hnsw) {
        Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
        Intrinsics.checkNotNullParameter((Object)hnsw, (String)"hnsw");
        this(scorerSupplier2, beamWidth, seed, hnsw, null, new HnswGraphSearcher(new NeighborQueue(beamWidth, true), new FixedBitSet(hnsw.size())));
    }

    @Override
    @NotNull
    public OnHeapHnswGraph build(int maxOrd) throws IOException {
        if (!(!this.frozen)) {
            boolean bl = false;
            String string = "This HnswGraphBuilder is frozen and cannot be updated";
            throw new IllegalStateException(string.toString());
        }
        if (this.infoStream.isEnabled(HNSW_COMPONENT)) {
            this.infoStream.message(HNSW_COMPONENT, "build graph from " + maxOrd + " vectors");
        }
        this.addVectors(maxOrd);
        return this.getCompletedGraph();
    }

    @Override
    public void setInfoStream(@NotNull InfoStream infoStream) {
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        this.infoStream = infoStream;
    }

    @Override
    @NotNull
    public OnHeapHnswGraph getCompletedGraph() {
        if (!this.frozen) {
            this.finish();
        }
        return this.getGraph();
    }

    @Override
    @NotNull
    public OnHeapHnswGraph getGraph() {
        return this.hnsw;
    }

    protected final void addVectors(int minOrd, int maxOrd) throws IOException {
        long start;
        if (!(!this.frozen)) {
            boolean bl = false;
            String string = "This HnswGraphBuilder is frozen and cannot be updated";
            throw new IllegalStateException(string.toString());
        }
        long t = start = Clock.System.INSTANCE.now().toEpochMilliseconds();
        if (this.infoStream.isEnabled(HNSW_COMPONENT)) {
            this.infoStream.message(HNSW_COMPONENT, "addVectors [" + minOrd + " " + maxOrd + ")");
        }
        UpdateableRandomVectorScorer scorer2 = this.scorerSupplier.scorer();
        for (int node = minOrd; node < maxOrd; ++node) {
            scorer2.setScoringOrdinal(node);
            this.addGraphNode(node, scorer2);
            if (node % 10000 != 0 || !this.infoStream.isEnabled(HNSW_COMPONENT)) continue;
            t = this.printGraphBuildStatus(node, start, t);
        }
    }

    private final void addVectors(int maxOrd) throws IOException {
        this.addVectors(0, maxOrd);
    }

    public void addGraphNode(int node, @NotNull UpdateableRandomVectorScorer scorer2) throws IOException {
        int nodeLevel;
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        if (!(!this.frozen)) {
            boolean $i$a$-check-HnswGraphBuilder$addGraphNode$32 = false;
            String $i$a$-check-HnswGraphBuilder$addGraphNode$32 = "Graph builder is already frozen";
            throw new IllegalStateException($i$a$-check-HnswGraphBuilder$addGraphNode$32.toString());
        }
        for (int level = nodeLevel = HnswGraphBuilder.Companion.getRandomGraphLevel(this.ml, this.random); -1 < level; --level) {
            this.hnsw.addNode(level, node);
        }
        if (this.hnsw.trySetNewEntryNode(node, nodeLevel)) {
            return;
        }
        int lowestUnsetLevel = 0;
        int curMaxLevel = 0;
        do {
            int i3;
            curMaxLevel = this.hnsw.numLevels() - 1;
            int[] nArray = new int[]{this.hnsw.entryNode()};
            int[] eps = nArray;
            GraphBuilderKnnCollector candidates = this.entryCandidates;
            int n = nodeLevel + 1;
            int level = curMaxLevel;
            if (n <= level) {
                while (true) {
                    candidates.clear();
                    this.graphSearcher.searchLevel(candidates, scorer2, level, eps, this.hnsw, null);
                    eps[0] = candidates.popNode();
                    if (level == n) break;
                    --level;
                }
            }
            candidates = this.beamCandidates;
            NeighborArray[] scratchPerLevel = new NeighborArray[Math.min(nodeLevel, curMaxLevel) - lowestUnsetLevel + 1];
            n = scratchPerLevel.length + -1;
            if (0 <= n) {
                do {
                    i3 = n--;
                    int level2 = i3 + lowestUnsetLevel;
                    candidates.clear();
                    this.graphSearcher.searchLevel(candidates, scorer2, level2, eps, this.hnsw, null);
                    eps = candidates.popUntilNearestKNodes();
                    scratchPerLevel[i3] = new NeighborArray(Math.max(this.beamCandidates.k(), this.M + 1), false);
                    NeighborArray neighborArray = scratchPerLevel[i3];
                    Intrinsics.checkNotNull((Object)neighborArray);
                    HnswGraphBuilder.Companion.popToScratch(candidates, neighborArray);
                } while (0 <= n);
            }
            i3 = scratchPerLevel.length;
            for (int i2 = 0; i2 < i3; ++i2) {
                NeighborArray neighborArray = scratchPerLevel[i2];
                Intrinsics.checkNotNull((Object)neighborArray);
                this.addDiverseNeighbors(i2 + lowestUnsetLevel, node, neighborArray, scorer2);
            }
            if (!((lowestUnsetLevel += scratchPerLevel.length) == Math.min(nodeLevel, curMaxLevel) + 1)) {
                String i3 = "Failed requirement.";
                throw new IllegalArgumentException(i3.toString());
            }
            if (lowestUnsetLevel > nodeLevel) {
                return;
            }
            if (!(lowestUnsetLevel == curMaxLevel + 1 && nodeLevel > curMaxLevel)) {
                String i3 = "Failed requirement.";
                throw new IllegalArgumentException(i3.toString());
            }
            if (!this.hnsw.tryPromoteNewEntryNode(node, nodeLevel, curMaxLevel)) continue;
            return;
        } while (this.hnsw.numLevels() != curMaxLevel + 1);
        boolean bl = false;
        String string = "We're not able to promote node " + node + " at level " + nodeLevel + " as entry node. But the max graph level " + curMaxLevel + " has not changed while we are inserting the node.";
        throw new IllegalStateException(string.toString());
    }

    @Override
    public void addGraphNode(int node) throws IOException {
        UpdateableRandomVectorScorer scorer2 = this.scorerSupplier.scorer();
        scorer2.setScoringOrdinal(node);
        this.addGraphNode(node, scorer2);
    }

    private final long printGraphBuildStatus(int node, long start, long t) {
        long now = Clock.System.INSTANCE.now().toEpochMilliseconds();
        this.infoStream.message(HNSW_COMPONENT, "built " + node + " in " + (now - t) + " ms/" + (now - start) + " ms");
        return now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addDiverseNeighbors(int level, int node, NeighborArray candidates, UpdateableRandomVectorScorer scorer2) throws IOException {
        NeighborArray neighbors = this.hnsw.getNeighbors(level, node);
        if (!(neighbors.size() == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int maxConnOnLevel = level == 0 ? this.M * 2 : this.M;
        boolean[] mask = this.selectAndLinkDiverse(neighbors, candidates, maxConnOnLevel, scorer2);
        int n = candidates.size();
        for (int i = 0; i < n; ++i) {
            if (!mask[i]) continue;
            int nbr = candidates.nodes()[i];
            if (this.hnswLock != null) {
                Lock lock2 = this.hnswLock.write(level, nbr);
                try {
                    NeighborArray nbrsOfNbr = this.getGraph().getNeighbors(level, nbr);
                    nbrsOfNbr.addAndEnsureDiversity(node, candidates.scores()[i], nbr, scorer2);
                    continue;
                }
                finally {
                    lock2.unlock();
                }
            }
            NeighborArray nbrsOfNbr = this.hnsw.getNeighbors(level, nbr);
            nbrsOfNbr.addAndEnsureDiversity(node, candidates.scores()[i], nbr, scorer2);
        }
    }

    private final boolean[] selectAndLinkDiverse(NeighborArray neighbors, NeighborArray candidates, int maxConnOnLevel, UpdateableRandomVectorScorer scorer2) throws IOException {
        boolean[] mask = new boolean[candidates.size()];
        for (int i = candidates.size() - 1; neighbors.size() < maxConnOnLevel && i >= 0; --i) {
            int cNode = candidates.nodes()[i];
            float cScore = candidates.scores()[i];
            if (!(cNode <= this.hnsw.maxNodeId())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            scorer2.setScoringOrdinal(cNode);
            if (!this.diversityCheck(cScore, neighbors, scorer2)) continue;
            mask[i] = true;
            neighbors.addInOrder(cNode, cScore);
        }
        return mask;
    }

    private final boolean diversityCheck(float score2, NeighborArray neighbors, RandomVectorScorer scorer2) throws IOException {
        int n = neighbors.size();
        for (int i = 0; i < n; ++i) {
            float neighborSimilarity = scorer2.score(neighbors.nodes()[i]);
            if (!(neighborSimilarity >= score2)) continue;
            return false;
        }
        return true;
    }

    public final void finish() throws IOException {
        this.connectComponents();
        this.frozen = true;
    }

    private final void connectComponents() throws IOException {
        long start = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        int n = this.hnsw.numLevels();
        for (int level = 0; level < n; ++level) {
            if (this.connectComponents(level) || !this.infoStream.isEnabled(HNSW_COMPONENT)) continue;
            this.infoStream.message(HNSW_COMPONENT, "connectComponents failed on level " + level);
        }
        if (this.infoStream.isEnabled(HNSW_COMPONENT)) {
            this.infoStream.message(HNSW_COMPONENT, "connectComponents " + Duration.getInWholeMilliseconds-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)start)) + " ms");
        }
    }

    private final boolean connectComponents(int level) throws IOException {
        FixedBitSet notFullyConnected = new FixedBitSet(this.hnsw.size());
        int maxConn = this.M;
        if (level == 0) {
            maxConn *= 2;
        }
        List<HnswUtil.Component> components = HnswUtil.INSTANCE.components(this.hnsw, level, notFullyConnected, maxConn);
        if (this.infoStream.isEnabled(HNSW_COMPONENT)) {
            this.infoStream.message(HNSW_COMPONENT, "connect " + components.size() + " components on level=" + level);
        }
        boolean result = true;
        if (components.size() > 1) {
            Object t;
            Iterable $this$maxBy$iv = components;
            boolean $i$f$maxByOrThrow = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = maxElem$iv;
            } else {
                HnswUtil.Component it = (HnswUtil.Component)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getSize();
                do {
                    Object e$iv = iterator$iv.next();
                    HnswUtil.Component it2 = (HnswUtil.Component)e$iv;
                    $i$a$-maxByOrThrow-HnswGraphBuilder$connectComponents$c0$1 = false;
                    int v$iv = it2.getSize();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = maxElem$iv;
            }
            HnswUtil.Component c0 = (HnswUtil.Component)t;
            if (c0.getStart() == Integer.MAX_VALUE) {
                return false;
            }
            GraphBuilderKnnCollector beam = new GraphBuilderKnnCollector(2);
            int[] eps = new int[1];
            UpdateableRandomVectorScorer scorer2 = this.scorerSupplier.scorer();
            for (HnswUtil.Component c : components) {
                if (c == c0 || c.getStart() == Integer.MAX_VALUE) continue;
                if (this.infoStream.isEnabled(HNSW_COMPONENT)) {
                    this.infoStream.message(HNSW_COMPONENT, "connect component " + c + " to " + c0);
                }
                beam.clear();
                eps[0] = c0.getStart();
                scorer2.setScoringOrdinal(c.getStart());
                this.graphSearcher.searchLevel(beam, scorer2, level, eps, this.hnsw, notFullyConnected);
                boolean linked = false;
                while (beam.size() > 0) {
                    int c0node = beam.popNode();
                    if (c0node == c.getStart() || !notFullyConnected.get(c0node)) continue;
                    float score2 = beam.minimumScore();
                    if (!notFullyConnected.get(c0node)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.link(level, c0node, c.getStart(), score2, notFullyConnected);
                    linked = true;
                    if (!this.infoStream.isEnabled(HNSW_COMPONENT)) continue;
                    this.infoStream.message(HNSW_COMPONENT, "connected ok " + c0node + " -> " + c.getStart());
                }
                if (linked) continue;
                if (this.infoStream.isEnabled(HNSW_COMPONENT)) {
                    this.infoStream.message(HNSW_COMPONENT, "not connected; no free nodes found");
                }
                result = false;
            }
        }
        return result;
    }

    private final void link(int level, int n0, int n1, float score2, FixedBitSet notFullyConnected) {
        NeighborArray nbr0 = this.hnsw.getNeighbors(level, n0);
        NeighborArray nbr1 = this.hnsw.getNeighbors(level, n1);
        int maxConn = nbr0.nodes().length - 1;
        if (!notFullyConnected.get(n0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(nbr0.size() < maxConn)) {
            boolean bl = false;
            String string = "node " + n0 + " is full, has " + nbr0.size() + " friends";
            throw new IllegalArgumentException(string.toString());
        }
        nbr0.addOutOfOrder(n1, score2);
        if (nbr0.size() == maxConn) {
            notFullyConnected.clear(n0);
        }
        if (nbr1.size() < maxConn) {
            nbr1.addOutOfOrder(n0, score2);
            if (nbr1.size() == maxConn) {
                notFullyConnected.clear(n1);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\bJ.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0005J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder$Companion;", "", "<init>", "()V", "DEFAULT_MAX_CONN", "", "DEFAULT_BEAM_WIDTH", "DEFAULT_RAND_SEED", "", "HNSW_COMPONENT", "", "randSeed", "getRandSeed", "()J", "setRandSeed", "(J)V", "create", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder;", "scorerSupplier", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "M", "beamWidth", "seed", "graphSize", "popToScratch", "", "candidates", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder$GraphBuilderKnnCollector;", "scratch", "Lorg/gnit/lucenekmp/util/hnsw/NeighborArray;", "getRandomGraphLevel", "ml", "", "random", "Lkotlin/random/Random;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final long getRandSeed() {
            return randSeed;
        }

        public final void setRandSeed(long l) {
            randSeed = l;
        }

        @NotNull
        public final HnswGraphBuilder create(@NotNull RandomVectorScorerSupplier scorerSupplier2, int M, int beamWidth, long seed) throws IOException {
            Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
            return new HnswGraphBuilder(scorerSupplier2, M, beamWidth, seed, -1);
        }

        @NotNull
        public final HnswGraphBuilder create(@NotNull RandomVectorScorerSupplier scorerSupplier2, int M, int beamWidth, long seed, int graphSize) throws IOException {
            Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
            return new HnswGraphBuilder(scorerSupplier2, M, beamWidth, seed, graphSize);
        }

        private final void popToScratch(GraphBuilderKnnCollector candidates, NeighborArray scratch) {
            scratch.clear();
            int candidateCount = candidates.size();
            for (int i = 0; i < candidateCount; ++i) {
                float maxSimilarity = candidates.minimumScore();
                scratch.addInOrder(candidates.popNode(), maxSimilarity);
            }
        }

        private final int getRandomGraphLevel(double ml, Random random) {
            double randDouble = 0.0;
            while ((randDouble = random.nextDouble()) == 0.0) {
            }
            return (int)(-Math.log(randDouble) * ml);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder$GraphBuilderKnnCollector;", "Lorg/gnit/lucenekmp/search/KnnCollector;", "k", "", "<init>", "(I)V", "queue", "Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;", "visitedCount", "", "size", "popNode", "popUntilNearestKNodes", "", "minimumScore", "", "clear", "", "earlyTerminated", "", "incVisitedCount", "count", "visitLimit", "collect", "docId", "similarity", "minCompetitiveSimilarity", "topDocs", "Lorg/gnit/lucenekmp/search/TopDocs;", "searchStrategy", "Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "getSearchStrategy", "()Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "core"})
    public static final class GraphBuilderKnnCollector
    implements KnnCollector {
        @NotNull
        private final NeighborQueue queue;
        private final int k;
        private long visitedCount;

        public GraphBuilderKnnCollector(int k) {
            this.queue = new NeighborQueue(k, false);
            this.k = k;
        }

        public final int size() {
            return this.queue.size();
        }

        public final int popNode() {
            return this.queue.pop();
        }

        @NotNull
        public final int[] popUntilNearestKNodes() {
            while (this.size() > this.k()) {
                this.queue.pop();
            }
            return this.queue.nodes();
        }

        public final float minimumScore() {
            return this.queue.topScore();
        }

        public final void clear() {
            this.queue.clear();
            this.visitedCount = 0L;
        }

        @Override
        public boolean earlyTerminated() {
            return false;
        }

        @Override
        public void incVisitedCount(int count) {
            this.visitedCount += (long)count;
        }

        @Override
        public long visitedCount() {
            return this.visitedCount;
        }

        @Override
        public long visitLimit() {
            return Long.MAX_VALUE;
        }

        @Override
        public int k() {
            return this.k;
        }

        @Override
        public boolean collect(int docId, float similarity) {
            return this.queue.insertWithOverflow(docId, similarity);
        }

        @Override
        public float minCompetitiveSimilarity() {
            return this.queue.size() >= this.k() ? this.queue.topScore() : Float.NEGATIVE_INFINITY;
        }

        @Override
        @NotNull
        public TopDocs topDocs() {
            throw new IllegalArgumentException();
        }

        @Override
        @NotNull
        public KnnSearchStrategy getSearchStrategy() {
            throw new IllegalArgumentException("Should not use unique strategy during graph building");
        }
    }
}

