/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.search.TopKnnCollector;
import org.gnit.lucenekmp.search.knn.KnnSearchStrategy;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.SparseFixedBitSet;
import org.gnit.lucenekmp.util.hnsw.AbstractHnswGraphSearcher;
import org.gnit.lucenekmp.util.hnsw.FilteredHnswGraphSearcher;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.gnit.lucenekmp.util.hnsw.HnswGraphBuilder;
import org.gnit.lucenekmp.util.hnsw.NeighborArray;
import org.gnit.lucenekmp.util.hnsw.NeighborQueue;
import org.gnit.lucenekmp.util.hnsw.OnHeapHnswGraph;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorer;
import org.gnit.lucenekmp.util.hnsw.SeededHnswGraphSearcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 &2\u00020\u0001:\u0002%&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J:\u0010\u000e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0013H\u0002J \u0010\"\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0013H\u0016J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswGraphSearcher;", "Lorg/gnit/lucenekmp/util/hnsw/AbstractHnswGraphSearcher;", "candidates", "Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;", "visited", "Lorg/gnit/lucenekmp/util/BitSet;", "<init>", "(Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;Lorg/gnit/lucenekmp/util/BitSet;)V", "getCandidates", "()Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;", "getVisited", "()Lorg/gnit/lucenekmp/util/BitSet;", "setVisited", "(Lorg/gnit/lucenekmp/util/BitSet;)V", "searchLevel", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder$GraphBuilderKnnCollector;", "scorer", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorer;", "topK", "", "level", "eps", "", "graph", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "findBestEntryPoint", "collector", "Lorg/gnit/lucenekmp/search/KnnCollector;", "", "results", "acceptOrds", "Lorg/gnit/lucenekmp/util/Bits;", "prepareScratchState", "capacity", "graphSeek", "targetNode", "graphNextNeighbor", "OnHeapHnswGraphSearcher", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nHnswGraphSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HnswGraphSearcher.kt\norg/gnit/lucenekmp/util/hnsw/HnswGraphSearcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,359:1\n1#2:360\n*E\n"})
public class HnswGraphSearcher
extends AbstractHnswGraphSearcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NeighborQueue candidates;
    @NotNull
    private BitSet visited;

    public HnswGraphSearcher(@NotNull NeighborQueue candidates, @NotNull BitSet visited) {
        Intrinsics.checkNotNullParameter((Object)candidates, (String)"candidates");
        Intrinsics.checkNotNullParameter((Object)visited, (String)"visited");
        this.candidates = candidates;
        this.visited = visited;
    }

    @NotNull
    protected final NeighborQueue getCandidates() {
        return this.candidates;
    }

    @NotNull
    protected final BitSet getVisited() {
        return this.visited;
    }

    protected final void setVisited(@NotNull BitSet bitSet) {
        Intrinsics.checkNotNullParameter((Object)bitSet, (String)"<set-?>");
        this.visited = bitSet;
    }

    @NotNull
    public final HnswGraphBuilder.GraphBuilderKnnCollector searchLevel(@NotNull RandomVectorScorer scorer2, int topK, int level, @NotNull int[] eps, @NotNull HnswGraph graph) throws IOException {
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        Intrinsics.checkNotNullParameter((Object)eps, (String)"eps");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        HnswGraphBuilder.GraphBuilderKnnCollector results2 = new HnswGraphBuilder.GraphBuilderKnnCollector(topK);
        this.searchLevel(results2, scorer2, level, eps, graph, null);
        return results2;
    }

    @Override
    @NotNull
    public int[] findBestEntryPoint(@NotNull RandomVectorScorer scorer2, @NotNull HnswGraph graph, @NotNull KnnCollector collector2) throws IOException {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        int currentEp = graph.entryNode();
        if (currentEp == -1 || graph.numLevels() == 1) {
            int[] nArray2 = new int[]{currentEp};
            return nArray2;
        }
        int size2 = Companion.getGraphSize(graph);
        this.prepareScratchState(size2);
        float currentScore = scorer2.score(currentEp);
        collector2.incVisitedCount(1);
        boolean foundBetter = false;
        for (int level = graph.numLevels() - 1; 0 < level; --level) {
            foundBetter = true;
            this.visited.set(currentEp);
            block1: while (foundBetter) {
                foundBetter = false;
                this.graphSeek(graph, level, currentEp);
                int friendOrd = 0;
                while (true) {
                    int n;
                    int it = n = this.graphNextNeighbor(graph);
                    boolean bl = false;
                    friendOrd = it;
                    if (n == Integer.MAX_VALUE) continue block1;
                    if (!(friendOrd < size2)) {
                        boolean bl2 = false;
                        String string = "friendOrd=" + friendOrd + "; size=" + size2;
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (this.visited.getAndSet(friendOrd)) continue;
                    if (collector2.earlyTerminated()) {
                        int[] nArray3 = new int[]{AbstractHnswGraphSearcher.Companion.getUNK_EP()};
                        return nArray3;
                    }
                    float friendSimilarity = scorer2.score(friendOrd);
                    collector2.incVisitedCount(1);
                    if (!(friendSimilarity > currentScore)) continue;
                    currentScore = friendSimilarity;
                    currentEp = friendOrd;
                    foundBetter = true;
                }
            }
        }
        if (collector2.earlyTerminated()) {
            int[] nArray4 = new int[]{AbstractHnswGraphSearcher.Companion.getUNK_EP()};
            nArray = nArray4;
        } else {
            int[] nArray5 = new int[]{currentEp};
            nArray = nArray5;
        }
        return nArray;
    }

    @Override
    public void searchLevel(@NotNull KnnCollector results2, @NotNull RandomVectorScorer scorer2, int level, @NotNull int[] eps, @NotNull HnswGraph graph, @Nullable Bits acceptOrds) throws IOException {
        float topCandidateSimilarity;
        Intrinsics.checkNotNullParameter((Object)results2, (String)"results");
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        Intrinsics.checkNotNullParameter((Object)eps, (String)"eps");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        int size2 = Companion.getGraphSize(graph);
        this.prepareScratchState(size2);
        for (int ep : eps) {
            if (this.visited.getAndSet(ep)) continue;
            if (results2.earlyTerminated()) break;
            float score2 = scorer2.score(ep);
            results2.incVisitedCount(1);
            this.candidates.add(ep, score2);
            if (acceptOrds != null && !acceptOrds.get(ep)) continue;
            results2.collect(ep, score2);
        }
        float minAcceptedSimilarity = Math.INSTANCE.nextUp(results2.minCompetitiveSimilarity());
        block1: while (this.candidates.size() > 0 && !results2.earlyTerminated() && !((topCandidateSimilarity = this.candidates.topScore()) < minAcceptedSimilarity)) {
            int topCandidateNode = this.candidates.pop();
            this.graphSeek(graph, level, topCandidateNode);
            int friendOrd = 0;
            while (true) {
                int n;
                int it = n = this.graphNextNeighbor(graph);
                boolean bl = false;
                friendOrd = it;
                if (n == Integer.MAX_VALUE) continue block1;
                if (!(friendOrd < size2)) {
                    boolean bl2 = false;
                    String string = "friendOrd=" + friendOrd + "; size=" + size2;
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.visited.getAndSet(friendOrd)) continue;
                if (results2.earlyTerminated()) continue block1;
                float friendSimilarity = scorer2.score(friendOrd);
                results2.incVisitedCount(1);
                if (!(friendSimilarity >= minAcceptedSimilarity)) continue;
                this.candidates.add(friendOrd, friendSimilarity);
                if (acceptOrds != null && !acceptOrds.get(friendOrd) || !results2.collect(friendOrd, friendSimilarity)) continue;
                minAcceptedSimilarity = Math.INSTANCE.nextUp(results2.minCompetitiveSimilarity());
            }
        }
    }

    private final void prepareScratchState(int capacity) {
        this.candidates.clear();
        if (this.visited.length() < capacity) {
            BitSet bitSet = this.visited;
            Intrinsics.checkNotNull((Object)bitSet, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.FixedBitSet");
            this.visited = FixedBitSet.Companion.ensureCapacity((FixedBitSet)bitSet, capacity);
        }
        this.visited.clear();
    }

    public void graphSeek(@NotNull HnswGraph graph, int level, int targetNode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        graph.seek(level, targetNode);
    }

    public int graphNextNeighbor(@NotNull HnswGraph graph) throws IOException {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        return graph.nextNeighbor();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ.\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswGraphSearcher$Companion;", "", "<init>", "()V", "search", "", "scorer", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorer;", "knnCollector", "Lorg/gnit/lucenekmp/search/KnnCollector;", "graph", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "acceptOrds", "Lorg/gnit/lucenekmp/util/Bits;", "filteredDocCount", "", "topK", "Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "visitedLimit", "getGraphSize", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final void search(@NotNull RandomVectorScorer scorer2, @NotNull KnnCollector knnCollector, @NotNull HnswGraph graph, @NotNull Bits acceptOrds) throws IOException {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            Intrinsics.checkNotNullParameter((Object)knnCollector, (String)"knnCollector");
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            Intrinsics.checkNotNullParameter((Object)acceptOrds, (String)"acceptOrds");
            int filteredDocCount = 0;
            if (acceptOrds instanceof BitSet) {
                filteredDocCount = java.lang.Math.min(((BitSet)acceptOrds).approximateCardinality(), graph.size());
            }
            this.search(scorer2, knnCollector, graph, acceptOrds, filteredDocCount);
        }

        public final void search(@NotNull RandomVectorScorer scorer2, @NotNull KnnCollector knnCollector, @NotNull HnswGraph graph, @Nullable Bits acceptOrds, int filteredDocCount) throws IOException {
            KnnSearchStrategy originalStrategy;
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            Intrinsics.checkNotNullParameter((Object)knnCollector, (String)"knnCollector");
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            if (!(filteredDocCount >= 0 && filteredDocCount <= graph.size())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            KnnSearchStrategy.Hnsw hnswStrategy = null;
            KnnSearchStrategy searchStrategy = knnCollector.getSearchStrategy();
            KnnSearchStrategy.Hnsw hnsw = searchStrategy instanceof KnnSearchStrategy.Hnsw ? (KnnSearchStrategy.Hnsw)searchStrategy : (searchStrategy instanceof KnnSearchStrategy.Seeded ? ((originalStrategy = ((KnnSearchStrategy.Seeded)searchStrategy).originalStrategy()) instanceof KnnSearchStrategy.Hnsw ? (KnnSearchStrategy.Hnsw)originalStrategy : KnnSearchStrategy.Hnsw.Companion.getDEFAULT()) : KnnSearchStrategy.Hnsw.Companion.getDEFAULT());
            hnswStrategy = hnsw;
            HnswGraphSearcher innerSearcher = acceptOrds != null && graph.maxConn() != -1 && filteredDocCount > 0 && hnswStrategy.useFilteredSearch((float)filteredDocCount / (float)graph.size()) ? (HnswGraphSearcher)FilteredHnswGraphSearcher.Companion.create(knnCollector.k(), graph, filteredDocCount, acceptOrds) : new HnswGraphSearcher(new NeighborQueue(knnCollector.k(), true), new SparseFixedBitSet(this.getGraphSize(graph)));
            AbstractHnswGraphSearcher graphSearcher = searchStrategy instanceof KnnSearchStrategy.Seeded && ((KnnSearchStrategy.Seeded)searchStrategy).numberOfEntryPoints() > 0 ? (AbstractHnswGraphSearcher)SeededHnswGraphSearcher.Companion.fromEntryPoints(innerSearcher, ((KnnSearchStrategy.Seeded)searchStrategy).numberOfEntryPoints(), ((KnnSearchStrategy.Seeded)searchStrategy).entryPoints(), graph.size()) : (AbstractHnswGraphSearcher)innerSearcher;
            graphSearcher.search(knnCollector, scorer2, graph, acceptOrds);
        }

        @NotNull
        public final KnnCollector search(@NotNull RandomVectorScorer scorer2, int topK, @NotNull OnHeapHnswGraph graph, @NotNull Bits acceptOrds, int visitedLimit) throws IOException {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            Intrinsics.checkNotNullParameter((Object)acceptOrds, (String)"acceptOrds");
            KnnCollector knnCollector = new TopKnnCollector(topK, visitedLimit, null);
            OnHeapHnswGraphSearcher graphSearcher = new OnHeapHnswGraphSearcher(new NeighborQueue(topK, true), new SparseFixedBitSet(this.getGraphSize(graph)));
            graphSearcher.search(knnCollector, scorer2, graph, acceptOrds);
            return knnCollector;
        }

        public final int getGraphSize(@NotNull HnswGraph graph) {
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            return graph.maxNodeId() + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswGraphSearcher$OnHeapHnswGraphSearcher;", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphSearcher;", "candidates", "Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;", "visited", "Lorg/gnit/lucenekmp/util/BitSet;", "<init>", "(Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;Lorg/gnit/lucenekmp/util/BitSet;)V", "cur", "Lorg/gnit/lucenekmp/util/hnsw/NeighborArray;", "upto", "", "graphSeek", "", "graph", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "level", "targetNode", "graphNextNeighbor", "core"})
    private static final class OnHeapHnswGraphSearcher
    extends HnswGraphSearcher {
        @Nullable
        private NeighborArray cur;
        private int upto;

        public OnHeapHnswGraphSearcher(@NotNull NeighborQueue candidates, @NotNull BitSet visited) {
            Intrinsics.checkNotNullParameter((Object)candidates, (String)"candidates");
            Intrinsics.checkNotNullParameter((Object)visited, (String)"visited");
            super(candidates, visited);
        }

        @Override
        public void graphSeek(@NotNull HnswGraph graph, int level, int targetNode) {
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            this.cur = ((OnHeapHnswGraph)graph).getNeighbors(level, targetNode);
            this.upto = -1;
        }

        @Override
        public int graphNextNeighbor(@NotNull HnswGraph graph) {
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            ++this.upto;
            NeighborArray neighborArray = this.cur;
            Intrinsics.checkNotNull((Object)neighborArray);
            if (this.upto < neighborArray.size()) {
                NeighborArray neighborArray2 = this.cur;
                Intrinsics.checkNotNull((Object)neighborArray2);
                return neighborArray2.nodes()[this.upto];
            }
            return Integer.MAX_VALUE;
        }
    }
}

