/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.gnit.lucenekmp.util.LongHeap;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u0013J\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020\u0010J\b\u0010$\u001a\u00020%H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;", "", "initialSize", "", "maxHeap", "", "<init>", "(IZ)V", "heap", "Lorg/gnit/lucenekmp/util/LongHeap;", "order", "Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue$Order;", "visitedCount", "incomplete", "size", "add", "", "newNode", "newScore", "", "insertWithOverflow", "encode", "", "node", "score", "decodeScore", "heapValue", "decodeNodeId", "pop", "nodes", "", "topNode", "topScore", "clear", "setVisitedCount", "markIncomplete", "toString", "", "Order", "core"})
public final class NeighborQueue {
    @NotNull
    private final LongHeap heap;
    @NotNull
    private final Order order;
    private int visitedCount;
    private boolean incomplete;

    public NeighborQueue(int initialSize, boolean maxHeap) {
        this.heap = new LongHeap(initialSize);
        this.order = maxHeap ? Order.MAX_HEAP : Order.MIN_HEAP;
    }

    public final int size() {
        return this.heap.size();
    }

    public final void add(int newNode, float newScore) {
        this.heap.push(this.encode(newNode, newScore));
    }

    public final boolean insertWithOverflow(int newNode, float newScore) {
        return this.heap.insertWithOverflow(this.encode(newNode, newScore));
    }

    private final long encode(int node, float score2) {
        return this.order.apply((long)NumericUtils.INSTANCE.floatToSortableInt(score2) << 32 | 0xFFFFFFFFL & ((long)node ^ 0xFFFFFFFFFFFFFFFFL));
    }

    private final float decodeScore(long heapValue) {
        return NumericUtils.INSTANCE.sortableIntToFloat((int)(this.order.apply(heapValue) >> 32));
    }

    private final int decodeNodeId(long heapValue) {
        return ~((int)this.order.apply(heapValue));
    }

    public final int pop() {
        return this.decodeNodeId(this.heap.pop());
    }

    @NotNull
    public final int[] nodes() {
        int size2 = this.size();
        int[] nodes = new int[size2];
        for (int i = 0; i < size2; ++i) {
            nodes[i] = this.decodeNodeId(this.heap.get(i + 1));
        }
        return nodes;
    }

    public final int topNode() {
        return this.decodeNodeId(this.heap.top());
    }

    public final float topScore() {
        return this.decodeScore(this.heap.top());
    }

    public final void clear() {
        this.heap.clear();
        this.visitedCount = 0;
        this.incomplete = false;
    }

    public final int visitedCount() {
        return this.visitedCount;
    }

    public final void setVisitedCount(int visitedCount) {
        this.visitedCount = visitedCount;
    }

    public final boolean incomplete() {
        return this.incomplete;
    }

    public final void markIncomplete() {
        this.incomplete = true;
    }

    @NotNull
    public String toString() {
        return "Neighbors[" + this.heap.size() + "]";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue$Order;", "", "<init>", "(Ljava/lang/String;I)V", "MIN_HEAP", "MAX_HEAP", "apply", "", "v", "core"})
    private static final abstract class Order
    extends Enum<Order> {
        public static final /* enum */ Order MIN_HEAP = new MIN_HEAP("MIN_HEAP", 0);
        public static final /* enum */ Order MAX_HEAP = new MAX_HEAP("MAX_HEAP", 1);
        private static final /* synthetic */ Order[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Order() {
        }

        public abstract long apply(long var1);

        public static Order[] values() {
            return (Order[])$VALUES.clone();
        }

        public static Order valueOf(String value) {
            return Enum.valueOf(Order.class, value);
        }

        @NotNull
        public static EnumEntries<Order> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Order(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = orderArray = new Order[]{Order.MIN_HEAP, Order.MAX_HEAP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"org/gnit/lucenekmp/util/hnsw/NeighborQueue.Order.MAX_HEAP", "Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue$Order;", "apply", "", "v", "core"})
        static final class MAX_HEAP
        extends Order {
            /*
             * WARNING - void declaration
             */
            MAX_HEAP() {
                void var1_1;
            }

            @Override
            public long apply(long v) {
                return (long)-1 - v;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"org/gnit/lucenekmp/util/hnsw/NeighborQueue.Order.MIN_HEAP", "Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue$Order;", "apply", "", "v", "core"})
        static final class MIN_HEAP
        extends Order {
            /*
             * WARNING - void declaration
             */
            MIN_HEAP() {
                void var1_1;
            }

            @Override
            public long apply(long v) {
                return v;
            }
        }
    }
}

