/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\t\n\u0002\b\r\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\tH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/util/packed/DeltaPackedLongValues;", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "pageShift", "", "pageMask", "values", "", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "mins", "", "size", "", "ramBytesUsed", "<init>", "(II[Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;[JJJ)V", "getMins", "()[J", "get", "block", "element", "decodeBlock", "dest", "Builder", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDeltaPackedLongValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeltaPackedLongValues.kt\norg/gnit/lucenekmp/util/packed/DeltaPackedLongValues\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,98:1\n3#2,8:99\n10#3:107\n*S KotlinDebug\n*F\n+ 1 DeltaPackedLongValues.kt\norg/gnit/lucenekmp/util/packed/DeltaPackedLongValues\n*L\n20#1:99,8\n20#1:107\n*E\n"})
public class DeltaPackedLongValues
extends PackedLongValues {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final long[] mins;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(DeltaPackedLongValues.class));

    public DeltaPackedLongValues(int pageShift, int pageMask, @NotNull PackedInts.Reader[] values2, @NotNull long[] mins, long size2, long ramBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)mins, (String)"mins");
        super(pageShift, pageMask, values2, size2, ramBytesUsed);
        boolean condition$iv = values2.length == mins.length;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.mins = mins;
    }

    @NotNull
    public final long[] getMins() {
        return this.mins;
    }

    @Override
    public long get(int block2, int element) {
        return this.mins[block2] + this.getValues()[block2].get(element);
    }

    @Override
    public int decodeBlock(int block2, @NotNull long[] dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int count = super.decodeBlock(block2, dest);
        long min = this.mins[block2];
        int i = 0;
        while (i < count) {
            int n = i++;
            dest[n] = dest[n] + min;
        }
        return count;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/util/packed/DeltaPackedLongValues$Builder;", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Builder;", "pageSize", "", "acceptableOverheadRatio", "", "<init>", "(IF)V", "mins", "", "getMins", "()[J", "setMins", "([J)V", "baseRamBytesUsed", "", "build", "Lorg/gnit/lucenekmp/util/packed/DeltaPackedLongValues;", "pack", "", "values", "numValues", "block", "grow", "newBlockCount", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nDeltaPackedLongValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeltaPackedLongValues.kt\norg/gnit/lucenekmp/util/packed/DeltaPackedLongValues$Builder\n+ 2 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n*L\n1#1,98:1\n759#2,2:99\n*S KotlinDebug\n*F\n+ 1 DeltaPackedLongValues.kt\norg/gnit/lucenekmp/util/packed/DeltaPackedLongValues$Builder\n*L\n54#1:99,2\n*E\n"})
    public static class Builder
    extends PackedLongValues.Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private long[] mins = new long[this.getValues().length];
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(Builder.class));

        public Builder(int pageSize, float acceptableOverheadRatio) {
            super(pageSize, acceptableOverheadRatio);
            this.setRamBytesUsed(this.getRamBytesUsed() + RamUsageEstimator.Companion.sizeOf(this.mins));
        }

        @NotNull
        public final long[] getMins() {
            return this.mins;
        }

        public final void setMins(@NotNull long[] lArray) {
            Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
            this.mins = lArray;
        }

        @Override
        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public DeltaPackedLongValues build() {
            void from$iv;
            void to$iv;
            this.finish();
            this.setPending(new long[0]);
            ArrayUtil.Companion companion = ArrayUtil.Companion;
            PackedInts.Reader[] readerArray = this.getValues();
            boolean bl = false;
            int n = this.getValuesOff();
            boolean $i$f$copyOfSubArray = false;
            void subLength$iv = to$iv - from$iv;
            int n2 = 0;
            PackedInts.Reader[] readerArray2 = new PackedInts.Reader[subLength$iv];
            while (n2 < subLength$iv) {
                void array$iv;
                int n3 = n2++;
                readerArray2[n3] = array$iv[from$iv + n3];
            }
            PackedInts.Reader[] values2 = readerArray2;
            long[] mins = ArrayUtil.Companion.copyOfSubArray(this.mins, 0, this.getValuesOff());
            long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(values2) + RamUsageEstimator.Companion.sizeOf(mins);
            return new DeltaPackedLongValues(this.getPageShift(), this.getPageMask(), values2, mins, this.getSize(), ramBytesUsed);
        }

        @Override
        public void pack(@NotNull long[] values2, int numValues, int block2, float acceptableOverheadRatio) {
            int i;
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            long min = values2[0];
            for (i = 1; i < numValues; ++i) {
                min = Math.min(min, values2[i]);
            }
            i = 0;
            while (i < numValues) {
                int n = i++;
                values2[n] = values2[n] - min;
            }
            super.pack(values2, numValues, block2, acceptableOverheadRatio);
            this.mins[block2] = min;
        }

        @Override
        public void grow(int newBlockCount) {
            super.grow(newBlockCount);
            this.setRamBytesUsed(this.getRamBytesUsed() - RamUsageEstimator.Companion.sizeOf(this.mins));
            this.mins = ArrayUtil.Companion.growExact(this.mins, newBlockCount);
            this.setRamBytesUsed(this.getRamBytesUsed() + RamUsageEstimator.Companion.sizeOf(this.mins));
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/packed/DeltaPackedLongValues$Builder$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/packed/DeltaPackedLongValues$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

