/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.util.LongValues;
import org.gnit.lucenekmp.util.packed.DirectReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\n\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader;", "Lorg/gnit/lucenekmp/util/LongValues;", "blockShift", "", "readers", "", "mins", "", "avgs", "", "bpvs", "", "<init>", "(I[Lorg/gnit/lucenekmp/util/LongValues;[J[F[B)V", "[Lorg/gnit/lucenekmp/util/LongValues;", "blockMask", "", "get", "index", "getBounds", "binarySearch", "fromIndex", "toIndex", "key", "Meta", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDirectMonotonicReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectMonotonicReader.kt\norg/gnit/lucenekmp/util/packed/DirectMonotonicReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class DirectMonotonicReader
extends LongValues {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int blockShift;
    @NotNull
    private final LongValues[] readers;
    private final long blockMask;
    @NotNull
    private final long[] mins;
    @NotNull
    private final float[] avgs;
    @NotNull
    private final byte[] bpvs;

    private DirectMonotonicReader(int blockShift, LongValues[] readers, long[] mins, float[] avgs, byte[] bpvs) {
        this.blockShift = blockShift;
        this.readers = readers;
        this.blockMask = (1L << this.blockShift) - 1L;
        this.mins = mins;
        this.avgs = avgs;
        this.bpvs = bpvs;
        if (!(this.readers.length == mins.length && this.readers.length == avgs.length && this.readers.length == bpvs.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public long get(long index) {
        int block2 = (int)(index >>> this.blockShift);
        long blockIndex = index & this.blockMask;
        long delta = this.readers[block2].get(blockIndex);
        return this.mins[block2] + (long)(this.avgs[block2] * (float)blockIndex) + delta;
    }

    private final long[] getBounds(long index) {
        long[] lArray;
        int block2 = Math.INSTANCE.toIntExact(index >>> this.blockShift);
        long blockIndex = index & this.blockMask;
        long lowerBound = this.mins[block2] + (long)(this.avgs[block2] * (float)blockIndex);
        long upperBound = lowerBound + (1L << this.bpvs[block2]) - 1L;
        if (this.bpvs[block2] == 64 || upperBound < lowerBound) {
            long[] lArray2 = new long[]{Long.MIN_VALUE, Long.MAX_VALUE};
            lArray = lArray2;
        } else {
            long[] lArray3 = new long[]{lowerBound, upperBound};
            lArray = lArray3;
        }
        return lArray;
    }

    public final long binarySearch(long fromIndex, long toIndex, long key) {
        if (!(fromIndex >= 0L && fromIndex <= toIndex)) {
            boolean bl = false;
            String string = "fromIndex=" + fromIndex + ",toIndex=" + toIndex;
            throw new IllegalArgumentException(string.toString());
        }
        long lo = fromIndex;
        long hi = toIndex - 1L;
        while (lo <= hi) {
            long mid = lo + hi >>> 1;
            long[] bounds = this.getBounds(mid);
            if (bounds[1] < key) {
                lo = mid + 1L;
                continue;
            }
            if (bounds[0] > key) {
                hi = mid - 1L;
                continue;
            }
            long midVal = this.get(mid);
            if (midVal < key) {
                lo = mid + 1L;
                continue;
            }
            if (midVal > key) {
                hi = mid - 1L;
                continue;
            }
            return mid;
        }
        return (long)-1 - lo;
    }

    public /* synthetic */ DirectMonotonicReader(int blockShift, LongValues[] readers, long[] mins, float[] avgs, byte[] bpvs, DefaultConstructorMarker $constructor_marker) {
        this(blockShift, readers, mins, avgs, bpvs);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Companion;", "", "<init>", "()V", "loadMeta", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "metaIn", "Lorg/gnit/lucenekmp/store/IndexInput;", "numValues", "", "blockShift", "", "getInstance", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader;", "meta", "data", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "merging", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Meta loadMeta(@NotNull IndexInput metaIn, long numValues, int blockShift) throws IOException {
            Intrinsics.checkNotNullParameter((Object)metaIn, (String)"metaIn");
            boolean allValuesZero = true;
            Meta meta = new Meta(numValues, blockShift);
            int n = meta.getNumBlocks$core();
            for (int i = 0; i < n; ++i) {
                byte bpvs;
                long min;
                meta.getMins$core()[i] = min = metaIn.readLong();
                int avgInt = metaIn.readInt();
                meta.getAvgs$core()[i] = FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, avgInt);
                meta.getOffsets$core()[i] = metaIn.readLong();
                meta.getBpvs$core()[i] = bpvs = metaIn.readByte();
                allValuesZero = allValuesZero && min == 0L && avgInt == 0 && bpvs == 0;
            }
            return allValuesZero ? Meta.Companion.getSINGLE_ZERO_BLOCK$core() : meta;
        }

        @NotNull
        public final DirectMonotonicReader getInstance(@NotNull Meta meta, @NotNull RandomAccessInput data) throws IOException {
            Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.getInstance(meta, data, false);
        }

        @NotNull
        public final DirectMonotonicReader getInstance(@NotNull Meta meta, @NotNull RandomAccessInput data, boolean merging) throws IOException {
            Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LongValues[] readers = new LongValues[meta.getNumBlocks$core()];
            int n = meta.getNumBlocks$core();
            for (int i = 0; i < n; ++i) {
                readers[i] = meta.getBpvs$core()[i] == 0 ? LongValues.Companion.getZEROES() : (merging && i < meta.getNumBlocks$core() - 1 && meta.getBlockShift$core() >= 7 ? DirectReader.INSTANCE.getMergeInstance(data, meta.getBpvs$core()[i], meta.getOffsets$core()[i], 1L << meta.getBlockShift$core()) : DirectReader.INSTANCE.getInstance(data, meta.getBpvs$core()[i], meta.getOffsets$core()[i]));
            }
            return new DirectMonotonicReader(meta.getBlockShift$core(), readers, meta.getMins$core(), meta.getAvgs$core(), meta.getBpvs$core(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "", "numValues", "", "blockShift", "", "<init>", "(JI)V", "getBlockShift$core", "()I", "numBlocks", "getNumBlocks$core", "mins", "", "getMins$core", "()[J", "avgs", "", "getAvgs$core", "()[F", "bpvs", "", "getBpvs$core", "()[B", "offsets", "getOffsets$core", "Companion", "core"})
    public static final class Meta {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int blockShift;
        private final int numBlocks;
        @NotNull
        private final long[] mins;
        @NotNull
        private final float[] avgs;
        @NotNull
        private final byte[] bpvs;
        @NotNull
        private final long[] offsets;
        @NotNull
        private static final Meta SINGLE_ZERO_BLOCK = new Meta(1L, 63);

        public Meta(long numValues, int blockShift) {
            this.blockShift = blockShift;
            long numBlocks = numValues >>> this.blockShift;
            if (numBlocks << this.blockShift < numValues) {
                ++numBlocks;
            }
            this.numBlocks = (int)numBlocks;
            this.mins = new long[this.numBlocks];
            this.avgs = new float[this.numBlocks];
            this.bpvs = new byte[this.numBlocks];
            this.offsets = new long[this.numBlocks];
        }

        public final int getBlockShift$core() {
            return this.blockShift;
        }

        public final int getNumBlocks$core() {
            return this.numBlocks;
        }

        @NotNull
        public final long[] getMins$core() {
            return this.mins;
        }

        @NotNull
        public final float[] getAvgs$core() {
            return this.avgs;
        }

        @NotNull
        public final byte[] getBpvs$core() {
            return this.bpvs;
        }

        @NotNull
        public final long[] getOffsets$core() {
            return this.offsets;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta$Companion;", "", "<init>", "()V", "SINGLE_ZERO_BLOCK", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "getSINGLE_ZERO_BLOCK$core", "()Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Meta getSINGLE_ZERO_BLOCK$core() {
                return SINGLE_ZERO_BLOCK;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

