/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.DeltaPackedLongValues;
import org.gnit.lucenekmp.util.packed.MonotonicBlockPackedReader;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\t\n\u0002\b\r\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\tH\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/util/packed/MonotonicLongValues;", "Lorg/gnit/lucenekmp/util/packed/DeltaPackedLongValues;", "pageShift", "", "pageMask", "values", "", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "mins", "", "averages", "", "size", "", "ramBytesUsed", "<init>", "(II[Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;[J[FJJ)V", "getAverages", "()[F", "get", "block", "element", "decodeBlock", "dest", "Builder", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMonotonicLongValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonotonicLongValues.kt\norg/gnit/lucenekmp/util/packed/MonotonicLongValues\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,104:1\n3#2,8:105\n10#3:113\n*S KotlinDebug\n*F\n+ 1 MonotonicLongValues.kt\norg/gnit/lucenekmp/util/packed/MonotonicLongValues\n*L\n20#1:105,8\n20#1:113\n*E\n"})
public final class MonotonicLongValues
extends DeltaPackedLongValues {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] averages;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(MonotonicLongValues.class));

    public MonotonicLongValues(int pageShift, int pageMask, @NotNull PackedInts.Reader[] values2, @NotNull long[] mins, @NotNull float[] averages, long size2, long ramBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)mins, (String)"mins");
        Intrinsics.checkNotNullParameter((Object)averages, (String)"averages");
        super(pageShift, pageMask, values2, mins, size2, ramBytesUsed);
        boolean condition$iv = values2.length == averages.length;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.averages = averages;
    }

    @NotNull
    public final float[] getAverages() {
        return this.averages;
    }

    @Override
    public long get(int block2, int element) {
        return MonotonicBlockPackedReader.Companion.expected(this.getMins()[block2], this.averages[block2], element) + this.getValues()[block2].get(element);
    }

    @Override
    public int decodeBlock(int block2, @NotNull long[] dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int count = super.decodeBlock(block2, dest);
        float average = this.averages[block2];
        for (int i = 0; i < count; ++i) {
            int n = i;
            dest[n] = dest[n] + MonotonicBlockPackedReader.Companion.expected(0L, average, i);
        }
        return count;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0003H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/util/packed/MonotonicLongValues$Builder;", "Lorg/gnit/lucenekmp/util/packed/DeltaPackedLongValues$Builder;", "pageSize", "", "acceptableOverheadRatio", "", "<init>", "(IF)V", "averages", "", "getAverages", "()[F", "setAverages", "([F)V", "baseRamBytesUsed", "", "build", "Lorg/gnit/lucenekmp/util/packed/MonotonicLongValues;", "pack", "", "values", "", "numValues", "block", "grow", "newBlockCount", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nMonotonicLongValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonotonicLongValues.kt\norg/gnit/lucenekmp/util/packed/MonotonicLongValues$Builder\n+ 2 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n*L\n1#1,104:1\n759#2,2:105\n*S KotlinDebug\n*F\n+ 1 MonotonicLongValues.kt\norg/gnit/lucenekmp/util/packed/MonotonicLongValues$Builder\n*L\n58#1:105,2\n*E\n"})
    public static final class Builder
    extends DeltaPackedLongValues.Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private float[] averages = new float[this.getValues().length];
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(Builder.class));

        public Builder(int pageSize, float acceptableOverheadRatio) {
            super(pageSize, acceptableOverheadRatio);
            this.setRamBytesUsed(this.getRamBytesUsed() + RamUsageEstimator.Companion.sizeOf(this.averages));
        }

        @NotNull
        public final float[] getAverages() {
            return this.averages;
        }

        public final void setAverages(@NotNull float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
            this.averages = fArray;
        }

        @Override
        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public MonotonicLongValues build() {
            void from$iv;
            void to$iv;
            this.finish();
            this.setPending(new long[0]);
            ArrayUtil.Companion companion = ArrayUtil.Companion;
            PackedInts.Reader[] readerArray = this.getValues();
            boolean bl = false;
            int n = this.getValuesOff();
            boolean $i$f$copyOfSubArray = false;
            void subLength$iv = to$iv - from$iv;
            int n2 = 0;
            PackedInts.Reader[] readerArray2 = new PackedInts.Reader[subLength$iv];
            while (n2 < subLength$iv) {
                void array$iv;
                int n3 = n2++;
                readerArray2[n3] = array$iv[from$iv + n3];
            }
            PackedInts.Reader[] values2 = readerArray2;
            long[] mins = ArrayUtil.Companion.copyOfSubArray(this.getMins(), 0, this.getValuesOff());
            float[] averages = ArrayUtil.Companion.copyOfSubArray(this.averages, 0, this.getValuesOff());
            long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(values2) + RamUsageEstimator.Companion.sizeOf(mins) + RamUsageEstimator.Companion.sizeOf(averages);
            return new MonotonicLongValues(this.getPageShift(), this.getPageMask(), values2, mins, averages, this.getSize(), ramBytesUsed);
        }

        @Override
        public void pack(@NotNull long[] values2, int numValues, int block2, float acceptableOverheadRatio) {
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            float average = numValues == 1 ? 0.0f : (float)(values2[numValues - 1] - values2[0]) / (float)(numValues - 1);
            for (int i = 0; i < numValues; ++i) {
                int n = i;
                values2[n] = values2[n] - MonotonicBlockPackedReader.Companion.expected(0L, average, i);
            }
            super.pack(values2, numValues, block2, acceptableOverheadRatio);
            this.averages[block2] = average;
        }

        @Override
        public void grow(int newBlockCount) {
            super.grow(newBlockCount);
            this.setRamBytesUsed(this.getRamBytesUsed() - RamUsageEstimator.Companion.sizeOf(this.averages));
            this.averages = ArrayUtil.Companion.growExact(this.averages, newBlockCount);
            this.setRamBytesUsed(this.getRamBytesUsed() + RamUsageEstimator.Companion.sizeOf(this.averages));
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/packed/MonotonicLongValues$Builder$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/packed/MonotonicLongValues$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

