/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.BulkOperation;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0003H\u0016J(\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\nH\u0016J(\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64;", "Lorg/gnit/lucenekmp/util/packed/PackedInts$MutableImpl;", "valueCount", "", "bitsPerValue", "<init>", "(II)V", "blocks", "", "maskRight", "", "bpvMinusBlockSize", "get", "index", "arr", "off", "len", "set", "", "value", "toString", "", "ramBytesUsed", "fill", "fromIndex", "toIndex", "val", "clear", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPacked64.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Packed64.kt\norg/gnit/lucenekmp/util/packed/Packed64\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
public final class Packed64
extends PackedInts.MutableImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final long[] blocks;
    private final long maskRight;
    private final int bpvMinusBlockSize;
    public static final int BLOCK_SIZE = 64;
    public static final int BLOCK_BITS = 6;
    public static final int MOD_MASK = 63;

    public Packed64(int valueCount, int bitsPerValue) {
        super(valueCount, bitsPerValue);
        PackedInts.Format format = PackedInts.Format.PACKED;
        int longCount = format.longCount(PackedInts.INSTANCE.getVERSION_CURRENT(), valueCount, bitsPerValue);
        this.blocks = new long[longCount];
        this.maskRight = -1L << 64 - bitsPerValue >>> 64 - bitsPerValue;
        this.bpvMinusBlockSize = bitsPerValue - 64;
    }

    @Override
    public long get(int index) {
        long majorBitPos = (long)index * (long)this.getBitsPerValue();
        int elementPos = (int)(majorBitPos >>> 6);
        long endBits = (majorBitPos & 0x3FL) + (long)this.bpvMinusBlockSize;
        if (endBits <= 0L) {
            return this.blocks[elementPos] >>> -((int)endBits) & this.maskRight;
        }
        return (this.blocks[elementPos] << (int)endBits | this.blocks[elementPos + 1] >>> (int)((long)64 - endBits)) & this.maskRight;
    }

    @Override
    public int get(int index, @NotNull long[] arr, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        int index2 = index;
        int off2 = off;
        int len2 = 0;
        len2 = len;
        if (!(len2 > 0)) {
            boolean $i$a$-require-Packed64$get$22 = false;
            String $i$a$-require-Packed64$get$22 = "len must be > 0 (got " + len2 + ")";
            throw new IllegalArgumentException($i$a$-require-Packed64$get$22.toString());
        }
        if (!(index2 >= 0 && index2 < this.getValueCount())) {
            String $i$a$-require-Packed64$get$22 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-require-Packed64$get$22.toString());
        }
        if (!(off2 + (len2 = Math.min(len2, this.getValueCount() - index2)) <= arr.length)) {
            String $i$a$-require-Packed64$get$22 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-require-Packed64$get$22.toString());
        }
        int originalIndex = index2;
        PackedInts.Decoder decoder = BulkOperation.Companion.of(PackedInts.Format.PACKED, this.getBitsPerValue());
        int offsetInBlocks = index2 % decoder.longValueCount();
        if (offsetInBlocks != 0) {
            for (int i = offsetInBlocks; i < decoder.longValueCount() && len2 > 0; len2 += -1, ++i) {
                arr[off2++] = this.get(index2++);
            }
            if (len2 == 0) {
                return index2 - originalIndex;
            }
        }
        if (!(index2 % decoder.longValueCount() == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int blockIndex = (int)((long)index2 * (long)this.getBitsPerValue() >>> 6);
        if (!(((long)index2 * (long)this.getBitsPerValue() & 0x3FL) == 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int iterations = len2 / decoder.longValueCount();
        decoder.decode(this.blocks, blockIndex, arr, off2, iterations);
        int gotValues = iterations * decoder.longValueCount();
        index2 += gotValues;
        if (!((len2 -= gotValues) >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (index2 > originalIndex) {
            return index2 - originalIndex;
        }
        if (!(index2 == originalIndex)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return super.get(index2, arr, off2, len2);
    }

    @Override
    public void set(int index, long value) {
        long majorBitPos = (long)index * (long)this.getBitsPerValue();
        int elementPos = (int)(majorBitPos >>> 6);
        long endBits = (majorBitPos & 0x3FL) + (long)this.bpvMinusBlockSize;
        if (endBits <= 0L) {
            this.blocks[elementPos] = this.blocks[elementPos] & (this.maskRight << -((int)endBits) ^ 0xFFFFFFFFFFFFFFFFL) | value << -((int)endBits);
            return;
        }
        this.blocks[elementPos] = this.blocks[elementPos] & (this.maskRight >>> (int)endBits ^ 0xFFFFFFFFFFFFFFFFL) | value >>> (int)endBits;
        this.blocks[elementPos + 1] = this.blocks[elementPos + 1] & -1L >>> (int)endBits | value << (int)((long)64 - endBits);
    }

    @Override
    public int set(int index, @NotNull long[] arr, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        int index2 = index;
        int off2 = off;
        int len2 = 0;
        len2 = len;
        if (!(len2 > 0)) {
            boolean $i$a$-require-Packed64$set$22 = false;
            String $i$a$-require-Packed64$set$22 = "len must be > 0 (got " + len2 + ")";
            throw new IllegalArgumentException($i$a$-require-Packed64$set$22.toString());
        }
        if (!(index2 >= 0 && index2 < this.getValueCount())) {
            String $i$a$-require-Packed64$set$22 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-require-Packed64$set$22.toString());
        }
        if (!(off2 + (len2 = Math.min(len2, this.getValueCount() - index2)) <= arr.length)) {
            String $i$a$-require-Packed64$set$22 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-require-Packed64$set$22.toString());
        }
        int originalIndex = index2;
        PackedInts.Encoder encoder = BulkOperation.Companion.of(PackedInts.Format.PACKED, this.getBitsPerValue());
        int offsetInBlocks = index2 % encoder.longValueCount();
        if (offsetInBlocks != 0) {
            for (int i = offsetInBlocks; i < encoder.longValueCount() && len2 > 0; len2 += -1, ++i) {
                this.set(index2++, arr[off2++]);
            }
            if (len2 == 0) {
                return index2 - originalIndex;
            }
        }
        if (!(index2 % encoder.longValueCount() == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int blockIndex = (int)((long)index2 * (long)this.getBitsPerValue() >>> 6);
        if (!(((long)index2 * (long)this.getBitsPerValue() & 0x3FL) == 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int iterations = len2 / encoder.longValueCount();
        encoder.encode(arr, off2, this.blocks, blockIndex, iterations);
        int setValues = iterations * encoder.longValueCount();
        index2 += setValues;
        if (!((len2 -= setValues) >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (index2 > originalIndex) {
            return index2 - originalIndex;
        }
        if (!(index2 == originalIndex)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return super.set(index2, arr, off2, len2);
    }

    @Override
    @NotNull
    public String toString() {
        return "Packed64(bitsPerValue=" + this.getBitsPerValue() + ",size=" + this.size() + ",blocks=" + this.blocks.length + ")";
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.Companion.alignObjectSize(32L) + RamUsageEstimator.Companion.sizeOf(this.blocks);
    }

    @Override
    public void fill(int fromIndex, int toIndex, long val) {
        int fromIndex2 = fromIndex;
        if (!(PackedInts.INSTANCE.unsignedBitsRequired(val) <= this.getBitsPerValue())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(fromIndex2 <= toIndex)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int span = toIndex - fromIndex2;
        int nAlignedValues = 64 / Packed64.Companion.gcd(64, this.getBitsPerValue());
        if (span <= 3 * nAlignedValues) {
            super.fill(fromIndex2, toIndex, val);
            return;
        }
        int fromIndexModNAlignedValues = fromIndex2 % nAlignedValues;
        if (fromIndexModNAlignedValues != 0) {
            for (int i = fromIndexModNAlignedValues; i < nAlignedValues; ++i) {
                this.set(fromIndex2++, val);
            }
        }
        if (!(fromIndex2 % nAlignedValues == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int nAlignedBlocks = nAlignedValues * this.getBitsPerValue() >> 6;
        long[] nAlignedValuesBlocks = null;
        Packed64 $this$fill_u24lambda_u242 = this;
        boolean bl = false;
        Packed64 values2 = new Packed64(nAlignedValues, $this$fill_u24lambda_u242.getBitsPerValue());
        for (int i = 0; i < nAlignedValues; ++i) {
            values2.set(i, val);
        }
        nAlignedValuesBlocks = values2.blocks;
        if (!(nAlignedBlocks <= nAlignedValuesBlocks.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int startBlock = (int)((long)fromIndex2 * (long)this.getBitsPerValue() >>> 6);
        int endBlock = (int)((long)toIndex * (long)this.getBitsPerValue() >>> 6);
        for (int block2 = startBlock; block2 < endBlock; ++block2) {
            long blockValue;
            this.blocks[block2] = blockValue = nAlignedValuesBlocks[block2 % nAlignedBlocks];
        }
        for (int i = (int)(((long)endBlock << 6) / (long)this.getBitsPerValue()); i < toIndex; ++i) {
            this.set(i, val);
        }
    }

    @Override
    public void clear() {
        ArraysKt.fill$default((long[])this.blocks, (long)0L, (int)0, (int)0, (int)6, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64$Companion;", "", "<init>", "()V", "BLOCK_SIZE", "", "BLOCK_BITS", "MOD_MASK", "gcd", "a", "b", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int gcd(int a, int b) {
            if (a < b) {
                return this.gcd(b, a);
            }
            if (b == 0) {
                return a;
            }
            return this.gcd(b, a % b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

