/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.IOException;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.LongsRef;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.BulkOperation;
import org.gnit.lucenekmp.util.packed.Packed64;
import org.gnit.lucenekmp.util.packed.Packed64SingleBlock;
import org.gnit.lucenekmp.util.packed.PackedReaderIterator;
import org.gnit.lucenekmp.util.packed.PackedWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001:\f@ABCDEFGHIJKB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nJ\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nJ6\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nJ\u001e\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005J\u001e\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ.\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nJ\u000e\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020.J\u000e\u0010-\u001a\u00020.2\u0006\u0010\u0019\u001a\u00020\nJ6\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nJ6\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\n2\u0006\u00108\u001a\u000209J\u001e\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u0016\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020.2\u0006\u0010;\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006L"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts;", "", "<init>", "()V", "FASTEST", "", "FAST", "DEFAULT", "COMPACT", "DEFAULT_BUFFER_SIZE", "", "CODEC_NAME", "", "VERSION_MONOTONIC_WITHOUT_ZIGZAG", "VERSION_START", "getVERSION_START", "()I", "VERSION_CURRENT", "getVERSION_CURRENT", "checkVersion", "", "version", "fastestFormatAndBits", "Lorg/gnit/lucenekmp/util/packed/PackedInts$FormatAndBits;", "valueCount", "bitsPerValue", "acceptableOverheadRatio", "getDecoder", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Decoder;", "format", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "getEncoder", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Encoder;", "getReaderIteratorNoHeader", "Lorg/gnit/lucenekmp/util/packed/PackedInts$ReaderIterator;", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "mem", "getMutable", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Mutable;", "getWriterNoHeader", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Writer;", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "bitsRequired", "maxValue", "", "unsignedBitsRequired", "bits", "copy", "src", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "srcPos", "dest", "destPos", "len", "buf", "", "checkBlockSize", "blockSize", "minBlockSize", "maxBlockSize", "numBlocks", "size", "Format", "FormatAndBits", "Decoder", "Encoder", "Reader", "ReaderIterator", "ReaderIteratorImpl", "Mutable", "ReaderImpl", "MutableImpl", "NullReader", "Writer", "core"})
@SourceDebugExtension(value={"SMAP\nPackedInts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackedInts.kt\norg/gnit/lucenekmp/util/packed/PackedInts\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,850:1\n1#2:851\n*E\n"})
public final class PackedInts {
    @NotNull
    public static final PackedInts INSTANCE = new PackedInts();
    public static final float FASTEST = 7.0f;
    public static final float FAST = 0.5f;
    public static final float DEFAULT = 0.25f;
    public static final float COMPACT = 0.0f;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    @NotNull
    public static final String CODEC_NAME = "PackedInts";
    public static final int VERSION_MONOTONIC_WITHOUT_ZIGZAG = 2;
    private static final int VERSION_START = 2;
    private static final int VERSION_CURRENT = 2;

    private PackedInts() {
    }

    public final int getVERSION_START() {
        return VERSION_START;
    }

    public final int getVERSION_CURRENT() {
        return VERSION_CURRENT;
    }

    public final void checkVersion(int version) {
        if (!(version >= VERSION_START)) {
            boolean $i$a$-require-PackedInts$checkVersion$32 = false;
            String $i$a$-require-PackedInts$checkVersion$32 = "Version is too old, should be at least " + VERSION_START + " (got " + version + ")";
            throw new IllegalArgumentException($i$a$-require-PackedInts$checkVersion$32.toString());
        }
        if (!(version <= VERSION_CURRENT)) {
            boolean bl = false;
            String string = "Version is too new, should be at most " + VERSION_CURRENT + " (got " + version + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final FormatAndBits fastestFormatAndBits(int valueCount, int bitsPerValue, float acceptableOverheadRatio) {
        int valueCount2 = valueCount;
        float acceptableOverheadRatio2 = acceptableOverheadRatio;
        if (valueCount2 == -1) {
            valueCount2 = Integer.MAX_VALUE;
        }
        acceptableOverheadRatio2 = Math.max(0.0f, acceptableOverheadRatio2);
        acceptableOverheadRatio2 = Math.min(7.0f, acceptableOverheadRatio2);
        float acceptableOverheadPerValue = acceptableOverheadRatio2 * (float)bitsPerValue;
        int maxBitsPerValue = bitsPerValue + (int)acceptableOverheadPerValue;
        int actualBitsPerValue = -1;
        actualBitsPerValue = bitsPerValue <= 8 && maxBitsPerValue >= 8 ? 8 : (bitsPerValue <= 16 && maxBitsPerValue >= 16 ? 16 : (bitsPerValue <= 32 && maxBitsPerValue >= 32 ? 32 : (bitsPerValue <= 64 && maxBitsPerValue >= 64 ? 64 : bitsPerValue)));
        return new FormatAndBits(Format.PACKED, actualBitsPerValue);
    }

    @NotNull
    public final Decoder getDecoder(@NotNull Format format, int version, int bitsPerValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        this.checkVersion(version);
        return BulkOperation.Companion.of(format, bitsPerValue);
    }

    @NotNull
    public final Encoder getEncoder(@NotNull Format format, int version, int bitsPerValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        this.checkVersion(version);
        return BulkOperation.Companion.of(format, bitsPerValue);
    }

    @NotNull
    public final ReaderIterator getReaderIteratorNoHeader(@NotNull DataInput in, @NotNull Format format, int version, int valueCount, int bitsPerValue, int mem) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        this.checkVersion(version);
        return new PackedReaderIterator(format, version, valueCount, bitsPerValue, in, mem);
    }

    @NotNull
    public final Mutable getMutable(int valueCount, int bitsPerValue, float acceptableOverheadRatio) {
        FormatAndBits formatAndBits = this.fastestFormatAndBits(valueCount, bitsPerValue, acceptableOverheadRatio);
        int n = formatAndBits.getBitsPerValue();
        Format format = formatAndBits.getFormat();
        Intrinsics.checkNotNull((Object)((Object)format));
        return INSTANCE.getMutable(valueCount, n, format);
    }

    @NotNull
    public final Mutable getMutable(int valueCount, int bitsPerValue, @NotNull Format format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        if (!(valueCount >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (WhenMappings.$EnumSwitchMapping$0[format.ordinal()] == 1) {
            return new Packed64(valueCount, bitsPerValue);
        }
        throw new AssertionError();
    }

    @NotNull
    public final Writer getWriterNoHeader(@NotNull DataOutput out, @NotNull Format format, int valueCount, int bitsPerValue, int mem) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        return new PackedWriter(format, out, valueCount, bitsPerValue, mem);
    }

    public final int bitsRequired(long maxValue) {
        if (!(maxValue >= 0L)) {
            boolean bl = false;
            String string = "maxValue must be non-negative (got: " + maxValue + ")";
            throw new IllegalArgumentException(string.toString());
        }
        return this.unsignedBitsRequired(maxValue);
    }

    public final int unsignedBitsRequired(long bits) {
        return Math.max(1, 64 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, bits));
    }

    public final long maxValue(int bitsPerValue) {
        return bitsPerValue == 64 ? Long.MAX_VALUE : -1L << bitsPerValue ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final void copy(@NotNull Reader src, int srcPos, @NotNull Mutable dest, int destPos, int len, int mem) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int srcPos2 = srcPos;
        int destPos2 = destPos;
        if (!(srcPos2 + len <= src.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(destPos2 + len <= dest.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int capacity = mem >>> 3;
        if (capacity == 0) {
            for (int i = 0; i < len; ++i) {
                dest.set(destPos2++, src.get(srcPos2++));
            }
        } else if (len > 0) {
            long[] buf = new long[Math.min(capacity, len)];
            this.copy(src, srcPos2, dest, destPos2, len, buf);
        }
    }

    public final void copy(@NotNull Reader src, int srcPos, @NotNull Mutable dest, int destPos, int len, @NotNull long[] buf) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int srcPos2 = srcPos;
        int destPos2 = destPos;
        int len2 = len;
        if (!(buf.length > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int remaining = 0;
        while (len2 > 0) {
            int read = src.get(srcPos2, buf, remaining, Math.min(len2, buf.length - remaining));
            if (!(read > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            srcPos2 += read;
            len2 -= read;
            int written = dest.set(destPos2, buf, 0, remaining += read);
            if (!(written > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            destPos2 += written;
            if (written < remaining) {
                ArraysKt.copyInto((long[])buf, (long[])buf, (int)0, (int)written, (int)remaining);
            }
            remaining -= written;
        }
        while (remaining > 0) {
            int written = dest.set(destPos2, buf, 0, remaining);
            destPos2 += written;
            if ((remaining -= written) <= 0) continue;
            ArraysKt.copyInto((long[])buf, (long[])buf, (int)0, (int)written, (int)(written + remaining));
        }
    }

    public final int checkBlockSize(int blockSize, int minBlockSize, int maxBlockSize) {
        if (!(blockSize >= minBlockSize && blockSize <= maxBlockSize)) {
            boolean $i$a$-require-PackedInts$checkBlockSize$32 = false;
            String $i$a$-require-PackedInts$checkBlockSize$32 = "blockSize must be >= " + minBlockSize + " and <= " + maxBlockSize + ", got " + blockSize;
            throw new IllegalArgumentException($i$a$-require-PackedInts$checkBlockSize$32.toString());
        }
        if (!((blockSize & blockSize - 1) == 0)) {
            boolean bl = false;
            String string = "blockSize must be a power of two, got " + blockSize;
            throw new IllegalArgumentException(string.toString());
        }
        return IntExtKt.numberOfTrailingZeros(IntCompanionObject.INSTANCE, blockSize);
    }

    public final int numBlocks(long size2, int blockSize) {
        int numBlocks = (int)(size2 / (long)blockSize) + (size2 % (long)blockSize == 0L ? 0 : 1);
        if (!((long)numBlocks * (long)blockSize >= size2)) {
            boolean bl = false;
            String string = "size is too large for this block size";
            throw new IllegalArgumentException(string.toString());
        }
        return numBlocks;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\u0010\u0015\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0003H&J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&\u00a8\u0006\u0011\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$Decoder;", "", "longBlockCount", "", "longValueCount", "byteBlockCount", "byteValueCount", "decode", "", "blocks", "", "blocksOffset", "values", "valuesOffset", "iterations", "", "", "core"})
    public static interface Decoder {
        public int longBlockCount();

        public int longValueCount();

        public int byteBlockCount();

        public int byteValueCount();

        public void decode(@NotNull long[] var1, int var2, @NotNull long[] var3, int var4, int var5);

        public void decode(@NotNull byte[] var1, int var2, @NotNull long[] var3, int var4, int var5);

        public void decode(@NotNull long[] var1, int var2, @NotNull int[] var3, int var4, int var5);

        public void decode(@NotNull byte[] var1, int var2, @NotNull int[] var3, int var4, int var5);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\u0010\u0015\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0003H&J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&\u00a8\u0006\u0011\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$Encoder;", "", "longBlockCount", "", "longValueCount", "byteBlockCount", "byteValueCount", "encode", "", "values", "", "valuesOffset", "blocks", "blocksOffset", "iterations", "", "", "core"})
    public static interface Encoder {
        public int longBlockCount();

        public int longValueCount();

        public int byteBlockCount();

        public int byteValueCount();

        public void encode(@NotNull long[] var1, int var2, @NotNull long[] var3, int var4, int var5);

        public void encode(@NotNull long[] var1, int var2, @NotNull byte[] var3, int var4, int var5);

        public void encode(@NotNull int[] var1, int var2, @NotNull long[] var3, int var4, int var5);

        public void encode(@NotNull int[] var1, int var2, @NotNull byte[] var3, int var4, int var5);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J \u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "", "id", "", "<init>", "(Ljava/lang/String;II)V", "getId", "()I", "PACKED", "PACKED_SINGLE_BLOCK", "byteCount", "", "packedIntsVersion", "valueCount", "bitsPerValue", "longCount", "isSupported", "", "overheadPerValue", "", "overheadRatio", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nPackedInts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackedInts.kt\norg/gnit/lucenekmp/util/packed/PackedInts$Format\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,850:1\n1#2:851\n*E\n"})
    public static final class Format
    extends Enum<Format> {
        @NotNull
        public static final Companion Companion;
        private final int id;
        public static final /* enum */ Format PACKED;
        @Deprecated(message="Use {@link #PACKED} instead.")
        public static final /* enum */ Format PACKED_SINGLE_BLOCK;
        private static final /* synthetic */ Format[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Format(int id) {
            this.id = id;
        }

        public final int getId() {
            return this.id;
        }

        public long byteCount(int packedIntsVersion, int valueCount, int bitsPerValue) {
            if (!(bitsPerValue >= 0 && bitsPerValue <= 64)) {
                boolean bl = false;
                Integer n = bitsPerValue;
                throw new IllegalArgumentException(((Object)n).toString());
            }
            return 8L * (long)this.longCount(packedIntsVersion, valueCount, bitsPerValue);
        }

        public int longCount(int packedIntsVersion, int valueCount, int bitsPerValue) {
            if (!(bitsPerValue >= 0 && bitsPerValue <= 64)) {
                boolean bl = false;
                Integer n = bitsPerValue;
                throw new IllegalArgumentException(((Object)n).toString());
            }
            long byteCount = this.byteCount(packedIntsVersion, valueCount, bitsPerValue);
            if (!(byteCount < 0x3FFFFFFF8L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return (int)(byteCount + (long)7 >>> 3);
        }

        public boolean isSupported(int bitsPerValue) {
            return bitsPerValue >= 1 && bitsPerValue <= 64;
        }

        public float overheadPerValue(int bitsPerValue) {
            if (!this.isSupported(bitsPerValue)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return 0.0f;
        }

        public final float overheadRatio(int bitsPerValue) {
            if (!this.isSupported(bitsPerValue)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.overheadPerValue(bitsPerValue) / (float)bitsPerValue;
        }

        public static Format[] values() {
            return (Format[])$VALUES.clone();
        }

        public static Format valueOf(String value) {
            return Enum.valueOf(Format.class, value);
        }

        @NotNull
        public static EnumEntries<Format> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Format(String $enum$name, int $enum$ordinal, int id, DefaultConstructorMarker $constructor_marker) {
            this(id);
        }

        static {
            PACKED = new PACKED("PACKED", 0);
            PACKED_SINGLE_BLOCK = new PACKED_SINGLE_BLOCK("PACKED_SINGLE_BLOCK", 1);
            $VALUES = formatArray = new Format[]{Format.PACKED, Format.PACKED_SINGLE_BLOCK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$Format$Companion;", "", "<init>", "()V", "byId", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "id", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Format byId(int id) {
                for (Format format : Format.getEntries()) {
                    if (format.getId() != id) continue;
                    return format;
                }
                throw new IllegalArgumentException("Unknown format id: " + id);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"org/gnit/lucenekmp/util/packed/PackedInts.Format.PACKED", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "byteCount", "", "packedIntsVersion", "", "valueCount", "bitsPerValue", "core"})
        static final class PACKED
        extends Format {
            /*
             * WARNING - void declaration
             */
            PACKED() {
                void var1_1;
            }

            @Override
            public long byteCount(int packedIntsVersion, int valueCount, int bitsPerValue) {
                return (long)Math.ceil((double)valueCount * (double)bitsPerValue / (double)8);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u000b"}, d2={"org/gnit/lucenekmp/util/packed/PackedInts.Format.PACKED_SINGLE_BLOCK", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "longCount", "", "packedIntsVersion", "valueCount", "bitsPerValue", "isSupported", "", "overheadPerValue", "", "core"})
        static final class PACKED_SINGLE_BLOCK
        extends Format {
            /*
             * WARNING - void declaration
             */
            PACKED_SINGLE_BLOCK() {
                void var1_1;
            }

            @Override
            public int longCount(int packedIntsVersion, int valueCount, int bitsPerValue) {
                int valuesPerBlock = 64 / bitsPerValue;
                return (int)Math.ceil((double)valueCount / (double)valuesPerBlock);
            }

            @Override
            public boolean isSupported(int bitsPerValue) {
                return Packed64SingleBlock.Companion.isSupported(bitsPerValue);
            }

            @Override
            public float overheadPerValue(int bitsPerValue) {
                if (!this.isSupported(bitsPerValue)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                int valuesPerBlock = 64 / bitsPerValue;
                int overhead = 64 % bitsPerValue;
                return (float)overhead / (float)valuesPerBlock;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$FormatAndBits;", "", "format", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "bitsPerValue", "", "<init>", "(Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;I)V", "getFormat", "()Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "getBitsPerValue", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    public static final class FormatAndBits {
        @NotNull
        private final Format format;
        private final int bitsPerValue;

        public FormatAndBits(@NotNull Format format, int bitsPerValue) {
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            this.format = format;
            this.bitsPerValue = bitsPerValue;
        }

        @NotNull
        public final Format getFormat() {
            return this.format;
        }

        public final int getBitsPerValue() {
            return this.bitsPerValue;
        }

        @NotNull
        public final Format component1() {
            return this.format;
        }

        public final int component2() {
            return this.bitsPerValue;
        }

        @NotNull
        public final FormatAndBits copy(@NotNull Format format, int bitsPerValue) {
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            return new FormatAndBits(format, bitsPerValue);
        }

        public static /* synthetic */ FormatAndBits copy$default(FormatAndBits formatAndBits, Format format, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                format = formatAndBits.format;
            }
            if ((n2 & 2) != 0) {
                n = formatAndBits.bitsPerValue;
            }
            return formatAndBits.copy(format, n);
        }

        @NotNull
        public String toString() {
            return "FormatAndBits(format=" + this.format + ", bitsPerValue=" + this.bitsPerValue + ")";
        }

        public int hashCode() {
            int result = this.format.hashCode();
            result = result * 31 + Integer.hashCode(this.bitsPerValue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FormatAndBits)) {
                return false;
            }
            FormatAndBits formatAndBits = (FormatAndBits)other;
            if (this.format != formatAndBits.format) {
                return false;
            }
            return this.bitsPerValue == formatAndBits.bitsPerValue;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH&J(\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J \u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$Mutable;", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "<init>", "()V", "bitsPerValue", "", "getBitsPerValue", "()I", "set", "", "index", "value", "", "arr", "", "off", "len", "fill", "fromIndex", "toIndex", "val", "clear", "core"})
    @SourceDebugExtension(value={"SMAP\nPackedInts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackedInts.kt\norg/gnit/lucenekmp/util/packed/PackedInts$Mutable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,850:1\n1#2:851\n*E\n"})
    public static abstract class Mutable
    extends Reader {
        public abstract int getBitsPerValue();

        public abstract void set(int var1, long var2);

        public int set(int index, @NotNull long[] arr, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
            int len2 = 0;
            len2 = len;
            if (!(len2 > 0)) {
                boolean $i$a$-require-PackedInts$Mutable$set$22 = false;
                String $i$a$-require-PackedInts$Mutable$set$22 = "len must be > 0 (got " + len2 + ")";
                throw new IllegalArgumentException($i$a$-require-PackedInts$Mutable$set$22.toString());
            }
            if (!(index >= 0 && index < this.size())) {
                String $i$a$-require-PackedInts$Mutable$set$22 = "Failed requirement.";
                throw new IllegalArgumentException($i$a$-require-PackedInts$Mutable$set$22.toString());
            }
            if (!(off + (len2 = Math.min(len2, this.size() - index)) <= arr.length)) {
                String $i$a$-require-PackedInts$Mutable$set$22 = "Failed requirement.";
                throw new IllegalArgumentException($i$a$-require-PackedInts$Mutable$set$22.toString());
            }
            int i = index;
            int o = off;
            int end = index + len2;
            while (i < end) {
                this.set(i, arr[o]);
                ++i;
                ++o;
            }
            return len2;
        }

        public void fill(int fromIndex, int toIndex, long val) {
            if (!(val <= INSTANCE.maxValue(this.getBitsPerValue()))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(fromIndex <= toIndex)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            for (int i = fromIndex; i < toIndex; ++i) {
                this.set(i, val);
            }
        }

        public void clear() {
            this.fill(0, this.size(), 0L);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$MutableImpl;", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Mutable;", "valueCount", "", "bitsPerValue", "<init>", "(II)V", "getValueCount", "()I", "getBitsPerValue", "size", "toString", "", "core"})
    @SourceDebugExtension(value={"SMAP\nPackedInts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackedInts.kt\norg/gnit/lucenekmp/util/packed/PackedInts$MutableImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,850:1\n1#2:851\n*E\n"})
    public static abstract class MutableImpl
    extends Mutable {
        private final int valueCount;
        private final int bitsPerValue;

        protected MutableImpl(int valueCount, int bitsPerValue) {
            this.valueCount = valueCount;
            this.bitsPerValue = bitsPerValue;
            if (!(this.getBitsPerValue() > 0 && this.getBitsPerValue() <= 64)) {
                boolean bl = false;
                String string = "bitsPerValue=" + this.getBitsPerValue();
                throw new IllegalArgumentException(string.toString());
            }
        }

        protected final int getValueCount() {
            return this.valueCount;
        }

        @Override
        public int getBitsPerValue() {
            return this.bitsPerValue;
        }

        @Override
        public int size() {
            return this.valueCount;
        }

        @NotNull
        public String toString() {
            return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(valueCount=" + this.valueCount + ",bitsPerValue=" + this.getBitsPerValue() + ")";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J(\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$NullReader;", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "arr", "", "off", "len", "size", "ramBytesUsed", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nPackedInts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackedInts.kt\norg/gnit/lucenekmp/util/packed/PackedInts$NullReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,850:1\n1#2:851\n*E\n"})
    public static final class NullReader
    extends Reader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int valueCount;
        @NotNull
        private static final NullReader DEFAULT_PACKED_LONG_VALUES_PAGE_SIZE = new NullReader(256);

        private NullReader(int valueCount) {
            this.valueCount = valueCount;
        }

        @Override
        public long get(int index) {
            return 0L;
        }

        @Override
        public int get(int index, @NotNull long[] arr, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
            int len2 = 0;
            len2 = len;
            if (!(len2 > 0)) {
                boolean bl = false;
                String string = "len must be > 0 (got " + len2 + ")";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(index >= 0 && index < this.valueCount)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            len2 = Math.min(len2, this.valueCount - index);
            ArraysKt.fill((long[])arr, (long)0L, (int)off, (int)(off + len2));
            return len2;
        }

        @Override
        public int size() {
            return this.valueCount;
        }

        @Override
        public long ramBytesUsed() {
            return this.valueCount == 256 ? 0L : RamUsageEstimator.Companion.alignObjectSize(12L);
        }

        public /* synthetic */ NullReader(int valueCount, DefaultConstructorMarker $constructor_marker) {
            this(valueCount);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$NullReader$Companion;", "", "<init>", "()V", "DEFAULT_PACKED_LONG_VALUES_PAGE_SIZE", "Lorg/gnit/lucenekmp/util/packed/PackedInts$NullReader;", "forCount", "valueCount", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final NullReader forCount(int valueCount) {
                if (valueCount == 256) {
                    return DEFAULT_PACKED_LONG_VALUES_PAGE_SIZE;
                }
                return new NullReader(valueCount, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J(\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H&\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "Lorg/gnit/lucenekmp/util/Accountable;", "<init>", "()V", "get", "", "index", "", "arr", "", "off", "len", "size", "core"})
    @SourceDebugExtension(value={"SMAP\nPackedInts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackedInts.kt\norg/gnit/lucenekmp/util/packed/PackedInts$Reader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,850:1\n1#2:851\n*E\n"})
    public static abstract class Reader
    implements Accountable {
        public abstract long get(int var1);

        public int get(int index, @NotNull long[] arr, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
            if (!(len > 0)) {
                boolean $i$a$-require-PackedInts$Reader$get$22 = false;
                String $i$a$-require-PackedInts$Reader$get$22 = "len must be > 0 (got " + len + ")";
                throw new IllegalArgumentException($i$a$-require-PackedInts$Reader$get$22.toString());
            }
            if (!(index >= 0 && index < this.size())) {
                String $i$a$-require-PackedInts$Reader$get$22 = "Failed requirement.";
                throw new IllegalArgumentException($i$a$-require-PackedInts$Reader$get$22.toString());
            }
            if (!(off + len <= arr.length)) {
                String $i$a$-require-PackedInts$Reader$get$22 = "Failed requirement.";
                throw new IllegalArgumentException($i$a$-require-PackedInts$Reader$get$22.toString());
            }
            int gets = Math.min(this.size() - index, len);
            int i = index;
            int o = off;
            int end = index + gets;
            while (i < end) {
                arr[o] = this.get(i);
                ++i;
                ++o;
            }
            return gets;
        }

        public abstract int size();

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return Accountable.super.getChildResources();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H&J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$ReaderImpl;", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "valueCount", "", "<init>", "(I)V", "getValueCount", "()I", "get", "", "index", "size", "core"})
    public static abstract class ReaderImpl
    extends Reader {
        private final int valueCount;

        protected ReaderImpl(int valueCount) {
            this.valueCount = valueCount;
        }

        protected final int getValueCount() {
            return this.valueCount;
        }

        @Override
        public abstract long get(int var1);

        @Override
        public int size() {
            return this.valueCount;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0002\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\n\u001a\u00020\u0006H&J\b\u0010\u000b\u001a\u00020\u0006H&R\u0012\u0010\u0007\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$ReaderIterator;", "", "next", "", "Lorg/gnit/lucenekmp/util/LongsRef;", "count", "", "bitsPerValue", "getBitsPerValue", "()I", "size", "ord", "core"})
    public static interface ReaderIterator {
        public long next() throws IOException;

        @NotNull
        public LongsRef next(int var1) throws IOException;

        public int getBitsPerValue();

        public int size();

        public int ord();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$ReaderIteratorImpl;", "Lorg/gnit/lucenekmp/util/packed/PackedInts$ReaderIterator;", "valueCount", "", "bitsPerValue", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "<init>", "(IILorg/gnit/lucenekmp/store/DataInput;)V", "getValueCount", "()I", "getBitsPerValue", "getIn", "()Lorg/gnit/lucenekmp/store/DataInput;", "next", "", "size", "core"})
    public static abstract class ReaderIteratorImpl
    implements ReaderIterator {
        private final int valueCount;
        private final int bitsPerValue;
        @NotNull
        private final DataInput in;

        protected ReaderIteratorImpl(int valueCount, int bitsPerValue, @NotNull DataInput in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.valueCount = valueCount;
            this.bitsPerValue = bitsPerValue;
            this.in = in;
        }

        public final int getValueCount() {
            return this.valueCount;
        }

        @Override
        public int getBitsPerValue() {
            return this.bitsPerValue;
        }

        @NotNull
        public final DataInput getIn() {
            return this.in;
        }

        @Override
        public long next() throws IOException {
            LongsRef nextValues = this.next(1);
            if (!(nextValues.getLength() > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long result = nextValues.getLongs()[nextValues.getOffset()];
            nextValues.setOffset(nextValues.getOffset() + 1);
            nextValues.getOffset();
            nextValues.setLength(nextValues.getLength() + -1);
            nextValues.getLength();
            return result;
        }

        @Override
        public int size() {
            return this.valueCount;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Format.values().length];
            try {
                nArray[Format.PACKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u0013H&J\b\u0010\u0017\u001a\u00020\u0005H&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedInts$Writer;", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "valueCount", "", "bitsPerValue", "<init>", "(Lorg/gnit/lucenekmp/store/DataOutput;II)V", "getOut", "()Lorg/gnit/lucenekmp/store/DataOutput;", "getValueCount", "()I", "getBitsPerValue", "format", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "getFormat", "()Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "add", "", "v", "", "finish", "ord", "core"})
    public static abstract class Writer {
        @NotNull
        private final DataOutput out;
        private final int valueCount;
        private final int bitsPerValue;

        protected Writer(@NotNull DataOutput out, int valueCount, int bitsPerValue) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            if (!(bitsPerValue <= 64)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(valueCount >= 0 || valueCount == -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.out = out;
            this.valueCount = valueCount;
            this.bitsPerValue = bitsPerValue;
        }

        @NotNull
        protected final DataOutput getOut() {
            return this.out;
        }

        protected final int getValueCount() {
            return this.valueCount;
        }

        protected final int getBitsPerValue() {
            return this.bitsPerValue;
        }

        @NotNull
        protected abstract Format getFormat();

        public abstract void add(long var1) throws IOException;

        public final int bitsPerValue() {
            return this.bitsPerValue;
        }

        public abstract void finish() throws IOException;

        public abstract int ord();
    }
}

