/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.LongValues;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0003\u001d\u001e\u001fB7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\n\u0010\u001b\u001a\u00060\u001cR\u00020\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "Lorg/gnit/lucenekmp/util/LongValues;", "Lorg/gnit/lucenekmp/util/Accountable;", "pageShift", "", "pageMask", "values", "", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "size", "", "ramBytesUsed", "<init>", "(II[Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;JJ)V", "getPageShift", "()I", "getPageMask", "getValues", "()[Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "[Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "decodeBlock", "block", "dest", "", "get", "element", "index", "iterator", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "Iterator", "Builder", "Companion", "core"})
public class PackedLongValues
extends LongValues
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int pageShift;
    private final int pageMask;
    @NotNull
    private final PackedInts.Reader[] values;
    private final long size;
    private final long ramBytesUsed;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(PackedLongValues.class));
    public static final int DEFAULT_PAGE_SIZE = 256;
    public static final int MIN_PAGE_SIZE = 64;
    public static final int MAX_PAGE_SIZE = 0x100000;

    public PackedLongValues(int pageShift, int pageMask, @NotNull PackedInts.Reader[] values2, long size2, long ramBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        this.pageShift = pageShift;
        this.pageMask = pageMask;
        this.values = values2;
        this.size = size2;
        this.ramBytesUsed = ramBytesUsed;
    }

    public final int getPageShift() {
        return this.pageShift;
    }

    public final int getPageMask() {
        return this.pageMask;
    }

    @NotNull
    public final PackedInts.Reader[] getValues() {
        return this.values;
    }

    public final long size() {
        return this.size;
    }

    public int decodeBlock(int block2, @NotNull long[] dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        PackedInts.Reader vals = this.values[block2];
        int size2 = vals.size();
        for (int k = 0; k < size2; k += vals.get(k, dest, k, size2 - k)) {
        }
        return size2;
    }

    public long get(int block2, int element) {
        return this.values[block2].get(element);
    }

    @Override
    public long get(long index) {
        if (!(index >= 0L && index < this.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int block2 = (int)(index >> this.pageShift);
        int element = (int)(index & (long)this.pageMask);
        return this.get(block2, element);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @NotNull
    public final Iterator iterator() {
        return new Iterator();
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 92\u00020\u0001:\u00019B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020\u0016H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0016J\u0006\u00102\u001a\u000203J\b\u00104\u001a\u000203H\u0002J(\u00104\u001a\u0002032\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u00107\u001a\u0002032\u0006\u00108\u001a\u00020\u0003H\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010#\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0018\"\u0004\b%\u0010\u001aR\u001a\u0010&\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\n\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\n\"\u0004\b,\u0010)\u00a8\u0006:"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Builder;", "Lorg/gnit/lucenekmp/util/Accountable;", "pageSize", "", "acceptableOverheadRatio", "", "<init>", "(IF)V", "pageShift", "getPageShift", "()I", "pageMask", "getPageMask", "getAcceptableOverheadRatio", "()F", "pending", "", "getPending", "()[J", "setPending", "([J)V", "size", "", "getSize", "()J", "setSize", "(J)V", "values", "", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "getValues", "()[Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "setValues", "([Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;)V", "[Lorg/gnit/lucenekmp/util/packed/PackedInts$Reader;", "ramBytesUsed", "getRamBytesUsed", "setRamBytesUsed", "valuesOff", "getValuesOff", "setValuesOff", "(I)V", "pendingOff", "getPendingOff", "setPendingOff", "build", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "baseRamBytesUsed", "add", "l", "finish", "", "pack", "numValues", "block", "grow", "newBlockCount", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nPackedLongValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackedLongValues.kt\norg/gnit/lucenekmp/util/packed/PackedLongValues$Builder\n+ 2 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n759#2,2:286\n180#2,5:289\n1#3:288\n*S KotlinDebug\n*F\n+ 1 PackedLongValues.kt\norg/gnit/lucenekmp/util/packed/PackedLongValues$Builder\n*L\n136#1:286,2\n216#1:289,5\n*E\n"})
    public static class Builder
    implements Accountable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int pageShift;
        private final int pageMask;
        private final float acceptableOverheadRatio;
        @Nullable
        private long[] pending;
        private long size;
        @NotNull
        private PackedInts.Reader[] values;
        private long ramBytesUsed;
        private int valuesOff;
        private int pendingOff;
        private static final int INITIAL_PAGE_COUNT = 16;
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(Builder.class));

        public Builder(int pageSize, float acceptableOverheadRatio) {
            this.pageShift = PackedInts.INSTANCE.checkBlockSize(pageSize, 64, 0x100000);
            this.pageMask = pageSize - 1;
            this.acceptableOverheadRatio = acceptableOverheadRatio;
            this.values = new PackedInts.Reader[16];
            this.pending = new long[pageSize];
            this.valuesOff = 0;
            this.pendingOff = 0;
            this.size = 0L;
            long l = this.baseRamBytesUsed();
            Intrinsics.checkNotNull((Object)this.pending);
            this.ramBytesUsed = l + RamUsageEstimator.Companion.sizeOf(this.pending) + RamUsageEstimator.Companion.shallowSizeOf((Object)this.values);
        }

        public final int getPageShift() {
            return this.pageShift;
        }

        public final int getPageMask() {
            return this.pageMask;
        }

        public final float getAcceptableOverheadRatio() {
            return this.acceptableOverheadRatio;
        }

        @Nullable
        public final long[] getPending() {
            return this.pending;
        }

        public final void setPending(@Nullable long[] lArray) {
            this.pending = lArray;
        }

        public final long getSize() {
            return this.size;
        }

        public final void setSize(long l) {
            this.size = l;
        }

        @NotNull
        public final PackedInts.Reader[] getValues() {
            return this.values;
        }

        public final void setValues(@NotNull PackedInts.Reader[] readerArray) {
            Intrinsics.checkNotNullParameter((Object)readerArray, (String)"<set-?>");
            this.values = readerArray;
        }

        public final long getRamBytesUsed() {
            return this.ramBytesUsed;
        }

        public final void setRamBytesUsed(long l) {
            this.ramBytesUsed = l;
        }

        public final int getValuesOff() {
            return this.valuesOff;
        }

        public final void setValuesOff(int n) {
            this.valuesOff = n;
        }

        public final int getPendingOff() {
            return this.pendingOff;
        }

        public final void setPendingOff(int n) {
            this.pendingOff = n;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public PackedLongValues build() {
            void from$iv;
            this.finish();
            this.pending = null;
            ArrayUtil.Companion companion = ArrayUtil.Companion;
            PackedInts.Reader[] readerArray = this.values;
            boolean bl = false;
            int to$iv = this.valuesOff;
            boolean $i$f$copyOfSubArray = false;
            int subLength$iv = to$iv - from$iv;
            int n = 0;
            PackedInts.Reader[] readerArray2 = new PackedInts.Reader[subLength$iv];
            while (n < subLength$iv) {
                void array$iv;
                int n2 = n++;
                readerArray2[n2] = array$iv[from$iv + n2];
            }
            PackedInts.Reader[] values2 = readerArray2;
            long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOfAccountableNullable(values2);
            return new PackedLongValues(this.pageShift, this.pageMask, values2, this.size, ramBytesUsed);
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        public final long size() {
            return this.size;
        }

        @NotNull
        public final Builder add(long l) {
            if (this.pending == null) {
                boolean bl = false;
                String string = "Cannot be reused after build()";
                throw new IllegalStateException(string.toString());
            }
            long[] buf = this.pending;
            if (this.pendingOff == buf.length) {
                if (this.values.length == this.valuesOff) {
                    int newLength = ArrayUtil.Companion.oversize(this.valuesOff + 1, 8);
                    this.grow(newLength);
                }
                this.pack();
            }
            int n = this.pendingOff;
            this.pendingOff = n + 1;
            buf[n] = l;
            ++this.size;
            return this;
        }

        public final void finish() {
            if (this.pendingOff > 0) {
                if (this.values.length == this.valuesOff) {
                    this.grow(this.valuesOff + 1);
                }
                this.pack();
            }
        }

        private final void pack() {
            if (this.pending == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            long[] buf = this.pending;
            this.pack(buf, this.pendingOff, this.valuesOff, this.acceptableOverheadRatio);
            this.ramBytesUsed += this.values[this.valuesOff].ramBytesUsed();
            ++this.valuesOff;
            this.pendingOff = 0;
        }

        public void pack(@NotNull long[] values2, int numValues, int block2, float acceptableOverheadRatio) {
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            if (!(numValues > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long minValue = values2[0];
            long maxValue = values2[0];
            for (int i = 1; i < numValues; ++i) {
                minValue = Math.min(minValue, values2[i]);
                maxValue = Math.max(maxValue, values2[i]);
            }
            if (minValue == 0L && maxValue == 0L) {
                this.values[block2] = PackedInts.NullReader.Companion.forCount(numValues);
            } else {
                int bitsRequired = minValue < 0L ? 64 : PackedInts.INSTANCE.bitsRequired(maxValue);
                PackedInts.Mutable mutable = PackedInts.INSTANCE.getMutable(numValues, bitsRequired, acceptableOverheadRatio);
                for (int i = 0; i < numValues; i += mutable.set(i, values2, i, numValues - i)) {
                }
                this.values[block2] = mutable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void grow(int newBlockCount) {
            void array$iv;
            int newLength$iv;
            this.ramBytesUsed -= RamUsageEstimator.Companion.shallowSizeOf((Object)this.values);
            ArrayUtil.Companion companion = ArrayUtil.Companion;
            PackedInts.Reader[] readerArray = this.values;
            int n = newBlockCount;
            Builder builder = this;
            boolean $i$f$growExact = false;
            if (newLength$iv < ((void)array$iv).length) {
                throw new IndexOutOfBoundsException("newLength (" + newLength$iv + ") < array.size (" + ((void)array$iv).length + ")");
            }
            PackedInts.Reader[] readerArray2 = new PackedInts.Reader[newLength$iv];
            for (int i = 0; i < newLength$iv; ++i) {
                int n2 = i;
                readerArray2[n2] = n2 < ((void)array$iv).length ? array$iv[n2] : null;
            }
            PackedInts.Reader[] newArray$iv = readerArray2;
            builder.values = newArray$iv;
            this.ramBytesUsed += RamUsageEstimator.Companion.shallowSizeOf((Object)this.values);
        }

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return Accountable.super.getChildResources();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Builder$Companion;", "", "<init>", "()V", "INITIAL_PAGE_COUNT", "", "BASE_RAM_BYTES_USED", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "DEFAULT_PAGE_SIZE", "", "MIN_PAGE_SIZE", "MAX_PAGE_SIZE", "packedBuilder", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Builder;", "pageSize", "acceptableOverheadRatio", "", "deltaPackedBuilder", "monotonicBuilder", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Builder packedBuilder(int pageSize, float acceptableOverheadRatio) {
            return new Builder(pageSize, acceptableOverheadRatio);
        }

        @NotNull
        public final Builder packedBuilder(float acceptableOverheadRatio) {
            return this.packedBuilder(256, acceptableOverheadRatio);
        }

        @NotNull
        public final Builder deltaPackedBuilder(int pageSize, float acceptableOverheadRatio) {
            return new Builder(pageSize, acceptableOverheadRatio);
        }

        @NotNull
        public final Builder deltaPackedBuilder(float acceptableOverheadRatio) {
            return this.deltaPackedBuilder(256, acceptableOverheadRatio);
        }

        @NotNull
        public final Builder monotonicBuilder(int pageSize, float acceptableOverheadRatio) {
            return new Builder(pageSize, acceptableOverheadRatio);
        }

        @NotNull
        public final Builder monotonicBuilder(float acceptableOverheadRatio) {
            return this.monotonicBuilder(256, acceptableOverheadRatio);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "", "<init>", "(Lorg/gnit/lucenekmp/util/packed/PackedLongValues;)V", "currentValues", "", "getCurrentValues", "()[J", "vOff", "", "getVOff", "()I", "setVOff", "(I)V", "pOff", "getPOff", "setPOff", "currentCount", "getCurrentCount", "setCurrentCount", "fillBlock", "", "hasNext", "", "next", "", "core"})
    public final class Iterator {
        @NotNull
        private final long[] currentValues;
        private int vOff;
        private int pOff;
        private int currentCount;

        public Iterator() {
            this.currentValues = new long[Math.min((int)PackedLongValues.this.size, PackedLongValues.this.getPageMask() + 1)];
            this.vOff = this.pOff;
            this.fillBlock();
        }

        @NotNull
        public final long[] getCurrentValues() {
            return this.currentValues;
        }

        public final int getVOff() {
            return this.vOff;
        }

        public final void setVOff(int n) {
            this.vOff = n;
        }

        public final int getPOff() {
            return this.pOff;
        }

        public final void setPOff(int n) {
            this.pOff = n;
        }

        public final int getCurrentCount() {
            return this.currentCount;
        }

        public final void setCurrentCount(int n) {
            this.currentCount = n;
        }

        private final void fillBlock() {
            if (this.vOff == PackedLongValues.this.getValues().length) {
                this.currentCount = 0;
            } else {
                this.currentCount = PackedLongValues.this.decodeBlock(this.vOff, this.currentValues);
                if (!(this.currentCount > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        public final boolean hasNext() {
            return this.pOff < this.currentCount;
        }

        public final long next() {
            if (!this.hasNext()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n = this.pOff;
            this.pOff = n + 1;
            long result = this.currentValues[n];
            if (this.pOff == this.currentCount) {
                ++this.vOff;
                this.pOff = 0;
                this.fillBlock();
            }
            return result;
        }
    }
}

