/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.packed.BulkOperation;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020+H\u0016J\b\u0010/\u001a\u00020+H\u0002J\b\u00100\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\"\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\"\"\u0004\b)\u0010&\u00a8\u00061"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedWriter;", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Writer;", "format", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "valueCount", "", "bitsPerValue", "mem", "<init>", "(Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;Lorg/gnit/lucenekmp/store/DataOutput;III)V", "getFormat", "()Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "finished", "", "getFinished", "()Z", "setFinished", "(Z)V", "encoder", "Lorg/gnit/lucenekmp/util/packed/BulkOperation;", "getEncoder", "()Lorg/gnit/lucenekmp/util/packed/BulkOperation;", "nextBlocks", "", "getNextBlocks", "()[B", "nextValues", "", "getNextValues", "()[J", "iterations", "getIterations", "()I", "off", "getOff", "setOff", "(I)V", "written", "getWritten", "setWritten", "add", "", "v", "", "finish", "flush", "ord", "core"})
public final class PackedWriter
extends PackedInts.Writer {
    @NotNull
    private final PackedInts.Format format;
    private boolean finished;
    @NotNull
    private final BulkOperation encoder;
    @NotNull
    private final byte[] nextBlocks;
    @NotNull
    private final long[] nextValues;
    private final int iterations;
    private int off;
    private int written;

    public PackedWriter(@NotNull PackedInts.Format format, @NotNull DataOutput out, int valueCount, int bitsPerValue, int mem) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super(out, valueCount, bitsPerValue);
        this.format = format;
        this.encoder = BulkOperation.Companion.of(this.getFormat(), bitsPerValue);
        this.iterations = this.encoder.computeIterations(valueCount, mem);
        this.nextBlocks = new byte[this.iterations * this.encoder.byteBlockCount()];
        this.nextValues = new long[this.iterations * this.encoder.byteValueCount()];
    }

    @Override
    @NotNull
    protected PackedInts.Format getFormat() {
        return this.format;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public final void setFinished(boolean bl) {
        this.finished = bl;
    }

    @NotNull
    public final BulkOperation getEncoder() {
        return this.encoder;
    }

    @NotNull
    public final byte[] getNextBlocks() {
        return this.nextBlocks;
    }

    @NotNull
    public final long[] getNextValues() {
        return this.nextValues;
    }

    public final int getIterations() {
        return this.iterations;
    }

    public final int getOff() {
        return this.off;
    }

    public final void setOff(int n) {
        this.off = n;
    }

    public final int getWritten() {
        return this.written;
    }

    public final void setWritten(int n) {
        this.written = n;
    }

    @Override
    public void add(long v) throws IOException {
        if (!(PackedInts.INSTANCE.unsignedBitsRequired(v) <= this.getBitsPerValue())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!this.finished)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getValueCount() != -1 && this.written >= this.getValueCount()) {
            throw new EOFException("Writing past end of stream");
        }
        int n = this.off;
        this.off = n + 1;
        this.nextValues[n] = v;
        if (this.off == this.nextValues.length) {
            this.flush();
        }
        ++this.written;
    }

    @Override
    public void finish() throws IOException {
        if (!(!this.finished)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getValueCount() != -1) {
            while (this.written < this.getValueCount()) {
                this.add(0L);
            }
        }
        this.flush();
        this.finished = true;
    }

    private final void flush() throws IOException {
        this.encoder.encode(this.nextValues, 0, this.nextBlocks, 0, this.iterations);
        int blockCount = (int)this.getFormat().byteCount(PackedInts.INSTANCE.getVERSION_CURRENT(), this.off, this.getBitsPerValue());
        this.getOut().writeBytes(this.nextBlocks, blockCount);
        ArraysKt.fill$default((long[])this.nextValues, (long)0L, (int)0, (int)0, (int)6, null);
        this.off = 0;
    }

    @Override
    public int ord() {
        return this.written - 1;
    }
}

