/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.queryparser.charstream;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.gnit.lucenekmp.jdkport.Reader;
import org.gnit.lucenekmp.jdkport.StringExtKt;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.jdkport.UncheckedIOException;
import org.gnit.lucenekmp.queryparser.charstream.CharStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020 H\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\rH\u0016J\b\u0010*\u001a\u00020\"H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R\u001a\u0010\u001b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u0005R\u0014\u0010+\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000fR\u0014\u0010-\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000fR\u0014\u0010/\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u000fR\u0014\u00101\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u000f\u00a8\u00064"}, d2={"Lorg/gnit/lucenekmp/queryparser/charstream/FastCharStream;", "Lorg/gnit/lucenekmp/queryparser/charstream/CharStream;", "r", "Lorg/gnit/lucenekmp/jdkport/Reader;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Reader;)V", "buffer", "", "getBuffer", "()[C", "setBuffer", "([C)V", "bufferLength", "", "getBufferLength", "()I", "setBufferLength", "(I)V", "bufferPosition", "getBufferPosition", "setBufferPosition", "tokenStart", "getTokenStart", "setTokenStart", "bufferStart", "getBufferStart", "setBufferStart", "input", "getInput", "()Lorg/gnit/lucenekmp/jdkport/Reader;", "setInput", "readChar", "", "refill", "", "BeginToken", "backup", "amount", "GetImage", "", "GetSuffix", "len", "Done", "endColumn", "getEndColumn", "endLine", "getEndLine", "beginColumn", "getBeginColumn", "beginLine", "getBeginLine", "Companion", "queryparser"})
public final class FastCharStream
implements CharStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private char[] buffer;
    private int bufferLength;
    private int bufferPosition;
    private int tokenStart;
    private int bufferStart;
    @NotNull
    private Reader input;
    @NotNull
    private static final IOException READ_PAST_EOF = new IOException("Read past EOF.");

    public FastCharStream(@NotNull Reader r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.input = r;
    }

    @Nullable
    public final char[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@Nullable char[] cArray) {
        this.buffer = cArray;
    }

    public final int getBufferLength() {
        return this.bufferLength;
    }

    public final void setBufferLength(int n) {
        this.bufferLength = n;
    }

    public final int getBufferPosition() {
        return this.bufferPosition;
    }

    public final void setBufferPosition(int n) {
        this.bufferPosition = n;
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    public final void setTokenStart(int n) {
        this.tokenStart = n;
    }

    public final int getBufferStart() {
        return this.bufferStart;
    }

    public final void setBufferStart(int n) {
        this.bufferStart = n;
    }

    @NotNull
    public final Reader getInput() {
        return this.input;
    }

    public final void setInput(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"<set-?>");
        this.input = reader;
    }

    @Override
    public char readChar() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        Intrinsics.checkNotNull((Object)this.buffer);
        int n = this.bufferPosition;
        this.bufferPosition = n + 1;
        return this.buffer[n];
    }

    private final void refill() throws IOException {
        int newPosition = this.bufferLength - this.tokenStart;
        if (this.tokenStart == 0) {
            if (this.buffer == null) {
                this.buffer = new char[2048];
            } else {
                Intrinsics.checkNotNull((Object)this.buffer);
                if (this.bufferLength == this.buffer.length) {
                    Intrinsics.checkNotNull((Object)this.buffer);
                    char[] newBuffer = new char[this.buffer.length * 2];
                    Intrinsics.checkNotNull((Object)this.buffer);
                    System.INSTANCE.arraycopy(this.buffer, 0, newBuffer, 0, this.bufferLength);
                    this.buffer = newBuffer;
                }
            }
        } else {
            Intrinsics.checkNotNull((Object)this.buffer);
            Intrinsics.checkNotNull((Object)this.buffer);
            System.INSTANCE.arraycopy(this.buffer, this.tokenStart, this.buffer, 0, newPosition);
        }
        this.bufferLength = newPosition;
        this.bufferPosition = newPosition;
        this.bufferStart += this.tokenStart;
        this.tokenStart = 0;
        Intrinsics.checkNotNull((Object)this.buffer);
        Intrinsics.checkNotNull((Object)this.buffer);
        int charsRead = this.input.read(this.buffer, newPosition, this.buffer.length - newPosition);
        if (charsRead == -1) {
            throw READ_PAST_EOF;
        }
        this.bufferLength += charsRead;
    }

    @Override
    public char BeginToken() throws IOException {
        this.tokenStart = this.bufferPosition;
        return this.readChar();
    }

    @Override
    public void backup(int amount) {
        this.bufferPosition -= amount;
    }

    @Override
    @NotNull
    public String GetImage() {
        Intrinsics.checkNotNull((Object)this.buffer);
        return StringExtKt.fromCharArray((StringCompanionObject)StringCompanionObject.INSTANCE, (char[])this.buffer, (int)this.tokenStart, (int)(this.bufferPosition - this.tokenStart));
    }

    @Override
    @NotNull
    public char[] GetSuffix(int len) {
        char[] value = new char[len];
        Intrinsics.checkNotNull((Object)this.buffer);
        System.INSTANCE.arraycopy(this.buffer, this.bufferPosition - len, value, 0, len);
        return value;
    }

    @Override
    public void Done() {
        try {
            this.input.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int getEndColumn() {
        return this.bufferStart + this.bufferPosition;
    }

    @Override
    public int getEndLine() {
        return 1;
    }

    @Override
    public int getBeginColumn() {
        return this.bufferStart + this.tokenStart;
    }

    @Override
    public int getBeginLine() {
        return 1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/queryparser/charstream/FastCharStream$Companion;", "", "<init>", "()V", "READ_PAST_EOF", "Ljava/io/IOException;", "Lokio/IOException;", "queryparser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

