/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.queryparser.classic;

import dev.scottpierce.envvar.EnvVar;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.queryparser.classic.Token;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0014\b\u0016\u0018\u0000 #2\u00060\u0001j\u0002`\u0002:\u0001#B-\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bB\t\b\u0016\u00a2\u0006\u0004\b\n\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\n\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/queryparser/classic/ParseException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "currentTokenVal", "Lorg/gnit/lucenekmp/queryparser/classic/Token;", "expectedTokenSequencesVal", "", "", "tokenImageVal", "", "<init>", "(Lorg/gnit/lucenekmp/queryparser/classic/Token;[[I[Ljava/lang/String;)V", "()V", "message", "(Ljava/lang/String;)V", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "currentToken", "getCurrentToken", "()Lorg/gnit/lucenekmp/queryparser/classic/Token;", "setCurrentToken", "(Lorg/gnit/lucenekmp/queryparser/classic/Token;)V", "expectedTokenSequences", "getExpectedTokenSequences", "()[[I", "setExpectedTokenSequences", "([[I)V", "[[I", "tokenImage", "getTokenImage", "()[Ljava/lang/String;", "setTokenImage", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "Companion", "queryparser"})
public class ParseException
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    private static final long serialVersionUID = 1L;
    @NotNull
    private static String EOL;

    public ParseException(@NotNull Token currentTokenVal, @NotNull int[][] expectedTokenSequencesVal, @NotNull String[] tokenImageVal) {
        Intrinsics.checkNotNullParameter((Object)currentTokenVal, (String)"currentTokenVal");
        Intrinsics.checkNotNullParameter((Object)expectedTokenSequencesVal, (String)"expectedTokenSequencesVal");
        Intrinsics.checkNotNullParameter((Object)tokenImageVal, (String)"tokenImageVal");
        super(ParseException.Companion.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
        this.currentToken = currentTokenVal;
        this.setExpectedTokenSequences(expectedTokenSequencesVal);
        this.setTokenImage(tokenImageVal);
    }

    public ParseException() {
    }

    public ParseException(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message);
    }

    public ParseException(@NotNull String message, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        super(message, cause);
    }

    @Nullable
    public final Token getCurrentToken() {
        return this.currentToken;
    }

    public final void setCurrentToken(@Nullable Token token) {
        this.currentToken = token;
    }

    @NotNull
    public final int[][] getExpectedTokenSequences() {
        if (this.expectedTokenSequences != null) {
            return this.expectedTokenSequences;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"expectedTokenSequences");
        return null;
    }

    public final void setExpectedTokenSequences(@NotNull int[][] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.expectedTokenSequences = nArray;
    }

    @NotNull
    public final String[] getTokenImage() {
        if (this.tokenImage != null) {
            return this.tokenImage;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tokenImage");
        return null;
    }

    public final void setTokenImage(@NotNull String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
        this.tokenImage = stringArray;
    }

    static {
        String string = EnvVar.INSTANCE.get("line.separator");
        if (string == null) {
            string = "\n";
        }
        EOL = string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/queryparser/classic/ParseException$Companion;", "", "<init>", "()V", "serialVersionUID", "", "EOL", "", "getEOL", "()Ljava/lang/String;", "setEOL", "(Ljava/lang/String;)V", "initialise", "currentToken", "Lorg/gnit/lucenekmp/queryparser/classic/Token;", "expectedTokenSequences", "", "", "tokenImage", "(Lorg/gnit/lucenekmp/queryparser/classic/Token;[[I[Ljava/lang/String;)Ljava/lang/String;", "add_escapes", "str", "queryparser"})
    @SourceDebugExtension(value={"SMAP\nParseException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParseException.kt\norg/gnit/lucenekmp/queryparser/classic/ParseException$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final String getEOL() {
            return EOL;
        }

        protected final void setEOL(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            EOL = string;
        }

        private final String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
            int n;
            StringBuilder expected = new StringBuilder();
            int maxSize = 0;
            int n2 = ((Object[])expectedTokenSequences).length;
            for (int i = 0; i < n2; ++i) {
                if (maxSize < expectedTokenSequences[i].length) {
                    maxSize = expectedTokenSequences[i].length;
                }
                n = expectedTokenSequences[i].length;
                for (int j = 0; j < n; ++j) {
                    expected.append(tokenImage[expectedTokenSequences[i][j]]).append(' ');
                }
                if (expectedTokenSequences[i][expectedTokenSequences[i].length - 1] != 0) {
                    expected.append("...");
                }
                expected.append(this.getEOL()).append("    ");
            }
            Object retval = "Encountered \"";
            Token token = currentToken.getNext();
            Intrinsics.checkNotNull((Object)token);
            Token tok = token;
            n = maxSize;
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    retval = (String)retval + " ";
                }
                if (tok.getKind() == 0) {
                    retval = (String)retval + tokenImage[0];
                    break;
                }
                retval = (String)retval + " " + tokenImage[tok.getKind()];
                retval = (String)retval + " \"";
                String string = tok.getImage();
                Intrinsics.checkNotNull((Object)string);
                retval = (String)retval + this.add_escapes(string);
                retval = (String)retval + " \"";
                Intrinsics.checkNotNull((Object)tok.getNext());
            }
            if (currentToken.getNext() != null) {
                Token token2 = currentToken.getNext();
                Intrinsics.checkNotNull((Object)token2);
                int n3 = token2.getBeginLine();
                Token token3 = currentToken.getNext();
                Intrinsics.checkNotNull((Object)token3);
                retval = (String)retval + "\" at line " + n3 + ", column " + token3.getBeginColumn();
            }
            retval = (String)retval + "." + this.getEOL();
            if (!(((Object[])expectedTokenSequences).length == 0)) {
                retval = (String)retval + (((Object[])expectedTokenSequences).length == 1 ? "Was expecting:" + this.getEOL() + "    " : "Was expecting one of:" + this.getEOL() + "    ");
                retval = (String)retval + expected;
            }
            return retval;
        }

        @NotNull
        public final String add_escapes(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            StringBuilder retval = new StringBuilder();
            char ch = '\u0000';
            int n = str.length();
            block10: for (int i = 0; i < n; ++i) {
                switch (str.charAt(i)) {
                    case '\b': {
                        retval.append("\\b");
                        continue block10;
                    }
                    case '\t': {
                        retval.append("\\t");
                        continue block10;
                    }
                    case '\n': {
                        retval.append("\\n");
                        continue block10;
                    }
                    case '\f': {
                        retval.append("\\f");
                        continue block10;
                    }
                    case '\r': {
                        retval.append("\\r");
                        continue block10;
                    }
                    case '\"': {
                        retval.append("\\\"");
                        continue block10;
                    }
                    case '\'': {
                        retval.append("\\'");
                        continue block10;
                    }
                    case '\\': {
                        retval.append("\\\\");
                        continue block10;
                    }
                    default: {
                        StringBuilder stringBuilder;
                        char c;
                        char it = c = str.charAt(i);
                        boolean bl = false;
                        ch = it;
                        if (c < ' ' || ch > '~') {
                            String s = "0000" + IntExtKt.toStringWithRadix((IntCompanionObject)IntCompanionObject.INSTANCE, (int)CharsKt.digitToInt((char)ch, (int)16), (int)16);
                            String string = s.substring(s.length() - 4, s.length());
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            stringBuilder = retval.append("\\u" + string);
                            continue block10;
                        }
                        stringBuilder = retval.append(ch);
                    }
                }
            }
            String string = retval.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

