/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.queryparser.classic;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.gnit.lucenekmp.analysis.Analyzer;
import org.gnit.lucenekmp.document.DateTools;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.jdkport.Locale;
import org.gnit.lucenekmp.jdkport.Reader;
import org.gnit.lucenekmp.jdkport.StringExtKt;
import org.gnit.lucenekmp.jdkport.StringReader;
import org.gnit.lucenekmp.queryparser.charstream.CharStream;
import org.gnit.lucenekmp.queryparser.charstream.FastCharStream;
import org.gnit.lucenekmp.queryparser.classic.ParseException;
import org.gnit.lucenekmp.queryparser.classic.QueryParser;
import org.gnit.lucenekmp.queryparser.classic.Token;
import org.gnit.lucenekmp.queryparser.classic.TokenMgrError;
import org.gnit.lucenekmp.queryparser.flexible.standard.CommonQueryParserConfiguration;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BoostQuery;
import org.gnit.lucenekmp.search.FuzzyQuery;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchAllDocsQuery;
import org.gnit.lucenekmp.search.MultiPhraseQuery;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.search.PhraseQuery;
import org.gnit.lucenekmp.search.PrefixQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.RegexpQuery;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.search.TermRangeQuery;
import org.gnit.lucenekmp.search.WildcardQuery;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.QueryBuilder;
import org.gnit.lucenekmp.util.UnicodeUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 \u0099\u00012\u00020\u00012\u00020\u0002:\u0002\u0099\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u00182\u0006\u0010N\u001a\u00020OJ\u0010\u0010P\u001a\u00020L2\u0006\u0010Q\u001a\u00020RH&J\u0010\u0010S\u001a\u00020T2\u0006\u0010\u0019\u001a\u00020\u0018H&J\u0010\u0010U\u001a\u0004\u0018\u00010T2\u0006\u0010V\u001a\u00020\u0018J\u000e\u0010W\u001a\u00020L2\u0006\u0010X\u001a\u00020\u0006J\u0016\u0010=\u001a\u00020L2\u0006\u0010[\u001a\u00020\u00182\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u00020:2\u0006\u0010[\u001a\u00020\u0018J0\u0010\\\u001a\u00020L2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^2\u0006\u0010`\u001a\u00020\u001f2\u0006\u0010a\u001a\u00020\u001f2\b\u0010b\u001a\u0004\u0018\u00010TH\u0004J \u0010c\u001a\u00020L2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^2\b\u0010b\u001a\u0004\u0018\u00010TH\u0004J \u0010d\u001a\u00020T2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010e\u001a\u00020\u00182\u0006\u0010f\u001a\u00020\u0012H\u0004J(\u0010g\u001a\u00020T2\u0006\u0010h\u001a\u00020O2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010e\u001a\u00020\u00182\u0006\u0010f\u001a\u00020\u0012H\u0004J \u0010d\u001a\u00020T2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010e\u001a\u00020\u00182\u0006\u0010i\u001a\u00020\u001fH\u0004J\u0018\u0010j\u001a\u00020k2\u0006\u0010V\u001a\u00020k2\u0006\u0010i\u001a\u00020\u001fH\u0002J4\u0010l\u001a\u00020T2\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010m\u001a\u0004\u0018\u00010\u00182\b\u0010n\u001a\u0004\u0018\u00010\u00182\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\u0012H\u0004J\u0018\u0010q\u001a\u00020_2\u0006\u0010b\u001a\u00020T2\u0006\u0010r\u001a\u00020sH\u0004J\u0010\u0010t\u001a\u00020T2\u0006\u0010u\u001a\u00020vH\u0004J\u0010\u0010w\u001a\u00020T2\u0006\u0010x\u001a\u00020vH\u0004J \u0010y\u001a\u00020T2\u0006\u0010z\u001a\u00020v2\u0006\u0010{\u001a\u00020%2\u0006\u0010|\u001a\u00020\u001fH\u0004J4\u0010}\u001a\u00020T2\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010m\u001a\u0004\u0018\u00010\u00182\b\u0010n\u001a\u0004\u0018\u00010\u00182\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\u0012H\u0004J\b\u0010~\u001a\u00020TH\u0004J\u0011\u0010\u007f\u001a\u00020T2\u0007\u0010\u0080\u0001\u001a\u00020vH\u0004J\u0019\u0010\u0081\u0001\u001a\u0004\u0018\u00010T2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^H\u0004J\u001a\u0010\u0082\u0001\u001a\u00020T2\u0006\u0010\u0019\u001a\u00020\u00182\u0007\u0010\u0083\u0001\u001a\u00020\u0018H\u0004J\u001b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0006\u0010\u0019\u001a\u00020\u00182\u0007\u0010\u0083\u0001\u001a\u00020\u0018H\u0002J\u001a\u0010\u0086\u0001\u001a\u00020T2\u0006\u0010\u0019\u001a\u00020\u00182\u0007\u0010\u0083\u0001\u001a\u00020\u0018H\u0004J\u001a\u0010\u0087\u0001\u001a\u00020T2\u0006\u0010\u0019\u001a\u00020\u00182\u0007\u0010\u0083\u0001\u001a\u00020\u0018H\u0004J#\u0010\u0088\u0001\u001a\u00020T2\u0006\u0010\u0019\u001a\u00020\u00182\u0007\u0010\u0083\u0001\u001a\u00020\u00182\u0007\u0010\u0089\u0001\u001a\u00020%H\u0004JE\u0010\u008a\u0001\u001a\u00020T2\u0007\u0010\u008b\u0001\u001a\u00020\u00182\u0007\u0010z\u001a\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008c\u00012\u0006\u0010u\u001a\u00020\u00122\u0007\u0010\u008e\u0001\u001a\u00020\u00122\u0007\u0010\u008f\u0001\u001a\u00020\u00122\u0006\u0010x\u001a\u00020\u0012J\u001e\u0010\u0090\u0001\u001a\u00020%2\b\u0010\u0091\u0001\u001a\u00030\u008c\u00012\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0018H\u0004J#\u0010\u0092\u0001\u001a\u00020T2\u0007\u0010\u008b\u0001\u001a\u00020\u00182\b\u0010\u008d\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0093\u0001\u001a\u00020\u0018J%\u0010\u0094\u0001\u001a\u00020T2\u0007\u0010\u008b\u0001\u001a\u00020\u00182\u0007\u0010z\u001a\u00030\u008c\u00012\n\u0010\u008d\u0001\u001a\u0005\u0018\u00010\u008c\u0001J\u001d\u0010\u0095\u0001\u001a\u00020T2\b\u0010b\u001a\u0004\u0018\u00010T2\n\u0010\u0096\u0001\u001a\u0005\u0018\u00010\u008c\u0001J\u0010\u0010\u0097\u0001\u001a\u00020\u00182\u0007\u0010\u0098\u0001\u001a\u00020\u0018R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@DX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010!\"\u0004\b,\u0010#R\u001a\u0010-\u001a\u00020.X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u000204X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020:X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R(\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020:\u0018\u00010@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0014\"\u0004\bG\u0010\u0016R\u001a\u0010H\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010!\"\u0004\bJ\u0010#R\u0011\u0010Y\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010\b\u00a8\u0006\u009a\u0001"}, d2={"Lorg/gnit/lucenekmp/queryparser/classic/QueryParserBase;", "Lorg/gnit/lucenekmp/util/QueryBuilder;", "Lorg/gnit/lucenekmp/queryparser/flexible/standard/CommonQueryParserConfiguration;", "<init>", "()V", "operator", "Lorg/gnit/lucenekmp/queryparser/classic/QueryParser$Operator;", "getOperator", "()Lorg/gnit/lucenekmp/queryparser/classic/QueryParser$Operator;", "setOperator", "(Lorg/gnit/lucenekmp/queryparser/classic/QueryParser$Operator;)V", "multiTermRewriteMethod", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "getMultiTermRewriteMethod", "()Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "setMultiTermRewriteMethod", "(Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;)V", "allowLeadingWildcard", "", "getAllowLeadingWildcard", "()Z", "setAllowLeadingWildcard", "(Z)V", "value", "", "field", "getField", "()Ljava/lang/String;", "setField", "(Ljava/lang/String;)V", "phraseSlop", "", "getPhraseSlop", "()I", "setPhraseSlop", "(I)V", "fuzzyMinSim", "", "getFuzzyMinSim", "()F", "setFuzzyMinSim", "(F)V", "fuzzyPrefixLength", "getFuzzyPrefixLength", "setFuzzyPrefixLength", "locale", "Lorg/gnit/lucenekmp/jdkport/Locale;", "getLocale", "()Lorg/gnit/lucenekmp/jdkport/Locale;", "setLocale", "(Lorg/gnit/lucenekmp/jdkport/Locale;)V", "timeZone", "Lkotlinx/datetime/TimeZone;", "getTimeZone", "()Lkotlinx/datetime/TimeZone;", "setTimeZone", "(Lkotlinx/datetime/TimeZone;)V", "dateResolution", "Lorg/gnit/lucenekmp/document/DateTools$Resolution;", "getDateResolution", "()Lorg/gnit/lucenekmp/document/DateTools$Resolution;", "setDateResolution", "(Lorg/gnit/lucenekmp/document/DateTools$Resolution;)V", "fieldToDateResolution", "", "getFieldToDateResolution", "()Ljava/util/Map;", "setFieldToDateResolution", "(Ljava/util/Map;)V", "autoGeneratePhraseQueries", "getAutoGeneratePhraseQueries", "setAutoGeneratePhraseQueries", "determinizeWorkLimit", "getDeterminizeWorkLimit", "setDeterminizeWorkLimit", "init", "", "f", "a", "Lorg/gnit/lucenekmp/analysis/Analyzer;", "ReInit", "stream", "Lorg/gnit/lucenekmp/queryparser/charstream/CharStream;", "TopLevelQuery", "Lorg/gnit/lucenekmp/search/Query;", "parse", "query", "setDefaultOperator", "op", "defaultOperator", "getDefaultOperator", "fieldName", "addClause", "clauses", "", "Lorg/gnit/lucenekmp/search/BooleanClause;", "conj", "mods", "q", "addMultiTermClauses", "getFieldQuery", "queryText", "quoted", "newFieldQuery", "analyzer", "slop", "addSlopToPhrase", "Lorg/gnit/lucenekmp/search/PhraseQuery;", "getRangeQuery", "part1", "part2", "startInclusive", "endInclusive", "newBooleanClause", "occur", "Lorg/gnit/lucenekmp/search/BooleanClause$Occur;", "newPrefixQuery", "prefix", "Lorg/gnit/lucenekmp/index/Term;", "newRegexpQuery", "regexp", "newFuzzyQuery", "term", "minimumSimilarity", "prefixLength", "newRangeQuery", "newMatchAllDocsQuery", "newWildcardQuery", "t", "getBooleanQuery", "getWildcardQuery", "termStr", "analyzeWildcard", "Lorg/gnit/lucenekmp/util/BytesRef;", "getRegexpQuery", "getPrefixQuery", "getFuzzyQuery", "minSimilarity", "handleBareTokenQuery", "qfield", "Lorg/gnit/lucenekmp/queryparser/classic/Token;", "fuzzySlop", "wildcard", "fuzzy", "getFuzzyDistance", "fuzzyToken", "handleBareFuzzy", "termImage", "handleQuotedTerm", "handleBoost", "boost", "discardEscapeChar", "input", "Companion", "queryparser"})
@SourceDebugExtension(value={"SMAP\nQueryParserBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryParserBase.kt\norg/gnit/lucenekmp/queryparser/classic/QueryParserBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,975:1\n1869#2,2:976\n1321#3,2:978\n*S KotlinDebug\n*F\n+ 1 QueryParserBase.kt\norg/gnit/lucenekmp/queryparser/classic/QueryParserBase\n*L\n597#1:976,2\n643#1:978,2\n*E\n"})
public abstract class QueryParserBase
extends QueryBuilder
implements CommonQueryParserConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private QueryParser.Operator operator = OR_OPERATOR;
    @NotNull
    private MultiTermQuery.RewriteMethod multiTermRewriteMethod = MultiTermQuery.Companion.getCONSTANT_SCORE_BLENDED_REWRITE();
    private boolean allowLeadingWildcard;
    protected String field;
    private int phraseSlop;
    private float fuzzyMinSim = 2.0f;
    private int fuzzyPrefixLength;
    @NotNull
    private Locale locale = new Locale();
    @NotNull
    private TimeZone timeZone = TimeZone.Companion.currentSystemDefault();
    public DateTools.Resolution dateResolution;
    @Nullable
    private Map<String, DateTools.Resolution> fieldToDateResolution;
    private boolean autoGeneratePhraseQueries;
    private int determinizeWorkLimit = 10000;
    public static final int CONJ_NONE = 0;
    public static final int CONJ_AND = 1;
    public static final int CONJ_OR = 2;
    public static final int MOD_NONE = 0;
    public static final int MOD_NOT = 10;
    public static final int MOD_REQ = 11;
    @NotNull
    private static final QueryParser.Operator AND_OPERATOR = QueryParser.Operator.AND;
    @NotNull
    private static final QueryParser.Operator OR_OPERATOR = QueryParser.Operator.OR;
    @NotNull
    private static final Regex WILDCARD_PATTERN = new Regex("(\\\\\\.)|([?*]+)");

    protected QueryParserBase() {
        super(null, 1, null);
    }

    @NotNull
    public final QueryParser.Operator getOperator() {
        return this.operator;
    }

    public final void setOperator(@NotNull QueryParser.Operator operator) {
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"<set-?>");
        this.operator = operator;
    }

    @Override
    @NotNull
    public MultiTermQuery.RewriteMethod getMultiTermRewriteMethod() {
        return this.multiTermRewriteMethod;
    }

    @Override
    public void setMultiTermRewriteMethod(@NotNull MultiTermQuery.RewriteMethod rewriteMethod) {
        Intrinsics.checkNotNullParameter((Object)rewriteMethod, (String)"<set-?>");
        this.multiTermRewriteMethod = rewriteMethod;
    }

    @Override
    public boolean getAllowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    @Override
    public void setAllowLeadingWildcard(boolean bl) {
        this.allowLeadingWildcard = bl;
    }

    @NotNull
    public final String getField() {
        String string = this.field;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"field");
        return null;
    }

    protected final void setField(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.field = string;
    }

    @Override
    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    @Override
    public void setPhraseSlop(int n) {
        this.phraseSlop = n;
    }

    @Override
    public float getFuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    @Override
    public void setFuzzyMinSim(float f) {
        this.fuzzyMinSim = f;
    }

    @Override
    public int getFuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    @Override
    public void setFuzzyPrefixLength(int n) {
        this.fuzzyPrefixLength = n;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"<set-?>");
        this.locale = locale;
    }

    @Override
    @NotNull
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(@NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"<set-?>");
        this.timeZone = timeZone;
    }

    @Override
    @NotNull
    public DateTools.Resolution getDateResolution() {
        DateTools.Resolution resolution = this.dateResolution;
        if (resolution != null) {
            return resolution;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dateResolution");
        return null;
    }

    @Override
    public void setDateResolution(@NotNull DateTools.Resolution resolution) {
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"<set-?>");
        this.dateResolution = resolution;
    }

    @Nullable
    public final Map<String, DateTools.Resolution> getFieldToDateResolution() {
        return this.fieldToDateResolution;
    }

    public final void setFieldToDateResolution(@Nullable Map<String, DateTools.Resolution> map) {
        this.fieldToDateResolution = map;
    }

    public boolean getAutoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    public void setAutoGeneratePhraseQueries(boolean bl) {
        this.autoGeneratePhraseQueries = bl;
    }

    public final int getDeterminizeWorkLimit() {
        return this.determinizeWorkLimit;
    }

    public final void setDeterminizeWorkLimit(int n) {
        this.determinizeWorkLimit = n;
    }

    public final void init(@NotNull String f, @NotNull Analyzer a) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        this.setAnalyzer(a);
        this.setField(f);
        this.setAutoGeneratePhraseQueries(false);
    }

    public abstract void ReInit(@NotNull CharStream var1);

    @NotNull
    public abstract Query TopLevelQuery(@NotNull String var1) throws ParseException;

    @Nullable
    public final Query parse(@NotNull String query) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.ReInit(new FastCharStream((Reader)new StringReader(query)));
        try {
            Query res = this.TopLevelQuery(this.getField());
            Query query2 = res;
            if (query2 == null) {
                query2 = (Query)this.newBooleanQuery().build();
            }
            return query2;
        }
        catch (ParseException tme) {
            ParseException e = new ParseException("Cannot parse '" + query + "': " + tme.getMessage(), tme);
            throw e;
        }
        catch (TokenMgrError tme) {
            ParseException e = new ParseException("Cannot parse '" + query + "': " + tme.getMessage(), tme);
            throw e;
        }
        catch (IndexSearcher.TooManyClauses tmc) {
            ParseException e = new ParseException("Cannot parse '" + query + "': too many boolean clauses", tmc);
            throw e;
        }
    }

    public final void setDefaultOperator(@NotNull QueryParser.Operator op) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        this.operator = op;
    }

    @NotNull
    public final QueryParser.Operator getDefaultOperator() {
        return this.operator;
    }

    public final void setDateResolution(@NotNull String fieldName, @NotNull DateTools.Resolution dateResolution) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)dateResolution, (String)"dateResolution");
        if (this.fieldToDateResolution == null) {
            this.fieldToDateResolution = new HashMap();
        }
        Map<String, DateTools.Resolution> map = this.fieldToDateResolution;
        Intrinsics.checkNotNull(map);
        map.put(fieldName, dateResolution);
    }

    @NotNull
    public final DateTools.Resolution getDateResolution(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        if (this.fieldToDateResolution == null) {
            return this.getDateResolution();
        }
        Map<String, DateTools.Resolution> map = this.fieldToDateResolution;
        Intrinsics.checkNotNull(map);
        DateTools.Resolution resolution = map.get(fieldName);
        if (resolution == null) {
            resolution = this.getDateResolution();
        }
        return resolution;
    }

    protected final void addClause(@NotNull List<BooleanClause> clauses, int conj, int mods, @Nullable Query q) {
        BooleanClause c;
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        boolean required = false;
        boolean prohibited = false;
        if (!((Collection)clauses).isEmpty() && conj == 1 && !(c = clauses.get(clauses.size() - 1)).isProhibited()) {
            clauses.set(clauses.size() - 1, new BooleanClause(c.getQuery(), BooleanClause.Occur.MUST));
        }
        if (!((Collection)clauses).isEmpty() && this.operator == AND_OPERATOR && conj == 2 && !(c = clauses.get(clauses.size() - 1)).isProhibited()) {
            clauses.set(clauses.size() - 1, new BooleanClause(c.getQuery(), BooleanClause.Occur.SHOULD));
        }
        if (q == null) {
            return;
        }
        if (this.operator == OR_OPERATOR) {
            prohibited = mods == 10;
            boolean bl = required = mods == 11;
            if (conj == 1 && !prohibited) {
                required = true;
            }
        } else {
            prohibited = mods == 10;
            boolean bl = required = !prohibited && conj != 2;
        }
        if (required && !prohibited) {
            v2 = clauses.add(this.newBooleanClause(q, BooleanClause.Occur.MUST));
        } else if (!required && !prohibited) {
            v2 = clauses.add(this.newBooleanClause(q, BooleanClause.Occur.SHOULD));
        } else if (!required && prohibited) {
            v2 = clauses.add(this.newBooleanClause(q, BooleanClause.Occur.MUST_NOT));
        } else {
            throw new RuntimeException("Clause cannot be both required and prohibited");
        }
    }

    protected final void addMultiTermClauses(@NotNull List<BooleanClause> clauses, @Nullable Query q) {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        if (q == null) {
            return;
        }
        boolean allNestedTermQueries = false;
        if (q instanceof BooleanQuery) {
            allNestedTermQueries = true;
            for (BooleanClause clause : ((BooleanQuery)q).clauses()) {
                if (clause.getQuery() instanceof TermQuery) continue;
                allNestedTermQueries = false;
                break;
            }
        }
        if (allNestedTermQueries) {
            clauses.addAll(((BooleanQuery)q).clauses());
        } else {
            BooleanClause.Occur occur;
            BooleanClause.Occur occur2 = occur = this.operator == OR_OPERATOR ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
            if (q instanceof BooleanQuery) {
                for (BooleanClause clause : ((BooleanQuery)q).clauses()) {
                    clauses.add(this.newBooleanClause(clause.getQuery(), occur));
                }
            } else {
                clauses.add(this.newBooleanClause(q, occur));
            }
        }
    }

    @NotNull
    protected final Query getFieldQuery(@NotNull String field, @NotNull String queryText, boolean quoted) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        return this.newFieldQuery(this.getAnalyzer(), field, queryText, quoted);
    }

    @NotNull
    protected final Query newFieldQuery(@NotNull Analyzer analyzer, @NotNull String field, @NotNull String queryText, boolean quoted) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        BooleanClause.Occur occur = this.operator == QueryParser.Operator.AND ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        return this.createFieldQuery(analyzer, occur, field, queryText, quoted || this.getAutoGeneratePhraseQueries(), this.getPhraseSlop());
    }

    @NotNull
    protected final Query getFieldQuery(@NotNull String field, @NotNull String queryText, int slop) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        Query query = this.getFieldQuery(field, queryText, true);
        if (query instanceof PhraseQuery) {
            query = (Query)this.addSlopToPhrase((PhraseQuery)query, slop);
        } else if (query instanceof MultiPhraseQuery && slop != ((MultiPhraseQuery)query).getSlop()) {
            query = (Query)new MultiPhraseQuery.Builder((MultiPhraseQuery)query).setSlop(slop).build();
        }
        return query;
    }

    private final PhraseQuery addSlopToPhrase(PhraseQuery query, int slop) {
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        builder.setSlop(slop);
        Term[] terms = query.getTerms();
        int[] positions = query.getPositions();
        int n = terms.length;
        for (int i = 0; i < n; ++i) {
            builder.add(terms[i], positions[i]);
        }
        return builder.build();
    }

    @NotNull
    protected final Query getRangeQuery(@NotNull String field, @Nullable String part1, @Nullable String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String part12 = part1;
        String part22 = part2;
        DateTools.Resolution resolution = this.getDateResolution(field);
        if (part12 != null) {
            try {
                part12 = DateTools.INSTANCE.dateToString(Instant.Companion.parse((CharSequence)part12), resolution);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (part22 != null) {
            try {
                Instant d2 = Instant.Companion.parse((CharSequence)part22);
                if (endInclusive) {
                    LocalDate localDate = TimeZoneKt.toLocalDateTime((Instant)d2, (TimeZone)this.getTimeZone()).getDate();
                    d2 = TimeZoneKt.toInstant$default((LocalDateTime)LocalDateKt.atTime((LocalDate)localDate, (LocalTime)new LocalTime(23, 59, 59, 999000000)), (TimeZone)this.getTimeZone(), null, (int)2, null);
                }
                part22 = DateTools.INSTANCE.dateToString(d2, resolution);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.newRangeQuery(field, part12, part22, startInclusive, endInclusive);
    }

    @NotNull
    protected final BooleanClause newBooleanClause(@NotNull Query q, @NotNull BooleanClause.Occur occur) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        Intrinsics.checkNotNullParameter((Object)occur, (String)"occur");
        return new BooleanClause(q, occur);
    }

    @NotNull
    protected final Query newPrefixQuery(@NotNull Term prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return (Query)new PrefixQuery(prefix, this.getMultiTermRewriteMethod());
    }

    @NotNull
    protected final Query newRegexpQuery(@NotNull Term regexp) {
        Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
        return (Query)new RegexpQuery(regexp, 255, 0, RegexpQuery.Companion.getDEFAULT_PROVIDER(), this.determinizeWorkLimit, this.getMultiTermRewriteMethod(), false, 64, null);
    }

    @NotNull
    protected final Query newFuzzyQuery(@NotNull Term term, float minimumSimilarity, int prefixLength) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        String text = term.text();
        int numEdits = FuzzyQuery.Companion.floatToEdits(minimumSimilarity, UnicodeUtilKt.codePointCount((String)text, (int)0, (int)text.length()));
        return (Query)new FuzzyQuery(term, numEdits, prefixLength, 0, false, null, 56, null);
    }

    @NotNull
    protected final Query newRangeQuery(@NotNull String field, @Nullable String part1, @Nullable String part2, boolean startInclusive, boolean endInclusive) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        BytesRef start = part1 == null ? null : this.getAnalyzer().normalize(field, part1);
        BytesRef end = part2 == null ? null : this.getAnalyzer().normalize(field, part2);
        BytesRef bytesRef = start;
        Intrinsics.checkNotNull((Object)bytesRef);
        return (Query)new TermRangeQuery(field, bytesRef, end, startInclusive, endInclusive, this.getMultiTermRewriteMethod());
    }

    @NotNull
    protected final Query newMatchAllDocsQuery() {
        return (Query)new MatchAllDocsQuery();
    }

    @NotNull
    protected final Query newWildcardQuery(@NotNull Term t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return (Query)new WildcardQuery(t, this.determinizeWorkLimit, this.getMultiTermRewriteMethod());
    }

    @Nullable
    protected final Query getBooleanQuery(@NotNull List<BooleanClause> clauses) throws ParseException {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        if (clauses.isEmpty()) {
            return null;
        }
        BooleanQuery.Builder query = this.newBooleanQuery();
        Iterable $this$forEach$iv = clauses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BooleanClause clause = (BooleanClause)element$iv;
            boolean bl = false;
            query.add(clause);
        }
        return (Query)query.build();
    }

    @NotNull
    protected final Query getWildcardQuery(@NotNull String field, @NotNull String termStr) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)termStr, (String)"termStr");
        if (Intrinsics.areEqual((Object)"*", (Object)field) && Intrinsics.areEqual((Object)"*", (Object)termStr)) {
            return this.newMatchAllDocsQuery();
        }
        if (!this.getAllowLeadingWildcard() && (StringsKt.startsWith$default((String)termStr, (String)"*", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)termStr, (String)"?", (boolean)false, (int)2, null))) {
            throw new ParseException("'*' or '?' not allowed as first character in WildcardQuery");
        }
        Term t = new Term(field, this.analyzeWildcard(field, termStr));
        return this.newWildcardQuery(t);
    }

    private final BytesRef analyzeWildcard(String field, String termStr) {
        BytesRefBuilder sb = new BytesRefBuilder();
        int last = 0;
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)WILDCARD_PATTERN, (CharSequence)termStr, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult matchResult = (MatchResult)element$iv;
            boolean bl = false;
            if (matchResult.getRange().getFirst() > 0) {
                String chunk;
                Intrinsics.checkNotNullExpressionValue((Object)termStr.substring(last, matchResult.getRange().getFirst()), (String)"substring(...)");
                BytesRef normalized = this.getAnalyzer().normalize(field, chunk);
                sb.append(normalized);
            }
            sb.append(new BytesRef((CharSequence)matchResult.getValue()));
            last = matchResult.getRange().getLast() + 1;
        }
        if (last < termStr.length()) {
            String string = termStr.substring(last);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String chunk = string;
            BytesRef normalized = this.getAnalyzer().normalize(field, chunk);
            sb.append(normalized);
        }
        return sb.toBytesRef();
    }

    @NotNull
    protected final Query getRegexpQuery(@NotNull String field, @NotNull String termStr) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)termStr, (String)"termStr");
        BytesRef term = this.getAnalyzer().normalize(field, termStr);
        Term t = new Term(field, term);
        return this.newRegexpQuery(t);
    }

    @NotNull
    protected final Query getPrefixQuery(@NotNull String field, @NotNull String termStr) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)termStr, (String)"termStr");
        if (!this.getAllowLeadingWildcard() && StringsKt.startsWith$default((String)termStr, (String)"*", (boolean)false, (int)2, null)) {
            throw new ParseException("'*' not allowed as first character in PrefixQuery");
        }
        BytesRef term = this.getAnalyzer().normalize(field, termStr);
        Term t = new Term(field, term);
        return this.newPrefixQuery(t);
    }

    @NotNull
    protected final Query getFuzzyQuery(@NotNull String field, @NotNull String termStr, float minSimilarity) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)termStr, (String)"termStr");
        BytesRef term = this.getAnalyzer().normalize(field, termStr);
        Term t = new Term(field, term);
        return this.newFuzzyQuery(t, minSimilarity, this.getFuzzyPrefixLength());
    }

    @NotNull
    public final Query handleBareTokenQuery(@NotNull String qfield, @NotNull Token term, @NotNull Token fuzzySlop, boolean prefix, boolean wildcard, boolean fuzzy, boolean regexp) throws ParseException {
        Query query;
        Intrinsics.checkNotNullParameter((Object)qfield, (String)"qfield");
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Intrinsics.checkNotNullParameter((Object)fuzzySlop, (String)"fuzzySlop");
        Query q = null;
        String string = term.getImage();
        Intrinsics.checkNotNull((Object)string);
        String termImage = this.discardEscapeChar(string);
        if (wildcard) {
            String string2 = term.getImage();
            Intrinsics.checkNotNull((Object)string2);
            query = this.getWildcardQuery(qfield, string2);
        } else if (prefix) {
            String string3 = term.getImage();
            Intrinsics.checkNotNull((Object)string3);
            String string4 = term.getImage();
            Intrinsics.checkNotNull((Object)string4);
            String string5 = string3.substring(0, string4.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            query = this.getPrefixQuery(qfield, this.discardEscapeChar(string5));
        } else if (regexp) {
            String string6 = term.getImage();
            Intrinsics.checkNotNull((Object)string6);
            String string7 = term.getImage();
            Intrinsics.checkNotNull((Object)string7);
            String string8 = string6.substring(1, string7.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
            query = this.getRegexpQuery(qfield, string8);
        } else {
            query = fuzzy ? this.handleBareFuzzy(qfield, fuzzySlop, termImage) : this.getFieldQuery(qfield, termImage, false);
        }
        q = query;
        return q;
    }

    protected final float getFuzzyDistance(@NotNull Token fuzzyToken, @Nullable String termStr) {
        Intrinsics.checkNotNullParameter((Object)fuzzyToken, (String)"fuzzyToken");
        try {
            String string = fuzzyToken.getImage();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return Float.parseFloat(string2);
        }
        catch (Exception exception) {
            return this.getFuzzyMinSim();
        }
    }

    @NotNull
    public final Query handleBareFuzzy(@NotNull String qfield, @NotNull Token fuzzySlop, @NotNull String termImage) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)qfield, (String)"qfield");
        Intrinsics.checkNotNullParameter((Object)fuzzySlop, (String)"fuzzySlop");
        Intrinsics.checkNotNullParameter((Object)termImage, (String)"termImage");
        float fms = this.getFuzzyDistance(fuzzySlop, termImage);
        if (fms < 0.0f) {
            throw new ParseException("Minimum similarity for a FuzzyQuery has to be between 0.0f and 1.0f !");
        }
        if (fms >= 1.0f && !(fms == (float)((int)fms))) {
            throw new ParseException("Fractional edit distances are not allowed!");
        }
        return this.getFuzzyQuery(qfield, termImage, fms);
    }

    @NotNull
    public final Query handleQuotedTerm(@NotNull String qfield, @NotNull Token term, @Nullable Token fuzzySlop) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)qfield, (String)"qfield");
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        int s = this.getPhraseSlop();
        if (fuzzySlop != null) {
            try {
                String string = fuzzySlop.getImage();
                Intrinsics.checkNotNull((Object)string);
                String string2 = string.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                s = (int)Float.parseFloat(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string = term.getImage();
        Intrinsics.checkNotNull((Object)string);
        String string3 = term.getImage();
        Intrinsics.checkNotNull((Object)string3);
        String string4 = string.substring(1, string3.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        return this.getFieldQuery(qfield, this.discardEscapeChar(string4), s);
    }

    @NotNull
    public final Query handleBoost(@Nullable Query q, @Nullable Token boost) {
        Query q2 = q;
        if (boost != null) {
            float f = 1.0f;
            try {
                String string = boost.getImage();
                Intrinsics.checkNotNull((Object)string);
                f = Float.parseFloat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (q2 != null) {
                q2 = (Query)new BoostQuery(q2, f);
            }
        }
        Query query = q2;
        Intrinsics.checkNotNull((Object)query);
        return query;
    }

    @NotNull
    public final String discardEscapeChar(@NotNull String input) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        char[] output = new char[input.length()];
        int length = 0;
        boolean lastCharWasEscapeChar = false;
        int codePointMultiplier = 0;
        int codePoint = 0;
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char curChar = input.charAt(i);
            if (codePointMultiplier > 0) {
                codePoint += Companion.hexToInt(curChar) * codePointMultiplier;
                if ((codePointMultiplier >>>= 4) != 0) continue;
                output[length++] = (char)codePoint;
                codePoint = 0;
                continue;
            }
            if (lastCharWasEscapeChar) {
                if (curChar == 'u') {
                    codePointMultiplier = 4096;
                } else {
                    output[length] = curChar;
                    ++length;
                }
                lastCharWasEscapeChar = false;
                continue;
            }
            if (curChar == '\\') {
                lastCharWasEscapeChar = true;
                continue;
            }
            output[length] = curChar;
            ++length;
        }
        if (codePointMultiplier > 0) {
            throw new ParseException("Truncated Unicode escape sequence.");
        }
        if (lastCharWasEscapeChar) {
            throw new ParseException("Term can not end with escape character.");
        }
        return StringExtKt.fromCharArray((StringCompanionObject)StringCompanionObject.INSTANCE, (char[])output, (int)0, (int)length);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/queryparser/classic/QueryParserBase$Companion;", "", "<init>", "()V", "CONJ_NONE", "", "CONJ_AND", "CONJ_OR", "MOD_NONE", "MOD_NOT", "MOD_REQ", "AND_OPERATOR", "Lorg/gnit/lucenekmp/queryparser/classic/QueryParser$Operator;", "getAND_OPERATOR", "()Lorg/gnit/lucenekmp/queryparser/classic/QueryParser$Operator;", "OR_OPERATOR", "getOR_OPERATOR", "WILDCARD_PATTERN", "Lkotlin/text/Regex;", "hexToInt", "c", "", "escape", "", "s", "queryparser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QueryParser.Operator getAND_OPERATOR() {
            return AND_OPERATOR;
        }

        @NotNull
        public final QueryParser.Operator getOR_OPERATOR() {
            return OR_OPERATOR;
        }

        public final int hexToInt(char c) throws ParseException {
            int n;
            if (Intrinsics.compare((int)48, (int)c) <= 0 && Intrinsics.compare((int)c, (int)57) <= 0) {
                n = c - 48;
            } else if (Intrinsics.compare((int)97, (int)c) <= 0 && Intrinsics.compare((int)c, (int)102) <= 0) {
                n = c - 97 + 10;
            } else if (Intrinsics.compare((int)65, (int)c) <= 0 && Intrinsics.compare((int)c, (int)70) <= 0) {
                n = c - 65 + 10;
            } else {
                throw new ParseException("Non-hex character in Unicode escape sequence: " + c);
            }
            return n;
        }

        @NotNull
        public final String escape(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            StringBuilder sb = new StringBuilder();
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '!': 
                    case '\"': 
                    case '&': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case ':': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': {
                        sb.append('\\');
                    }
                }
                sb.append(c);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

