/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.cli;

import fr.insalyon.citi.golo.compiler.GoloClassLoader;
import fr.insalyon.citi.golo.compiler.GoloCompilationException;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Arrays;

public class MainGoloGolo {
    public static void main(String ... args) throws Throwable {
        int i;
        if (args.length < 1) {
            System.out.println("Usage: gologolo <.golo files> [--args arg1 arg2 ...]");
            System.out.println("(the last .golo file has a main function)");
            System.out.println();
            System.out.println("Examples:");
            System.out.println("  golo foo.golo bar.golo");
            System.out.println("  golo foo.golo bar.golo --args hello world");
            System.out.println();
            return;
        }
        GoloClassLoader loader = new GoloClassLoader();
        Class<?> lastClass = null;
        for (i = 0; i < args.length && !"--args".equals(args[i]); ++i) {
            File file = new File(args[i]);
            if (!file.exists()) {
                System.out.println("Error: " + file + " does not exist.");
                return;
            }
            if (!file.isFile()) {
                System.out.println("Error: " + file + " is not a file.");
                return;
            }
            try (FileInputStream in = new FileInputStream(file);){
                lastClass = loader.load(file.getName(), in);
                continue;
            }
            catch (GoloCompilationException e) {
                MainGoloGolo.handleCompilationException(e);
            }
        }
        Object[] appArgs = i < args.length ? Arrays.copyOfRange(args, i + 1, args.length) : new Object[]{};
        Method main = lastClass.getMethod("main", Object.class);
        main.invoke(null, new Object[]{appArgs});
    }

    static void handleCompilationException(GoloCompilationException e) {
        if (e.getMessage() != null) {
            System.out.println("[error] " + e.getMessage());
        }
        if (e.getCause() != null) {
            System.out.println("[error] " + e.getCause().getMessage());
        }
        for (GoloCompilationException.Problem problem : e.getProblems()) {
            System.out.println("[error] " + problem.getDescription());
        }
        System.exit(1);
    }
}

