/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.cli;

import fr.insalyon.citi.golo.cli.MainGoloGolo;
import fr.insalyon.citi.golo.cli.Metadata;
import fr.insalyon.citi.golo.compiler.GoloCompilationException;
import fr.insalyon.citi.golo.compiler.GoloCompiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;

public class MainGoloc {
    public static void main(String ... args) {
        if (args.length == 0) {
            MainGoloc.help();
            return;
        }
        LinkedList<String> sources = new LinkedList<String>();
        String output = ".";
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("-")) {
                    arg = arg.substring(1);
                    switch (Options.valueOf(arg)) {
                        case output: {
                            if (++i >= args.length) {
                                MainGoloc.help();
                                return;
                            }
                            output = args[i];
                            break;
                        }
                        case version: {
                            MainGoloc.version();
                            return;
                        }
                        case fullversion: {
                            MainGoloc.fullversion();
                            return;
                        }
                        case help: {
                            MainGoloc.help();
                            return;
                        }
                    }
                    continue;
                }
                sources.add(arg);
            }
        }
        catch (IllegalArgumentException e) {
            MainGoloc.help();
        }
        GoloCompiler compiler = new GoloCompiler();
        File outputDir = new File(output);
        for (String source : sources) {
            File file = new File(source);
            try {
                FileInputStream in = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    compiler.compileTo(file.getName(), in, outputDir);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                System.out.println("[error] " + source + " does not exist or could not be opened.");
                return;
            }
            catch (GoloCompilationException e) {
                MainGoloGolo.handleCompilationException(e);
            }
        }
    }

    private static void version() {
        System.out.println(Metadata.VERSION);
    }

    private static void fullversion() {
        System.out.println(MainGoloc.versionAndBuild());
    }

    private static void help() {
        System.out.println("Golo compiler " + MainGoloc.versionAndBuild());
        System.out.println();
        System.out.println("Usage: goloc <options> file1.golo file2.golo (...)");
        System.out.println("where options include:");
        for (Options option : Options.values()) {
            System.out.println("    -" + option.name());
            System.out.println("         " + option.description);
        }
    }

    private static String versionAndBuild() {
        return Metadata.VERSION + " (build " + Metadata.TIMESTAMP + ")";
    }

    private static enum Options {
        output("the compiled classes output directory"),
        version("prints the software version"),
        fullversion("prints the software version and build number"),
        help("prints this message ");

        final String description;

        private Options(String description) {
            this.description = description;
        }
    }
}

