/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler;

import fr.insalyon.citi.golo.compiler.ClosureCaptureGoloIrVisitor;
import fr.insalyon.citi.golo.compiler.CodeGenerationResult;
import fr.insalyon.citi.golo.compiler.GoloCompilationException;
import fr.insalyon.citi.golo.compiler.JavaBytecodeGenerationGoloIrVisitor;
import fr.insalyon.citi.golo.compiler.LocalReferenceAssignmentAndVerificationVisitor;
import fr.insalyon.citi.golo.compiler.ParseTreeToGoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.GoloModule;
import fr.insalyon.citi.golo.compiler.parser.ASTCompilationUnit;
import fr.insalyon.citi.golo.compiler.parser.GoloParser;
import fr.insalyon.citi.golo.compiler.parser.ParseException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class GoloCompiler {
    private GoloParser parser;
    private GoloCompilationException.Builder exceptionBuilder = null;

    public final void setExceptionBuilder(GoloCompilationException.Builder builder) {
        this.exceptionBuilder = builder;
    }

    private GoloCompilationException.Builder getOrCreateExceptionBuilder(String goloSourceFile) {
        if (this.exceptionBuilder == null) {
            this.exceptionBuilder = new GoloCompilationException.Builder(goloSourceFile);
        }
        return this.exceptionBuilder;
    }

    public final GoloParser initParser(InputStream sourceCodeInputStream) {
        return this.initParser(new InputStreamReader(sourceCodeInputStream));
    }

    public final GoloParser initParser(Reader sourceReader) {
        if (this.parser == null) {
            this.parser = this.createGoloParser(sourceReader);
        } else {
            this.parser.ReInit(sourceReader);
        }
        return this.parser;
    }

    public final List<CodeGenerationResult> compile(String goloSourceFilename, InputStream sourceCodeInputStream) throws GoloCompilationException {
        ASTCompilationUnit compilationUnit = this.parse(goloSourceFilename, this.initParser(sourceCodeInputStream));
        GoloModule goloModule = this.check(compilationUnit);
        if (!this.getProblems().isEmpty()) {
            this.exceptionBuilder.doThrow();
        }
        JavaBytecodeGenerationGoloIrVisitor bytecodeGenerator = new JavaBytecodeGenerationGoloIrVisitor();
        return bytecodeGenerator.generateBytecode(goloModule, goloSourceFilename);
    }

    public List<GoloCompilationException.Problem> getProblems() {
        if (this.exceptionBuilder == null) {
            return Collections.emptyList();
        }
        return this.exceptionBuilder.getProblems();
    }

    public final void compileTo(String goloSourceFilename, InputStream sourceCodeInputStream, File targetFolder) throws GoloCompilationException, IOException {
        if (targetFolder.isFile()) {
            throw new IllegalArgumentException(targetFolder + " already exists and is a file.");
        }
        List<CodeGenerationResult> results = this.compile(goloSourceFilename, sourceCodeInputStream);
        for (CodeGenerationResult result : results) {
            File outputFolder = new File(targetFolder, result.getPackageAndClass().packageName().replaceAll("\\.", "/"));
            if (!outputFolder.exists() && !outputFolder.mkdirs()) {
                throw new IOException("mkdir() failed on " + outputFolder);
            }
            File outputFile = new File(outputFolder, result.getPackageAndClass().className() + ".class");
            FileOutputStream out = new FileOutputStream(outputFile);
            Throwable throwable = null;
            try {
                out.write(result.getBytecode());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    public final ASTCompilationUnit parse(String goloSourceFilename, GoloParser parser) throws GoloCompilationException {
        ASTCompilationUnit compilationUnit = null;
        LinkedList errors = new LinkedList();
        parser.exceptionBuilder = this.getOrCreateExceptionBuilder(goloSourceFilename);
        try {
            compilationUnit = parser.CompilationUnit();
        }
        catch (ParseException pe) {
            this.exceptionBuilder.report(pe, compilationUnit);
        }
        return compilationUnit;
    }

    public final GoloModule check(ASTCompilationUnit compilationUnit) {
        ParseTreeToGoloIrVisitor parseTreeToIR = new ParseTreeToGoloIrVisitor();
        parseTreeToIR.setExceptionBuilder(this.exceptionBuilder);
        GoloModule goloModule = parseTreeToIR.transform(compilationUnit);
        ClosureCaptureGoloIrVisitor closureCaptureVisitor = new ClosureCaptureGoloIrVisitor();
        closureCaptureVisitor.visitModule(goloModule);
        LocalReferenceAssignmentAndVerificationVisitor localReferenceVisitor = new LocalReferenceAssignmentAndVerificationVisitor();
        localReferenceVisitor.setExceptionBuilder(this.exceptionBuilder);
        localReferenceVisitor.visitModule(goloModule);
        return goloModule;
    }

    protected GoloParser createGoloParser(Reader sourceReader) {
        return new GoloParser(sourceReader);
    }
}

