/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler;

import fr.insalyon.citi.golo.compiler.CodeGenerationResult;
import fr.insalyon.citi.golo.compiler.PackageAndClass;
import fr.insalyon.citi.golo.compiler.ir.AbstractInvocation;
import fr.insalyon.citi.golo.compiler.ir.AssignmentStatement;
import fr.insalyon.citi.golo.compiler.ir.BinaryOperation;
import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.ClosureReference;
import fr.insalyon.citi.golo.compiler.ir.ConditionalBranching;
import fr.insalyon.citi.golo.compiler.ir.ConstantStatement;
import fr.insalyon.citi.golo.compiler.ir.ExpressionStatement;
import fr.insalyon.citi.golo.compiler.ir.FunctionInvocation;
import fr.insalyon.citi.golo.compiler.ir.GoloFunction;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.GoloModule;
import fr.insalyon.citi.golo.compiler.ir.GoloStatement;
import fr.insalyon.citi.golo.compiler.ir.LocalReference;
import fr.insalyon.citi.golo.compiler.ir.LoopStatement;
import fr.insalyon.citi.golo.compiler.ir.MethodInvocation;
import fr.insalyon.citi.golo.compiler.ir.ModuleImport;
import fr.insalyon.citi.golo.compiler.ir.ReferenceLookup;
import fr.insalyon.citi.golo.compiler.ir.ReferenceTable;
import fr.insalyon.citi.golo.compiler.ir.ReturnStatement;
import fr.insalyon.citi.golo.compiler.ir.ThrowStatement;
import fr.insalyon.citi.golo.compiler.ir.TryCatchFinally;
import fr.insalyon.citi.golo.compiler.ir.UnaryOperation;
import fr.insalyon.citi.golo.compiler.parser.GoloParser;
import fr.insalyon.citi.golo.runtime.OperatorType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class JavaBytecodeGenerationGoloIrVisitor
implements GoloIrVisitor {
    private static final String JOBJECT = "java/lang/Object";
    private static final String TOBJECT = "Ljava/lang/Object;";
    private static final Handle FUNCTION_INVOCATION_HANDLE;
    private static final Handle OPERATOR_HANDLE;
    private static final Handle METHOD_INVOCATION_HANDLE;
    private static final Handle CLASSREF_HANDLE;
    private static final Handle CLOSUREREF_HANDLE;
    private static final Handle CLOSURE_INVOCATION_HANDLE;
    private ClassWriter classWriter;
    private String klass;
    private MethodVisitor methodVisitor;
    private List<CodeGenerationResult> generationResults;
    private String sourceFilename;
    private Context context;
    private static final int[] ICONST;

    JavaBytecodeGenerationGoloIrVisitor() {
    }

    public List<CodeGenerationResult> generateBytecode(GoloModule module, String sourceFilename) {
        this.sourceFilename = sourceFilename;
        this.classWriter = new ClassWriter(3);
        this.generationResults = new LinkedList<CodeGenerationResult>();
        this.context = new Context();
        module.accept(this);
        this.generationResults.add(new CodeGenerationResult(this.classWriter.toByteArray(), module.getPackageAndClass()));
        return this.generationResults;
    }

    @Override
    public void visitModule(GoloModule module) {
        this.classWriter.visit(51, 33, module.getPackageAndClass().toJVMType(), null, JOBJECT, null);
        this.classWriter.visitSource(this.sourceFilename, null);
        this.writeImportMetaData(module.getImports());
        this.klass = module.getPackageAndClass().toString();
        for (GoloFunction goloFunction : module.getFunctions()) {
            goloFunction.accept(this);
        }
        for (Map.Entry entry : module.getPimps().entrySet()) {
            this.generatePimpBytecode(module, (String)entry.getKey(), (Set)entry.getValue());
        }
        this.writePimpsMetaData(module.getPimps().keySet());
        this.classWriter.visitEnd();
    }

    private void writeImportMetaData(Set<ModuleImport> imports) {
        ModuleImport[] importsArray = imports.toArray(new ModuleImport[imports.size()]);
        this.methodVisitor = this.classWriter.visitMethod(4105, "$imports", "()[Ljava/lang/String;", null, null);
        this.methodVisitor.visitCode();
        this.loadInteger(importsArray.length);
        this.methodVisitor.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < importsArray.length; ++i) {
            this.methodVisitor.visitInsn(89);
            this.loadInteger(i);
            this.methodVisitor.visitLdcInsn((Object)importsArray[i].getPackageAndClass().toString());
            this.methodVisitor.visitInsn(83);
        }
        this.methodVisitor.visitInsn(176);
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    private void writePimpsMetaData(Set<String> pimps) {
        String[] pimpsArray = pimps.toArray(new String[pimps.size()]);
        this.methodVisitor = this.classWriter.visitMethod(4105, "$pimps", "()[Ljava/lang/String;", null, null);
        this.methodVisitor.visitCode();
        this.loadInteger(pimpsArray.length);
        this.methodVisitor.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < pimpsArray.length; ++i) {
            this.methodVisitor.visitInsn(89);
            this.loadInteger(i);
            this.methodVisitor.visitLdcInsn((Object)pimpsArray[i]);
            this.methodVisitor.visitInsn(83);
        }
        this.methodVisitor.visitInsn(176);
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    private void generatePimpBytecode(GoloModule module, String target, Set<GoloFunction> functions) {
        ClassWriter mainClassWriter = this.classWriter;
        String mangledClass = target.replace('.', '$');
        PackageAndClass packageAndClass = new PackageAndClass(module.getPackageAndClass().packageName(), module.getPackageAndClass().className() + "$" + mangledClass);
        String pimpClassInternalName = packageAndClass.toJVMType();
        String outerName = module.getPackageAndClass().toJVMType();
        mainClassWriter.visitInnerClass(pimpClassInternalName, outerName, mangledClass, 9);
        this.classWriter = new ClassWriter(3);
        this.classWriter.visit(51, 33, pimpClassInternalName, null, JOBJECT, null);
        this.classWriter.visitSource(this.sourceFilename, null);
        this.classWriter.visitOuterClass(outerName, null, null);
        for (GoloFunction function : functions) {
            function.accept(this);
        }
        HashSet<ModuleImport> imports = new HashSet<ModuleImport>(module.getImports());
        imports.add(new ModuleImport(module.getPackageAndClass()));
        this.writeImportMetaData(imports);
        this.classWriter.visitEnd();
        this.generationResults.add(new CodeGenerationResult(this.classWriter.toByteArray(), packageAndClass));
        this.classWriter = mainClassWriter;
    }

    @Override
    public void visitFunction(GoloFunction function) {
        String signature;
        int accessFlags;
        int n = accessFlags = function.getVisibility() == GoloFunction.Visibility.PUBLIC ? 1 : 2;
        if (function.isVarargs()) {
            accessFlags |= 0x80;
            signature = this.goloVarargsFunctionSignature(function.getArity());
        } else {
            signature = this.goloFunctionSignature(function.getArity());
        }
        if (function.isSynthetic()) {
            accessFlags |= 0x1000;
        }
        this.context.methodArityStack.push(function.getArity());
        this.methodVisitor = this.classWriter.visitMethod(accessFlags | 8, function.getName(), signature, null, null);
        this.methodVisitor.visitCode();
        this.context.labelRangeStack.push(new LabelRange(new Label(), new Label()));
        function.getBlock().accept(this);
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
        this.context.methodArityStack.pop();
    }

    private String goloFunctionSignature(int arity) {
        return MethodType.genericMethodType(arity).toMethodDescriptorString();
    }

    private String goloVarargsFunctionSignature(int arity) {
        return MethodType.genericMethodType(arity - 1, true).toMethodDescriptorString();
    }

    @Override
    public void visitBlock(Block block) {
        ReferenceTable referenceTable = block.getReferenceTable();
        this.context.referenceTableStack.push(referenceTable);
        LabelRange labelRange = this.context.labelRangeStack.isEmpty() ? new LabelRange(new Label(), new Label()) : (LabelRange)this.context.labelRangeStack.pop();
        int lastParameterIndex = (Integer)this.context.methodArityStack.peek() - 1;
        for (LocalReference localReference : referenceTable.ownedReferences()) {
            if (localReference.getIndex() <= lastParameterIndex) continue;
            this.methodVisitor.visitLocalVariable(localReference.getName(), TOBJECT, null, labelRange.begin, labelRange.end, localReference.getIndex());
        }
        for (GoloStatement statement : block.getStatements()) {
            statement.accept(this);
            this.insertMissingPop(statement);
        }
        this.context.referenceTableStack.pop();
    }

    private void insertMissingPop(GoloStatement statement) {
        BinaryOperation operation;
        Class<?> statementClass = statement.getClass();
        if (statementClass == FunctionInvocation.class) {
            this.methodVisitor.visitInsn(87);
        } else if (statementClass == BinaryOperation.class && (operation = (BinaryOperation)statement).getType() == OperatorType.METHOD_CALL) {
            this.methodVisitor.visitInsn(87);
        }
    }

    private static boolean between(int value, int lower, int upper) {
        return value >= lower && value <= upper;
    }

    private void loadInteger(int value) {
        if (JavaBytecodeGenerationGoloIrVisitor.between(value, Short.MIN_VALUE, Short.MAX_VALUE)) {
            if (JavaBytecodeGenerationGoloIrVisitor.between(value, -128, 127)) {
                if (JavaBytecodeGenerationGoloIrVisitor.between(value, -1, 5)) {
                    this.methodVisitor.visitInsn(ICONST[value + 1]);
                } else {
                    this.methodVisitor.visitIntInsn(16, value);
                }
            } else {
                this.methodVisitor.visitIntInsn(17, value);
            }
        } else {
            this.methodVisitor.visitLdcInsn((Object)value);
        }
    }

    private void loadLong(long value) {
        if (value == 0L) {
            this.methodVisitor.visitInsn(9);
        } else if (value == 1L) {
            this.methodVisitor.visitInsn(10);
        } else {
            this.methodVisitor.visitLdcInsn((Object)value);
        }
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
        Object value = constantStatement.getValue();
        if (value == null) {
            this.methodVisitor.visitInsn(1);
            return;
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            this.loadInteger(i);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            return;
        }
        if (value instanceof Long) {
            long l = (Long)value;
            this.loadLong(l);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            return;
        }
        if (value instanceof Boolean) {
            boolean b = (Boolean)value;
            this.loadInteger(b ? 1 : 0);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            return;
        }
        if (value instanceof String) {
            this.methodVisitor.visitLdcInsn(value);
            return;
        }
        if (value instanceof Character) {
            this.loadInteger(((Character)value).charValue());
            this.methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            return;
        }
        if (value instanceof GoloParser.ParserClassRef) {
            GoloParser.ParserClassRef ref = (GoloParser.ParserClassRef)value;
            this.methodVisitor.visitInvokeDynamicInsn(ref.name.replaceAll("\\.", "#"), "()Ljava/lang/Class;", CLASSREF_HANDLE, new Object[0]);
            return;
        }
        if (value instanceof GoloParser.FunctionRef) {
            GoloParser.FunctionRef ref = (GoloParser.FunctionRef)value;
            String module = ref.module;
            if (module == null) {
                module = this.klass;
            }
            this.methodVisitor.visitLdcInsn((Object)ref.name);
            this.methodVisitor.visitInvokeDynamicInsn(module.replaceAll("\\.", "#"), "()Ljava/lang/Class;", CLASSREF_HANDLE, new Object[0]);
            this.methodVisitor.visitInvokeDynamicInsn("gololang#Predefined#fun", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", FUNCTION_INVOCATION_HANDLE, new Object[0]);
            return;
        }
        if (value instanceof Double) {
            double d = (Double)value;
            this.methodVisitor.visitLdcInsn((Object)d);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            return;
        }
        if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            this.methodVisitor.visitLdcInsn((Object)Float.valueOf(f));
            this.methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            return;
        }
        throw new IllegalArgumentException("Constants of type " + value.getClass() + " cannot be handled.");
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        returnStatement.getExpressionStatement().accept(this);
        this.methodVisitor.visitInsn(176);
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        throwStatement.getExpressionStatement().accept(this);
        this.methodVisitor.visitTypeInsn(192, "java/lang/Throwable");
        this.methodVisitor.visitInsn(191);
    }

    private void invocation(AbstractInvocation invocation, Handle boostrap, int arity) {
        this.invocation(invocation, boostrap, this.goloFunctionSignature(arity));
    }

    private void invocation(AbstractInvocation invocation, Handle boostrap, String signature) {
        for (ExpressionStatement statement : invocation.getArguments()) {
            statement.accept(this);
        }
        this.methodVisitor.visitInvokeDynamicInsn(invocation.getName().replaceAll("\\.", "#"), signature, boostrap, new Object[0]);
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        if (functionInvocation.isOnReference()) {
            ReferenceTable table = (ReferenceTable)this.context.referenceTableStack.peek();
            this.methodVisitor.visitVarInsn(25, table.get(functionInvocation.getName()).getIndex());
            this.methodVisitor.visitTypeInsn(192, "java/lang/invoke/MethodHandle");
            MethodType type = MethodType.genericMethodType(functionInvocation.getArity() + 1).changeParameterType(0, MethodHandle.class);
            this.invocation((AbstractInvocation)functionInvocation, CLOSURE_INVOCATION_HANDLE, type.toMethodDescriptorString());
        } else {
            this.invocation((AbstractInvocation)functionInvocation, FUNCTION_INVOCATION_HANDLE, functionInvocation.getArity());
        }
    }

    @Override
    public void acceptMethodInvocation(MethodInvocation methodInvocation) {
        this.invocation((AbstractInvocation)methodInvocation, METHOD_INVOCATION_HANDLE, methodInvocation.getArity() + 1);
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        assignmentStatement.getExpressionStatement().accept(this);
        this.methodVisitor.visitVarInsn(58, assignmentStatement.getLocalReference().getIndex());
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        LocalReference reference = referenceLookup.resolveIn((ReferenceTable)this.context.referenceTableStack.peek());
        this.methodVisitor.visitVarInsn(25, reference.getIndex());
    }

    @Override
    public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        Label startLabel = new Label();
        Label endLabel = new Label();
        Label branchingElseLabel = new Label();
        Label branchingExitLabel = new Label();
        conditionalBranching.getCondition().accept(this);
        this.methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
        this.methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        this.methodVisitor.visitJumpInsn(153, branchingElseLabel);
        this.context.labelRangeStack.push(new LabelRange(startLabel, endLabel));
        conditionalBranching.getTrueBlock().accept(this);
        if (conditionalBranching.hasFalseBlock()) {
            if (!conditionalBranching.getTrueBlock().hasReturn()) {
                this.methodVisitor.visitJumpInsn(167, branchingExitLabel);
            }
            this.methodVisitor.visitLabel(branchingElseLabel);
            this.context.labelRangeStack.push(new LabelRange(endLabel, new Label()));
            conditionalBranching.getFalseBlock().accept(this);
            this.methodVisitor.visitLabel(branchingExitLabel);
        } else if (conditionalBranching.hasElseConditionalBranching()) {
            if (!conditionalBranching.getTrueBlock().hasReturn()) {
                this.methodVisitor.visitJumpInsn(167, branchingExitLabel);
            }
            this.methodVisitor.visitLabel(branchingElseLabel);
            conditionalBranching.getElseConditionalBranching().accept(this);
            this.methodVisitor.visitLabel(branchingExitLabel);
        } else {
            this.methodVisitor.visitLabel(branchingElseLabel);
        }
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        Label loopStart = new Label();
        Label loopEnd = new Label();
        if (loopStatement.hasInitStatement()) {
            loopStatement.getInitStatement().accept(this);
        }
        this.methodVisitor.visitLabel(loopStart);
        loopStatement.getConditionStatement().accept(this);
        this.methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
        this.methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        this.methodVisitor.visitJumpInsn(153, loopEnd);
        this.context.labelRangeStack.push(new LabelRange(new Label(), new Label()));
        loopStatement.getBlock().accept(this);
        if (loopStatement.hasPostStatement()) {
            loopStatement.getPostStatement().accept(this);
        }
        this.methodVisitor.visitJumpInsn(167, loopStart);
        this.methodVisitor.visitLabel(loopEnd);
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label catchStart = new Label();
        Label catchEnd = new Label();
        Label rethrowStart = null;
        Label rethrowEnd = null;
        if (tryCatchFinally.isTryCatchFinally()) {
            rethrowStart = new Label();
            rethrowEnd = new Label();
        }
        this.methodVisitor.visitTryCatchBlock(tryStart, tryEnd, catchStart, null);
        this.methodVisitor.visitLabel(tryStart);
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.isTryCatch() || tryCatchFinally.isTryCatchFinally()) {
            this.methodVisitor.visitJumpInsn(167, catchEnd);
        }
        this.methodVisitor.visitLabel(tryEnd);
        if (tryCatchFinally.isTryFinally()) {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitJumpInsn(167, catchEnd);
        }
        if (tryCatchFinally.isTryCatchFinally()) {
            this.methodVisitor.visitTryCatchBlock(catchStart, catchEnd, rethrowStart, null);
        }
        this.methodVisitor.visitLabel(catchStart);
        if (tryCatchFinally.isTryCatch() || tryCatchFinally.isTryCatchFinally()) {
            Block catchBlock = tryCatchFinally.getCatchBlock();
            int exceptionRefIndex = catchBlock.getReferenceTable().get(tryCatchFinally.getExceptionId()).getIndex();
            this.methodVisitor.visitVarInsn(58, exceptionRefIndex);
            tryCatchFinally.getCatchBlock().accept(this);
        } else {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitInsn(191);
        }
        this.methodVisitor.visitLabel(catchEnd);
        if (tryCatchFinally.isTryCatchFinally()) {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitJumpInsn(167, rethrowEnd);
            this.methodVisitor.visitLabel(rethrowStart);
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitInsn(191);
            this.methodVisitor.visitLabel(rethrowEnd);
        }
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        GoloFunction target = closureReference.getTarget();
        boolean isVarArgs = target.isVarargs();
        int arity = isVarArgs ? target.getArity() - 1 : target.getArity();
        this.methodVisitor.visitInvokeDynamicInsn(target.getName(), MethodType.methodType(MethodHandle.class).toMethodDescriptorString(), CLOSUREREF_HANDLE, new Object[]{this.klass, arity, isVarArgs});
        int syntheticCount = closureReference.getTarget().getSyntheticParameterCount();
        if (syntheticCount > 0) {
            ReferenceTable table = (ReferenceTable)this.context.referenceTableStack.peek();
            String[] refs = closureReference.getCapturedReferenceNames().toArray(new String[syntheticCount]);
            this.loadInteger(closureReference.getSyntheticArgumentsIndexStart());
            this.loadInteger(syntheticCount);
            this.methodVisitor.visitTypeInsn(189, JOBJECT);
            for (int i = 0; i < syntheticCount; ++i) {
                this.methodVisitor.visitInsn(89);
                this.loadInteger(i);
                this.methodVisitor.visitVarInsn(25, table.get(refs[i]).getIndex());
                this.methodVisitor.visitInsn(83);
            }
            this.methodVisitor.visitMethodInsn(184, "java/lang/invoke/MethodHandles", "insertArguments", "(Ljava/lang/invoke/MethodHandle;I[Ljava/lang/Object;)Ljava/lang/invoke/MethodHandle;");
        }
    }

    @Override
    public void acceptBinaryOperation(BinaryOperation binaryOperation) {
        binaryOperation.getLeftExpression().accept(this);
        binaryOperation.getRightExpression().accept(this);
        if (!binaryOperation.getType().equals((Object)OperatorType.METHOD_CALL)) {
            String name = binaryOperation.getType().name().toLowerCase();
            this.methodVisitor.visitInvokeDynamicInsn(name, this.goloFunctionSignature(2), OPERATOR_HANDLE, new Object[]{2});
        }
    }

    @Override
    public void visitUnaryOperation(UnaryOperation unaryOperation) {
        String name = unaryOperation.getType().name().toLowerCase();
        unaryOperation.getExpressionStatement().accept(this);
        this.methodVisitor.visitInvokeDynamicInsn(name, this.goloFunctionSignature(1), OPERATOR_HANDLE, new Object[]{1});
    }

    static {
        String bootstrapOwner = "fr/insalyon/citi/golo/runtime/FunctionCallSupport";
        String bootstrapMethod = "bootstrap";
        String description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
        FUNCTION_INVOCATION_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        bootstrapOwner = "fr/insalyon/citi/golo/runtime/OperatorSupport";
        bootstrapMethod = "bootstrap";
        description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;I)Ljava/lang/invoke/CallSite;";
        OPERATOR_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        bootstrapOwner = "fr/insalyon/citi/golo/runtime/MethodInvocationSupport";
        bootstrapMethod = "bootstrap";
        description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
        METHOD_INVOCATION_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        bootstrapOwner = "fr/insalyon/citi/golo/runtime/ClassReferenceSupport";
        bootstrapMethod = "bootstrap";
        description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
        CLASSREF_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        bootstrapOwner = "fr/insalyon/citi/golo/runtime/ClosureReferenceSupport";
        bootstrapMethod = "bootstrap";
        description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/String;II)Ljava/lang/invoke/CallSite;";
        CLOSUREREF_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        bootstrapOwner = "fr/insalyon/citi/golo/runtime/ClosureCallSupport";
        bootstrapMethod = "bootstrap";
        description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
        CLOSURE_INVOCATION_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        ICONST = new int[]{2, 3, 4, 5, 6, 7, 8};
    }

    private static class LabelRange {
        final Label begin;
        final Label end;

        private LabelRange(Label begin, Label end) {
            this.begin = begin;
            this.end = end;
        }
    }

    private static class Context {
        private final Stack<ReferenceTable> referenceTableStack = new Stack();
        private final Stack<Integer> methodArityStack = new Stack();
        private final Stack<LabelRange> labelRangeStack = new Stack();

        private Context() {
        }
    }
}

