/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler;

import fr.insalyon.citi.golo.compiler.GoloCompilationException;
import fr.insalyon.citi.golo.compiler.ir.AssignmentStatement;
import fr.insalyon.citi.golo.compiler.ir.BinaryOperation;
import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.ClosureReference;
import fr.insalyon.citi.golo.compiler.ir.ConditionalBranching;
import fr.insalyon.citi.golo.compiler.ir.ConstantStatement;
import fr.insalyon.citi.golo.compiler.ir.ExpressionStatement;
import fr.insalyon.citi.golo.compiler.ir.FunctionInvocation;
import fr.insalyon.citi.golo.compiler.ir.GoloFunction;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.GoloModule;
import fr.insalyon.citi.golo.compiler.ir.GoloStatement;
import fr.insalyon.citi.golo.compiler.ir.LocalReference;
import fr.insalyon.citi.golo.compiler.ir.LoopStatement;
import fr.insalyon.citi.golo.compiler.ir.MethodInvocation;
import fr.insalyon.citi.golo.compiler.ir.ReferenceLookup;
import fr.insalyon.citi.golo.compiler.ir.ReferenceTable;
import fr.insalyon.citi.golo.compiler.ir.ReturnStatement;
import fr.insalyon.citi.golo.compiler.ir.ThrowStatement;
import fr.insalyon.citi.golo.compiler.ir.TryCatchFinally;
import fr.insalyon.citi.golo.compiler.ir.UnaryOperation;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

class LocalReferenceAssignmentAndVerificationVisitor
implements GoloIrVisitor {
    private GoloModule module = null;
    private int indexAssignmentCounter = 0;
    private Stack<ReferenceTable> tableStack = new Stack();
    private Stack<Set<LocalReference>> assignmentStack = new Stack();
    private GoloCompilationException.Builder exceptionBuilder;

    LocalReferenceAssignmentAndVerificationVisitor() {
    }

    private void resetIndexAssignmentCounter() {
        this.indexAssignmentCounter = 0;
    }

    private int nextAssignmentIndex() {
        int value = this.indexAssignmentCounter++;
        return value;
    }

    public void setExceptionBuilder(GoloCompilationException.Builder builder) {
        this.exceptionBuilder = builder;
    }

    private GoloCompilationException.Builder getExceptionBuilder() {
        if (this.exceptionBuilder == null) {
            this.exceptionBuilder = new GoloCompilationException.Builder(this.module.getPackageAndClass().toString());
        }
        return this.exceptionBuilder;
    }

    @Override
    public void visitModule(GoloModule module) {
        this.module = module;
        for (GoloFunction function : module.getFunctions()) {
            function.accept(this);
        }
        for (String pimpTarget : module.getPimps().keySet()) {
            Set<GoloFunction> functions = module.getPimps().get(pimpTarget);
            for (GoloFunction function : functions) {
                function.accept(this);
            }
        }
    }

    @Override
    public void visitFunction(GoloFunction function) {
        this.resetIndexAssignmentCounter();
        ReferenceTable table = function.getBlock().getReferenceTable();
        for (String parameterName : function.getParameterNames()) {
            LocalReference reference = table.get(parameterName);
            if (reference == null) {
                throw new IllegalStateException("[please report this bug] " + parameterName + " is not declared in the references of function " + function.getName());
            }
            reference.setIndex(this.nextAssignmentIndex());
        }
        function.getBlock().accept(this);
    }

    @Override
    public void visitBlock(Block block) {
        ReferenceTable table = block.getReferenceTable();
        for (LocalReference reference : table.ownedReferences()) {
            if (reference.getIndex() >= 0) continue;
            reference.setIndex(this.nextAssignmentIndex());
        }
        this.tableStack.push(table);
        this.assignmentStack.push(new HashSet());
        for (GoloStatement statement : block.getStatements()) {
            statement.accept(this);
        }
        this.tableStack.pop();
        this.assignmentStack.pop();
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        returnStatement.getExpressionStatement().accept(this);
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        if (this.tableStack.peek().hasReferenceFor(functionInvocation.getName())) {
            functionInvocation.setOnReference(true);
        }
        for (ExpressionStatement argument : functionInvocation.getArguments()) {
            argument.accept(this);
        }
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        LocalReference reference = assignmentStatement.getLocalReference();
        if (reference.getKind().equals((Object)LocalReference.Kind.CONSTANT)) {
            Set<LocalReference> assignedReferences = this.assignmentStack.peek();
            if (assignedReferences.contains(reference)) {
                this.getExceptionBuilder().report(GoloCompilationException.Problem.Type.ASSIGN_CONSTANT, assignmentStatement.getASTNode(), "Assigning " + reference.getName() + " at " + assignmentStatement.getPositionInSourceCode() + " but it is a constant");
            } else {
                assignedReferences.add(reference);
            }
        }
        assignmentStatement.getExpressionStatement().accept(this);
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        ReferenceTable table = this.tableStack.peek();
        if (!table.hasReferenceFor(referenceLookup.getName())) {
            this.getExceptionBuilder().report(GoloCompilationException.Problem.Type.UNDECLARED_REFERENCE, referenceLookup.getASTNode(), "Undeclared reference at " + referenceLookup.getPositionInSourceCode());
        }
    }

    @Override
    public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        conditionalBranching.getCondition().accept(this);
        conditionalBranching.getTrueBlock().accept(this);
        if (conditionalBranching.hasFalseBlock()) {
            conditionalBranching.getFalseBlock().accept(this);
        } else if (conditionalBranching.hasElseConditionalBranching()) {
            conditionalBranching.getElseConditionalBranching().accept(this);
        }
    }

    @Override
    public void acceptBinaryOperation(BinaryOperation binaryOperation) {
        binaryOperation.getLeftExpression().accept(this);
        binaryOperation.getRightExpression().accept(this);
    }

    @Override
    public void visitUnaryOperation(UnaryOperation unaryOperation) {
        unaryOperation.getExpressionStatement().accept(this);
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        if (loopStatement.hasInitStatement()) {
            loopStatement.getInitStatement().accept(this);
        }
        loopStatement.getConditionStatement().accept(this);
        loopStatement.getBlock().accept(this);
        if (loopStatement.hasPostStatement()) {
            loopStatement.getPostStatement().accept(this);
        }
    }

    @Override
    public void acceptMethodInvocation(MethodInvocation methodInvocation) {
        for (ExpressionStatement argument : methodInvocation.getArguments()) {
            argument.accept(this);
        }
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        throwStatement.getExpressionStatement().accept(this);
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.hasCatchBlock()) {
            tryCatchFinally.getCatchBlock().accept(this);
        }
        if (tryCatchFinally.hasFinallyBlock()) {
            tryCatchFinally.getFinallyBlock().accept(this);
        }
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        GoloFunction target = closureReference.getTarget();
        int totalArgsCount = target.getParameterNames().size();
        int startIndex = totalArgsCount - target.getSyntheticParameterCount();
        closureReference.setSyntheticArgumentsIndexStart(startIndex);
        int currentIndex = 0;
        for (String name : target.getParameterNames()) {
            if (currentIndex >= startIndex) {
                closureReference.addCapturedReferenceName(name);
            }
            ++currentIndex;
        }
    }
}

