/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler.ir;

import fr.insalyon.citi.golo.compiler.PackageAndClass;
import fr.insalyon.citi.golo.compiler.ir.GoloElement;
import fr.insalyon.citi.golo.compiler.ir.GoloFunction;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.ModuleImport;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class GoloModule
extends GoloElement {
    private final PackageAndClass packageAndClass;
    private final Set<ModuleImport> imports = new HashSet<ModuleImport>();
    private final Set<GoloFunction> functions = new HashSet<GoloFunction>();
    private final Map<String, Set<GoloFunction>> pimps = new HashMap<String, Set<GoloFunction>>();
    public static final ModuleImport PREDEF = new ModuleImport(PackageAndClass.fromString("gololang.Predefined"));
    public static final ModuleImport STD_PIMPS = new ModuleImport(PackageAndClass.fromString("gololang.StandardPimps"));
    public static final ModuleImport GOLOLANG = new ModuleImport(PackageAndClass.fromString("gololang"));

    public GoloModule(PackageAndClass packageAndClass) {
        this.packageAndClass = packageAndClass;
        this.imports.add(PREDEF);
        this.imports.add(STD_PIMPS);
        this.imports.add(GOLOLANG);
    }

    public PackageAndClass getPackageAndClass() {
        return this.packageAndClass;
    }

    public Set<ModuleImport> getImports() {
        return Collections.unmodifiableSet(this.imports);
    }

    public Map<String, Set<GoloFunction>> getPimps() {
        return Collections.unmodifiableMap(this.pimps);
    }

    public void addImport(ModuleImport moduleImport) {
        this.imports.add(moduleImport);
    }

    public void addFunction(GoloFunction function) {
        this.functions.add(function);
    }

    public void addPimp(String target, GoloFunction function) {
        Set<Object> bag;
        if (!this.pimps.containsKey(target)) {
            bag = new HashSet();
            this.pimps.put(target, bag);
        } else {
            bag = this.pimps.get(target);
        }
        bag.add(function);
    }

    public Set<GoloFunction> getFunctions() {
        return Collections.unmodifiableSet(this.functions);
    }

    public void accept(GoloIrVisitor visitor) {
        visitor.visitModule(this);
    }
}

