/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler.ir;

import fr.insalyon.citi.golo.compiler.ir.LocalReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ReferenceTable {
    private ReferenceTable parent;
    private final Map<String, LocalReference> table = new HashMap<String, LocalReference>();

    public ReferenceTable() {
        this(null);
    }

    private ReferenceTable(ReferenceTable parent) {
        this.parent = parent;
    }

    public ReferenceTable add(LocalReference reference) {
        this.table.put(reference.getName(), reference);
        return this;
    }

    public boolean hasReferenceFor(String name) {
        return this.table.containsKey(name) || this.parent != null && this.parent.hasReferenceFor(name);
    }

    public LocalReference get(String name) {
        LocalReference reference = this.table.get(name);
        if (reference != null) {
            return reference;
        }
        if (this.parent != null) {
            return this.parent.get(name);
        }
        return null;
    }

    public Set<String> ownedSymbols() {
        return Collections.unmodifiableSet(this.table.keySet());
    }

    public Collection<LocalReference> ownedReferences() {
        return Collections.unmodifiableCollection(this.table.values());
    }

    public void relink(ReferenceTable parent) {
        this.parent = parent;
    }

    public Set<String> symbols() {
        HashSet<String> localSymbols = new HashSet<String>(this.table.keySet());
        if (this.parent != null) {
            localSymbols.addAll(this.parent.symbols());
        }
        return localSymbols;
    }

    public Collection<LocalReference> references() {
        HashSet<LocalReference> localReferences = new HashSet<LocalReference>(this.table.values());
        if (this.parent != null) {
            localReferences.addAll(this.parent.references());
        }
        return localReferences;
    }

    public ReferenceTable fork() {
        return new ReferenceTable(this);
    }

    public ReferenceTable flatDeepCopy() {
        ReferenceTable referenceTable = new ReferenceTable();
        for (LocalReference reference : this.references()) {
            referenceTable.add(new LocalReference(reference.getKind(), reference.getName()));
        }
        return referenceTable;
    }

    public void remove(String name) {
        this.table.remove(name);
    }
}

