/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import fr.insalyon.citi.golo.runtime.Module;
import fr.insalyon.citi.golo.runtime.TypeMatching;
import gololang.DynamicObject;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class MethodInvocationSupport {
    private static final MethodHandle CLASS_GUARD;
    private static final MethodHandle INSTANCE_GUARD;
    private static final MethodHandle FALLBACK;
    private static final MethodHandle VTABLE_LOOKUP;
    private static final MethodHandle NOT_DYNAMIC_OBJECT;
    private static final Set<String> DYNAMIC_OBJECT_RESERVED_METHOD_NAMES;

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type) {
        MethodHandle fallbackHandle;
        InlineCache callSite = new InlineCache(caller, name, type);
        callSite.fallback = fallbackHandle = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallbackHandle);
        return callSite;
    }

    public static boolean classGuard(Class<?> expected, Object receiver) {
        return receiver.getClass() == expected;
    }

    public static boolean instanceGuard(Object expected, Object receiver) {
        return expected == receiver;
    }

    public static boolean notDynamicObject(Object receiver) {
        return receiver.getClass() != DynamicObject.class;
    }

    public static MethodHandle vtableLookup(InlineCache inlineCache, Object[] args) {
        Class<?> receiverClass = args[0].getClass();
        MethodHandle target = inlineCache.vtable.get(receiverClass);
        if (target == null) {
            target = MethodInvocationSupport.findTarget(receiverClass, inlineCache, args);
            inlineCache.vtable.put(receiverClass, target);
        }
        return target;
    }

    public static Object fallback(InlineCache inlineCache, Object[] args) throws Throwable {
        if (MethodInvocationSupport.isCallOnDynamicObject(inlineCache, args[0])) {
            return MethodInvocationSupport.installDynamicObjectDispatch(inlineCache, args);
        }
        if (inlineCache.isMegaMorphic()) {
            return MethodInvocationSupport.installVTableDispatch(inlineCache, args);
        }
        Class<?> receiverClass = args[0].getClass();
        MethodHandle target = MethodInvocationSupport.findTarget(receiverClass, inlineCache, args);
        MethodHandle guard = CLASS_GUARD.bindTo(receiverClass);
        MethodHandle fallback = inlineCache.state == InlineCache.State.POLYMORPHIC ? inlineCache.getTarget() : inlineCache.fallback;
        MethodHandle root = MethodHandles.guardWithTest(guard, target, fallback);
        inlineCache.setTarget(root);
        inlineCache.state = InlineCache.State.POLYMORPHIC;
        ++inlineCache.depth;
        return target.invokeWithArguments(args);
    }

    private static Object installVTableDispatch(InlineCache inlineCache, Object[] args) throws Throwable {
        if (inlineCache.vtable == null) {
            inlineCache.vtable = new HashMap();
        }
        MethodHandle lookup = VTABLE_LOOKUP.bindTo(inlineCache).asCollector(Object[].class, args.length);
        MethodHandle exactInvoker = MethodHandles.exactInvoker(inlineCache.type());
        MethodHandle vtableTarget = MethodHandles.foldArguments(exactInvoker, lookup);
        MethodHandle gwt = MethodHandles.guardWithTest(NOT_DYNAMIC_OBJECT, vtableTarget, inlineCache.fallback);
        inlineCache.setTarget(gwt);
        inlineCache.setTarget(vtableTarget);
        return vtableTarget.invokeWithArguments(args);
    }

    private static Object installDynamicObjectDispatch(InlineCache inlineCache, Object[] args) throws Throwable {
        DynamicObject dynamicObject = (DynamicObject)args[0];
        MethodHandle target = dynamicObject.plug(inlineCache.name, inlineCache.type(), inlineCache.fallback);
        MethodHandle guard = INSTANCE_GUARD.bindTo(dynamicObject);
        MethodHandle root = MethodHandles.guardWithTest(guard, target, inlineCache.fallback);
        inlineCache.state = InlineCache.State.DYNAMIC_OBJECT;
        inlineCache.resetWith(root);
        return target.invokeWithArguments(args);
    }

    private static boolean isCallOnDynamicObject(InlineCache inlineCache, Object arg) {
        return arg instanceof DynamicObject && !DYNAMIC_OBJECT_RESERVED_METHOD_NAMES.contains(inlineCache.name);
    }

    private static MethodHandle findTarget(Class<?> receiverClass, InlineCache inlineCache, Object[] args) {
        MethodHandle target;
        MethodType type = inlineCache.type();
        boolean makeAccessible = !Modifier.isPublic(receiverClass.getModifiers());
        Object searchResult = MethodInvocationSupport.findMethodOrField(receiverClass, inlineCache.name, type.parameterArray(), args);
        if (searchResult != null) {
            try {
                MethodHandle target2;
                if (searchResult.getClass() == Method.class) {
                    Method method = (Method)searchResult;
                    if (makeAccessible) {
                        method.setAccessible(true);
                    }
                    target2 = inlineCache.callerLookup.unreflect(method).asType(type);
                } else {
                    Field field = (Field)searchResult;
                    if (makeAccessible) {
                        field.setAccessible(true);
                    }
                    if (args.length == 1) {
                        target2 = inlineCache.callerLookup.unreflectGetter(field).asType(type);
                    } else {
                        target2 = inlineCache.callerLookup.unreflectSetter(field);
                        target2 = MethodHandles.filterReturnValue(target2, MethodHandles.constant(receiverClass, args[0])).asType(type);
                    }
                }
                return target2;
            }
            catch (IllegalAccessException ignored) {
                // empty catch block
            }
        }
        if ((target = MethodInvocationSupport.findInPimps(receiverClass, inlineCache)) != null) {
            return target;
        }
        throw new NoSuchMethodError(receiverClass + "::" + inlineCache.name);
    }

    private static Object findMethodOrField(Class<?> receiverClass, String name, Class<?>[] argumentTypes, Object[] args) {
        LinkedList<Method> candidates = new LinkedList<Method>();
        for (Method method : receiverClass.getMethods()) {
            if (!MethodInvocationSupport.isCandidateMethod(name, method)) continue;
            candidates.add(method);
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        if (!candidates.isEmpty()) {
            for (Method method : candidates) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                Object[] objectArray = Arrays.copyOfRange(args, 1, args.length);
                if (!TypeMatching.haveSameNumberOfArguments(objectArray, parameterTypes) && !TypeMatching.haveEnoughArgumentsForVarargs(objectArray, method, parameterTypes) || !TypeMatching.canAssign(parameterTypes, objectArray, method.isVarArgs())) continue;
                return method;
            }
        }
        if (argumentTypes.length <= 2) {
            for (AccessibleObject accessibleObject : receiverClass.getDeclaredFields()) {
                if (!MethodInvocationSupport.isMatchingField(name, (Field)accessibleObject)) continue;
                return accessibleObject;
            }
            for (AccessibleObject accessibleObject : receiverClass.getFields()) {
                if (!MethodInvocationSupport.isMatchingField(name, (Field)accessibleObject)) continue;
                return accessibleObject;
            }
        }
        return null;
    }

    private static MethodHandle findInPimps(Class<?> receiverClass, InlineCache inlineCache) {
        Class<?> callerClass = inlineCache.callerLookup.lookupClass();
        String name = inlineCache.name;
        MethodType type = inlineCache.type();
        MethodHandles.Lookup lookup = inlineCache.callerLookup;
        int arity = inlineCache.type().parameterCount();
        ClassLoader classLoader = callerClass.getClassLoader();
        for (String pimp : Module.pimps(callerClass)) {
            try {
                Class<?> pimpedClass = classLoader.loadClass(pimp);
                if (!pimpedClass.isAssignableFrom(receiverClass)) continue;
                Class<?> pimpClass = classLoader.loadClass(MethodInvocationSupport.pimpClassName(callerClass, pimpedClass));
                for (Method method : pimpClass.getMethods()) {
                    if (!MethodInvocationSupport.isCandidateMethod(name, method) || !MethodInvocationSupport.pimpMethodMatches(arity, method)) continue;
                    return lookup.unreflect(method).asType(type);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException ignored) {
                // empty catch block
            }
        }
        for (String importSymbol : Module.imports(callerClass)) {
            try {
                Class<?> importClass = classLoader.loadClass(importSymbol);
                for (String pimp : Module.pimps(importClass)) {
                    try {
                        Class<?> pimpedClass = classLoader.loadClass(pimp);
                        if (!pimpedClass.isAssignableFrom(receiverClass)) continue;
                        Class<?> pimpClass = classLoader.loadClass(MethodInvocationSupport.pimpClassName(importClass, pimpedClass));
                        for (Method method : pimpClass.getMethods()) {
                            if (!MethodInvocationSupport.isCandidateMethod(name, method) || !MethodInvocationSupport.pimpMethodMatches(arity, method)) continue;
                            return lookup.unreflect(method).asType(type);
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException ignored) {
                        // empty catch block
                    }
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean pimpMethodMatches(int arity, Method method) {
        int parameterCount = method.getParameterTypes().length;
        return parameterCount == arity || method.isVarArgs() && parameterCount <= arity;
    }

    private static String pimpClassName(Class<?> moduleClass, Class<?> pimpedClass) {
        return moduleClass.getName() + "$" + pimpedClass.getName().replace('.', '$');
    }

    private static boolean isMatchingField(String name, Field field) {
        return field.getName().equals(name) && !Modifier.isStatic(field.getModifiers());
    }

    private static boolean isCandidateMethod(String name, Method method) {
        return method.getName().equals(name) && Modifier.isPublic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers());
    }

    static {
        DYNAMIC_OBJECT_RESERVED_METHOD_NAMES = new HashSet<String>(){
            {
                this.add("get");
                this.add("plug");
                this.add("define");
                this.add("undefine");
                this.add("mixin");
                this.add("copy");
                this.add("freeze");
                this.add("properties");
            }
        };
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CLASS_GUARD = lookup.findStatic(MethodInvocationSupport.class, "classGuard", MethodType.methodType(Boolean.TYPE, Class.class, Object.class));
            INSTANCE_GUARD = lookup.findStatic(MethodInvocationSupport.class, "instanceGuard", MethodType.methodType(Boolean.TYPE, Object.class, Object.class));
            FALLBACK = lookup.findStatic(MethodInvocationSupport.class, "fallback", MethodType.methodType(Object.class, InlineCache.class, Object[].class));
            VTABLE_LOOKUP = lookup.findStatic(MethodInvocationSupport.class, "vtableLookup", MethodType.methodType(MethodHandle.class, InlineCache.class, Object[].class));
            NOT_DYNAMIC_OBJECT = lookup.findStatic(MethodInvocationSupport.class, "notDynamicObject", MethodType.methodType(Boolean.TYPE, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles", e);
        }
    }

    static class InlineCache
    extends MutableCallSite {
        final MethodHandles.Lookup callerLookup;
        final String name;
        int depth = 0;
        State state = State.POLYMORPHIC;
        MethodHandle fallback;
        HashMap<Class, MethodHandle> vtable;

        InlineCache(MethodHandles.Lookup callerLookup, String name, MethodType type) {
            super(type);
            this.callerLookup = callerLookup;
            this.name = name;
        }

        boolean isMegaMorphic() {
            return this.depth > 5;
        }

        void resetWith(MethodHandle target) {
            this.setTarget(target);
        }

        static enum State {
            DYNAMIC_OBJECT,
            POLYMORPHIC;

        }
    }
}

