/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class TypeMatching {
    private static final Map<Class, Class> PRIMITIVE_MAP = new HashMap<Class, Class>(){
        {
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Character.TYPE, Character.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
        }
    };

    TypeMatching() {
    }

    static boolean haveEnoughArgumentsForVarargs(Object[] arguments, Constructor constructor, Class<?>[] parameterTypes) {
        return constructor.isVarArgs() && arguments.length >= parameterTypes.length;
    }

    static boolean haveEnoughArgumentsForVarargs(Object[] arguments, Method method, Class<?>[] parameterTypes) {
        return method.isVarArgs() && arguments.length >= parameterTypes.length - 1;
    }

    static boolean haveSameNumberOfArguments(Object[] arguments, Class<?>[] parameterTypes) {
        return parameterTypes.length == arguments.length;
    }

    static boolean canAssign(Class<?>[] types, Object[] arguments, boolean varArgs) {
        if (types.length == 0 || arguments.length == 0) {
            return true;
        }
        for (int i = 0; i < types.length - 1; ++i) {
            if (TypeMatching.valueAndTypeMatch(types[i], arguments[i])) continue;
            return false;
        }
        int last = types.length - 1;
        if (varArgs) {
            return TypeMatching.valueAndTypeMatch(types[last].getComponentType(), arguments[last]);
        }
        return TypeMatching.valueAndTypeMatch(types[last], arguments[last]);
    }

    private static boolean valueAndTypeMatch(Class<?> type, Object value) {
        return TypeMatching.primitiveCompatible(type, value) || type.isInstance(value) || value == null;
    }

    private static boolean primitiveCompatible(Class<?> type, Object value) {
        if (!type.isPrimitive() || value == null) {
            return false;
        }
        return PRIMITIVE_MAP.get(type) == value.getClass();
    }
}

