/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DynamicObject {
    private final Map<String, Set<SwitchPoint>> switchPoints = new HashMap<String, Set<SwitchPoint>>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private boolean frozen = false;
    private static final MethodHandle PROPERTY_MISSING;
    private static final MethodHandle DEFINE;

    public DynamicObject define(String name, Object value) {
        if (this.frozen) {
            throw new IllegalStateException("the object is frozen");
        }
        this.properties.put(name, value);
        if (this.switchPoints.containsKey(name)) {
            this.invalidate(name);
        } else {
            this.switchPoints.put(name, new HashSet());
        }
        return this;
    }

    public Set<Map.Entry<String, Object>> properties() {
        return this.properties.entrySet();
    }

    private void invalidate(String name) {
        Set<SwitchPoint> switches = this.switchPoints.get(name);
        SwitchPoint.invalidateAll(switches.toArray(new SwitchPoint[switches.size()]));
        switches.clear();
    }

    public Object get(String name) {
        return this.properties.get(name);
    }

    public DynamicObject undefine(String name) {
        if (this.properties.containsKey(name)) {
            this.properties.remove(name);
            this.invalidate(name);
            this.switchPoints.remove(name);
        }
        return this;
    }

    public DynamicObject copy() {
        DynamicObject copy = new DynamicObject();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            this.define(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public DynamicObject mixin(DynamicObject other) {
        for (Map.Entry<String, Object> entry : other.properties.entrySet()) {
            this.define(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public DynamicObject freeze() {
        this.frozen = true;
        return this;
    }

    public static Object propertyMissing(String name, Object[] args) throws NoSuchMethodException {
        throw new NoSuchMethodException("Missing DynamicObject definition for " + name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MethodHandle plug(String name, MethodType type, MethodHandle fallback) {
        MethodHandle target;
        Object value = this.properties.get(name);
        int parameterCount = type.parameterCount();
        if (value != null) {
            if (value instanceof MethodHandle) {
                target = (MethodHandle)value;
                if (this.missesReceiverType(target)) {
                    throw new IllegalArgumentException(name + " must have a first a non-array first argument as the dynamic object");
                }
                if (this.wrongMethodSignature(type, target)) {
                    throw new IllegalArgumentException(name + " must have the following signature: " + type + " (found: " + target.type() + ")");
                }
            } else if (parameterCount == 1) {
                target = MethodHandles.dropArguments(MethodHandles.constant(Object.class, value), 0, new Class[]{DynamicObject.class});
            } else {
                if (parameterCount != 2) throw new IllegalArgumentException(name + " needs to invoked with just 1 argument");
                target = MethodHandles.insertArguments(DEFINE, 1, name);
            }
        } else {
            target = parameterCount == 2 ? MethodHandles.insertArguments(DEFINE, 1, name) : PROPERTY_MISSING.bindTo(name).asCollector(Object[].class, parameterCount).asType(type);
            this.switchPoints.put(name, new HashSet());
        }
        SwitchPoint switchPoint = new SwitchPoint();
        this.switchPoints.get(name).add(switchPoint);
        return switchPoint.guardWithTest(target.asType(type), fallback);
    }

    private boolean wrongMethodSignature(MethodType type, MethodHandle target) {
        return target.type().parameterCount() != type.parameterCount();
    }

    private boolean missesReceiverType(MethodHandle target) {
        return target.type().parameterCount() < 1 || ((Class)target.type().parameterType(0)).isArray();
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            PROPERTY_MISSING = lookup.findStatic(DynamicObject.class, "propertyMissing", MethodType.methodType(Object.class, String.class, Object[].class));
            DEFINE = lookup.findVirtual(DynamicObject.class, "define", MethodType.methodType(DynamicObject.class, String.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles");
        }
    }
}

