/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler;

import fr.insalyon.citi.golo.compiler.CodeGenerationResult;
import fr.insalyon.citi.golo.compiler.JavaBytecodeUtils;
import fr.insalyon.citi.golo.compiler.ir.Struct;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class JavaBytecodeStructGenerator {
    private static final String $_frozen = "$_frozen";
    public static final String IMMUTABLE_FACTORY_METHOD = "$_immutable";

    JavaBytecodeStructGenerator() {
    }

    public CodeGenerationResult compile(Struct struct, String sourceFilename) {
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visitSource(sourceFilename, null);
        classWriter.visit(51, 49, struct.getPackageAndClass().toJVMType(), null, "gololang/GoloStruct", null);
        this.makeFields(classWriter, struct);
        this.makeAccessors(classWriter, struct);
        this.makeConstructors(classWriter, struct);
        this.makeImmutableFactory(classWriter, struct);
        this.makeToString(classWriter, struct);
        this.makeCopy(classWriter, struct, false);
        this.makeCopy(classWriter, struct, true);
        this.makeHashCode(classWriter, struct);
        this.makeEquals(classWriter, struct);
        this.makeValuesMethod(classWriter, struct);
        this.makeGetMethod(classWriter, struct);
        this.makeSetMethod(classWriter, struct);
        classWriter.visitEnd();
        return new CodeGenerationResult(classWriter.toByteArray(), struct.getPackageAndClass());
    }

    private void makeSetMethod(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "set", "(Ljava/lang/String;Ljava/lang/Object;)Lgololang/GoloStruct;", null, null);
        visitor.visitCode();
        Label nextCase = new Label();
        for (String member : struct.getMembers()) {
            visitor.visitLdcInsn((Object)member);
            visitor.visitVarInsn(25, 1);
            visitor.visitJumpInsn(166, nextCase);
            visitor.visitVarInsn(25, 0);
            visitor.visitVarInsn(25, 2);
            visitor.visitMethodInsn(182, owner, member, "(Ljava/lang/Object;)Lgololang/GoloStruct;");
            visitor.visitInsn(176);
            visitor.visitLabel(nextCase);
            nextCase = new Label();
        }
        visitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        visitor.visitInsn(89);
        visitor.visitLdcInsn((Object)("Unknown member in " + struct.getPackageAndClass().toString()));
        visitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        visitor.visitInsn(191);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeGetMethod(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "get", "(Ljava/lang/String;)Ljava/lang/Object;", null, null);
        visitor.visitCode();
        Label nextCase = new Label();
        for (String member : struct.getMembers()) {
            visitor.visitLdcInsn((Object)member);
            visitor.visitVarInsn(25, 1);
            visitor.visitJumpInsn(166, nextCase);
            visitor.visitVarInsn(25, 0);
            visitor.visitMethodInsn(182, owner, member, "()Ljava/lang/Object;");
            visitor.visitInsn(176);
            visitor.visitLabel(nextCase);
            nextCase = new Label();
        }
        visitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        visitor.visitInsn(89);
        visitor.visitLdcInsn((Object)("Unknown member in " + struct.getPackageAndClass().toString()));
        visitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        visitor.visitInsn(191);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeValuesMethod(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "values", "()Lgololang/Tuple;", null, null);
        visitor.visitCode();
        JavaBytecodeUtils.loadInteger(visitor, struct.getMembers().size());
        visitor.visitTypeInsn(189, "java/lang/Object");
        int index = 0;
        for (String member : struct.getMembers()) {
            visitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(visitor, index);
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, owner, member, "Ljava/lang/Object;");
            visitor.visitInsn(83);
            ++index;
        }
        visitor.visitMethodInsn(184, "gololang/Tuple", "fromArray", "([Ljava/lang/Object;)Lgololang/Tuple;");
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeEquals(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        Label notFrozenLabel = new Label();
        Label falseLabel = new Label();
        Label sameTypeLabel = new Label();
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, owner, $_frozen, "Z");
        visitor.visitJumpInsn(154, notFrozenLabel);
        visitor.visitVarInsn(25, 0);
        visitor.visitVarInsn(25, 1);
        visitor.visitMethodInsn(183, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        visitor.visitInsn(172);
        visitor.visitLabel(notFrozenLabel);
        visitor.visitVarInsn(25, 1);
        visitor.visitTypeInsn(193, owner);
        visitor.visitJumpInsn(154, sameTypeLabel);
        visitor.visitJumpInsn(167, falseLabel);
        visitor.visitLabel(sameTypeLabel);
        visitor.visitVarInsn(25, 1);
        visitor.visitTypeInsn(192, owner);
        visitor.visitFieldInsn(180, owner, $_frozen, "Z");
        visitor.visitJumpInsn(153, falseLabel);
        for (String member : struct.getMembers()) {
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, owner, member, "Ljava/lang/Object;");
            visitor.visitVarInsn(25, 1);
            visitor.visitTypeInsn(192, owner);
            visitor.visitFieldInsn(180, owner, member, "Ljava/lang/Object;");
            visitor.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            visitor.visitJumpInsn(153, falseLabel);
        }
        visitor.visitInsn(4);
        visitor.visitInsn(172);
        visitor.visitLabel(falseLabel);
        visitor.visitInsn(3);
        visitor.visitInsn(172);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeHashCode(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "hashCode", "()I", null, null);
        Label notFrozenLabel = new Label();
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, owner, $_frozen, "Z");
        visitor.visitJumpInsn(154, notFrozenLabel);
        visitor.visitVarInsn(25, 0);
        visitor.visitMethodInsn(183, "java/lang/Object", "hashCode", "()I");
        visitor.visitInsn(172);
        visitor.visitLabel(notFrozenLabel);
        JavaBytecodeUtils.loadInteger(visitor, struct.getMembers().size());
        visitor.visitTypeInsn(189, "java/lang/Object");
        int i = 0;
        for (String member : struct.getMembers()) {
            visitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(visitor, i);
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, owner, member, "Ljava/lang/Object;");
            visitor.visitInsn(83);
            ++i;
        }
        visitor.visitMethodInsn(184, "java/util/Objects", "hash", "([Ljava/lang/Object;)I");
        visitor.visitInsn(172);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeCopy(ClassWriter classWriter, Struct struct, boolean frozen) {
        String owner = struct.getPackageAndClass().toJVMType();
        String methodName = frozen ? "frozenCopy" : "copy";
        MethodVisitor visitor = classWriter.visitMethod(1, methodName, "()Lgololang/GoloStruct;", null, null);
        visitor.visitCode();
        visitor.visitTypeInsn(187, owner);
        visitor.visitInsn(89);
        for (String member : struct.getMembers()) {
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, owner, member, "Ljava/lang/Object;");
        }
        visitor.visitMethodInsn(183, owner, "<init>", this.allArgsConstructorSignature(struct));
        visitor.visitInsn(89);
        visitor.visitInsn(frozen ? 4 : 3);
        visitor.visitFieldInsn(181, owner, $_frozen, "Z");
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeToString(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        visitor.visitCode();
        visitor.visitTypeInsn(187, "java/lang/StringBuilder");
        visitor.visitInsn(89);
        visitor.visitLdcInsn((Object)("struct " + struct.getPackageAndClass().className() + "{"));
        visitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
        boolean first = true;
        for (String member : struct.getMembers()) {
            visitor.visitInsn(89);
            visitor.visitLdcInsn((Object)((!first ? ", " : "") + member + "="));
            first = false;
            visitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            visitor.visitInsn(89);
            visitor.visitVarInsn(25, 0);
            visitor.visitFieldInsn(180, owner, member, "Ljava/lang/Object;");
            visitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        }
        visitor.visitLdcInsn((Object)"}");
        visitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        visitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeConstructors(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        this.makeNoArgsConstructor(classWriter, struct);
        this.makeAllArgsConstructor(classWriter, struct, owner);
    }

    private void makeAllArgsConstructor(ClassWriter classWriter, Struct struct, String owner) {
        MethodVisitor visitor = classWriter.visitMethod(1, "<init>", this.allArgsConstructorSignature(struct), null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitMethodInsn(183, "gololang/GoloStruct", "<init>", "()V");
        int arg = 1;
        for (String name : struct.getMembers()) {
            visitor.visitVarInsn(25, 0);
            visitor.visitVarInsn(25, arg);
            visitor.visitFieldInsn(181, owner, name, "Ljava/lang/Object;");
            ++arg;
        }
        this.initMembersField(struct, owner, visitor);
        visitor.visitVarInsn(25, 0);
        visitor.visitInsn(3);
        visitor.visitFieldInsn(181, owner, $_frozen, "Z");
        visitor.visitInsn(177);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeImmutableFactory(ClassWriter classWriter, Struct struct) {
        String constructorDesc = this.allArgsConstructorSignature(struct);
        String desc = constructorDesc.substring(0, constructorDesc.length() - 1);
        String classType = struct.getPackageAndClass().toJVMType();
        desc = desc + "L" + classType + ";";
        MethodVisitor visitor = classWriter.visitMethod(9, IMMUTABLE_FACTORY_METHOD, desc, null, null);
        visitor.visitCode();
        visitor.visitTypeInsn(187, classType);
        visitor.visitInsn(89);
        int arg = 0;
        for (String name : struct.getMembers()) {
            visitor.visitVarInsn(25, arg);
            ++arg;
        }
        visitor.visitMethodInsn(183, classType, "<init>", constructorDesc);
        visitor.visitInsn(89);
        visitor.visitInsn(4);
        visitor.visitFieldInsn(181, classType, $_frozen, "Z");
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void initMembersField(Struct struct, String owner, MethodVisitor visitor) {
        visitor.visitVarInsn(25, 0);
        JavaBytecodeUtils.loadInteger(visitor, struct.getMembers().size());
        visitor.visitTypeInsn(189, "java/lang/String");
        int arg = 0;
        for (String name : struct.getMembers()) {
            visitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(visitor, arg);
            visitor.visitLdcInsn((Object)name);
            visitor.visitInsn(83);
            ++arg;
        }
        visitor.visitFieldInsn(181, owner, "members", "[Ljava/lang/String;");
    }

    private String allArgsConstructorSignature(Struct struct) {
        StringBuilder signatureBuilder = new StringBuilder("(");
        for (int i = 0; i < struct.getMembers().size(); ++i) {
            signatureBuilder.append("Ljava/lang/Object;");
        }
        signatureBuilder.append(")V");
        return signatureBuilder.toString();
    }

    private void makeNoArgsConstructor(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        MethodVisitor visitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitMethodInsn(183, "gololang/GoloStruct", "<init>", "()V");
        visitor.visitVarInsn(25, 0);
        visitor.visitInsn(3);
        visitor.visitFieldInsn(181, struct.getPackageAndClass().toJVMType(), $_frozen, "Z");
        this.initMembersField(struct, owner, visitor);
        visitor.visitInsn(177);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeFields(ClassWriter classWriter, Struct struct) {
        classWriter.visitField(18, $_frozen, "Z", null, null).visitEnd();
        for (String name : struct.getMembers()) {
            FieldVisitor fieldVisitor = classWriter.visitField(2, name, "Ljava/lang/Object;", null, null);
            fieldVisitor.visitEnd();
        }
    }

    private void makeAccessors(ClassWriter classWriter, Struct struct) {
        String owner = struct.getPackageAndClass().toJVMType();
        for (String name : struct.getMembers()) {
            this.makeGetter(classWriter, owner, name);
            this.makeSetter(classWriter, owner, name);
        }
        this.makeFrozenGetter(classWriter, owner);
    }

    private void makeFrozenGetter(ClassWriter classWriter, String owner) {
        MethodVisitor visitor = classWriter.visitMethod(1, "isFrozen", "()Z", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, owner, $_frozen, "Z");
        visitor.visitInsn(172);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeSetter(ClassWriter classWriter, String owner, String name) {
        MethodVisitor visitor = classWriter.visitMethod(1, name, "(Ljava/lang/Object;)Lgololang/GoloStruct;", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, owner, $_frozen, "Z");
        Label setLabel = new Label();
        visitor.visitJumpInsn(153, setLabel);
        visitor.visitTypeInsn(187, "java/lang/IllegalStateException");
        visitor.visitInsn(89);
        visitor.visitLdcInsn((Object)"The struct instance is frozen");
        visitor.visitMethodInsn(183, "java/lang/IllegalStateException", "<init>", "(Ljava/lang/String;)V");
        visitor.visitInsn(191);
        visitor.visitLabel(setLabel);
        visitor.visitVarInsn(25, 0);
        visitor.visitVarInsn(25, 1);
        visitor.visitFieldInsn(181, owner, name, "Ljava/lang/Object;");
        visitor.visitVarInsn(25, 0);
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeGetter(ClassWriter classWriter, String owner, String name) {
        MethodVisitor visitor = classWriter.visitMethod(1, name, "()Ljava/lang/Object;", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, owner, name, "Ljava/lang/Object;");
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }
}

