/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler;

import fr.insalyon.citi.golo.compiler.CodeGenerationResult;
import fr.insalyon.citi.golo.compiler.JavaBytecodeStructGenerator;
import fr.insalyon.citi.golo.compiler.JavaBytecodeUtils;
import fr.insalyon.citi.golo.compiler.PackageAndClass;
import fr.insalyon.citi.golo.compiler.ir.AbstractInvocation;
import fr.insalyon.citi.golo.compiler.ir.AssignmentStatement;
import fr.insalyon.citi.golo.compiler.ir.BinaryOperation;
import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.ClosureReference;
import fr.insalyon.citi.golo.compiler.ir.CollectionLiteral;
import fr.insalyon.citi.golo.compiler.ir.ConditionalBranching;
import fr.insalyon.citi.golo.compiler.ir.ConstantStatement;
import fr.insalyon.citi.golo.compiler.ir.ExpressionStatement;
import fr.insalyon.citi.golo.compiler.ir.FunctionInvocation;
import fr.insalyon.citi.golo.compiler.ir.GoloFunction;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.GoloModule;
import fr.insalyon.citi.golo.compiler.ir.GoloStatement;
import fr.insalyon.citi.golo.compiler.ir.LocalReference;
import fr.insalyon.citi.golo.compiler.ir.LoopBreakFlowStatement;
import fr.insalyon.citi.golo.compiler.ir.LoopStatement;
import fr.insalyon.citi.golo.compiler.ir.MethodInvocation;
import fr.insalyon.citi.golo.compiler.ir.ModuleImport;
import fr.insalyon.citi.golo.compiler.ir.ReferenceLookup;
import fr.insalyon.citi.golo.compiler.ir.ReferenceTable;
import fr.insalyon.citi.golo.compiler.ir.ReturnStatement;
import fr.insalyon.citi.golo.compiler.ir.Struct;
import fr.insalyon.citi.golo.compiler.ir.ThrowStatement;
import fr.insalyon.citi.golo.compiler.ir.TryCatchFinally;
import fr.insalyon.citi.golo.compiler.ir.UnaryOperation;
import fr.insalyon.citi.golo.compiler.parser.GoloParser;
import fr.insalyon.citi.golo.runtime.OperatorType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class JavaBytecodeGenerationGoloIrVisitor
implements GoloIrVisitor {
    private static final String JOBJECT = "java/lang/Object";
    private static final String TOBJECT = "Ljava/lang/Object;";
    private static final Handle FUNCTION_INVOCATION_HANDLE;
    private static final Handle OPERATOR_HANDLE;
    private static final Handle METHOD_INVOCATION_HANDLE;
    private static final Handle CLASSREF_HANDLE;
    private static final Handle CLOSUREREF_HANDLE;
    private static final Handle CLOSURE_INVOCATION_HANDLE;
    private ClassWriter classWriter;
    private String klass;
    private MethodVisitor methodVisitor;
    private List<CodeGenerationResult> generationResults;
    private String sourceFilename;
    private Context context;

    JavaBytecodeGenerationGoloIrVisitor() {
    }

    public List<CodeGenerationResult> generateBytecode(GoloModule module, String sourceFilename) {
        this.sourceFilename = sourceFilename;
        this.classWriter = new ClassWriter(3);
        this.generationResults = new LinkedList<CodeGenerationResult>();
        this.context = new Context();
        module.accept(this);
        this.generationResults.add(new CodeGenerationResult(this.classWriter.toByteArray(), module.getPackageAndClass()));
        return this.generationResults;
    }

    @Override
    public void visitModule(GoloModule module) {
        this.classWriter.visit(51, 33, module.getPackageAndClass().toJVMType(), null, JOBJECT, null);
        this.classWriter.visitSource(this.sourceFilename, null);
        this.writeImportMetaData(module.getImports());
        this.klass = module.getPackageAndClass().toString();
        for (GoloFunction goloFunction : module.getFunctions()) {
            goloFunction.accept(this);
        }
        for (Map.Entry entry : module.getAugmentations().entrySet()) {
            this.generateAugmentationBytecode(module, (String)entry.getKey(), (Set)entry.getValue());
        }
        if (module.getStructs().size() > 0) {
            JavaBytecodeStructGenerator structGenerator = new JavaBytecodeStructGenerator();
            for (Struct struct : module.getStructs()) {
                this.generationResults.add(structGenerator.compile(struct, this.sourceFilename));
            }
        }
        this.writeAugmentsMetaData(module.getAugmentations().keySet());
        this.classWriter.visitEnd();
    }

    private void writeImportMetaData(Set<ModuleImport> imports) {
        ModuleImport[] importsArray = imports.toArray(new ModuleImport[imports.size()]);
        this.methodVisitor = this.classWriter.visitMethod(4105, "$imports", "()[Ljava/lang/String;", null, null);
        this.methodVisitor.visitCode();
        JavaBytecodeUtils.loadInteger(this.methodVisitor, importsArray.length);
        this.methodVisitor.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < importsArray.length; ++i) {
            this.methodVisitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, i);
            this.methodVisitor.visitLdcInsn((Object)importsArray[i].getPackageAndClass().toString());
            this.methodVisitor.visitInsn(83);
        }
        this.methodVisitor.visitInsn(176);
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    private void writeAugmentsMetaData(Set<String> augmentations) {
        String[] augmentArray = augmentations.toArray(new String[augmentations.size()]);
        this.methodVisitor = this.classWriter.visitMethod(4105, "$augmentations", "()[Ljava/lang/String;", null, null);
        this.methodVisitor.visitCode();
        JavaBytecodeUtils.loadInteger(this.methodVisitor, augmentArray.length);
        this.methodVisitor.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < augmentArray.length; ++i) {
            this.methodVisitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, i);
            this.methodVisitor.visitLdcInsn((Object)augmentArray[i]);
            this.methodVisitor.visitInsn(83);
        }
        this.methodVisitor.visitInsn(176);
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    private void generateAugmentationBytecode(GoloModule module, String target, Set<GoloFunction> functions) {
        ClassWriter mainClassWriter = this.classWriter;
        String mangledClass = target.replace('.', '$');
        PackageAndClass packageAndClass = new PackageAndClass(module.getPackageAndClass().packageName(), module.getPackageAndClass().className() + "$" + mangledClass);
        String augmentationClassInternalName = packageAndClass.toJVMType();
        String outerName = module.getPackageAndClass().toJVMType();
        mainClassWriter.visitInnerClass(augmentationClassInternalName, outerName, mangledClass, 9);
        this.classWriter = new ClassWriter(3);
        this.classWriter.visit(51, 33, augmentationClassInternalName, null, JOBJECT, null);
        this.classWriter.visitSource(this.sourceFilename, null);
        this.classWriter.visitOuterClass(outerName, null, null);
        for (GoloFunction function : functions) {
            function.accept(this);
        }
        HashSet<ModuleImport> imports = new HashSet<ModuleImport>(module.getImports());
        imports.add(new ModuleImport(module.getPackageAndClass()));
        this.writeImportMetaData(imports);
        this.classWriter.visitEnd();
        this.generationResults.add(new CodeGenerationResult(this.classWriter.toByteArray(), packageAndClass));
        this.classWriter = mainClassWriter;
    }

    @Override
    public void visitFunction(GoloFunction function) {
        String signature;
        int accessFlags;
        int n = accessFlags = function.getVisibility() == GoloFunction.Visibility.PUBLIC ? 1 : 2;
        if (function.isMain()) {
            signature = "([Ljava/lang/String;)V";
        } else if (function.isVarargs()) {
            accessFlags |= 0x80;
            signature = this.goloVarargsFunctionSignature(function.getArity());
        } else {
            signature = this.goloFunctionSignature(function.getArity());
        }
        if (function.isSynthetic()) {
            accessFlags |= 0x1000;
        }
        this.methodVisitor = this.classWriter.visitMethod(accessFlags | 8, function.getName(), signature, null, null);
        this.methodVisitor.visitCode();
        JavaBytecodeUtils.visitLine(function, this.methodVisitor);
        function.getBlock().accept(this);
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    private String goloFunctionSignature(int arity) {
        return MethodType.genericMethodType(arity).toMethodDescriptorString();
    }

    private String goloVarargsFunctionSignature(int arity) {
        return MethodType.genericMethodType(arity - 1, true).toMethodDescriptorString();
    }

    @Override
    public void visitBlock(Block block) {
        ReferenceTable referenceTable = block.getReferenceTable();
        this.context.referenceTableStack.push(referenceTable);
        Label blockStart = new Label();
        Label blockEnd = new Label();
        this.methodVisitor.visitLabel(blockStart);
        for (GoloStatement statement : block.getStatements()) {
            JavaBytecodeUtils.visitLine(statement, this.methodVisitor);
            statement.accept(this);
            this.insertMissingPop(statement);
        }
        this.methodVisitor.visitLabel(blockEnd);
        for (LocalReference localReference : referenceTable.ownedReferences()) {
            this.methodVisitor.visitLocalVariable(localReference.getName(), TOBJECT, null, blockStart, blockEnd, localReference.getIndex());
        }
        this.context.referenceTableStack.pop();
    }

    private void insertMissingPop(GoloStatement statement) {
        BinaryOperation operation;
        Class<?> statementClass = statement.getClass();
        if (statementClass == FunctionInvocation.class) {
            this.methodVisitor.visitInsn(87);
        } else if (statementClass == BinaryOperation.class && this.isMethodCall(operation = (BinaryOperation)statement)) {
            this.methodVisitor.visitInsn(87);
        }
    }

    private boolean isMethodCall(BinaryOperation operation) {
        return operation.getType() == OperatorType.METHOD_CALL || operation.getType() == OperatorType.ELVIS_METHOD_CALL;
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
        Object value = constantStatement.getValue();
        if (value == null) {
            this.methodVisitor.visitInsn(1);
            return;
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            JavaBytecodeUtils.loadInteger(this.methodVisitor, i);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            return;
        }
        if (value instanceof Long) {
            long l = (Long)value;
            JavaBytecodeUtils.loadLong(this.methodVisitor, l);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            return;
        }
        if (value instanceof Boolean) {
            boolean b = (Boolean)value;
            JavaBytecodeUtils.loadInteger(this.methodVisitor, b ? 1 : 0);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            return;
        }
        if (value instanceof String) {
            this.methodVisitor.visitLdcInsn(value);
            return;
        }
        if (value instanceof Character) {
            JavaBytecodeUtils.loadInteger(this.methodVisitor, ((Character)value).charValue());
            this.methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            return;
        }
        if (value instanceof GoloParser.ParserClassRef) {
            GoloParser.ParserClassRef ref = (GoloParser.ParserClassRef)value;
            this.methodVisitor.visitInvokeDynamicInsn(ref.name.replaceAll("\\.", "#"), "()Ljava/lang/Class;", CLASSREF_HANDLE, new Object[0]);
            return;
        }
        if (value instanceof GoloParser.FunctionRef) {
            GoloParser.FunctionRef ref = (GoloParser.FunctionRef)value;
            String module = ref.module;
            if (module == null) {
                module = this.klass;
            }
            this.methodVisitor.visitLdcInsn((Object)ref.name);
            this.methodVisitor.visitInvokeDynamicInsn(module.replaceAll("\\.", "#"), "()Ljava/lang/Class;", CLASSREF_HANDLE, new Object[0]);
            this.methodVisitor.visitInvokeDynamicInsn("gololang#Predefined#fun", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", FUNCTION_INVOCATION_HANDLE, new Object[0]);
            return;
        }
        if (value instanceof Double) {
            double d = (Double)value;
            this.methodVisitor.visitLdcInsn((Object)d);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            return;
        }
        if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            this.methodVisitor.visitLdcInsn((Object)Float.valueOf(f));
            this.methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            return;
        }
        throw new IllegalArgumentException("Constants of type " + value.getClass() + " cannot be handled.");
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        returnStatement.getExpressionStatement().accept(this);
        if (returnStatement.isReturningVoid()) {
            this.methodVisitor.visitInsn(177);
        } else {
            this.methodVisitor.visitInsn(176);
        }
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        throwStatement.getExpressionStatement().accept(this);
        this.methodVisitor.visitTypeInsn(192, "java/lang/Throwable");
        this.methodVisitor.visitInsn(191);
    }

    private void visitInvocationArguments(AbstractInvocation invocation) {
        for (ExpressionStatement statement : invocation.getArguments()) {
            statement.accept(this);
        }
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        if (functionInvocation.isOnReference()) {
            ReferenceTable table = (ReferenceTable)this.context.referenceTableStack.peek();
            this.methodVisitor.visitVarInsn(25, table.get(functionInvocation.getName()).getIndex());
        }
        if (functionInvocation.isAnonymous() || functionInvocation.isOnReference()) {
            this.methodVisitor.visitTypeInsn(192, "java/lang/invoke/MethodHandle");
            MethodType type = MethodType.genericMethodType(functionInvocation.getArity() + 1).changeParameterType(0, MethodHandle.class);
            this.visitInvocationArguments(functionInvocation);
            this.methodVisitor.visitInvokeDynamicInsn(functionInvocation.getName().replaceAll("\\.", "#"), type.toMethodDescriptorString(), CLOSURE_INVOCATION_HANDLE, new Object[0]);
        } else {
            this.visitInvocationArguments(functionInvocation);
            this.methodVisitor.visitInvokeDynamicInsn(functionInvocation.getName().replaceAll("\\.", "#"), this.goloFunctionSignature(functionInvocation.getArity()), FUNCTION_INVOCATION_HANDLE, new Object[0]);
        }
        for (FunctionInvocation invocation : functionInvocation.getAnonymousFunctionInvocations()) {
            invocation.accept(this);
        }
    }

    @Override
    public void acceptMethodInvocation(MethodInvocation methodInvocation) {
        this.visitInvocationArguments(methodInvocation);
        this.methodVisitor.visitInvokeDynamicInsn(methodInvocation.getName().replaceAll("\\.", "#"), this.goloFunctionSignature(methodInvocation.getArity() + 1), METHOD_INVOCATION_HANDLE, new Object[]{methodInvocation.isNullSafeGuarded()});
        for (FunctionInvocation invocation : methodInvocation.getAnonymousFunctionInvocations()) {
            invocation.accept(this);
        }
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        assignmentStatement.getExpressionStatement().accept(this);
        this.methodVisitor.visitVarInsn(58, assignmentStatement.getLocalReference().getIndex());
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        LocalReference reference = referenceLookup.resolveIn((ReferenceTable)this.context.referenceTableStack.peek());
        this.methodVisitor.visitVarInsn(25, reference.getIndex());
    }

    @Override
    public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        Label branchingElseLabel = new Label();
        Label branchingExitLabel = new Label();
        conditionalBranching.getCondition().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(153, branchingElseLabel);
        conditionalBranching.getTrueBlock().accept(this);
        if (conditionalBranching.hasFalseBlock()) {
            if (!conditionalBranching.getTrueBlock().hasReturn()) {
                this.methodVisitor.visitJumpInsn(167, branchingExitLabel);
            }
            this.methodVisitor.visitLabel(branchingElseLabel);
            conditionalBranching.getFalseBlock().accept(this);
            this.methodVisitor.visitLabel(branchingExitLabel);
        } else if (conditionalBranching.hasElseConditionalBranching()) {
            if (!conditionalBranching.getTrueBlock().hasReturn()) {
                this.methodVisitor.visitJumpInsn(167, branchingExitLabel);
            }
            this.methodVisitor.visitLabel(branchingElseLabel);
            conditionalBranching.getElseConditionalBranching().accept(this);
            this.methodVisitor.visitLabel(branchingExitLabel);
        } else {
            this.methodVisitor.visitLabel(branchingElseLabel);
        }
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        Label loopStart = new Label();
        Label loopEnd = new Label();
        this.context.loopStartMap.put(loopStatement, loopStart);
        this.context.loopEndMap.put(loopStatement, loopEnd);
        if (loopStatement.hasInitStatement()) {
            loopStatement.getInitStatement().accept(this);
        }
        this.methodVisitor.visitLabel(loopStart);
        loopStatement.getConditionStatement().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(153, loopEnd);
        loopStatement.getBlock().accept(this);
        if (loopStatement.hasPostStatement()) {
            loopStatement.getPostStatement().accept(this);
        }
        this.methodVisitor.visitJumpInsn(167, loopStart);
        this.methodVisitor.visitLabel(loopEnd);
    }

    @Override
    public void acceptLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
        Label jumpTarget = LoopBreakFlowStatement.Type.BREAK.equals((Object)loopBreakFlowStatement.getType()) ? (Label)this.context.loopEndMap.get(loopBreakFlowStatement.getEnclosingLoop()) : (Label)this.context.loopStartMap.get(loopBreakFlowStatement.getEnclosingLoop());
        this.methodVisitor.visitLdcInsn((Object)0);
        this.methodVisitor.visitJumpInsn(153, jumpTarget);
    }

    @Override
    public void acceptCollectionLiteral(CollectionLiteral collectionLiteral) {
        switch (collectionLiteral.getType()) {
            case tuple: {
                this.createTuple(collectionLiteral);
                break;
            }
            case array: {
                this.createArray(collectionLiteral);
                break;
            }
            case list: {
                this.createList(collectionLiteral);
                break;
            }
            case vector: {
                this.createVector(collectionLiteral);
                break;
            }
            case set: {
                this.createSet(collectionLiteral);
                break;
            }
            case map: {
                this.createMap(collectionLiteral);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can't handle collections of type " + (Object)((Object)collectionLiteral.getType()) + " yet");
            }
        }
    }

    private void createMap(CollectionLiteral collectionLiteral) {
        this.methodVisitor.visitTypeInsn(187, "java/util/LinkedHashMap");
        this.methodVisitor.visitInsn(89);
        this.methodVisitor.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V");
        for (ExpressionStatement expression : collectionLiteral.getExpressions()) {
            this.methodVisitor.visitInsn(89);
            expression.accept(this);
            this.methodVisitor.visitTypeInsn(192, "gololang/Tuple");
            this.methodVisitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, 0);
            this.methodVisitor.visitMethodInsn(182, "gololang/Tuple", "get", "(I)Ljava/lang/Object;");
            this.methodVisitor.visitInsn(95);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, 1);
            this.methodVisitor.visitMethodInsn(182, "gololang/Tuple", "get", "(I)Ljava/lang/Object;");
            this.methodVisitor.visitMethodInsn(182, "java/util/LinkedHashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.methodVisitor.visitInsn(87);
        }
    }

    private void createSet(CollectionLiteral collectionLiteral) {
        this.methodVisitor.visitTypeInsn(187, "java/util/LinkedHashSet");
        this.methodVisitor.visitInsn(89);
        this.methodVisitor.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V");
        for (ExpressionStatement expression : collectionLiteral.getExpressions()) {
            this.methodVisitor.visitInsn(89);
            expression.accept(this);
            this.methodVisitor.visitMethodInsn(182, "java/util/LinkedHashSet", "add", "(Ljava/lang/Object;)Z");
            this.methodVisitor.visitInsn(87);
        }
    }

    private void createVector(CollectionLiteral collectionLiteral) {
        this.methodVisitor.visitTypeInsn(187, "java/util/ArrayList");
        this.methodVisitor.visitInsn(89);
        JavaBytecodeUtils.loadInteger(this.methodVisitor, collectionLiteral.getExpressions().size());
        this.methodVisitor.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V");
        for (ExpressionStatement expression : collectionLiteral.getExpressions()) {
            this.methodVisitor.visitInsn(89);
            expression.accept(this);
            this.methodVisitor.visitMethodInsn(182, "java/util/ArrayList", "add", "(Ljava/lang/Object;)Z");
            this.methodVisitor.visitInsn(87);
        }
    }

    private void createList(CollectionLiteral collectionLiteral) {
        this.methodVisitor.visitTypeInsn(187, "java/util/LinkedList");
        this.methodVisitor.visitInsn(89);
        this.methodVisitor.visitMethodInsn(183, "java/util/LinkedList", "<init>", "()V");
        for (ExpressionStatement expression : collectionLiteral.getExpressions()) {
            this.methodVisitor.visitInsn(89);
            expression.accept(this);
            this.methodVisitor.visitMethodInsn(182, "java/util/LinkedList", "add", "(Ljava/lang/Object;)Z");
            this.methodVisitor.visitInsn(87);
        }
    }

    private void createArray(CollectionLiteral collectionLiteral) {
        JavaBytecodeUtils.loadInteger(this.methodVisitor, collectionLiteral.getExpressions().size());
        this.methodVisitor.visitTypeInsn(189, JOBJECT);
        int i = 0;
        for (ExpressionStatement expression : collectionLiteral.getExpressions()) {
            this.methodVisitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, i);
            expression.accept(this);
            this.methodVisitor.visitInsn(83);
            ++i;
        }
    }

    private void createTuple(CollectionLiteral collectionLiteral) {
        this.methodVisitor.visitTypeInsn(187, "gololang/Tuple");
        this.methodVisitor.visitInsn(89);
        this.createArray(collectionLiteral);
        this.methodVisitor.visitMethodInsn(183, "gololang/Tuple", "<init>", "([Ljava/lang/Object;)V");
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label catchStart = new Label();
        Label catchEnd = new Label();
        Label rethrowStart = null;
        Label rethrowEnd = null;
        if (tryCatchFinally.isTryCatchFinally()) {
            rethrowStart = new Label();
            rethrowEnd = new Label();
        }
        this.methodVisitor.visitTryCatchBlock(tryStart, tryEnd, catchStart, null);
        this.methodVisitor.visitLabel(tryStart);
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.isTryCatch() || tryCatchFinally.isTryCatchFinally()) {
            this.methodVisitor.visitJumpInsn(167, catchEnd);
        }
        this.methodVisitor.visitLabel(tryEnd);
        if (tryCatchFinally.isTryFinally()) {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitJumpInsn(167, catchEnd);
        }
        if (tryCatchFinally.isTryCatchFinally()) {
            this.methodVisitor.visitTryCatchBlock(catchStart, catchEnd, rethrowStart, null);
        }
        this.methodVisitor.visitLabel(catchStart);
        if (tryCatchFinally.isTryCatch() || tryCatchFinally.isTryCatchFinally()) {
            Block catchBlock = tryCatchFinally.getCatchBlock();
            int exceptionRefIndex = catchBlock.getReferenceTable().get(tryCatchFinally.getExceptionId()).getIndex();
            this.methodVisitor.visitVarInsn(58, exceptionRefIndex);
            tryCatchFinally.getCatchBlock().accept(this);
        } else {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitInsn(191);
        }
        this.methodVisitor.visitLabel(catchEnd);
        if (tryCatchFinally.isTryCatchFinally()) {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitJumpInsn(167, rethrowEnd);
            this.methodVisitor.visitLabel(rethrowStart);
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitInsn(191);
            this.methodVisitor.visitLabel(rethrowEnd);
        }
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        GoloFunction target = closureReference.getTarget();
        boolean isVarArgs = target.isVarargs();
        int arity = isVarArgs ? target.getArity() - 1 : target.getArity();
        this.methodVisitor.visitInvokeDynamicInsn(target.getName(), MethodType.methodType(MethodHandle.class).toMethodDescriptorString(), CLOSUREREF_HANDLE, new Object[]{this.klass, arity, isVarArgs});
        int syntheticCount = closureReference.getTarget().getSyntheticParameterCount();
        if (syntheticCount > 0) {
            ReferenceTable table = (ReferenceTable)this.context.referenceTableStack.peek();
            String[] refs = closureReference.getCapturedReferenceNames().toArray(new String[syntheticCount]);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, 0);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, syntheticCount);
            this.methodVisitor.visitTypeInsn(189, JOBJECT);
            for (int i = 0; i < syntheticCount; ++i) {
                this.methodVisitor.visitInsn(89);
                JavaBytecodeUtils.loadInteger(this.methodVisitor, i);
                this.methodVisitor.visitVarInsn(25, table.get(refs[i]).getIndex());
                this.methodVisitor.visitInsn(83);
            }
            this.methodVisitor.visitMethodInsn(184, "java/lang/invoke/MethodHandles", "insertArguments", "(Ljava/lang/invoke/MethodHandle;I[Ljava/lang/Object;)Ljava/lang/invoke/MethodHandle;");
            if (isVarArgs) {
                this.methodVisitor.visitLdcInsn((Object)Type.getType(Object[].class));
                this.methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodHandle", "asVarargsCollector", "(Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;");
            }
        }
    }

    @Override
    public void acceptBinaryOperation(BinaryOperation binaryOperation) {
        OperatorType operatorType = binaryOperation.getType();
        if (OperatorType.AND.equals((Object)operatorType)) {
            this.andOperator(binaryOperation);
        } else if (OperatorType.OR.equals((Object)operatorType)) {
            this.orOperator(binaryOperation);
        } else {
            this.genericBinaryOperator(binaryOperation, operatorType);
        }
    }

    private void genericBinaryOperator(BinaryOperation binaryOperation, OperatorType operatorType) {
        binaryOperation.getLeftExpression().accept(this);
        binaryOperation.getRightExpression().accept(this);
        if (!this.isMethodCall(binaryOperation)) {
            String name = operatorType.name().toLowerCase();
            this.methodVisitor.visitInvokeDynamicInsn(name, this.goloFunctionSignature(2), OPERATOR_HANDLE, new Object[]{2});
        }
    }

    private void orOperator(BinaryOperation binaryOperation) {
        Label exitLabel = new Label();
        Label trueLabel = new Label();
        binaryOperation.getLeftExpression().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(154, trueLabel);
        binaryOperation.getRightExpression().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(154, trueLabel);
        this.asmFalseObject();
        this.methodVisitor.visitJumpInsn(167, exitLabel);
        this.methodVisitor.visitLabel(trueLabel);
        this.asmTrueObject();
        this.methodVisitor.visitLabel(exitLabel);
    }

    private void andOperator(BinaryOperation binaryOperation) {
        Label exitLabel = new Label();
        Label falseLabel = new Label();
        binaryOperation.getLeftExpression().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(153, falseLabel);
        binaryOperation.getRightExpression().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(153, falseLabel);
        this.asmTrueObject();
        this.methodVisitor.visitJumpInsn(167, exitLabel);
        this.methodVisitor.visitLabel(falseLabel);
        this.asmFalseObject();
        this.methodVisitor.visitLabel(exitLabel);
    }

    private void asmFalseObject() {
        this.methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
    }

    private void asmTrueObject() {
        this.methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
    }

    private void asmBooleanValue() {
        this.methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
        this.methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
    }

    @Override
    public void visitUnaryOperation(UnaryOperation unaryOperation) {
        String name = unaryOperation.getType().name().toLowerCase();
        unaryOperation.getExpressionStatement().accept(this);
        this.methodVisitor.visitInvokeDynamicInsn(name, this.goloFunctionSignature(1), OPERATOR_HANDLE, new Object[]{1});
    }

    static {
        String bootstrapOwner = "fr/insalyon/citi/golo/runtime/FunctionCallSupport";
        String bootstrapMethod = "bootstrap";
        String description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
        FUNCTION_INVOCATION_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        bootstrapOwner = "fr/insalyon/citi/golo/runtime/OperatorSupport";
        bootstrapMethod = "bootstrap";
        description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;I)Ljava/lang/invoke/CallSite;";
        OPERATOR_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        bootstrapOwner = "fr/insalyon/citi/golo/runtime/MethodInvocationSupport";
        bootstrapMethod = "bootstrap";
        description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;I)Ljava/lang/invoke/CallSite;";
        METHOD_INVOCATION_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        bootstrapOwner = "fr/insalyon/citi/golo/runtime/ClassReferenceSupport";
        bootstrapMethod = "bootstrap";
        description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
        CLASSREF_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        bootstrapOwner = "fr/insalyon/citi/golo/runtime/ClosureReferenceSupport";
        bootstrapMethod = "bootstrap";
        description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/String;II)Ljava/lang/invoke/CallSite;";
        CLOSUREREF_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
        bootstrapOwner = "fr/insalyon/citi/golo/runtime/ClosureCallSupport";
        bootstrapMethod = "bootstrap";
        description = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
        CLOSURE_INVOCATION_HANDLE = new Handle(6, bootstrapOwner, bootstrapMethod, description);
    }

    private static class Context {
        private final Deque<ReferenceTable> referenceTableStack = new LinkedList<ReferenceTable>();
        private final Map<LoopStatement, Label> loopStartMap = new HashMap<LoopStatement, Label>();
        private final Map<LoopStatement, Label> loopEndMap = new HashMap<LoopStatement, Label>();

        private Context() {
        }
    }
}

