/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler.ir;

import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.ExpressionStatement;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import fr.insalyon.citi.golo.compiler.ir.GoloStatement;

public final class ConditionalBranching
extends GoloStatement {
    private final ExpressionStatement condition;
    private final Block trueBlock;
    private final ConditionalBranching elseConditionalBranching;
    private final Block falseBlock;

    public ConditionalBranching(ExpressionStatement condition, Block trueBlock, Block falseBlock) {
        this.condition = condition;
        this.trueBlock = trueBlock;
        this.falseBlock = falseBlock;
        this.elseConditionalBranching = null;
    }

    public ConditionalBranching(ExpressionStatement condition, Block trueBlock, ConditionalBranching elseConditionalBranching) {
        this.condition = condition;
        this.trueBlock = trueBlock;
        this.elseConditionalBranching = elseConditionalBranching;
        this.falseBlock = null;
    }

    public ExpressionStatement getCondition() {
        return this.condition;
    }

    public Block getTrueBlock() {
        return this.trueBlock;
    }

    public Block getFalseBlock() {
        return this.falseBlock;
    }

    public boolean hasFalseBlock() {
        return this.falseBlock != null;
    }

    public ConditionalBranching getElseConditionalBranching() {
        return this.elseConditionalBranching;
    }

    public boolean hasElseConditionalBranching() {
        return this.elseConditionalBranching != null;
    }

    public boolean returnsFromBothBranches() {
        if (this.hasFalseBlock()) {
            return this.trueBlock.hasReturn() && this.falseBlock.hasReturn();
        }
        if (this.hasElseConditionalBranching()) {
            return this.trueBlock.hasReturn() && this.elseConditionalBranching.returnsFromBothBranches();
        }
        return false;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitConditionalBranching(this);
    }
}

