/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.doc;

import fr.insalyon.citi.golo.compiler.parser.ASTCompilationUnit;
import fr.insalyon.citi.golo.compiler.parser.ASTModuleDeclaration;
import gololang.TemplateEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandle;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractProcessor {
    private TemplateEngine templateEngine = new TemplateEngine();
    private HashMap<String, MethodHandle> templateCache = new HashMap();

    public abstract String render(ASTCompilationUnit var1) throws Throwable;

    public abstract void process(List<ASTCompilationUnit> var1, Path var2) throws Throwable;

    protected MethodHandle template(String name, String format) throws IOException {
        String key = name + "-" + format;
        if (this.templateCache.containsKey(key)) {
            return this.templateCache.get(key);
        }
        InputStream in = AbstractProcessor.class.getResourceAsStream("/fr/insalyon/citi/golo/doc/" + name + "-" + format);
        if (in == null) {
            throw new IllegalArgumentException("There is no template " + name + " for format: " + format);
        }
        try (InputStreamReader reader = new InputStreamReader(in);){
            int nread;
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[1024];
            while ((nread = reader.read(buffer)) > 0) {
                builder.append(buffer, 0, nread);
            }
            MethodHandle compiledTemplate = this.templateEngine.compile(builder.toString());
            this.templateCache.put(key, compiledTemplate);
            MethodHandle methodHandle = compiledTemplate;
            return methodHandle;
        }
    }

    protected void ensureFolderExists(Path path) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
    }

    protected Path outputFile(Path targetFolder, String moduleName, String extension) {
        return targetFolder.resolve(moduleName.replace('.', '/') + extension);
    }

    protected String moduleName(ASTCompilationUnit unit) {
        return ((ASTModuleDeclaration)unit.jjtGetChild(0)).getName();
    }
}

