/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;

public class ClosureCallSupport {
    private static final MethodHandle GUARD;
    private static final MethodHandle FALLBACK;

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type) {
        MethodHandle fallbackHandle;
        InlineCache callSite = new InlineCache(type);
        callSite.fallback = fallbackHandle = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallbackHandle);
        return callSite;
    }

    public static boolean guard(MethodHandle expected, MethodHandle actual) {
        return expected == actual;
    }

    public static Object fallback(InlineCache callSite, Object[] args) throws Throwable {
        MethodHandle target = (MethodHandle)args[0];
        MethodHandle invoker = MethodHandles.dropArguments(target, 0, new Class[]{MethodHandle.class});
        MethodType type = invoker.type();
        if (type.parameterType(type.parameterCount() - 1) == Object[].class) {
            invoker = invoker.asCollector(Object[].class, callSite.type().parameterCount() - target.type().parameterCount());
        }
        MethodHandle guard = GUARD.bindTo(target);
        MethodHandle root = MethodHandles.guardWithTest(guard, invoker, callSite.fallback);
        callSite.setTarget(root);
        return invoker.invokeWithArguments(args);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            GUARD = lookup.findStatic(ClosureCallSupport.class, "guard", MethodType.methodType(Boolean.TYPE, MethodHandle.class, MethodHandle.class));
            FALLBACK = lookup.findStatic(ClosureCallSupport.class, "fallback", MethodType.methodType(Object.class, InlineCache.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles", e);
        }
    }

    static class InlineCache
    extends MutableCallSite {
        MethodHandle fallback;

        public InlineCache(MethodType type) {
            super(type);
        }
    }
}

