/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.runtime.adapters;

import fr.insalyon.citi.golo.runtime.adapters.AdapterDefinition;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.Map;

public class AdapterSupport {
    public static final String DEFINITION_FIELD = "_$_$adapter_$definition";
    private static final MethodHandle FALLBACK;

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type) {
        AdapterCallSite callSite = new AdapterCallSite(type, caller, name);
        MethodHandle fallbackHandle = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallbackHandle);
        return callSite;
    }

    public static Object fallback(AdapterCallSite callSite, Object[] args) throws Throwable {
        Class<?> receiverClass = args[0].getClass();
        Class<?> receiverParentClass = receiverClass.getSuperclass();
        AdapterDefinition definition = (AdapterDefinition)receiverClass.getField(DEFINITION_FIELD).get(args[0]);
        Map<String, MethodHandle> implementations = definition.getImplementations();
        MethodHandle target = implementations.get(callSite.name);
        if (target == null && (target = implementations.get("*")) != null) {
            target = target.bindTo(callSite.name).asCollector(Object[].class, args.length);
        }
        if (target == null) {
            Map<String, MethodHandle> overrides = definition.getOverrides();
            MethodHandle superTarget = callSite.callerLookup.findSpecial(receiverParentClass, callSite.name, callSite.type().dropParameterTypes(0, 1), receiverClass);
            superTarget = superTarget.isVarargsCollector() ? superTarget.asType(MethodType.genericMethodType(superTarget.type().parameterCount() - 1, true)) : superTarget.asType(MethodType.genericMethodType(superTarget.type().parameterCount()));
            target = overrides.get(callSite.name);
            boolean star = false;
            if (target == null) {
                target = overrides.get("*");
                star = true;
            }
            if (target == null) {
                target = superTarget;
            } else {
                target = target.bindTo(superTarget);
                if (star) {
                    target = target.bindTo(callSite.name);
                    target = target.asCollector(Object[].class, args.length);
                }
            }
        }
        callSite.setTarget(target.asType(callSite.type()));
        return target.invokeWithArguments(args);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            FALLBACK = lookup.findStatic(AdapterSupport.class, "fallback", MethodType.methodType(Object.class, AdapterCallSite.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required method handles", e);
        }
    }

    static final class AdapterCallSite
    extends MutableCallSite {
        final MethodHandles.Lookup callerLookup;
        final String name;

        AdapterCallSite(MethodType type, MethodHandles.Lookup callerLookup, String name) {
            super(type);
            this.callerLookup = callerLookup;
            this.name = name;
        }
    }
}

