/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import fr.insalyon.citi.golo.runtime.TypeMatching;
import fr.insalyon.citi.golo.runtime.adapters.AdapterDefinition;
import fr.insalyon.citi.golo.runtime.adapters.JavaBytecodeAdapterGenerator;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class AdapterFabric {
    private final ClassLoader classLoader;
    private final AtomicLong nextId = new AtomicLong();
    private final JavaBytecodeAdapterGenerator adapterGenerator = new JavaBytecodeAdapterGenerator();

    public AdapterFabric(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public AdapterFabric() {
        this(new ClassLoader(Thread.currentThread().getContextClassLoader()){});
    }

    public static AdapterFabric withParentClassLoader(ClassLoader parentClassLoader) {
        return new AdapterFabric(new ClassLoader(parentClassLoader){});
    }

    public Maker maker(Map<String, Object> configuration) {
        String parent = "java.lang.Object";
        if (configuration.containsKey("extends")) {
            parent = (String)configuration.get("extends");
        }
        String name = "$Golo$Adapter$" + this.nextId.getAndIncrement();
        AdapterDefinition definition = new AdapterDefinition(this.classLoader, name, parent);
        if (configuration.containsKey("interfaces")) {
            Iterable interfaces = (Iterable)configuration.get("interfaces");
            for (String string : interfaces) {
                definition.implementsInterface(string);
            }
        }
        if (configuration.containsKey("implements")) {
            Map implementations = (Map)configuration.get("implements");
            for (Map.Entry entry : implementations.entrySet()) {
                definition.implementsMethod((String)entry.getKey(), (MethodHandle)entry.getValue());
            }
        }
        if (configuration.containsKey("overrides")) {
            Map overrides = (Map)configuration.get("overrides");
            for (Map.Entry entry : overrides.entrySet()) {
                definition.overridesMethod((String)entry.getKey(), (MethodHandle)entry.getValue());
            }
        }
        definition.validate();
        Class<?> adapterClass = this.adapterGenerator.generateIntoDefinitionClassloader(definition);
        return new Maker(definition, adapterClass);
    }

    public static final class Maker {
        private final AdapterDefinition adapterDefinition;
        private final Class<?> adapterClass;

        private Maker(AdapterDefinition adapterDefinition, Class<?> adapterClass) {
            this.adapterDefinition = adapterDefinition;
            this.adapterClass = adapterClass;
        }

        public Object newInstance(Object ... args) throws ReflectiveOperationException {
            Object[] cargs = new Object[args.length + 1];
            cargs[0] = this.adapterDefinition;
            System.arraycopy(args, 0, cargs, 1, args.length);
            for (Constructor<?> constructor : this.adapterClass.getConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (cargs.length != parameterTypes.length && (!constructor.isVarArgs() || cargs.length < parameterTypes.length) || !TypeMatching.canAssign(parameterTypes, cargs, constructor.isVarArgs())) continue;
                return constructor.newInstance(cargs);
            }
            throw new IllegalArgumentException("Could not create an instance for arguments " + Arrays.toString(cargs));
        }
    }
}

