/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.EvaluationEnvironment;
import java.lang.invoke.MethodHandle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateEngine {
    private final EvaluationEnvironment evaluationEnvironment = new EvaluationEnvironment();
    private static final Pattern PATTERN = Pattern.compile("<%(.*?)%>", 32);

    public MethodHandle compile(String template) {
        this.evaluationEnvironment.clearImports();
        String goloCode = this.templateToGolo(template);
        return (MethodHandle)this.evaluationEnvironment.def(goloCode);
    }

    public String templateToGolo(String template) {
        StringBuilder builder = new StringBuilder();
        String params = null;
        builder.append("  let _$result = java.lang.StringBuilder()\n");
        Matcher matcher = PATTERN.matcher(template);
        int startIndex = 0;
        while (matcher.find()) {
            String text = template.substring(startIndex, matcher.start());
            int lowerBound = 0;
            int upperBound = text.length();
            if (text.startsWith("\"")) {
                lowerBound = 1;
                builder.append("  _$result: append(\"\\\"\")\n");
            }
            if (text.endsWith("\"")) {
                upperBound = text.length() - 1;
            }
            builder.append("  _$result: append(\"\"\"").append(text.substring(lowerBound, upperBound)).append("\"\"\")\n");
            if (text.endsWith("\"")) {
                builder.append("  _$result: append(\"\\\"\")\n");
            }
            String code = matcher.group();
            if ((code = code.substring(2, code.length() - 2)).startsWith("=")) {
                builder.append("  _$result: append(").append(code.substring(1)).append(")\n");
            } else if (code.startsWith("@params")) {
                params = "|" + code.substring(7).trim() + "| {\n";
            } else if (code.startsWith("@import")) {
                this.evaluationEnvironment.imports(code.substring(7).trim(), new String[0]);
            } else {
                builder.append(code);
            }
            startIndex = matcher.end();
        }
        builder.append("\n  _$result: append(\"\"\"").append(template.substring(startIndex)).append("\"\"\")\n").append("  return _$result: toString()\n").append("}\n");
        if (params == null) {
            params = "|params| {\n";
        }
        return params + builder.toString();
    }
}

