/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.compiler.ir;

import fr.insalyon.citi.golo.compiler.ir.Block;
import fr.insalyon.citi.golo.compiler.ir.GoloElement;
import fr.insalyon.citi.golo.compiler.ir.GoloIrVisitor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class GoloFunction
extends GoloElement {
    private final String name;
    private final Visibility visibility;
    private final Scope scope;
    private List<String> parameterNames = new LinkedList<String>();
    private List<String> syntheticParameterNames = new LinkedList<String>();
    private int syntheticParameterCount = 0;
    private boolean varargs;
    private Block block;
    private boolean synthetic = false;
    private String syntheticSelfName = null;

    public GoloFunction(String name, Visibility visibility, Scope scope) {
        this.name = name;
        this.visibility = visibility;
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public int getSyntheticParameterCount() {
        return this.syntheticParameterCount;
    }

    public List<String> getParameterNames() {
        LinkedList<String> list = new LinkedList<String>(this.syntheticParameterNames);
        list.addAll(this.parameterNames);
        return Collections.unmodifiableList(list);
    }

    public List<String> getSyntheticParameterNames() {
        return Collections.unmodifiableList(this.syntheticParameterNames);
    }

    public void setParameterNames(List<String> parameterNames) {
        this.parameterNames.addAll(parameterNames);
    }

    public void addSyntheticParameter(String name) {
        this.syntheticParameterNames.add(name);
        ++this.syntheticParameterCount;
    }

    public void removeSyntheticParameter(String name) {
        this.syntheticParameterNames.remove(name);
        --this.syntheticParameterCount;
    }

    public void setVarargs(boolean varargs) {
        this.varargs = varargs;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public String getSyntheticSelfName() {
        return this.syntheticSelfName;
    }

    public void setSyntheticSelfName(String syntheticSelfName) {
        this.syntheticSelfName = syntheticSelfName;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public int getArity() {
        return this.parameterNames.size() + this.syntheticParameterCount;
    }

    public boolean isVarargs() {
        return this.varargs;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public boolean isMain() {
        return this.name.equals("main") && this.getArity() == 1;
    }

    public void accept(GoloIrVisitor visitor) {
        visitor.visitFunction(this);
    }

    public static enum Scope {
        MODULE,
        AUGMENT,
        CLOSURE;

    }

    public static enum Visibility {
        PUBLIC,
        LOCAL;

    }
}

