/*
 * Decompiled with CFR 0.152.
 */
package fr.insalyon.citi.golo.doc;

import fr.insalyon.citi.golo.compiler.parser.ASTCompilationUnit;
import fr.insalyon.citi.golo.doc.AbstractProcessor;
import fr.insalyon.citi.golo.doc.ModuleDocumentation;
import gololang.Predefined;
import java.lang.invoke.MethodHandle;
import java.nio.file.Path;
import java.util.List;
import java.util.TreeMap;

public class MarkdownProcessor
extends AbstractProcessor {
    @Override
    public String render(ASTCompilationUnit compilationUnit) throws Throwable {
        MethodHandle template = this.template("template", "markdown");
        ModuleDocumentation documentation = new ModuleDocumentation(compilationUnit);
        return (String)template.invokeWithArguments(documentation);
    }

    @Override
    public void process(List<ASTCompilationUnit> units, Path targetFolder) throws Throwable {
        TreeMap<String, String> moduleDocFile = new TreeMap<String, String>();
        this.ensureFolderExists(targetFolder);
        for (ASTCompilationUnit unit : units) {
            String moduleName = this.moduleName(unit);
            Path docFile = this.outputFile(targetFolder, moduleName, ".markdown");
            this.ensureFolderExists(docFile.getParent());
            Predefined.textToFile(this.render(unit), docFile);
            moduleDocFile.put(moduleName, targetFolder.relativize(docFile).toString());
        }
        MethodHandle indexTemplate = this.template("index", "markdown");
        String index = (String)indexTemplate.invokeWithArguments(moduleDocFile);
        Predefined.textToFile(index, targetFolder.resolve("index.markdown"));
    }
}

