/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class DynamicObject {
    private final HashMap<String, Object> properties = new HashMap();
    private boolean frozen = false;
    private static final MethodHandle MAP_GET;
    private static final MethodHandle MAP_PUT;
    private static final MethodHandle MAP_HAS;
    private static final MethodHandle IS_MH_1;
    private static final MethodHandle IS_MH_2;

    public DynamicObject define(String name, Object value) {
        this.frozenMutationCheck();
        this.properties.put(name, value);
        return this;
    }

    public Set<Map.Entry<String, Object>> properties() {
        return this.properties.entrySet();
    }

    public Object get(String name) {
        return this.properties.get(name);
    }

    public DynamicObject undefine(String name) {
        this.properties.remove(name);
        return this;
    }

    public DynamicObject copy() {
        DynamicObject copy = new DynamicObject();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            copy.properties.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public DynamicObject mixin(DynamicObject other) {
        this.frozenMutationCheck();
        for (Map.Entry<String, Object> entry : other.properties.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public DynamicObject freeze() {
        this.frozen = true;
        return this;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public MethodHandle invoker(String property, MethodType type) {
        switch (type.parameterCount()) {
            case 0: {
                throw new IllegalArgumentException("A dynamic object invoker type needs at least 1 argument (the receiver)");
            }
            case 1: {
                return this.getterStyleInvoker(property, type);
            }
            case 2: {
                return this.setterStyleInvoker(property, type);
            }
        }
        return this.anyInvoker(property, type);
    }

    public boolean hasMethod(String method) {
        Object obj = this.properties.get(method);
        if (obj != null) {
            return obj instanceof MethodHandle;
        }
        return false;
    }

    public DynamicObject fallback(Object value) {
        return this.define("fallback", value);
    }

    private boolean hasFallback() {
        return this.properties.containsKey("fallback");
    }

    private void frozenMutationCheck() {
        if (this.frozen) {
            throw new IllegalStateException("the object is frozen");
        }
    }

    private Object put(String key, Object value) {
        this.frozenMutationCheck();
        this.properties.put(key, value);
        return this;
    }

    private Object get(Object key) {
        return this.properties.get(key);
    }

    private MethodHandle anyInvoker(String property, MethodType type) {
        MethodHandle mapGet = MethodHandles.insertArguments(MAP_GET, 1, property);
        mapGet = mapGet.asType(mapGet.type().changeParameterType(0, Object.class));
        MethodHandle invoker = MethodHandles.invoker(type);
        invoker = invoker.asType(invoker.type().changeParameterType(0, Object.class));
        if (this.hasFallback()) {
            return this.fallback(MethodHandles.foldArguments(invoker, mapGet), property, type);
        }
        return MethodHandles.foldArguments(invoker, mapGet);
    }

    private MethodHandle setterStyleInvoker(String property, MethodType type) {
        MethodHandle mapGet = MethodHandles.insertArguments(MAP_GET, 1, property);
        mapGet = mapGet.asType(mapGet.type().changeParameterType(0, Object.class));
        MethodHandle mapPut = MethodHandles.dropArguments(MethodHandles.insertArguments(MAP_PUT, 1, property), 0, new Class[]{Object.class});
        mapPut = mapPut.asType(mapPut.type().changeParameterType(1, Object.class));
        MethodHandle invoker = MethodHandles.invoker(type);
        invoker = invoker.asType(invoker.type().changeParameterType(0, Object.class));
        MethodHandle gwt = MethodHandles.guardWithTest(IS_MH_2, invoker, mapPut);
        return MethodHandles.foldArguments(gwt, mapGet);
    }

    private MethodHandle getterStyleInvoker(String property, MethodType type) {
        MethodHandle mapGet = MethodHandles.insertArguments(MAP_GET, 1, property);
        mapGet = mapGet.asType(mapGet.type().changeParameterType(0, Object.class));
        MethodHandle identity = MethodHandles.dropArguments(MethodHandles.identity(Object.class), 1, type.parameterArray());
        MethodHandle invoker = MethodHandles.invoker(type);
        invoker = invoker.asType(invoker.type().changeParameterType(0, Object.class));
        MethodHandle gwt = MethodHandles.guardWithTest(IS_MH_1, invoker, identity);
        if (this.hasFallback()) {
            return this.fallback(MethodHandles.foldArguments(gwt, mapGet), property, type);
        }
        return MethodHandles.foldArguments(gwt, mapGet);
    }

    private MethodHandle fallback(MethodHandle target, String property, MethodType type) {
        MethodHandle fallbackHandle = (MethodHandle)this.properties.get("fallback");
        fallbackHandle = MethodHandles.insertArguments(fallbackHandle, 1, property);
        fallbackHandle = fallbackHandle.asType(fallbackHandle.type().changeParameterType(0, Object.class));
        fallbackHandle = fallbackHandle.asCollector(Object[].class, target.type().parameterCount() - 1);
        MethodHandle has = MethodHandles.insertArguments(MAP_HAS, 1, property);
        return MethodHandles.guardWithTest(has, target, fallbackHandle);
    }

    private static boolean isMethodHandle_1(Object obj) {
        if (obj instanceof MethodHandle) {
            MethodHandle handle = (MethodHandle)obj;
            if (handle.isVarargsCollector()) {
                return handle.type().parameterCount() == 2;
            }
            return handle.type().parameterCount() == 1;
        }
        return false;
    }

    private static boolean isMethodHandle_2(Object obj) {
        if (obj instanceof MethodHandle) {
            MethodHandle handle = (MethodHandle)obj;
            return handle.type().parameterCount() == 2;
        }
        return false;
    }

    private static boolean has(Object obj, Object property) {
        if (obj instanceof DynamicObject) {
            DynamicObject receiver = (DynamicObject)obj;
            return receiver.properties.containsKey(property);
        }
        return false;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MAP_GET = lookup.findSpecial(DynamicObject.class, "get", MethodType.methodType(Object.class, Object.class), DynamicObject.class);
            MAP_PUT = lookup.findSpecial(DynamicObject.class, "put", MethodType.methodType(Object.class, String.class, Object.class), DynamicObject.class);
            MAP_HAS = lookup.findStatic(DynamicObject.class, "has", MethodType.methodType(Boolean.TYPE, Object.class, Object.class));
            IS_MH_1 = lookup.findStatic(DynamicObject.class, "isMethodHandle_1", MethodType.methodType(Boolean.TYPE, Object.class));
            IS_MH_2 = lookup.findStatic(DynamicObject.class, "isMethodHandle_2", MethodType.methodType(Boolean.TYPE, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
            throw new Error("Could not bootstrap the required method handles");
        }
    }
}

